/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.jbo.CustomClassNotFoundException;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClassLoader;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.domain.DataCreationException;

public class JBOClass {
    private static JBOClassLoader mLoader;
    public static Object[][] nativeTypesArr;
    private static /* synthetic */ Class class$java$lang$Integer;
    private static /* synthetic */ Class class$java$lang$Boolean;
    private static /* synthetic */ Class class$java$lang$Short;
    private static /* synthetic */ Class class$java$lang$Long;
    private static /* synthetic */ Class class$java$lang$Float;
    private static /* synthetic */ Class class$java$lang$Double;
    private static /* synthetic */ Class class$java$lang$Byte;
    private static /* synthetic */ Class class$java$lang$Character;
    private static /* synthetic */ Class class$java$lang$Void;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$common$JDKClassLoader;
    private static /* synthetic */ Class class$oracle$jbo$common$JBOClassLoader;
    private static /* synthetic */ Class class$java$lang$String;

    static {
        JBOClass.initLoader();
        Object[][] objectArrayArray = new Object[18][];
        Object[] objectArray = new Object[2];
        objectArray[0] = "String";
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = JBOClass.class$("java.lang.String");
        }
        objectArray[1] = clazz;
        objectArrayArray[0] = objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "Integer";
        Class clazz2 = class$java$lang$Integer;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Integer = JBOClass.class$("java.lang.Integer");
        }
        objectArray2[1] = clazz2;
        objectArrayArray[1] = objectArray2;
        objectArrayArray[2] = new Object[]{"int", Integer.TYPE};
        objectArrayArray[3] = new Object[]{"boolean", Boolean.TYPE};
        objectArrayArray[4] = new Object[]{"long", Long.TYPE};
        Object[] objectArray3 = new Object[2];
        objectArray3[0] = "Boolean";
        Class clazz3 = class$java$lang$Boolean;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Boolean = JBOClass.class$("java.lang.Boolean");
        }
        objectArray3[1] = clazz3;
        objectArrayArray[5] = objectArray3;
        Object[] objectArray4 = new Object[2];
        objectArray4[0] = "Long";
        Class clazz4 = class$java$lang$Long;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Long = JBOClass.class$("java.lang.Long");
        }
        objectArray4[1] = clazz4;
        objectArrayArray[6] = objectArray4;
        Object[] objectArray5 = new Object[2];
        objectArray5[0] = "Short";
        Class clazz5 = class$java$lang$Short;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Short = JBOClass.class$("java.lang.Short");
        }
        objectArray5[1] = clazz5;
        objectArrayArray[7] = objectArray5;
        Object[] objectArray6 = new Object[2];
        objectArray6[0] = "Float";
        Class clazz6 = class$java$lang$Float;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Float = JBOClass.class$("java.lang.Float");
        }
        objectArray6[1] = clazz6;
        objectArrayArray[8] = objectArray6;
        Object[] objectArray7 = new Object[2];
        objectArray7[0] = "Double";
        Class clazz7 = class$java$lang$Double;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Double = JBOClass.class$("java.lang.Double");
        }
        objectArray7[1] = clazz7;
        objectArrayArray[9] = objectArray7;
        Object[] objectArray8 = new Object[2];
        objectArray8[0] = "Char";
        Class clazz8 = class$java$lang$Character;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Character = JBOClass.class$("java.lang.Character");
        }
        objectArray8[1] = clazz8;
        objectArrayArray[10] = objectArray8;
        Object[] objectArray9 = new Object[2];
        objectArray9[0] = "Btye";
        Class clazz9 = class$java$lang$Byte;
        if (clazz9 == null) {
            clazz9 = class$java$lang$Byte = JBOClass.class$("java.lang.Byte");
        }
        objectArray9[1] = clazz9;
        objectArrayArray[11] = objectArray9;
        objectArrayArray[12] = new Object[]{"byte", Byte.TYPE};
        objectArrayArray[13] = new Object[]{"double", Double.TYPE};
        objectArrayArray[14] = new Object[]{"float", Float.TYPE};
        objectArrayArray[15] = new Object[]{"short", Short.TYPE};
        objectArrayArray[16] = new Object[]{"char", Character.TYPE};
        objectArrayArray[17] = new Object[]{"void", Void.TYPE};
        nativeTypesArr = objectArrayArray;
    }

    private JBOClass() {
    }

    public static InputStream getResourceAsStream(String string) {
        return mLoader.loadResourceAsStream(string);
    }

    public static InputStream loadResource(String string) throws JboException {
        InputStream inputStream = mLoader.loadResourceAsStream(string);
        if (inputStream == null) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = JBOClass.class$("oracle.jbo.CSMessageBundle");
            }
            throw new JboException(clazz, "26027", new Object[]{string});
        }
        return inputStream;
    }

    private static void initLoader() {
        Class clazz;
        if (JboEnvUtil.inJServer()) {
            throw new UnsupportedOperationException();
        }
        if (JboEnvUtil.inJava12()) {
            try {
                clazz = Class.forName("oracle.jbo.common.java2.JDK2ClassLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JboException(classNotFoundException);
            }
        } else {
            Class clazz2 = class$oracle$jbo$common$JDKClassLoader;
            if (clazz2 == null) {
                clazz2 = class$oracle$jbo$common$JDKClassLoader = JBOClass.class$("oracle.jbo.common.JDKClassLoader");
            }
            clazz = clazz2;
        }
        try {
            Object t = clazz.newInstance();
            if (!(t instanceof JBOClassLoader)) {
                Object[] objectArray = new Object[2];
                objectArray[0] = clazz.getName();
                Class clazz3 = class$oracle$jbo$common$JBOClassLoader;
                if (clazz3 == null) {
                    clazz3 = class$oracle$jbo$common$JBOClassLoader = JBOClass.class$("oracle.jbo.common.JBOClassLoader");
                }
                objectArray[1] = clazz3.getName();
                Diagnostic.ASSERT(false, "{0} doesn't implement {1}", objectArray);
            }
            mLoader = (JBOClassLoader)t;
            mLoader.init();
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public static Class forName(String string) throws ClassNotFoundException {
        Class clazz = null;
        if (string != null) {
            if (string.indexOf(46) < 0) {
                int n = 0;
                while (n < nativeTypesArr.length) {
                    if (nativeTypesArr[n][0].equals(string)) {
                        clazz = (Class)nativeTypesArr[n][1];
                    }
                    ++n;
                }
            }
            if (clazz == null) {
                clazz = mLoader.loadClassForName(string);
            }
        }
        return clazz;
    }

    public static Class findCustomClass(String string, Class clazz) {
        Class clazz2 = null;
        try {
            clazz2 = JBOClass.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Custom class " + string + " not found");
            }
            throw new CustomClassNotFoundException(string, classNotFoundException);
        }
        if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
            Class clazz3 = class$oracle$jbo$CSMessageBundle;
            if (clazz3 == null) {
                clazz3 = class$oracle$jbo$CSMessageBundle = JBOClass.class$("oracle.jbo.CSMessageBundle");
            }
            throw new CustomClassNotFoundException(clazz3, "26023", new Object[]{string, clazz.getName()});
        }
        return clazz2;
    }

    public static Class findDataClass(String string) {
        Class clazz = null;
        try {
            clazz = JBOClass.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class clazz2 = class$oracle$jbo$CSMessageBundle;
            if (clazz2 == null) {
                clazz2 = class$oracle$jbo$CSMessageBundle = JBOClass.class$("oracle.jbo.CSMessageBundle");
            }
            throw new DataCreationException(clazz2, "25029", new Object[]{string}, classNotFoundException);
        }
        return clazz;
    }

    public static Object newInstance(Class clazz) {
        try {
            Object t = clazz.newInstance();
            return t;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JboException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new JboException(instantiationException);
        }
    }

    public static Object newInstance(String string) {
        try {
            Object t = JBOClass.forName(string).newInstance();
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new JboException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JboException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new JboException(instantiationException);
        }
    }

    public static Class getObjectClass(Class clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            Class clazz2 = class$java$lang$Integer;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Integer = JBOClass.class$("java.lang.Integer");
            }
            return clazz2;
        }
        if (clazz == Boolean.TYPE) {
            Class clazz3 = class$java$lang$Boolean;
            if (clazz3 == null) {
                clazz3 = class$java$lang$Boolean = JBOClass.class$("java.lang.Boolean");
            }
            return clazz3;
        }
        if (clazz == Short.TYPE) {
            Class clazz4 = class$java$lang$Short;
            if (clazz4 == null) {
                clazz4 = class$java$lang$Short = JBOClass.class$("java.lang.Short");
            }
            return clazz4;
        }
        if (clazz == Long.TYPE) {
            Class clazz5 = class$java$lang$Long;
            if (clazz5 == null) {
                clazz5 = class$java$lang$Long = JBOClass.class$("java.lang.Long");
            }
            return clazz5;
        }
        if (clazz == Float.TYPE) {
            Class clazz6 = class$java$lang$Float;
            if (clazz6 == null) {
                clazz6 = class$java$lang$Float = JBOClass.class$("java.lang.Float");
            }
            return clazz6;
        }
        if (clazz == Double.TYPE) {
            Class clazz7 = class$java$lang$Double;
            if (clazz7 == null) {
                clazz7 = class$java$lang$Double = JBOClass.class$("java.lang.Double");
            }
            return clazz7;
        }
        if (clazz == Byte.TYPE) {
            Class clazz8 = class$java$lang$Byte;
            if (clazz8 == null) {
                clazz8 = class$java$lang$Byte = JBOClass.class$("java.lang.Byte");
            }
            return clazz8;
        }
        if (clazz == Character.TYPE) {
            Class clazz9 = class$java$lang$Character;
            if (clazz9 == null) {
                clazz9 = class$java$lang$Character = JBOClass.class$("java.lang.Character");
            }
            return clazz9;
        }
        Class clazz10 = class$java$lang$Void;
        if (clazz10 == null) {
            clazz10 = class$java$lang$Void = JBOClass.class$("java.lang.Void");
        }
        return clazz10;
    }

    public static ResourceBundle loadResourceBundle(String string, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(string, locale, JBOClass.getCurrentClassLoader());
    }

    public static ClassLoader getCurrentClassLoader() {
        return mLoader.getCurrentClassLoader();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

