/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.InputStream;
import java.util.Properties;
import oracle.jbo.common.ADFLoggerDiagnosticImpl;
import oracle.jbo.common.ConsoleDiagnosticImpl;
import oracle.jbo.common.FileDiagnosticImpl;
import oracle.jbo.common.IASDiagnosticImpl;
import oracle.jbo.common.IDiagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.PipeDiagnosticImpl;
import oracle.jbo.common.SharedFileDiagnosticImpl;
import oracle.jbo.common.SilentDiagnosticImpl;

public class DiagnosticFactory {
    static Properties s_Properties = new Properties();
    private static Properties m_storedProps = null;
    private static Properties m_defaultProps = null;
    public static final String DIAGNOSTIC_DOT_PROPERTIES = "/oracle/jbo/common/Diagnostic.properties";
    public static final String PN_DEBUG_PREFIX = "jbo.debug.prefix";
    public static final String PN_DEBUG_TYPE = "jbo.debugoutput";
    public static final String PN_PIPE_TARGET = "jbo.pipe.target";
    public static final String PN_SHOW_TIMING = "jbo.logging.show.timing";
    public static final String PN_SHOW_FUNCTION = "jbo.logging.show.function";
    public static final String PN_SHOW_LINECOUNT = "jbo.logging.show.linecount";
    public static final String PN_SHOW_LEVEL = "jbo.logging.show.level";
    public static final String PN_TRACE_THRESHOLD = "jbo.logging.trace.threshold";
    public static final String PN_JDBC_DRIVER_VERBOSE = "jbo.jdbc.driver.verbose";
    public static final String PV_DEBUG_TYPE_ADF = "adflogger";
    public static final String PV_DEBUG_TYPE_CONSOLE = "console";
    public static final String PV_DEBUG_TYPE_OUT = "out";
    public static final String PV_DEBUG_TYPE_FILE = "file";
    public static final String PV_DEBUG_TYPE_SHARED_FILE = "sharedfile";
    public static final String PV_DEBUG_TYPE_SILENT = "silent";
    public static final String PV_DEBUG_TYPE_PIPE = "pipe";
    public static final String PV_DEBUG_TYPE_IAS = "ias";
    public static final String PV_DEBUG_PREFIX = "*";
    public static final String PV_PIPE_TARGET_LOOPBACK = "127.127.0.1";
    public static final String PV_TRACE_THRESHOLD = "3";
    public static final String PV_TRUE = "true";
    public static final String PV_FALSE = "false";
    public static final int PD_DIAGNOSTIC_DEFAULT_LEVEL = 3;
    public static final int PD_DEBUGDIAGNOSTIC_DEFAULT_LEVEL = 6;
    public static final String PN_ORACLE_HOME = "oracle.home";
    public static final String PN_OC4J_INSTANCE_NAME = "oc4j.name";
    private static /* synthetic */ Class class$oracle$jbo$common$DiagnosticFactory;

    private DiagnosticFactory() {
    }

    public static IDiagnostic createDiagnostic() {
        IDiagnostic iDiagnostic = null;
        String string = DiagnosticFactory.getProperty(PN_DEBUG_TYPE);
        if (string == null) {
            System.out.println("Warning: could not find value for 'jbo.debugoutput' defaulting");
            iDiagnostic = new SilentDiagnosticImpl();
        } else if (string.equalsIgnoreCase(PV_DEBUG_TYPE_ADF)) {
            iDiagnostic = new ADFLoggerDiagnosticImpl();
        } else if (string.equalsIgnoreCase(PV_DEBUG_TYPE_CONSOLE) || string.equalsIgnoreCase(PV_DEBUG_TYPE_OUT)) {
            iDiagnostic = new ConsoleDiagnosticImpl();
        } else if (string.equalsIgnoreCase(PV_DEBUG_TYPE_SILENT)) {
            iDiagnostic = new SilentDiagnosticImpl();
        } else if (string.equalsIgnoreCase(PV_DEBUG_TYPE_FILE)) {
            iDiagnostic = new FileDiagnosticImpl();
        } else if (string.toUpperCase().startsWith(PV_DEBUG_TYPE_SHARED_FILE.toUpperCase())) {
            int n = string.indexOf(58);
            if (n >= 0) {
                String string2 = string.substring(n + 1);
                iDiagnostic = new SharedFileDiagnosticImpl(string2);
            } else {
                iDiagnostic = new SharedFileDiagnosticImpl();
            }
        } else if (string.equalsIgnoreCase(PV_DEBUG_TYPE_PIPE)) {
            iDiagnostic = new PipeDiagnosticImpl();
        } else if (string.equalsIgnoreCase(PV_DEBUG_TYPE_IAS)) {
            String string3 = DiagnosticFactory.getProperty(PN_ORACLE_HOME);
            String string4 = DiagnosticFactory.getProperty(PN_OC4J_INSTANCE_NAME);
            iDiagnostic = string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0 ? (IDiagnostic)new ConsoleDiagnosticImpl() : (IDiagnostic)new IASDiagnosticImpl(string3, string4);
        } else {
            try {
                iDiagnostic = (IDiagnostic)JBOClass.forName(string).newInstance();
            }
            catch (Exception exception) {
                System.out.println("Failed to build Diagnostic class: '" + exception.getMessage() + "'");
                iDiagnostic = new ConsoleDiagnosticImpl();
            }
        }
        return iDiagnostic;
    }

    public static String getProperty(String string) {
        String string2 = null;
        string2 = (String)s_Properties.get(string);
        if (string2 == null) {
            try {
                string2 = System.getProperty(string);
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = DiagnosticFactory.getStoredProperties().getProperty(string);
        }
        if (string2 == null) {
            string2 = DiagnosticFactory.getDefaultProperties().getProperty(string);
        }
        return string2;
    }

    private static Properties getStoredProperties() {
        if (m_storedProps == null) {
            try {
                m_storedProps = new Properties();
                Class clazz = class$oracle$jbo$common$DiagnosticFactory;
                if (clazz == null) {
                    clazz = class$oracle$jbo$common$DiagnosticFactory = DiagnosticFactory.class$("oracle.jbo.common.DiagnosticFactory");
                }
                InputStream inputStream = clazz.getResourceAsStream(DIAGNOSTIC_DOT_PROPERTIES);
                m_storedProps.load(inputStream);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("Failed to load properties file: getResourceAsStream(\"/oracle/jbo/common/Diagnostic.properties\") Error: stream returned null value");
            }
            catch (Exception exception) {
                System.out.println("Failed to load properties file: getResourceAsStream(\"/oracle/jbo/common/Diagnostic.properties\") Error:" + exception.getMessage());
                m_storedProps.clear();
            }
        }
        return m_storedProps;
    }

    private static Properties getDefaultProperties() {
        if (m_defaultProps == null) {
            m_defaultProps = new Properties();
            m_defaultProps.put(PN_DEBUG_PREFIX, PV_DEBUG_PREFIX);
            m_defaultProps.put(PN_DEBUG_TYPE, PV_DEBUG_TYPE_CONSOLE);
            m_defaultProps.put(PN_PIPE_TARGET, PV_PIPE_TARGET_LOOPBACK);
            m_defaultProps.put(PN_SHOW_TIMING, PV_FALSE);
            m_defaultProps.put(PN_SHOW_FUNCTION, PV_FALSE);
            m_defaultProps.put(PN_SHOW_LINECOUNT, PV_TRUE);
            m_defaultProps.put(PN_TRACE_THRESHOLD, PV_TRACE_THRESHOLD);
            m_defaultProps.put(PN_SHOW_LEVEL, PV_FALSE);
        }
        return m_defaultProps;
    }

    public static void setProperty(String string, String string2) {
        s_Properties.put(string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

