/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import com.sun.java.util.collections.HashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.SQLDatumException;
import oracle.jbo.StructureDef;
import oracle.jbo.Transaction;
import oracle.jbo.common.TypeMarshaller;
import oracle.jbo.domain.DomainAttributeDef;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.MarshalledDomain;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jbo.domain.XMLDomainInterface;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.MutableStruct;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.STRUCT;
import oracle.svcmsg.ResponseValues;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Struct
implements MarshalledDomain,
Serializable,
CustomDatum,
AttributeList,
XMLDomainInterface,
DomainOwnerInterface,
LobInterface {
    protected Object mData;
    int mHashCode;
    boolean mIsHashGood;
    String mIndexString;
    DomainOwnerInterface mOwner;
    protected Object mConnection;
    protected Transaction mTxn;
    protected HashMap mContext;
    protected int mOwnerAttrIndex;
    protected XMLDomainFactory mXmlFac;
    protected XMLDomainFactory[] mAttrXmlFac;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mOwner = null;
        this.mContext = new HashMap(2);
        this.mOwnerAttrIndex = -1;
        this.mXmlFac = null;
        this.mAttrXmlFac = null;
    }

    public abstract String getColumnType();

    public abstract StructureDef getStructureDef();

    public abstract int[] getAttrSQLTypes();

    public abstract CustomDatumFactory[] getAttrCustomDatumFactories();

    protected abstract void initStructureDef();

    public static StructureDef resolveAndGetStructureDef(Class clazz) {
        if (clazz != null) {
            try {
                Struct struct = (Struct)clazz.newInstance();
                struct.initStructureDef();
                StructureDef structureDef = struct.getStructureDef();
                return structureDef;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        return null;
    }

    private void initStruct(Datum datum) {
        this.mHashCode = -1;
        this.mIsHashGood = false;
        this.initStructureDef();
        this.mData = datum != null ? (Object[])datum : new Object[this.getAttributeCount()];
    }

    protected Struct() throws SQLException {
        this.$init$();
        this.initStruct(null);
    }

    protected Struct(Datum datum) throws SQLException {
        this.$init$();
        this.initStruct(datum);
    }

    public Object getData() {
        return this;
    }

    public void domainToBeModified(DomainInterface domainInterface) {
        if (this.mOwner != null) {
            this.mOwner.domainToBeModified((DomainInterface)this);
        }
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
        this.mOwner = domainOwnerInterface;
        this.mTxn = transaction;
        HashMap hashMap = (HashMap)object;
        this.mContext = (HashMap)hashMap.clone();
        this.mOwnerAttrIndex = (Integer)this.mContext.get((Object)"0");
        int n = 0;
        while (n < this.getAttributeCount()) {
            Object object2 = this.getAttribute(n);
            if (object2 instanceof DomainInterface) {
                this.mContext.put((Object)"0", (Object)new Integer(n));
                DomainAttributeDef domainAttributeDef = (DomainAttributeDef)this.getStructureDef().getAttributeDef(n);
                this.mContext.put((Object)"4", (Object)domainAttributeDef.getSQLTypeName());
                ((DomainInterface)object2).setContext((DomainOwnerInterface)this, transaction, (Object)this.mContext);
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Struct) {
            Struct struct = (Struct)object;
            int n = this.getAttributeCount();
            if (n != struct.getAttributeCount()) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getAttribute(n2);
                Object object3 = struct.getAttribute(n2);
                if (object2 == null ? object3 != null : !object2.equals(object3)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.mIsHashGood) {
            int n = this.getAttributeCount();
            this.mHashCode = 0;
            int n2 = 0;
            while (n2 < n) {
                this.mHashCode += this.getAttribute(n2).hashCode();
                ++n2;
            }
            this.mIsHashGood = true;
        }
        return this.mHashCode;
    }

    public String toString() {
        int n = this.getAttributeCount();
        String string = "(";
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                string = string + ", ";
            }
            string = string + this.getAttribute(n2);
            ++n2;
        }
        string = string + ")";
        return string;
    }

    void convertArrayToStruct() {
        if (this.mData instanceof STRUCT) {
            try {
                this.mConnection = (oracle.jdbc.OracleConnection)((STRUCT)this.mData).getJavaSqlConnection();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mData = new MutableStruct((STRUCT)this.mData, this.getAttrSQLTypes(), this.getAttrCustomDatumFactories());
        } else if (!(this.mData instanceof MutableStruct)) {
            Object[] objectArray = this.mData != null ? (Object[])this.mData : new Object[this.getAttributeCount()];
            MutableStruct mutableStruct = new MutableStruct((STRUCT)null, this.getAttrSQLTypes(), this.getAttrCustomDatumFactories());
            int n = 0;
            while (n < objectArray.length) {
                try {
                    Object object = objectArray[n];
                    mutableStruct.setAttribute(n, object);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++n;
            }
            this.mData = mutableStruct;
        }
    }

    public Datum toDatum(OracleConnection oracleConnection) throws SQLException {
        return this.toDatum((oracle.jdbc.OracleConnection)oracleConnection);
    }

    public Datum toDatum(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this.convertArrayToStruct();
        this.mConnection = oracleConnection;
        int[] nArray = this.getAttrSQLTypes();
        Object[] objectArray = ((MutableStruct)this.mData).getAttributes();
        boolean bl = false;
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] > 2000 && objectArray[n] instanceof String) {
                nArray[n] = 12;
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.mData = new MutableStruct(objectArray, nArray, this.getAttrCustomDatumFactories());
        }
        return ((MutableStruct)this.mData).toDatum(oracleConnection, this.getColumnType());
    }

    public Object getAttribute(int n) {
        try {
            Object object;
            if (this.mData instanceof Object[]) {
                Object object2 = ((Object[])this.mData)[n];
                return object2;
            }
            this.convertArrayToStruct();
            Object object3 = object = ((MutableStruct)this.mData).getAttribute(n);
            if (this.getAttrCustomDatumFactories()[n] == null && (object3 = TypeFactory.getInstance((Class)this.getStructureDef().getAttributeDef(n).getJavaType(), (Object)object)) instanceof DomainInterface && object3 != object) {
                DomainAttributeDef domainAttributeDef = (DomainAttributeDef)this.getStructureDef().getAttributeDef(n);
                this.mContext.put((Object)"4", (Object)domainAttributeDef.getSQLTypeName());
                this.mContext.put((Object)"0", (Object)new Integer(n));
                ((DomainInterface)object3).setContext((DomainOwnerInterface)this, this.mTxn, (Object)this.mContext);
                if (object3 instanceof LobInterface) {
                    ((MutableStruct)this.mData).setAttribute(n, object3);
                }
            }
            Object object4 = object3;
            return object4;
        }
        catch (SQLException sQLException) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = Struct.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLDatumException(clazz, "26081", new Object[]{this.getColumnType(), this.getStructureDef().getAttributeDef(n).getName()}, (Exception)sQLException);
        }
    }

    public Object getAttribute(String string) {
        return this.getAttribute(this.getAttributeIndexOf(string));
    }

    public void setAttribute(int n, Object object) {
        if (this.mOwner != null) {
            this.mOwner.domainToBeModified((DomainInterface)this);
        }
        try {
            this.mIsHashGood = false;
            if (object instanceof DomainInterface) {
                this.mContext.put((Object)"0", (Object)new Integer(n));
                ((DomainInterface)object).setContext((DomainOwnerInterface)this, this.mTxn, (Object)this.mContext);
            }
            object = TypeFactory.getInstance((Class)this.getStructureDef().getAttributeDef(n).getJavaType(), (Object)object);
            if (this.mData instanceof Object[]) {
                ((Object[])this.mData)[n] = object;
            } else {
                this.convertArrayToStruct();
                ((MutableStruct)this.mData).setAttribute(n, object);
            }
        }
        catch (SQLException sQLException) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = Struct.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLDatumException(clazz, "26081", new Object[]{this.getColumnType(), this.getStructureDef().getAttributeDef(n).getName(), object}, (Exception)sQLException);
        }
        if (this.mOwner instanceof AttributeList && this.mOwnerAttrIndex > -1) {
            ((AttributeList)this.mOwner).setAttribute(this.mOwnerAttrIndex, (Object)this);
        }
    }

    public String getRemoteIdString() {
        if (this.mIndexString == null) {
            StringBuffer stringBuffer = new StringBuffer(new Integer(this.mOwnerAttrIndex).toString());
            DomainOwnerInterface domainOwnerInterface = this.mOwner;
            while (domainOwnerInterface instanceof Struct) {
                stringBuffer = stringBuffer.insert(0, '.');
                stringBuffer = stringBuffer.insert(0, new Integer(((Struct)domainOwnerInterface).mOwnerAttrIndex).toString());
                domainOwnerInterface = ((Struct)domainOwnerInterface).mOwner;
            }
            this.mIndexString = stringBuffer.toString();
        }
        return this.mIndexString;
    }

    public void setAttributeNoCheck(int n, Object object) {
        try {
            this.mIsHashGood = false;
            if (this.mData instanceof Object[]) {
                if (object instanceof DomainInterface) {
                    this.mContext.put((Object)"0", (Object)new Integer(n));
                    ((DomainInterface)object).setContext((DomainOwnerInterface)this, this.mTxn, (Object)this.mContext);
                }
                ((Object[])this.mData)[n] = object;
                return;
            }
            this.convertArrayToStruct();
            ((MutableStruct)this.mData).setAttribute(n, object);
        }
        catch (SQLException sQLException) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = Struct.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLDatumException(clazz, "26081", new Object[]{this.getColumnType(), this.getStructureDef().getAttributeDef(n).getName(), object}, (Exception)sQLException);
        }
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(this.getAttributeIndexOf(string), object);
    }

    public int getAttributeCount() {
        return this.getStructureDef().getAttributeCount();
    }

    public int getAttributeIndexOf(String string) {
        return this.getStructureDef().findAttributeDef(string).getIndex();
    }

    public int[] buildAttrSQLTypes() {
        int n = this.getStructureDef().getAttributeCount();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.getStructureDef().getAttributeDef(n2).getSQLType();
            ++n2;
        }
        return nArray;
    }

    public ResponseValues marshal() {
        return TypeMarshaller.serializeObject((Serializable)this);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.mHashCode);
        objectOutputStream.writeBoolean(this.mIsHashGood);
        int n = this.getAttributeCount();
        int n2 = 0;
        while (n2 < n) {
            objectOutputStream.writeObject(this.getAttribute(n2));
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.mData == null) {
            this.initStruct(null);
        }
        this.mHashCode = objectInputStream.readInt();
        this.mIsHashGood = objectInputStream.readBoolean();
        int n = this.getAttributeCount();
        Object[] objectArray = (Object[])this.mData;
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = objectInputStream.readObject();
            ++n2;
        }
        this.mIsHashGood = false;
    }

    protected String getXMLElementTag() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    protected String getAttrXMLElementTag(AttributeDef attributeDef) {
        return this.getXMLElementTag() + "_" + attributeDef.getName();
    }

    protected boolean isAttrXMLCData(AttributeDef attributeDef) {
        return false;
    }

    public Node getXMLContentNode(Document document) {
        String string = this.getXMLElementTag();
        Element element = document.createElement(string);
        AttributeDef[] attributeDefArray = this.getStructureDef().getAttributeDefs();
        int n = 0;
        while (n < attributeDefArray.length) {
            Node node;
            string = this.getAttrXMLElementTag(attributeDefArray[n]);
            if (!string.equals("#hide") && (node = DomainAttributeDef.getXMLContentNode((Document)document, (Object)this.getAttribute(n), (boolean)this.isAttrXMLCData(attributeDefArray[n]), (boolean)false)) != null) {
                Element element2 = document.createElement(string);
                element2.appendChild(node);
                element.appendChild(element2);
            }
            ++n;
        }
        return element;
    }

    protected void readAttrsFromXML(Element element) {
        AttributeDef[] attributeDefArray = this.getStructureDef().getAttributeDefs();
        if (this.mAttrXmlFac == null) {
            this.initAttrXMLDomainFactories(attributeDefArray);
        }
        Object object = null;
        if ((element = (Element)element.getFirstChild()) == null) {
            return;
        }
        int n = 0;
        while (n < attributeDefArray.length) {
            object = null;
            NodeList nodeList = ((XMLElement)element).getChildrenByTagName(this.getAttrXMLElementTag(attributeDefArray[n]));
            if (nodeList.getLength() > 0) {
                if (this.mAttrXmlFac[n] != null) {
                    object = this.mAttrXmlFac[n].createDomainFromXMLElement((Element)nodeList.item(0));
                } else {
                    object = nodeList.item(0).getFirstChild().getNodeValue();
                    if (object != null) {
                        object = TypeFactory.getInstance((Class)attributeDefArray[n].getJavaType(), (Object)object);
                    }
                }
            }
            if (object != null) {
                this.setAttribute(n, object);
            }
            ++n;
        }
    }

    public String printXMLDefinition(Hashtable hashtable, PrintWriter printWriter, boolean bl) {
        AttributeDef[] attributeDefArray = this.getStructureDef().getAttributeDefs();
        String string = this.getXMLElementTag();
        if (hashtable.get(string) == null) {
            StringBuffer stringBuffer = new StringBuffer("<!ELEMENT ").append(string).append(" (");
            int n = 0;
            while (n < attributeDefArray.length) {
                String string2 = this.getAttrXMLElementTag(attributeDefArray[n]);
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(DomainAttributeDef.printAttrXMLDefinition((AttributeList)this, (String)string2, (AttributeDef)attributeDefArray[n], (Hashtable)hashtable, (PrintWriter)printWriter, (boolean)bl));
                ++n;
            }
            stringBuffer.append(")>");
            hashtable.put(string, string);
            printWriter.println(stringBuffer.toString());
        }
        return string;
    }

    public static XMLDomainFactory getXMLDomainFactory(Class clazz) {
        return new 1facClass(clazz);
    }

    protected void initAttrXMLDomainFactories(AttributeDef[] attributeDefArray) {
        if (this.mAttrXmlFac == null) {
            this.mAttrXmlFac = new XMLDomainFactory[attributeDefArray.length];
            int n = 0;
            while (n < this.mAttrXmlFac.length) {
                try {
                    Object[] objectArray = new Object[]{attributeDefArray[n].getJavaType()};
                    Method method = ((Class)objectArray[0]).getMethod("getXMLDomainFactory", objectArray[0].getClass());
                    this.mAttrXmlFac[n] = (XMLDomainFactory)method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void loadFromDatabase(Transaction transaction) throws Exception {
        int n = 0;
        while (n < this.getAttributeCount()) {
            Object object = this.getAttribute(n);
            if (object instanceof LobInterface) {
                ((LobInterface)object).loadFromDatabase(transaction);
            }
            ++n;
        }
    }

    public void saveToDatabase(Transaction transaction) throws Exception {
        int n = 0;
        while (n < this.getAttributeCount()) {
            Object object = this.getAttribute(n);
            if (object instanceof LobInterface) {
                ((LobInterface)object).saveToDatabase(transaction);
            }
            ++n;
        }
    }

    public void saveToDatabase(Transaction transaction, Object object) throws Exception {
        Struct struct = (Struct)object;
        int n = 0;
        while (n < this.getAttributeCount()) {
            Object object2 = this.getAttribute(n);
            if (object2 instanceof LobInterface) {
                ((LobInterface)object2).saveToDatabase(transaction, struct.getAttribute(n));
            }
            ++n;
        }
    }

    public void prepareForDML(Object object) {
        int n = 0;
        while (n < this.getAttributeCount()) {
            Object object2 = this.getAttribute(n);
            if (object2 instanceof LobInterface) {
                ((LobInterface)object2).prepareForDML(object);
            }
            ++n;
        }
    }

    public void syncClientLob(LobInterface lobInterface) {
        if (lobInterface instanceof Struct) {
            Struct struct = (Struct)lobInterface;
            int n = struct.getAttributeCount();
            int n2 = 0;
            while (n2 < n) {
                Object object = this.getAttribute(n2);
                if (object instanceof LobInterface) {
                    ((LobInterface)object).syncClientLob((LobInterface)struct.getAttribute(n2));
                } else {
                    this.setAttributeNoCheck(n2, struct.getAttribute(n2));
                }
                ++n2;
            }
        }
    }

    public void syncServerLob(LobInterface lobInterface) {
        if (lobInterface instanceof Struct) {
            Struct struct = (Struct)lobInterface;
            int n = this.getAttributeCount();
            int n2 = 0;
            while (n2 < n) {
                Object object = this.getAttribute(n2);
                if (object instanceof LobInterface) {
                    ((LobInterface)object).syncServerLob((LobInterface)struct.getAttribute(n2));
                }
                ++n2;
            }
        }
    }

    public DomainOwnerInterface getOwner() {
        return this.mOwner;
    }

    public int getOwnerAttributeIndex() {
        return this.mOwnerAttrIndex;
    }

    protected DomainOwnerInterface getOwnerRow() {
        DomainOwnerInterface domainOwnerInterface = this.mOwner;
        while (domainOwnerInterface instanceof LobInterface) {
            domainOwnerInterface = ((LobInterface)domainOwnerInterface).getOwner();
        }
        return domainOwnerInterface instanceof Row ? domainOwnerInterface : null;
    }

    public long getSize() {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = Struct.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "25221", new Object[]{"TransPostEntityRow.writeXML"});
    }

    public static void setStructAttribute(AttributeList attributeList, StructureDef structureDef, String string, Object object) {
        int n = string.indexOf(46);
        try {
            if (n < 0) {
                attributeList.setAttribute(string, object);
                return;
            }
            AttributeDef attributeDef = structureDef.findAttributeDef(string.substring(0, n));
            int n2 = attributeDef.getIndex();
            Struct struct = (Struct)attributeList.getAttribute(n2);
            boolean bl = struct == null;
            if (bl) {
                struct = (Struct)attributeDef.getJavaType().newInstance();
            }
            Struct.setStructAttribute(struct, struct.getStructureDef(), string.substring(n + 1), object);
            if (bl) {
                attributeList.setAttribute(n2, (Object)struct);
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public static Object getStructAttribute(AttributeList attributeList, StructureDef structureDef, String string) {
        int n = string.indexOf(46);
        try {
            if (n < 0) {
                Object object = attributeList.getAttribute(string);
                return object;
            }
            AttributeDef attributeDef = structureDef.findAttributeDef(string.substring(0, n));
            int n2 = attributeDef.getIndex();
            Struct struct = (Struct)attributeList.getAttribute(n2);
            boolean bl = struct == null;
            if (bl) {
                struct = (Struct)attributeDef.getJavaType().newInstance();
            }
            Object object = Struct.getStructAttribute(struct, struct.getStructureDef(), string.substring(n + 1));
            return object;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public static void fillObjectAttributeDefs(AttributeList attributeList, StructureDef structureDef, String[] stringArray, AttributeDef[] attributeDefArray) {
        String string = stringArray[0];
        int n = string.indexOf(46);
        int n2 = stringArray.length;
        if (n < 0) {
            int n3 = 0;
            while (n3 < n2) {
                attributeDefArray[n3] = structureDef.findAttributeDef(stringArray[n3]);
                ++n3;
            }
            return;
        }
        AttributeDef attributeDef = structureDef.findAttributeDef(string.substring(0, n));
        int n4 = attributeDef.getIndex();
        try {
            Struct struct = (Struct)attributeList.getAttribute(n4);
            boolean bl = struct == null;
            if (bl) {
                struct = (Struct)attributeDef.getJavaType().newInstance();
            }
            String[] stringArray2 = new String[n2];
            ++n;
            int n5 = 0;
            while (n5 < n2) {
                stringArray2[n5] = stringArray[n5].substring(n);
                ++n5;
            }
            Struct.fillObjectAttributeDefs(struct, struct.getStructureDef(), stringArray2, attributeDefArray);
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public String[] getAttributeNames() {
        return null;
    }

    public Object[] getAttributeValues() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class 1facClass
    implements XMLDomainFactory {
        Class mAttrClass;

        1facClass(Class clazz) {
            this.mAttrClass = clazz;
        }

        public DomainInterface createDomainFromXMLElement(Element element) {
            try {
                Struct struct = (Struct)this.mAttrClass.newInstance();
                struct.readAttrsFromXML(element);
                Struct struct2 = struct;
                return struct2;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
    }
}

