/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import com.sun.java.util.collections.HashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.Transaction;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.MarshalledDomain;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.svcmsg.ResponseValues;

public abstract class BaseLobDomain
implements MarshalledDomain,
CustomDatum,
Serializable {
    static final String CLIENT_LOB_DOMAIN_INPUT = "oracle.jbo.client.remote.LobDomainInputStream";
    static final String CLIENT_LOB_DOMAIN_OUTPUT = "oracle.jbo.client.remote.LobDomainOutputStream";
    static final String CLIENT_APPMODULE_CLASS = "oracle.jbo.client.remote.ApplicationModuleImpl";
    private static final int MAX_CHUNK_SIZE = Short.MAX_VALUE;
    static final int REOPEN_STREAM_UNINIT = -1;
    static final int REOPEN_STREAM_TRUE = 1;
    static final int REOPEN_STREAM_FALSE = 0;
    private static int mReopenStream = -1;
    transient BlobOutputStream mData;
    transient Datum lob;
    transient InputStream inStream;
    transient OutputStream outStream;
    transient Reader inReader;
    transient DomainOwnerInterface mOwner;
    transient Transaction xAct;
    transient boolean mDataModified;
    transient boolean mClient;
    transient Integer relIdx;
    transient String mIndexString;
    transient boolean mNeedsServerSync;
    private static /* synthetic */ Class class$oracle$jbo$Row;
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class array$Ljava$lang$String;
    private static /* synthetic */ Class array$Ljava$lang$Object;
    private static /* synthetic */ Class class$oracle$jbo$Transaction;
    private static /* synthetic */ Class class$oracle$jbo$domain$DomainOwnerInterface;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.lob = null;
        this.inReader = null;
        this.mOwner = null;
        this.xAct = null;
        this.mDataModified = false;
        this.mClient = false;
        this.relIdx = new Integer(-1);
        this.mIndexString = null;
        this.mNeedsServerSync = false;
    }

    BaseLobDomain() {
        this.$init$();
        this.mDataModified = true;
    }

    BaseLobDomain(Datum datum) {
        this.$init$();
        this.lob = datum;
    }

    BaseLobDomain(byte[] byArray) {
        this.$init$();
        if (byArray != null) {
            this.setBytes(byArray);
        }
    }

    BaseLobDomain(Datum datum, byte[] byArray) {
        this.$init$();
        this.lob = datum;
        this.setBytes(byArray);
    }

    BaseLobDomain(BaseLobDomain baseLobDomain, byte[] byArray) {
        this.$init$();
        this.mClient = baseLobDomain.mClient;
        this.setBytes(byArray);
    }

    BaseLobDomain(ResponseValues responseValues) {
        this.$init$();
        boolean bl = responseValues.getBooleanValues()[0];
        boolean bl2 = responseValues.getBooleanValues()[1];
        boolean bl3 = responseValues.getBooleanValues()[2];
        String string = (String)responseValues.getObjectValues()[0];
        byte[] byArray = (byte[])responseValues.getObjectValues()[1];
        this.mDataModified = bl2;
        if (bl && bl2) {
            this.setBytes(byArray);
        }
        this.mNeedsServerSync = bl3;
    }

    public Datum toDatum(OracleConnection oracleConnection) throws SQLException {
        this.prepareForDML(oracleConnection);
        return this.lob;
    }

    public void setBytes(byte[] byArray) {
        OutputStream outputStream = this.getOutputStream();
        if (outputStream != null) {
            try {
                if (this.inStream != null) {
                    this.inStream.close();
                    this.inStream = null;
                }
                if (byArray != null) {
                    outputStream.write(byArray, 0, byArray.length);
                } else {
                    outputStream.write(new byte[0], 0, 0);
                }
                this.closeOutputStream();
                return;
            }
            catch (IOException iOException) {
                Diagnostic.println((String)"Error opening cache'd stream. Set the attribute again into it's row");
            }
        }
        this.mDataModified = true;
    }

    public void loadFromDatabase(Transaction transaction) throws Exception {
        this.xAct = transaction;
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
        Integer n;
        this.xAct = transaction;
        this.mOwner = domainOwnerInterface;
        HashMap hashMap = (HashMap)object;
        if (hashMap.get((Object)"3") != null) {
            this.mClient = true;
        }
        if (this.xAct instanceof ApplicationModule) {
            this.mClient = true;
        }
        this.relIdx = (n = (Integer)hashMap.get((Object)"0")) != null ? n : this.relIdx;
        this.mIndexString = null;
    }

    abstract void prepareForDML(Object var1);

    abstract byte[] readBytesFromLob(long var1, int var3);

    abstract void writeBytesToLob();

    abstract OutputStream getInternalOutputStream();

    abstract InputStream getInternalStream();

    abstract InputStream getInternalDataStream();

    abstract void syncLob(Datum var1);

    abstract long getLength();

    protected int getRemoteBufferSize() {
        Method method = BaseLobDomain.getInvokeDomainMethod();
        try {
            if (this.mIndexString == null) {
                this.getRemoteIdString();
            }
            Object object = method.invoke((Object)this.xAct, this.getOwnerRow(), this.mIndexString, Boolean.FALSE, "getBufferSize", new String[0], new Object[0]);
            System.out.println("Return value:" + object);
            if (object instanceof Number) {
                int n = ((Number)object).intValue();
                return n;
            }
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
        return 0;
    }

    protected long getRemoteLength() {
        Method method = BaseLobDomain.getInvokeDomainMethod();
        try {
            if (this.mIndexString == null) {
                this.getRemoteIdString();
            }
            Object object = method.invoke((Object)this.xAct, this.getOwnerRow(), this.mIndexString, Boolean.FALSE, "getLength", new String[0], new Object[0]);
            System.out.println("Return value:" + object);
            if (object instanceof Number) {
                long l = ((Number)object).longValue();
                return l;
            }
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
        return 0L;
    }

    private ByteArrayOutputStream dumplob() {
        try {
            this.mData = new BlobOutputStream();
            try {
                byte[] byArray;
                int n = 0;
                int n2 = 31744;
                while ((byArray = this.readBytesFromLob(n + 1, n2)) != null) {
                    this.mData.write(byArray, 0, byArray.length);
                    n += byArray.length;
                    if (byArray.length == n2) continue;
                    break;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.mData.flush();
            this.mData.close();
        }
        catch (Exception exception) {
            new JboException((Throwable)exception);
        }
        return this.mData;
    }

    private void dumpStream() {
        InputStream inputStream = this.getInputStream();
        try {
            this.mData = new BlobOutputStream();
            try {
                boolean bl = false;
                int n = 31744;
                byte[] byArray = new byte[n];
                do {
                    n = inputStream.read(byArray, 0, n);
                    this.mData.write(byArray, 0, n);
                } while (byArray.length == n);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.mData.flush();
            this.closeInputStream();
            this.mData.close();
        }
        catch (Exception exception) {
            new JboException((Throwable)exception);
        }
    }

    public Object getData() {
        return this.lob;
    }

    public void saveToDatabase(Transaction transaction) throws SQLException {
        if (this.lob != null && this.mData != null) {
            this.writeBytesToLob();
        }
    }

    public void saveToDatabase(Transaction transaction, Object object) throws SQLException {
        try {
            if (this.inStream != null) {
                this.inStream.close();
                this.inStream = null;
            }
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
        this.closeOutputStream();
        if (this.mData != null) {
            this.syncLob(((BaseLobDomain)object).lob);
            this.writeBytesToLob();
        }
    }

    public String toString() {
        if (!(this.mData != null || this.lob != null || this.mClient && this.mOwner != null)) {
            return "";
        }
        byte[] byArray = this.toByteArray();
        if (byArray != null) {
            return new String(byArray);
        }
        return "";
    }

    public boolean isCacheDataModified() {
        return this.mDataModified && this.mData != null;
    }

    public byte[] getStorageByteArray() {
        if (this.mData != null) {
            return this.mData.getStorage();
        }
        return null;
    }

    public byte[] toByteArray() {
        if (!this.mDataModified && this.mData == null) {
            if (this.lob != null) {
                this.dumplob();
            } else if (this.mOwner != null) {
                this.dumpStream();
            }
        }
        if (this.mData != null) {
            return this.mData.toByteArray();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof BaseLobDomain) {
            BaseLobDomain baseLobDomain = (BaseLobDomain)object;
            if (this.lob != null && baseLobDomain.lob != null && !this.mDataModified) {
                if (this.lob == baseLobDomain.lob) {
                    return true;
                }
                return this.getLength() == baseLobDomain.getLength();
            }
            if (this.mData == null && this.lob != null) {
                this.dumplob();
            }
            if (baseLobDomain.mData == null && baseLobDomain.lob != null) {
                baseLobDomain.dumplob();
            }
            if (this.mData == baseLobDomain.mData) {
                return true;
            }
            if (this.mData != null) {
                return baseLobDomain.mData != null ? this.mData.size() == baseLobDomain.mData.size() : false;
            }
            return baseLobDomain.getData() == null;
        }
        return false;
    }

    public ResponseValues marshal() {
        boolean bl;
        SvcMsgResponseValues svcMsgResponseValues = new SvcMsgResponseValues(4255, null);
        boolean bl2 = this.mClient || this.mDataModified;
        String string = this.getClass().getName();
        byte[] byArray = null;
        if (this.mDataModified) {
            bl = false;
            byArray = this.toByteArray();
        } else {
            bl = !this.mClient && this.lob != null || this.mClient && this.mNeedsServerSync;
        }
        svcMsgResponseValues.setBooleanValues(new boolean[]{bl2, this.mDataModified, bl});
        svcMsgResponseValues.setObjectValues(new Object[]{string, byArray});
        return svcMsgResponseValues;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.mClient || this.mDataModified);
        if (this.mClient || this.mDataModified) {
            objectOutputStream.writeBoolean(this.mDataModified);
            if (this.mDataModified) {
                byte[] byArray = this.toByteArray();
                if (byArray != null) {
                    objectOutputStream.writeInt(byArray.length);
                    int n = 0;
                    while (n < byArray.length) {
                        objectOutputStream.write(byArray[n]);
                        ++n;
                    }
                } else {
                    objectOutputStream.writeInt(-1);
                }
                objectOutputStream.writeBoolean(false);
                return;
            }
        }
        objectOutputStream.writeBoolean(!this.mClient && this.lob != null || this.mClient && this.mNeedsServerSync);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = objectInputStream.readBoolean();
        if (bl && objectInputStream.readBoolean()) {
            int n = objectInputStream.readInt();
            byte[] byArray = null;
            if (n > -1) {
                byArray = new byte[n];
                int n2 = 0;
                while (n2 < byArray.length) {
                    byArray[n2] = (byte)objectInputStream.read();
                    ++n2;
                }
            }
            this.setBytes(byArray);
        }
        this.mNeedsServerSync = objectInputStream.readBoolean();
    }

    public OutputStream getOutputStream() {
        if (this.outStream != null) {
            return this.outStream;
        }
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inStream = null;
        }
        if (!this.mDataModified && this.mData != null) {
            this.resetCachedData();
        }
        if (!this.mClient) {
            DomainOwnerInterface domainOwnerInterface = this.getOwnerRow();
            if (domainOwnerInterface != null) {
                try {
                    Method method;
                    Class<?> clazz = Class.forName("oracle.jbo.server.EntityDefImpl");
                    Class[] classArray = new Class[1];
                    Class clazz2 = class$oracle$jbo$Row;
                    if (clazz2 == null) {
                        clazz2 = classArray[0] = (class$oracle$jbo$Row = BaseLobDomain.class$("oracle.jbo.Row"));
                    }
                    if (!((Boolean)(method = clazz.getMethod("checkEntityLocked", classArray)).invoke(null, domainOwnerInterface)).booleanValue()) {
                        Class clazz3 = class$oracle$jbo$CSMessageBundle;
                        if (clazz3 == null) {
                            clazz3 = class$oracle$jbo$CSMessageBundle = BaseLobDomain.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new JboException(clazz3, "25040", null);
                    }
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)exception);
                }
            }
            if (this.lob != null) {
                if (this.mDataModified) {
                    this.writeBytesToLob();
                }
                this.outStream = this.getInternalOutputStream();
            } else if (this.mData != null) {
                this.outStream = this.mData;
            } else {
                this.mData = new BlobOutputStream();
                this.outStream = this.mData;
                this.mDataModified = true;
            }
        } else {
            if (this.mIndexString == null) {
                this.getRemoteIdString();
            }
            try {
                Class clazz;
                Class clazz4;
                Class<?> clazz5 = Class.forName(CLIENT_LOB_DOMAIN_OUTPUT);
                Class[] classArray = new Class[3];
                Class clazz6 = class$oracle$jbo$Transaction;
                if (clazz6 == null) {
                    clazz6 = classArray[0] = (class$oracle$jbo$Transaction = BaseLobDomain.class$("oracle.jbo.Transaction"));
                }
                if ((clazz4 = class$oracle$jbo$domain$DomainOwnerInterface) == null) {
                    clazz4 = classArray[1] = (class$oracle$jbo$domain$DomainOwnerInterface = BaseLobDomain.class$("oracle.jbo.domain.DomainOwnerInterface"));
                }
                if ((clazz = class$java$lang$String) == null) {
                    clazz = class$java$lang$String = BaseLobDomain.class$("java.lang.String");
                }
                classArray[2] = clazz;
                Constructor<?> constructor = clazz5.getConstructor(classArray);
                this.outStream = (OutputStream)constructor.newInstance(this.xAct, this.getOwnerRow(), this.mIndexString);
                this.resetCachedData();
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof JboException) {
                    throw (JboException)throwable;
                }
                throw new JboException(throwable);
            }
        }
        return this.outStream;
    }

    public String getRemoteIdString() {
        if (this.mIndexString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.relIdx.toString());
            DomainOwnerInterface domainOwnerInterface = this.mOwner;
            while (domainOwnerInterface instanceof LobInterface) {
                stringBuffer = stringBuffer.insert(0, '.');
                stringBuffer = stringBuffer.insert(0, new Integer(((LobInterface)domainOwnerInterface).getOwnerAttributeIndex()).toString());
                domainOwnerInterface = ((LobInterface)domainOwnerInterface).getOwner();
            }
            this.mIndexString = stringBuffer.toString();
        }
        return this.mIndexString;
    }

    public DomainOwnerInterface getOwner() {
        return this.mOwner;
    }

    public int getOwnerAttributeIndex() {
        return this.relIdx;
    }

    protected DomainOwnerInterface getOwnerRow() {
        DomainOwnerInterface domainOwnerInterface = this.mOwner;
        while (domainOwnerInterface instanceof LobInterface) {
            domainOwnerInterface = ((LobInterface)domainOwnerInterface).getOwner();
        }
        return domainOwnerInterface instanceof Row ? domainOwnerInterface : null;
    }

    public InputStream getInputStream() {
        boolean bl = true;
        if (this.inStream != null) {
            try {
                if (this.inStream.available() > 0) {
                    InputStream inputStream = this.inStream;
                    return inputStream;
                }
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (mReopenStream == -1) {
                int n = mReopenStream = PropertyMetadata.JBO_BLOB_REOPEN_STREAM.getPropertyAsBoolean() ? 1 : 0;
            }
            if (mReopenStream == 0) {
                bl = false;
            }
        }
        if (this.lob != null) {
            if (this.mDataModified) {
                this.writeBytesToLob();
                bl = true;
            }
            if (bl) {
                this.inStream = this.getInternalStream();
                try {
                    this.inStream.reset();
                }
                catch (IOException iOException) {}
            }
        } else if (this.mData != null || this.mDataModified) {
            if (bl) {
                this.inStream = this.getInternalDataStream();
            }
        } else if (this.mClient) {
            if (this.mIndexString == null) {
                this.getRemoteIdString();
            }
            try {
                Class clazz;
                Class clazz2;
                Class<?> clazz3 = Class.forName(CLIENT_LOB_DOMAIN_INPUT);
                Class[] classArray = new Class[3];
                Class clazz4 = class$oracle$jbo$Transaction;
                if (clazz4 == null) {
                    clazz4 = classArray[0] = (class$oracle$jbo$Transaction = BaseLobDomain.class$("oracle.jbo.Transaction"));
                }
                if ((clazz2 = class$oracle$jbo$domain$DomainOwnerInterface) == null) {
                    clazz2 = classArray[1] = (class$oracle$jbo$domain$DomainOwnerInterface = BaseLobDomain.class$("oracle.jbo.domain.DomainOwnerInterface"));
                }
                if ((clazz = class$java$lang$String) == null) {
                    clazz = class$java$lang$String = BaseLobDomain.class$("java.lang.String");
                }
                classArray[2] = clazz;
                Constructor<?> constructor = clazz3.getConstructor(classArray);
                this.inStream = (InputStream)constructor.newInstance(this.xAct, this.getOwnerRow(), this.mIndexString);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof JboException) {
                    throw (JboException)throwable;
                }
                throw new JboException(throwable);
            }
        }
        return this.inStream;
    }

    public Reader getCharacterStream() {
        if (this.inReader != null) {
            return this.inReader;
        }
        this.inReader = new InputStreamReader(this.getInputStream());
        return this.inReader;
    }

    protected void resetCachedData() {
        this.mData = null;
        this.mDataModified = false;
    }

    public void syncClientLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            BaseLobDomain baseLobDomain = (BaseLobDomain)lobInterface;
            this.mData = null;
            this.mDataModified = false;
            this.mData = baseLobDomain.mData;
            this.mDataModified = baseLobDomain.mDataModified;
            if (this.inStream != null) {
                try {
                    this.inStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.inStream = null;
            }
            this.closeOutputStream();
        }
    }

    public void syncServerLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            BaseLobDomain baseLobDomain = (BaseLobDomain)lobInterface;
            if (this.mNeedsServerSync) {
                this.syncLob(baseLobDomain.lob);
                this.mData = baseLobDomain.mData;
                this.inStream = baseLobDomain.inStream;
                this.outStream = baseLobDomain.outStream;
                this.mDataModified = baseLobDomain.mDataModified;
                this.mNeedsServerSync = false;
            } else if (baseLobDomain.xAct != null && !baseLobDomain.mDataModified && !this.mDataModified) {
                this.syncLob(baseLobDomain.lob);
                this.mData = null;
                this.mDataModified = false;
                if (this.inStream != null) {
                    try {
                        this.inStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.inStream = null;
                }
                this.closeOutputStream();
            } else if (baseLobDomain.mDataModified && !this.mDataModified) {
                this.mData = baseLobDomain.mData;
                this.mDataModified = baseLobDomain.mDataModified;
            }
            this.mOwner = baseLobDomain.mOwner;
            this.xAct = baseLobDomain.xAct;
            this.mClient = baseLobDomain.mClient;
            this.relIdx = baseLobDomain.relIdx;
        }
    }

    public long getSize() {
        return -1;
    }

    public static Method getInvokeDomainMethod() {
        try {
            Method method;
            Class clazz;
            Class clazz2;
            Class clazz3;
            Class<?> clazz4 = Class.forName(CLIENT_APPMODULE_CLASS);
            Class[] classArray = new Class[6];
            Class clazz5 = class$oracle$jbo$Row;
            if (clazz5 == null) {
                clazz5 = classArray[0] = (class$oracle$jbo$Row = BaseLobDomain.class$("oracle.jbo.Row"));
            }
            if ((clazz3 = class$java$lang$String) == null) {
                clazz3 = class$java$lang$String = BaseLobDomain.class$("java.lang.String");
            }
            classArray[1] = clazz3;
            classArray[2] = Boolean.TYPE;
            Class clazz6 = class$java$lang$String;
            if (clazz6 == null) {
                clazz6 = classArray[3] = (class$java$lang$String = BaseLobDomain.class$("java.lang.String"));
            }
            if ((clazz2 = array$Ljava$lang$String) == null) {
                clazz2 = classArray[4] = (array$Ljava$lang$String = BaseLobDomain.class$("[Ljava.lang.String;"));
            }
            if ((clazz = array$Ljava$lang$Object) == null) {
                clazz = array$Ljava$lang$Object = BaseLobDomain.class$("[Ljava.lang.Object;");
            }
            classArray[5] = clazz;
            Method method2 = method = clazz4.getMethod("invokeDomainMethod", classArray);
            return method2;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public void closeOutputStream() {
        if (this.outStream != null) {
            try {
                this.outStream.flush();
                this.outStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outStream = null;
        }
    }

    public void closeInputStream() {
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inStream = null;
        }
    }

    public void closeCharacterStream() {
        if (this.inReader != null) {
            try {
                this.inReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inReader = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class BlobOutputStream
    extends ByteArrayOutputStream {
        BlobOutputStream() {
            super(128);
        }

        BlobOutputStream(int n) {
            super(n);
        }

        synchronized byte[] getStorage() {
            return this.buf;
        }
    }
}

