/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

class ClassLoaderChooser {
    private static int STACK_OFFSET = 3;
    private static final ClassStackWrapper CLASS_STACK;

    private ClassLoaderChooser() {
    }

    public static synchronized ClassLoader getClassLoader() {
        Class clazz = ClassLoaderChooser.getCallerClass(0);
        return clazz.getClassLoader();
    }

    private static Class getCallerClass(int n) {
        return CLASS_STACK.getClassContext()[STACK_OFFSET + n];
    }

    static {
        try {
            CLASS_STACK = new ClassStackWrapper();
        }
        catch (SecurityException securityException) {
            throw new RuntimeException("ClassLoadChooser: could not create ClassLoadChooser: " + securityException);
        }
    }

    private static final class ClassStackWrapper
    extends SecurityManager {
        private ClassStackWrapper() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

