/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.CharConvBuilder;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.util.CharConvBuilder.MappingSetter;

abstract class LCMapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    static final int LCWIDTH = 16;
    static final int LCSHIFT = 16;
    static final int LCMASK = 65535;
    static final int INVALIDLC = 65535;
    int m_l1BlockSize = 256;
    int m_ucsReplacement;
    char[] m_leadingCode;
    int m_lcCount;
    Vector[] m_mapStores;

    LCMapSetter(int n, int n2) {
        super(n);
        this.m_ucsReplacement = n2;
        this.m_leadingCode = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
        this.m_mapStores = new Vector[this.m_leadingCode.length];
        this.m_lcCount = 0;
    }

    boolean set(int n, int n2) throws IOException {
        Vector<int[]> vector;
        int n3;
        int n4 = n >> 16 & 0xFFFF;
        int n5 = -1;
        for (n3 = 0; n3 < this.m_lcCount; ++n3) {
            if (n4 != this.m_leadingCode[n3]) continue;
            n5 = n3;
            break;
        }
        if (n5 == -1) {
            if (n3 < this.m_leadingCode.length) {
                this.m_leadingCode[n3] = (char)n4;
                n5 = n3;
                this.m_lcCount = n3 + 1;
            } else {
                this.printErrorMsg("***** Error: too many leading codes: " + LCMapSetter.intToHex8(n4));
                return false;
            }
        }
        if ((vector = this.m_mapStores[n3]) == null) {
            this.m_mapStores[n3] = vector = new Vector<int[]>();
        }
        n2 = (int)LCMapSetter.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL);
        int[] nArray = new int[]{n, n2};
        vector.addElement(nArray);
        return true;
    }

    void finish() {
        this.buildMapping();
        super.finish();
    }

    void buildMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        Vector vector;
        int n7;
        int n8;
        int n9;
        int n10 = 8;
        int n11 = 8;
        int n12 = (1 << n10) - 1;
        int n13 = (1 << n11) - 1;
        int n14 = this.m_l1BlockSize * this.m_lcCount;
        char[] cArray = new char[n14];
        char[][] cArray2 = new char[n14][2];
        for (n9 = 0; n9 < n14; ++n9) {
            cArray[n9] = 65535;
            cArray2[n9][0] = (char)n13;
            cArray2[n9][1] = '\u0000';
        }
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        for (n8 = 0; n8 < this.m_lcCount; ++n8) {
            n7 = this.m_l1BlockSize * n8;
            vector = this.m_mapStores[n8];
            n6 = vector.size();
            for (n9 = 0; n9 < n6; ++n9) {
                nArray = (int[])vector.elementAt(n9);
                n5 = nArray[1];
                if (n5 == -1) continue;
                n4 = nArray[0];
                if (hashtable.get(new Integer(n5)) == null) {
                    hashtable.put(new Integer(n5), new Integer(n4));
                } else {
                    hashtable2.put(new Integer(n5), hashtable.get(new Integer(n5)));
                }
                n3 = (n4 >> n11 & n12) + n7;
                cArray[n3] = '\u0001';
                n2 = n4 & n13;
                if (n2 < cArray2[n3][0]) {
                    cArray2[n3][0] = (char)n2;
                }
                if (n2 <= cArray2[n3][1]) continue;
                cArray2[n3][1] = (char)n2;
            }
        }
        int n15 = n = n13 + 1;
        int n16 = 0;
        for (n9 = 0; n9 < n14; ++n9) {
            if (cArray[n9] == '\uffff') continue;
            int n17 = cArray2[n9][0];
            cArray[n9] = (char)(n15 - (n16 < n17 ? n16 : n17));
            n15 = cArray[n9] + n;
            n16 = n - cArray2[n9][1] - 1;
        }
        int[] nArray2 = new int[n15];
        for (n9 = 0; n9 < n15; ++n9) {
            nArray2[n9] = -1;
        }
        for (n8 = 0; n8 < this.m_lcCount; ++n8) {
            n7 = this.m_l1BlockSize * n8;
            vector = this.m_mapStores[n8];
            n6 = vector.size();
            for (n9 = 0; n9 < n6; ++n9) {
                nArray = (int[])vector.elementAt(n9);
                n5 = nArray[1];
                if (n5 == -1) continue;
                n4 = nArray[0];
                n3 = (n4 >> n11 & n12) + n7;
                n2 = n4 & n13;
                int n18 = cArray[n3] + n2;
                nArray2[n18] = n5;
            }
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setLCTable();
        this.setDuplicateMapping(hashtable2);
    }

    abstract void setArray2(int[] var1);

    abstract void setArray(char[] var1);

    abstract void setLCTable();

    abstract void setDuplicateMapping(Hashtable var1);
}

