/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterSJIS
extends CharacterConverter12Byte {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;

    public CharacterConverterSJIS() {
        this.m_groupId = 4;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 2.0f;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = n; i < n3; ++i) {
            int n4;
            int n5 = byArray[i] & 0xFF;
            if (n5 > 223 || n5 > 127 && n5 < 161) {
                if (i < n3 - 1) {
                    n5 = byArray[i] << 8 & 0xFF00 | byArray[i + 1] & 0xFF;
                    ++i;
                } else {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
            }
            if (((long)(n4 = this.toUnicode(n5)) & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n4 >>> 16));
                stringBuffer.append((char)(n4 & 0xFFFF));
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5 = byArray[n + i] & 0xFF;
            if ((n5 > 223 || n5 > 127 && n5 < 161) && i < n3 - 1) {
                n5 = byArray[i] << 8 & 0xFF00 | byArray[i + 1] & 0xFF;
                ++i;
            }
            if (((long)(n4 = this.toUnicodeWithReplacement(n5)) & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n4 >>> 16));
                stringBuffer.append((char)(n4 & 0xFFFF));
                continue;
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }
}

