/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.localesource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.servlet.ServletHelper;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.text.OraCollator;
import oracle.i18n.text.OraDecimalFormat;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;

public class DBLocaleSource
extends LocaleSource {
    public static final Class OBJECT_KEY = class$oracle$i18n$servlet$localesource$DBLocaleSource == null ? (class$oracle$i18n$servlet$localesource$DBLocaleSource = DBLocaleSource.class$("oracle.i18n.servlet.localesource.DBLocaleSource")) : class$oracle$i18n$servlet$localesource$DBLocaleSource;
    private static final String M_C_DATA_SOURCE_NAME = "data-source-name";
    private static final String M_C_LOCALE_SOURCE_TABLE = "locale-source-table";
    private static final String M_C_USER_COLUMN = "user-column";
    private static final String M_C_USER_KEY = "user-key";
    private static final String M_C_LOCALE_COLUMN = "locale-column";
    private static final String M_C_LANGUAGE_COLUMN = "language-column";
    private static final String M_C_SHORT_LANGUAGE_COLUMN = "short-language-column";
    private static final String M_C_TERRITORY_COLUMN = "territory-column";
    private static final String M_C_CHARSET_COLUMN = "charset-column";
    private static final String M_C_TIMEZONE_COLUMN = "timezone-column";
    private static final String M_C_LINGUISTIC_SORT_COLUMN = "linugistic-sort-column";
    private static final String M_C_DATE_FORMAT_COLUMN = "date-format-column";
    private static final String M_C_LONG_DATE_FORMAT_COLUMN = "long-date-format-column";
    private static final String M_C_TIME_FORMAT_COLUMN = "time-format-column";
    private static final String M_C_DATE_TIME_FORMAT_COLUMN = "date-time-format-column";
    private static final String M_C_LONG_DATE_TIME_FORMAT_COLUMN = "long-date-time-format-column";
    private static final String M_C_NUMBER_FORMAT_COLUMN = "number-format-column";
    private static final String M_C_CURRENCY_FORMAT_COLUMN = "currency-format-column";
    private static final String M_C_WRITING_DIRECTION_COLUMN = "writing-direction-column";
    private static final String M_C_ISO_CURRENCY_COLUMN = "iso-currency-column";
    private String m_user;
    private final ApplicationContext m_appctx;
    private final Map m_params;
    private DataSource m_datasrc;
    private final boolean m_is_locale;
    private final boolean m_is_short_lang;
    private final String m_loadStatement;
    private final String m_storeStatement;
    private final List m_paramList = new ArrayList();
    static /* synthetic */ Class class$oracle$i18n$servlet$localesource$DBLocaleSource;

    private DBLocaleSource(String string, Map map, ApplicationContext applicationContext) {
        super(class$oracle$i18n$servlet$localesource$DBLocaleSource == null ? (class$oracle$i18n$servlet$localesource$DBLocaleSource = DBLocaleSource.class$("oracle.i18n.servlet.localesource.DBLocaleSource")) : class$oracle$i18n$servlet$localesource$DBLocaleSource, true, false, false);
        String string2;
        String string3;
        Object object;
        this.m_user = string;
        this.m_appctx = applicationContext;
        this.m_params = map;
        try {
            object = new InitialContext();
            string3 = (String)map.get(M_C_DATA_SOURCE_NAME);
            this.m_datasrc = (DataSource)object.lookup(string3);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        object = (String)this.m_params.get(M_C_LOCALE_SOURCE_TABLE);
        string3 = (String)this.m_params.get(M_C_USER_COLUMN);
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        StringBuffer stringBuffer2 = new StringBuffer("UPDATE ").append((String)object).append(" SET ");
        String string4 = (String)this.m_params.get(M_C_LANGUAGE_COLUMN);
        String string5 = (String)this.m_params.get(M_C_SHORT_LANGUAGE_COLUMN);
        String string6 = (String)this.m_params.get(M_C_TERRITORY_COLUMN);
        if (string5 == null && string4 == null || string6 == null) {
            string2 = (String)this.m_params.get(M_C_LOCALE_COLUMN);
            if (string2 == null) {
                throw new IllegalArgumentException("Locale column or language and territory columns must be specified.");
            }
            stringBuffer.append(string2);
            stringBuffer2.append(string2).append("=?");
            this.m_is_locale = true;
            this.m_is_short_lang = false;
        } else {
            this.m_is_locale = false;
            if (string4 == null) {
                string4 = string5;
                this.m_is_short_lang = true;
            } else {
                this.m_is_short_lang = false;
            }
            stringBuffer.append(string4).append(", ").append(string6);
            stringBuffer2.append(string4).append("=?,").append(string6).append("=?");
        }
        string2 = (String)this.m_params.get(M_C_CHARSET_COLUMN);
        if (string2 != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.CHARSET);
        }
        if ((string2 = (String)this.m_params.get(M_C_TIMEZONE_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.TIMEZONE);
        }
        if ((string2 = (String)this.m_params.get(M_C_LINGUISTIC_SORT_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.LINGUISTIC_SORT);
        }
        if ((string2 = (String)this.m_params.get(M_C_DATE_FORMAT_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.DATE_FORMAT);
        }
        if ((string2 = (String)this.m_params.get(M_C_LONG_DATE_FORMAT_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.LONG_DATE_FORMAT);
        }
        if ((string2 = (String)this.m_params.get(M_C_TIME_FORMAT_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.TIME_FORMAT);
        }
        if ((string2 = (String)this.m_params.get(M_C_DATE_TIME_FORMAT_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.DATE_TIME_FORMAT);
        }
        if ((string2 = (String)this.m_params.get(M_C_LONG_DATE_TIME_FORMAT_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.LONG_DATE_TIME_FORMAT);
        }
        if ((string2 = (String)this.m_params.get(M_C_NUMBER_FORMAT_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.NUMBER_FORMAT);
        }
        if ((string2 = (String)this.m_params.get(M_C_CURRENCY_FORMAT_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.CURRENCY_FORMAT);
        }
        if ((string2 = (String)this.m_params.get(M_C_WRITING_DIRECTION_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.WRITING_DIRECTION);
        }
        if ((string2 = (String)this.m_params.get(M_C_ISO_CURRENCY_COLUMN)) != null) {
            stringBuffer.append(",").append(string2);
            stringBuffer2.append(",").append(string2).append("=?");
            this.m_paramList.add(LocaleSource.Parameter.ISO_CURRENCY);
        }
        this.m_loadStatement = stringBuffer.append(" FROM ").append((String)object).append(" WHERE LOWER(").append(string3).append(") = LOWER(?)").toString();
        this.m_storeStatement = stringBuffer2.append(" WHERE LOWER(").append(string3).append(") = LOWER(?)").toString();
    }

    public static LocaleSource getInstance(HttpServletRequest httpServletRequest) {
        Map map = (Map)httpServletRequest.getAttribute("oracle.i18n.servlet.localesource.LocaleSource.paramkey");
        String string = (String)map.get(M_C_USER_KEY);
        Object object = httpServletRequest.getSession().getAttribute(string);
        if (object == null) {
            return null;
        }
        return new DBLocaleSource((String)object, map, ServletHelper.getApplicationContextInstance(httpServletRequest));
    }

    public static boolean isAccessible(HttpServletRequest httpServletRequest) {
        Map map = (Map)httpServletRequest.getAttribute("oracle.i18n.servlet.localesource.LocaleSource.paramkey");
        String string = (String)map.get(M_C_USER_KEY);
        Object object = httpServletRequest.getSession().getAttribute(string);
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean store() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.m_datasrc.getConnection();
            preparedStatement = connection.prepareStatement(this.m_storeStatement);
            int n = 1;
            if (this.m_is_locale) {
                preparedStatement.setString(n++, this.getLocale().toString());
            } else {
                OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance(this.getLocale());
                if (this.m_is_short_lang) {
                    preparedStatement.setString(n++, oraLocaleInfo.getShortLanguage());
                } else {
                    preparedStatement.setString(n++, oraLocaleInfo.getLanguage());
                }
                preparedStatement.setString(n++, oraLocaleInfo.getTerritory());
            }
            for (int i = 0; i < this.m_paramList.size(); ++i) {
                Object object;
                LocaleSource.Parameter parameter = (LocaleSource.Parameter)this.m_paramList.get(i);
                if (parameter == LocaleSource.Parameter.TIMEZONE) {
                    object = (TimeZone)this.getAttribute(parameter);
                    if (object == null) continue;
                    preparedStatement.setString(n++, ((TimeZone)object).getID());
                    continue;
                }
                if (parameter == LocaleSource.Parameter.CURRENCY_FORMAT || parameter == LocaleSource.Parameter.NUMBER_FORMAT) {
                    object = (OraDecimalFormat)this.getAttribute(parameter);
                    if (object == null) continue;
                    preparedStatement.setString(n++, ((OraDecimalFormat)object).toPattern());
                    continue;
                }
                if (parameter == LocaleSource.Parameter.LINGUISTIC_SORT) {
                    object = this.getCollator();
                    if (object == null) continue;
                    preparedStatement.setString(n++, ((OraCollator)object).getName());
                    continue;
                }
                if (parameter == LocaleSource.Parameter.WRITING_DIRECTION) {
                    object = this.getWritingDirection();
                    if (object == null) continue;
                    preparedStatement.setString(n++, ((LocaleSource.WritingDirection)object).toString());
                    continue;
                }
                if (parameter == LocaleSource.Parameter.DATE_FORMAT || parameter == LocaleSource.Parameter.DATE_TIME_FORMAT || parameter == LocaleSource.Parameter.LONG_DATE_FORMAT || parameter == LocaleSource.Parameter.LONG_DATE_TIME_FORMAT || parameter == LocaleSource.Parameter.TIME_FORMAT) {
                    object = (OraSimpleDateFormat)this.getAttribute(parameter);
                    if (object == null) continue;
                    preparedStatement.setString(n++, ((OraSimpleDateFormat)object).toPattern());
                    continue;
                }
                object = this.getAttribute(parameter);
                if (object == null) continue;
                preparedStatement.setString(n++, (String)object);
            }
            preparedStatement.setString(n, this.m_user);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            boolean bl;
            try {
                this.m_user = null;
                bl = false;
            }
            catch (Throwable throwable) {
                DBLocaleSource.closeAllObjects(connection, preparedStatement, null);
                throw throwable;
            }
            DBLocaleSource.closeAllObjects(connection, preparedStatement, null);
            return bl;
        }
        DBLocaleSource.closeAllObjects(connection, preparedStatement, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block20: {
            connection = null;
            preparedStatement = null;
            resultSet = null;
            connection = this.m_datasrc.getConnection();
            preparedStatement = connection.prepareStatement(this.m_loadStatement);
            preparedStatement.setString(1, this.m_user);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) break block20;
            this.m_user = null;
            boolean bl = false;
            DBLocaleSource.closeAllObjects(connection, preparedStatement, resultSet);
            return bl;
        }
        try {
            int n = 1;
            if (this.m_is_locale) {
                this.setLocale(this.m_appctx.fallbackLocale(OraLocaleInfo.getLocaleFromString(resultSet.getString(n++))));
            } else if (this.m_is_short_lang) {
                this.setLocale(this.m_appctx.fallbackLocale(OraLocaleInfo.getInstance(LocaleMapper.getOraLanguageFromShortName(resultSet.getString(n++)), resultSet.getString(n++)).getLocale()));
            } else {
                this.setLocale(this.m_appctx.fallbackLocale(OraLocaleInfo.getInstance(resultSet.getString(n++), resultSet.getString(n++)).getLocale()));
            }
            int n2 = this.m_paramList.size();
            for (int i = 0; i < n2; ++i) {
                LocaleSource.Parameter parameter = (LocaleSource.Parameter)this.m_paramList.get(i);
                if (parameter == LocaleSource.Parameter.TIMEZONE) {
                    this.setTimeZone(TimeZone.getTimeZone(resultSet.getString(n++)));
                    continue;
                }
                if (parameter == LocaleSource.Parameter.CURRENCY_FORMAT || parameter == LocaleSource.Parameter.NUMBER_FORMAT) {
                    try {
                        this.setAttribute(parameter, (Object)new OraDecimalFormat(resultSet.getString(n++)));
                    }
                    catch (ParseException parseException) {}
                    continue;
                }
                if (parameter == LocaleSource.Parameter.LINGUISTIC_SORT) {
                    this.setAttribute(parameter, (Object)OraCollator.getInstance(resultSet.getString(n++)));
                    continue;
                }
                if (parameter == LocaleSource.Parameter.WRITING_DIRECTION) {
                    this.setAttribute(parameter, (Object)LocaleSource.WritingDirection.getWritingDirection(resultSet.getString(n++)));
                    continue;
                }
                if (parameter == LocaleSource.Parameter.DATE_FORMAT || parameter == LocaleSource.Parameter.DATE_TIME_FORMAT || parameter == LocaleSource.Parameter.LONG_DATE_FORMAT || parameter == LocaleSource.Parameter.LONG_DATE_TIME_FORMAT || parameter == LocaleSource.Parameter.TIME_FORMAT) {
                    try {
                        OraSimpleDateFormat oraSimpleDateFormat = new OraSimpleDateFormat(resultSet.getString(n++));
                        TimeZone timeZone = this.getTimeZone();
                        if (timeZone != null) {
                            oraSimpleDateFormat.setTimeZone(timeZone);
                        }
                        this.setAttribute(parameter, (Object)oraSimpleDateFormat);
                    }
                    catch (ParseException parseException) {}
                    continue;
                }
                this.setAttribute(parameter, (Object)resultSet.getString(n++));
            }
        }
        catch (SQLException sQLException) {
            boolean bl;
            try {
                this.m_user = null;
                bl = false;
            }
            catch (Throwable throwable) {
                DBLocaleSource.closeAllObjects(connection, preparedStatement, resultSet);
                throw throwable;
            }
            DBLocaleSource.closeAllObjects(connection, preparedStatement, resultSet);
            return bl;
        }
        DBLocaleSource.closeAllObjects(connection, preparedStatement, resultSet);
        return true;
    }

    private static void closeAllObjects(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

