/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.StringManager;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.rules.AbstractValidator;
import oracle.jbo.rules.JboPrecisionScaleValidator;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.RulesBeanUtils;
import oracle.jbo.rules.ValidationManager;
import oracle.jbo.uicli.binding.JUControlDef;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;

public abstract class JUCtrlValueDef
extends JUControlDef
implements ValidationManager {
    private String[] mAttrNames;
    private ArrayList mValidators;
    private HashMap mAttrValMap;
    private String mCustomInputHandler;
    private boolean mApplyValidation;
    public static final String PNAME_AttrNames = "AttrNames";
    public static final String PNAME_ApplyValidation = "ApplyValidation";
    public static final String PNAME_InputHandler = "CustomInputHandler";
    public static final String PNAME_ListNullValueId = "NullValueId";
    public static final String DEFAULT_HANDLER = "DEFAULT";
    private Object mNullValue;
    private String mNullValueId;
    private int mVarInit;
    private static /* synthetic */ Class class$oracle$jbo$uicli$UIMessageBundle;

    private /* synthetic */ void $init$() {
        this.mApplyValidation = false;
        this.mVarInit = -1;
    }

    public JUCtrlValueDef() {
        this.$init$();
    }

    public JUCtrlValueDef(String string, String string2, String string3, String string4, String[] stringArray) {
        super(string, string2, string3, string4);
        this.$init$();
        this.mAttrNames = stringArray;
    }

    public void init(HashMap hashMap) {
        super.init(hashMap);
        this.initMyValues(hashMap);
    }

    private void initMyValues(HashMap hashMap) {
        Object v = hashMap.get(PNAME_AttrNames);
        if (v != null) {
            this.mAttrNames = (String[])v;
        }
        if ((v = hashMap.get(PNAME_ApplyValidation)) != null) {
            this.mApplyValidation = JUCtrlValueDef.convertToBoolean(v);
        }
        if ((v = hashMap.get(PNAME_ListNullValueId)) != null) {
            this.mNullValueId = (String)v;
        }
        this.loadInputHandler((String)hashMap.get(PNAME_InputHandler));
    }

    public boolean isApplyValidation() {
        return this.mApplyValidation;
    }

    public void setApplyValidation(boolean bl) {
        this.mApplyValidation = bl;
    }

    public String getFirstAttrName() {
        if (this.mAttrNames == null || this.mAttrNames.length == 0) {
            return null;
        }
        return this.mAttrNames[0];
    }

    protected void setNullValueObject(Object object) {
        this.mNullValue = object;
    }

    public String getNullValueId() {
        return this.mNullValueId;
    }

    public Object getNullValueObject() {
        return this.mNullValue;
    }

    public String[] getAttrNames() {
        return this.mAttrNames;
    }

    public void addValidator(JboValidatorInterface jboValidatorInterface) {
        if (this.mValidators == null) {
            this.mValidators = new ArrayList(4);
        }
        this.mValidators.add(jboValidatorInterface);
    }

    public ArrayList getValidators() {
        return this.mValidators;
    }

    public String getCustomInputHandler() {
        return this.mCustomInputHandler;
    }

    public boolean hasCustomInputHandler() {
        return this.mCustomInputHandler != null;
    }

    public void setCustomInputHandler(String string) {
        this.mCustomInputHandler = string;
    }

    ArrayList getValidatorsForAttribute(AttributeDef attributeDef) {
        String string = attributeDef.getName();
        if (this.mAttrValMap != null && this.mAttrValMap.containsKey(string)) {
            return (ArrayList)this.mAttrValMap.get(string);
        }
        ArrayList<JboPrecisionScaleValidator> arrayList = null;
        ArrayList arrayList2 = this.getValidators();
        if (arrayList2 != null) {
            int n = arrayList2.size();
            arrayList = new ArrayList<JboPrecisionScaleValidator>(n);
            int n2 = 0;
            while (n2 < n) {
                Object e = arrayList2.get(n2);
                if (e instanceof AbstractValidator && string.equals(((AbstractValidator)e).getValidatingAttributeName())) {
                    arrayList.add((JboPrecisionScaleValidator)e);
                }
                ++n2;
            }
        }
        if (attributeDef.getPrecision() > 0) {
            if (arrayList == null) {
                arrayList = new ArrayList(1);
            }
            arrayList.add(JboPrecisionScaleValidator.getSingleton());
        }
        this.setValidatorsForAttribute(string, arrayList);
        return arrayList;
    }

    void setValidatorsForAttribute(String string, ArrayList arrayList) {
        if (this.mAttrValMap == null) {
            this.mAttrValMap = new HashMap(this.mAttrNames != null ? this.mAttrNames.length : 2);
        }
        this.mAttrValMap.put(string, arrayList);
    }

    protected void loadChildrenFromXML(DefElement defElement) {
        super.loadChildrenFromXML(defElement);
        HashMap hashMap = new HashMap(3);
        JUCtrlValueDef.readXMLStringArray(defElement, PNAME_AttrNames, hashMap);
        this.initMyValues(hashMap);
    }

    protected void loadCustomDef(DefElement defElement) {
        RulesBeanUtils.loadValidators(defElement, this, this.getMessageBundleClass());
    }

    public void loadFromXML(DefElement defElement) {
        super.loadFromXML(defElement);
        this.mNullValueId = defElement.readString(PNAME_ListNullValueId);
        this.mApplyValidation = defElement.readBoolean(PNAME_ApplyValidation);
        this.loadInputHandler(defElement.readString(PNAME_InputHandler));
    }

    private final void loadInputHandler(String string) {
        if (string != null && string.length() > 0) {
            this.mCustomInputHandler = string;
        }
    }

    public DCControlBinding createControlBinding(Object object, DCBindingContainer dCBindingContainer) {
        JUCtrlValueBinding jUCtrlValueBinding = (JUCtrlValueBinding)super.createControlBinding(object, dCBindingContainer);
        if (this.hasCustomInputHandler()) {
            jUCtrlValueBinding.lookupInputHandler();
        }
        return jUCtrlValueBinding;
    }

    public JUIteratorBinding getIterBinding(JUFormBinding jUFormBinding) {
        try {
            JUIteratorBinding jUIteratorBinding = super.getIterBinding(jUFormBinding);
            return jUIteratorBinding;
        }
        catch (JboException jboException) {
            if (this.getIterBindingName() == null && this.hasVariables()) {
                JUIteratorBinding jUIteratorBinding = null;
                return jUIteratorBinding;
            }
            throw jboException;
        }
    }

    public final Class getMessageBundleClass() {
        try {
            Class clazz = JBOClass.forName(this.getBindingContainerDef().getMessageBundleClassName());
            return clazz;
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Ignoring exception on loading Message bundle for :" + this.getBindingContainerDef().getName());
            }
            return null;
        }
    }

    boolean hasVariables() {
        if (this.mVarInit == -1) {
            this.mVarInit = this.getIterBindingName() == null && this.mAttrNames != null && this.mAttrNames.length > 0 ? 1 : 0;
        }
        return this.mVarInit == 1;
    }

    String initializeNullValue(DCBindingContainer dCBindingContainer) {
        if (this.mNullValueId != null) {
            try {
                String string = dCBindingContainer.getDef().getMessageBundleClassName();
                LocaleContext localeContext = dCBindingContainer.getLocaleContext();
                Locale locale = localeContext != null ? localeContext.getLocale() : Locale.getDefault();
                Class clazz = class$oracle$jbo$uicli$UIMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$uicli$UIMessageBundle = JUCtrlValueDef.class$("oracle.jbo.uicli.UIMessageBundle");
                }
                this.mNullValue = StringManager.getLocalizedString(clazz.getName(), "02507", "", locale);
                if (string != null) {
                    this.mNullValue = StringManager.getLocalizedString(string, this.mNullValueId, (String)this.mNullValue, locale);
                }
            }
            catch (Exception exception) {
                Diagnostic.println("Warning! Assuming null value id as the null value due to :");
                Diagnostic.println("exception on loading null value string from message bundle for :" + this.getName());
                Diagnostic.printStackTrace(exception);
                this.mNullValue = this.mNullValueId;
            }
        }
        return (String)this.mNullValue;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

