/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.EventGroup;
import oracle.jbo.common.Instrumentation;
import oracle.jdeveloper.profiler.ProfilerAPI;

class OjvmInstrumentation
extends Instrumentation {
    public boolean isEnabled(EventGroup eventGroup) {
        return ProfilerAPI.isActive;
    }

    public int startEvent(EventGroup eventGroup) {
        if (ProfilerAPI.isActive) {
            return this.startEvent(eventGroup, null);
        }
        return 0;
    }

    public int startEvent(EventGroup eventGroup, String string) {
        if (ProfilerAPI.isActive) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("{{ type: '" + eventGroup + "' " + string, 2);
            }
            int n = ProfilerAPI.startEvent((int)eventGroup.getID(), (String)(eventGroup + " - " + string)) + 1;
            return n;
        }
        return 0;
    }

    public void endEvent(int n) {
        if (ProfilerAPI.isActive) {
            this.endEvent(n, null);
        }
    }

    public void endEvent(int n, String string) {
        if (ProfilerAPI.isActive && n != 0) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("}}+++ End Event" + n + " " + string, 2);
            }
            ProfilerAPI.endEvent((int)(n - 1), (String)string);
        }
    }

    public void addComment(int n, String string) {
        if (ProfilerAPI.isActive && n != 0) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("--+++ EventComment" + n + " " + string, 2);
            }
            ProfilerAPI.addComment((int)(n - 1), (String)string);
        }
    }

    OjvmInstrumentation() {
    }
}

