/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;

public class JboInitialContextFactory
implements InitialContextFactory {
    private static ContextInfo vbInfo = new ContextInfo("VB", "oracle.jbo.client.remote.corba.vb.VBrokerInitialContext");
    private static ContextInfo localInfo = new ContextInfo("LOCAL", "oracle.jbo.server.InitialContextImpl");
    private static ContextInfo coloInfo = new ContextInfo("COLO", "oracle.jbo.server.remote.colo.ColoInitialContext");
    private static ContextInfo auroraInfo = new ContextInfo("8i", "oracle.jbo.client.remote.corba.aurora.AuroraInitialContext");
    private static ContextInfo ejbInfo = new ContextInfo("Ejb", "oracle.jbo.client.remote.ejb.aurora.AuroraEJBInitialContext");
    private static ContextInfo wlsInfo = new ContextInfo("EjbWls", "oracle.jbo.client.remote.ejb.wl.WLEJBInitialContext");
    private static ContextInfo iasInfo = new ContextInfo("EjbIas", "oracle.jbo.client.remote.ejb.ias.InitialContextImpl");
    private static ContextInfo[] ejbServers = new ContextInfo[]{vbInfo, iasInfo, auroraInfo, ejbInfo, localInfo, coloInfo, wlsInfo};
    private static /* synthetic */ Class class$java$util$Hashtable;

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        String string = JboEnvUtil.getDeployPlatform(hashtable);
        if (Diagnostic.isOn()) {
            Diagnostic.println("BC4JDeployPlatform: " + string);
        }
        try {
            Context context;
            Class clazz = JBOClass.forName(JboInitialContextFactory.getContextImplClassName(string));
            Class[] classArray = new Class[1];
            Class clazz2 = class$java$util$Hashtable;
            if (clazz2 == null) {
                clazz2 = class$java$util$Hashtable = JboInitialContextFactory.class$("java.util.Hashtable");
            }
            classArray[0] = clazz2;
            Context context2 = context = (Context)clazz.getConstructor(classArray).newInstance(hashtable);
            return context2;
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException(exception.getMessage());
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    private static String getContextImplClassName(String string) throws NamingException {
        if (string != null) {
            int n = 0;
            while (n < ejbServers.length) {
                if (string.compareTo(JboInitialContextFactory.ejbServers[n].name) == 0) {
                    return JboInitialContextFactory.ejbServers[n].path;
                }
                ++n;
            }
        }
        throw new NamingException("Invalid platform ");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ContextInfo {
        public String name;
        public String path;

        public ContextInfo(String string, String string2) {
            this.name = string;
            this.path = string2;
        }
    }
}

