/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class ArrayResourceBundle
extends ResourceBundle {
    private static final Logger LOG;
    private int[] _autoSyncMap;
    protected Object[] contents;
    private static /* synthetic */ Class class$oracle$jbo$common$ArrayResourceBundle;

    final String getString2(int n) {
        return (String)this.getObject(n);
    }

    public final String[] getStringArray(int n) {
        return (String[])this.getObject(n);
    }

    public final Object getObject(int n) {
        int n2;
        if (this.contents == null) {
            this.contents = this.getContents();
        }
        if ((n2 = this.getMappedIndex(n)) < this.contents.length && n2 >= 0) {
            Object object = this.contents[n2];
            return object;
        }
        if (this.parent == null) {
            throw new MissingResourceException("Can't find resource", this.getClass().getName(), String.valueOf(n));
        }
        if (this.parent instanceof ArrayResourceBundle) {
            return ((ArrayResourceBundle)this.parent).getObject(n);
        }
        return this.parent.getObject(String.valueOf(n));
    }

    protected abstract Object[] getContents();

    public final Enumeration getKeys() {
        if (this.contents == null) {
            this.contents = this.getContents();
        }
        Vector<String> vector = new Vector<String>(this.contents.length);
        int n = this.contents.length;
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(String.valueOf(n2));
            ++n2;
        }
        return vector.elements();
    }

    protected Object handleGetObject(String string) {
        return this.getObject(Integer.parseInt(string));
    }

    private int getMappedIndex(int n) {
        if (this.parent == null || !(this.parent instanceof ArrayResourceBundle)) {
            return n;
        }
        if (this._autoSyncMap == null) {
            this.buildAutoSyncMap();
        }
        try {
            int n2 = this._autoSyncMap[n];
            if (n2 == -1) {
                LOG.warning("NLSSYNC: ARB key '" + ArrayResourceBundle.getFieldNameForIndex(this.parent.getClass(), n) + "' exists in " + this.parent.getClass() + " but not in " + this.getClass().getName());
            }
            int n3 = n2;
            return n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            LOG.warning("NLSSYNC: Key " + ArrayResourceBundle.getFieldNameForIndex(this.getClass(), n) + " does not exist in " + this.getClass().getName());
            int n4 = -1;
            return n4;
        }
    }

    private void buildAutoSyncMap() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (field.getType() == Integer.TYPE) {
                try {
                    int n2 = field.getInt(null);
                    hashMap.put(field.getName(), new Integer(n2));
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            ++n;
        }
        Field[] fieldArray2 = this.parent.getClass().getDeclaredFields();
        this._autoSyncMap = new int[fieldArray2.length];
        Arrays.fill(this._autoSyncMap, -1);
        int n3 = 0;
        while (n3 < fieldArray2.length) {
            Field field = fieldArray2[n3];
            if (field.getType() == Integer.TYPE) {
                try {
                    int n4 = field.getInt(null);
                    Integer n5 = (Integer)hashMap.get(field.getName());
                    if (n5 != null) {
                        this._autoSyncMap[n4] = n5;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
            }
            ++n3;
        }
    }

    private static String getFieldNameForIndex(Class clazz, int n) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Field field = fieldArray[n2];
            if (field.getType() == Integer.TYPE) {
                try {
                    int n3 = field.getInt(null);
                    if (n3 == n) {
                        String string = field.getName();
                        return string;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return String.valueOf(n);
    }

    static {
        Class clazz = class$oracle$jbo$common$ArrayResourceBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$common$ArrayResourceBundle = ArrayResourceBundle.class$("oracle.jbo.common.ArrayResourceBundle");
        }
        LOG = Logger.getLogger(clazz.getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

