/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.logging.ADFLogger;
import oracle.jbo.common.DiagnosticFactory;
import oracle.jbo.common.IDiagnostic;
import oracle.jbo.common.IDiagnostic2;

public class ADFLoggerDiagnosticImpl
implements IDiagnostic2,
IDiagnostic {
    private ADFLogger mADFLogger = ADFLogger.createADFLogger(this.getClass());
    public static final String ADF_LOG_LEVEL = "jbo.adflogger.level";

    public ADFLoggerDiagnosticImpl() {
        Level level = Level.FINE;
        String string = DiagnosticFactory.getProperty(ADF_LOG_LEVEL);
        if (string != null) {
            level = this.getLogLevel(string);
        }
        this.mADFLogger.setLevel(level);
        Handler[] handlerArray = Logger.getLogger("").getHandlers();
        int n = 0;
        while (n < handlerArray.length) {
            handlerArray[n].setLevel(level);
            ++n;
        }
    }

    public void initialized(String string) {
        this.mADFLogger.log("Diagnostics: (" + string + ") " + this.toString());
    }

    public void print(String string) {
        if (string != null && string.length() != 0) {
            this.mADFLogger.log(string);
        }
    }

    public void println(String string) {
        if (string != null && string.length() != 0) {
            this.mADFLogger.log(string);
            this.mADFLogger.log("\r\n");
        }
    }

    public String toString() {
        return "return diagnostics to ADFLogger";
    }

    private Level getLogLevel(String string) {
        Level level = Level.FINE;
        if (string.equalsIgnoreCase("OFF")) {
            level = Level.OFF;
        } else if (string.equalsIgnoreCase("ALL")) {
            level = Level.ALL;
        } else if (string.equalsIgnoreCase("CONFIG")) {
            level = Level.CONFIG;
        } else if (string.equalsIgnoreCase("FINE")) {
            level = Level.FINE;
        } else if (string.equalsIgnoreCase("FINER")) {
            level = Level.FINER;
        } else if (string.equalsIgnoreCase("FINEST")) {
            level = Level.FINEST;
        } else if (string.equalsIgnoreCase("INFO")) {
            level = Level.INFO;
        } else if (string.equalsIgnoreCase("SEVERE")) {
            level = Level.SEVERE;
        } else if (string.equalsIgnoreCase("WARNING")) {
            level = Level.WARNING;
        }
        return level;
    }
}

