/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.binding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import oracle.adf.model.RegionBinding;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.RepConversion;
import oracle.jbo.uicli.binding.JUAccessorIteratorDef;

public class DCBindingContainerState {
    private static final String STATE_PREFIX = "BCST:";
    static final String STATE_TOKEN_DELIMITER = ",";
    private DCBindingContainer _container;
    static char FIND_MODE_CHAR = (char)49;
    static char DATA_MODE_CHAR = (char)48;
    private static /* synthetic */ Class class$oracle$adf$model$ADFmMessageBundle;

    public DCBindingContainerState(DCBindingContainer dCBindingContainer) {
        this._container = dCBindingContainer;
    }

    private StringBuffer buildStringBuffer() {
        StringBuffer stringBuffer = new StringBuffer(STATE_PREFIX);
        stringBuffer.append('=').append(this._container.isFindMode() ? FIND_MODE_CHAR : DATA_MODE_CHAR);
        this._container.buildFormToken(stringBuffer);
        List list = this._container.getIterBindingList();
        int n = 0;
        while (n < list.size()) {
            DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)list.get(n);
            dCIteratorBinding.buildFormToken(stringBuffer, this._container.isTokenValidationEnabled());
            ++n;
        }
        list = this._container.getRegionBindings();
        if (list != null) {
            int n2 = 0;
            while (n2 < list.size()) {
                RegionBinding regionBinding = (RegionBinding)list.get(n2);
                if (regionBinding.isTokenValidationEnabled()) {
                    stringBuffer.append(regionBinding.getName()).append('=').append(regionBinding.getStateToken()).append(STATE_TOKEN_DELIMITER);
                }
                ++n2;
            }
        }
        return stringBuffer;
    }

    byte[] compressBuffer(StringBuffer stringBuffer) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        byte[] byArray = stringBuffer.toString().getBytes();
        deflaterOutputStream.write(byArray);
        deflaterOutputStream.flush();
        deflaterOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    String decompressBytes(byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n = inflaterInputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = inflaterInputStream.read();
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inflaterInputStream.close();
            throw throwable;
        }
        inflaterInputStream.close();
        return stringBuffer.toString();
    }

    private HashMap buildMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, STATE_TOKEN_DELIMITER, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) break;
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            Object object = this._container.get(string3);
            if (object == null) {
                throw new InvalidObjNameException(512, string3);
            }
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private void restoreIterator(HashMap hashMap, DCIteratorBinding dCIteratorBinding) throws Exception {
        String string = (String)hashMap.get(dCIteratorBinding.getName());
        if (string == null) {
            return;
        }
        dCIteratorBinding.setCurrentRowWithKey(string);
        if (dCIteratorBinding.getCurrentRow() == null) {
            this.throwRowNotFoundException(dCIteratorBinding, dCIteratorBinding.parseKeyValue(string));
        }
        hashMap.remove(dCIteratorBinding.getName());
    }

    private void throwRowNotFoundException(DCIteratorBinding dCIteratorBinding, String string) {
        Key key;
        Object[] objectArray = new Object[1];
        objectArray[0] = string != null && string.length() > 0 ? ((key = dCIteratorBinding.createKey(string)) != null ? key.toString() : null) : null;
        Class clazz = class$oracle$adf$model$ADFmMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$adf$model$ADFmMessageBundle = DCBindingContainerState.class$("oracle.adf.model.ADFmMessageBundle");
        }
        throw new JboException(clazz, "35007", objectArray);
    }

    private void validateIterator(HashMap hashMap, DCIteratorBinding dCIteratorBinding, Map map) throws Exception {
        String string = (String)hashMap.get(dCIteratorBinding.getName());
        if (string == null) {
            return;
        }
        if (dCIteratorBinding.processFormToken(string, map)) {
            hashMap.remove(dCIteratorBinding.getName());
        } else {
            this.throwRowNotFoundException(dCIteratorBinding, dCIteratorBinding.parseKeyValue(string));
        }
    }

    private ArrayList buildHierarchy(DCIteratorBinding dCIteratorBinding) {
        ArrayList<DCIteratorBinding> arrayList = new ArrayList<DCIteratorBinding>();
        arrayList.add(dCIteratorBinding);
        JUAccessorIteratorDef jUAccessorIteratorDef = (JUAccessorIteratorDef)dCIteratorBinding.getDef();
        String string = jUAccessorIteratorDef.getMasterBindingName();
        while (string != null) {
            DCIteratorBinding dCIteratorBinding2 = this._container.findIteratorBinding(string);
            if (dCIteratorBinding2 == null) {
                throw new InvalidObjNameException(512, string);
            }
            arrayList.add(0, dCIteratorBinding2);
            string = null;
            if (!dCIteratorBinding2.isAccessorIterator()) continue;
            JUAccessorIteratorDef jUAccessorIteratorDef2 = (JUAccessorIteratorDef)dCIteratorBinding2.getDef();
            string = jUAccessorIteratorDef2.getMasterBindingName();
        }
        return arrayList;
    }

    private void restoreStateFromString(String string) throws Exception {
        if (string == null || !string.startsWith(STATE_PREFIX)) {
            throw new InvalidParamException("restoreStateFromString", "sState", string);
        }
        string = string.substring(STATE_PREFIX.length());
        HashMap hashMap = this.buildMap(string);
        while (!hashMap.isEmpty()) {
            String string2 = (String)hashMap.keySet().iterator().next();
            Object object = this._container.get(string2);
            if (object instanceof DCIteratorBinding) {
                DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)object;
                if (dCIteratorBinding.isAccessorIterator()) {
                    ArrayList arrayList = this.buildHierarchy(dCIteratorBinding);
                    int n = 0;
                    while (n < arrayList.size()) {
                        this.restoreIterator(hashMap, (DCIteratorBinding)arrayList.get(n));
                        ++n;
                    }
                    continue;
                }
                this.restoreIterator(hashMap, dCIteratorBinding);
                continue;
            }
            if (object instanceof DCBindingContainer) {
                new DCBindingContainerState((DCBindingContainer)object).restoreState((String)hashMap.get(string2));
                continue;
            }
            if (!Diagnostic.isOn()) continue;
            Diagnostic.println("Unable to restore state for :" + string2);
        }
    }

    private void validateStateFromString(String string) throws Exception {
        if (string == null || !string.startsWith(STATE_PREFIX)) {
            throw new InvalidParamException("restoreStateFromString", "sState", string);
        }
        if (string.length() == STATE_PREFIX.length()) {
            return;
        }
        boolean bl = string.charAt(STATE_PREFIX.length() + 1) == FIND_MODE_CHAR;
        string = string.substring(STATE_PREFIX.length() + 2);
        string = this._container.processFormToken(string);
        HashMap hashMap = this.buildMap(string);
        HashMap hashMap2 = new HashMap(hashMap.size());
        while (!hashMap.isEmpty()) {
            String string2 = (String)hashMap.keySet().iterator().next();
            Object object = this._container.get(string2);
            if (object instanceof DCIteratorBinding) {
                DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)object;
                if (dCIteratorBinding.isAccessorIterator()) {
                    ArrayList arrayList = this.buildHierarchy(dCIteratorBinding);
                    int n = 0;
                    while (n < arrayList.size()) {
                        this.validateIterator(hashMap, (DCIteratorBinding)arrayList.get(n), hashMap2);
                        ++n;
                    }
                    continue;
                }
                this.validateIterator(hashMap, dCIteratorBinding, hashMap2);
                continue;
            }
            if (!(object instanceof RegionBinding)) continue;
            ((RegionBinding)object).validateToken((String)hashMap.get(string2));
            hashMap.remove(string2);
        }
        if (hashMap2.size() > 0) {
            Iterator iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                DCIteratorBinding dCIteratorBinding = (DCIteratorBinding)iterator.next();
                dCIteratorBinding.cacheCreatedRow(dCIteratorBinding.getRowSetIterator(), (Row)hashMap2.get(dCIteratorBinding));
            }
        }
        if (bl) {
            Diagnostic.println("Setting back to findmode based on validation token");
            this._container.setFindMode(true);
        }
    }

    public void restoreState(String string) {
        try {
            byte[] byArray = RepConversion.nibbles2bArray(string.getBytes());
            String string2 = this.decompressBytes(byArray);
            Diagnostic.println("restoreState:Decompressed BC state:" + string2);
            this.restoreStateFromString(string2);
        }
        catch (Exception exception) {
            Diagnostic.printStackTrace(exception);
        }
    }

    public void validateToken(String string) throws Exception {
        try {
            if (string == null) {
                return;
            }
            byte[] byArray = RepConversion.nibbles2bArray(string.getBytes());
            String string2 = this.decompressBytes(byArray);
            Diagnostic.println("valiateToken:Decompressed BC state:" + string2);
            this.validateStateFromString(string2);
        }
        catch (Exception exception) {
            Diagnostic.printStackTrace(exception);
            throw exception;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = this.buildStringBuffer();
        try {
            String string;
            byte[] byArray = this.compressBuffer(stringBuffer);
            String string2 = string = RepConversion.bArray2String(byArray);
            return string2;
        }
        catch (Exception exception) {
            Diagnostic.printStackTrace(exception);
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

