/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter.dataformat;

import java.util.Hashtable;
import java.util.Map;
import oracle.binding.meta.AccessorDefinition;
import oracle.binding.meta.ArrayListDefinitionContainer;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.OperationDefinition;
import oracle.binding.meta.StructureDefinition;

public class StructureDef
implements StructureDefinition {
    public static final int TYPE_ACCESSOR = 1;
    private String mName;
    private String mFullName;
    private Definition mParent;
    private String mPkgName;
    private ArrayListDefinitionContainer mAttribs;
    private ArrayListDefinitionContainer mAccessors;
    private ArrayListDefinitionContainer mMethods;
    private ArrayListDefinitionContainer mConstructors;
    private Hashtable mProps;

    private /* synthetic */ void $init$() {
        this.mAttribs = new ArrayListDefinitionContainer();
        this.mAccessors = new ArrayListDefinitionContainer();
        this.mMethods = new ArrayListDefinitionContainer();
        this.mConstructors = new ArrayListDefinitionContainer();
        this.mProps = new Hashtable(10);
    }

    public StructureDef(String string) {
        this.$init$();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            this.mFullName = string;
            this.mName = string.substring(n + 1);
            this.mPkgName = string.substring(0, n);
        } else {
            this.mName = string;
        }
    }

    public StructureDef(String string, Definition definition) {
        this(string);
        this.mParent = definition;
    }

    public DefinitionContainer getAttributeDefinitions() {
        return this.mAttribs;
    }

    public DefinitionContainer getOperationDefinitions() {
        return this.mMethods;
    }

    public DefinitionContainer getAccessorDefinitions() {
        return this.mAccessors;
    }

    public DefinitionContainer getConstructorOperationDefinitions() {
        return this.mConstructors;
    }

    public DataControlDefinition getDataControlDefinition() {
        if (this.mParent != null) {
            switch (this.mParent.getDefinitionType()) {
                case 20: {
                    return ((StructureDefinition)this.mParent).getDataControlDefinition();
                }
                case 50: {
                    return (DataControlDefinition)this.mParent;
                }
            }
        }
        return null;
    }

    public String getFullName() {
        if (this.mFullName != null) {
            return this.mFullName;
        }
        if (this.mPkgName != null && this.mPkgName.length() > 0) {
            return this.mPkgName + "." + this.getName();
        }
        return this.getName();
    }

    public String getName() {
        return this.mName;
    }

    public Definition getDefinitionParent() {
        return this.mParent;
    }

    public int getDefinitionType() {
        return 20;
    }

    public void setParentType(int n) {
    }

    public void setFullName(String string) {
        this.mFullName = string;
    }

    public void setPackageName(String string) {
        this.mPkgName = string;
    }

    public void addAttribute(AttributeDefinition attributeDefinition) {
        if (attributeDefinition != null) {
            this.mAttribs.add((Object)attributeDefinition);
        }
    }

    public void addAccessor(AccessorDefinition accessorDefinition) {
        if (accessorDefinition != null) {
            this.mAccessors.add((Object)accessorDefinition);
        }
    }

    public void addMethod(OperationDefinition operationDefinition) {
        if (operationDefinition != null) {
            this.mMethods.add((Object)operationDefinition);
        }
    }

    public void addConstructorMethod(OperationDefinition operationDefinition) {
        if (operationDefinition != null) {
            this.mConstructors.add((Object)operationDefinition);
        }
    }

    public void setParent(Definition definition) {
        this.mParent = definition;
    }

    public void addProperty(String string, Object object) {
        if (string != null && object != null) {
            this.mProps.put(string, object);
        }
    }

    public Object getProperty(String string) {
        return this.mProps.get(string);
    }

    public void addProperties(Map map) {
        if (map != null) {
            this.mProps.putAll(map);
        }
    }

    public Hashtable getProperties() {
        return this.mProps;
    }
}

