/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.adf.model.adapter.AbstractAdapter;
import oracle.adf.model.adapter.AdapterContext;
import oracle.adf.model.adapter.AdapterException;
import oracle.adf.model.adapter.utils.NodeAttributeHelper;
import oracle.adf.share.logging.ADFLogger;
import oracle.jbo.common.JBOClass;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AdapterDefinition {
    public static final String DEF_FILE = "meta-inf/adapter-definition.xml";
    public static final String TAG_ADAPTER = "Adapter";
    public static final String ATTR_TYPE_NAME = "Name";
    public static final String ATTR_TYPE_CLASS = "ClassName";
    public static final String TAG_SOURCE_TYPE = "Source";
    public static final String TAG_TYPE = "Type";
    public static final String ATTR_JDEV_NODE = "JDevNode";
    public static final String TAG_SCHEMA = "Schema";
    public static final String ATTR_NS = "Namespace";
    public static final String ATTR_LOCATION = "Location";
    public static final String TAG_DEPENDENCIES = "Dependencies";
    public static final String TAG_LIBRARY = "Library";
    public static final String ATTR_PATH = "Path";
    public static final String TAG_JDEV_CTX_HOOK = "JDevContextHook";
    public static final String ATTR_JDEV_CTX_HOOK_CLASS = "Class";
    public static final String TAG_PROPERTIES = "Properties";
    public static final String TAG_PROPERTY = "Property";
    public static final String ATTR_PROP_NAME = "Name";
    public static final String ATTR_PROP_VALUE = "Value";
    private static ClassLoader sClassLoader = null;
    private static Map sDefinitionStore;
    private static boolean sLoaded;
    private ADFLogger mDbgLog;
    private String mName;
    private Class mClass;
    private Map mSchema;
    private Map mSupportedSourceTypes;
    private String mJDevCtxHookName;
    private Map mProperties;
    private List mLibraries;
    private Object mLock;
    private static /* synthetic */ Class class$oracle$adf$model$ADFmMessageBundle;

    private /* synthetic */ void $init$() {
        this.mDbgLog = AdapterContext.getDefaultContext().getLogger();
        this.mSchema = new HashMap(5);
        this.mSupportedSourceTypes = new HashMap(5);
        this.mProperties = new HashMap(5);
        this.mLibraries = new ArrayList(10);
        this.mLock = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void initialize() {
        ADFLogger aDFLogger;
        block18: {
            block17: {
                block16: {
                    aDFLogger = AdapterContext.getDefaultContext().getLogger();
                    aDFLogger.entering("oracle.adf.model.adapter.AdapterDefinition", "initialize");
                    try {
                        try {
                            if (sLoaded) {
                                Object var8_1 = null;
                                break block16;
                            }
                            aDFLogger.fine("Start loading adapters defined for the system.");
                            Enumeration<URL> enumeration = null;
                            try {
                                ClassLoader classLoader = sClassLoader;
                                if (classLoader == null) {
                                    aDFLogger.fine("Loading by the current thread's class loader.");
                                    classLoader = Thread.currentThread().getContextClassLoader();
                                }
                                if (classLoader != null) {
                                    enumeration = classLoader.getResources(DEF_FILE);
                                }
                            }
                            catch (Exception exception) {
                                aDFLogger.log(Level.SEVERE, "Exception: ", (Throwable)exception);
                            }
                            if (enumeration == null) {
                                aDFLogger.fine("Trying to load by system class loader.");
                                enumeration = ClassLoader.getSystemResources(DEF_FILE);
                            }
                            if (!enumeration.hasMoreElements()) {
                                aDFLogger.fine("No adapter definition found in the class path.");
                                sLoaded = true;
                                break block17;
                            }
                            sDefinitionStore = new HashMap(15);
                            while (true) {
                                if (!enumeration.hasMoreElements()) {
                                    sLoaded = true;
                                    break block18;
                                }
                                aDFLogger.fine("Loading adapter definition.");
                                URL uRL = enumeration.nextElement();
                                try {
                                    AdapterDefinition.loadAdapterDefinition(uRL.openStream());
                                }
                                catch (Exception exception) {
                                    aDFLogger.log(Level.SEVERE, "Failed to load the adapter: ", (Throwable)exception);
                                }
                            }
                        }
                        catch (Exception exception) {
                            aDFLogger.log(Level.SEVERE, "Adapter initialization failed: ", (Throwable)exception);
                            Object var8_4 = null;
                            aDFLogger.exiting("oracle.adf.model.adapter.AdapterDefinition", "initialize");
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_5 = null;
                        aDFLogger.exiting("oracle.adf.model.adapter.AdapterDefinition", "initialize");
                        throw throwable;
                    }
                }
                aDFLogger.exiting("oracle.adf.model.adapter.AdapterDefinition", "initialize");
                return;
            }
            Object var8_2 = null;
            aDFLogger.exiting("oracle.adf.model.adapter.AdapterDefinition", "initialize");
            return;
        }
        Object var8_3 = null;
        aDFLogger.exiting("oracle.adf.model.adapter.AdapterDefinition", "initialize");
    }

    public static void setClassLoader(ClassLoader classLoader) {
        sClassLoader = classLoader;
    }

    public static AdapterDefinition getDefinition(String string) {
        if (sDefinitionStore == null) {
            return null;
        }
        return (AdapterDefinition)sDefinitionStore.get(string);
    }

    public static Iterator enumAdapters() {
        if (sDefinitionStore == null) {
            return new ArrayList().iterator();
        }
        return sDefinitionStore.values().iterator();
    }

    public String getName() {
        return this.mName;
    }

    public Iterator enumSchemaNS() {
        return this.mSchema.keySet().iterator();
    }

    public Iterator enumSchemaLocations() {
        return this.mSchema.values().iterator();
    }

    public String getSchemaLocation(String string) {
        return (String)this.mSchema.get(string);
    }

    public String getJDevCtxHookName() {
        return this.mJDevCtxHookName;
    }

    public String getPropertyValue(String string) {
        return (String)this.mProperties.get(string);
    }

    public String getClassName() {
        if (this.mClass != null) {
            return this.mClass.getName();
        }
        return null;
    }

    public Iterator getLibraries() {
        return this.mLibraries.iterator();
    }

    public AbstractAdapter createAdapterInstance() {
        if (this.mClass == null) {
            Class clazz = class$oracle$adf$model$ADFmMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$adf$model$ADFmMessageBundle = AdapterDefinition.class$("oracle.adf.model.ADFmMessageBundle");
            }
            throw new AdapterException(clazz, "35102");
        }
        try {
            AbstractAdapter abstractAdapter = (AbstractAdapter)this.mClass.newInstance();
            return abstractAdapter;
        }
        catch (Exception exception) {
            Class clazz = class$oracle$adf$model$ADFmMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$adf$model$ADFmMessageBundle = AdapterDefinition.class$("oracle.adf.model.ADFmMessageBundle");
            }
            throw new AdapterException(clazz, "35102").setCause(exception);
        }
    }

    public Iterator getSupportedSourceNames() {
        return this.mSupportedSourceTypes.keySet().iterator();
    }

    public Iterator getSupportedSourceTypes() {
        return this.mSupportedSourceTypes.values().iterator();
    }

    public Iterator getSupportedSourceClasses() {
        ArrayList<Class> arrayList = new ArrayList<Class>(5);
        Iterator iterator = this.mSupportedSourceTypes.values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class clazz = JBOClass.forName(string);
                arrayList.add(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.iterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canHandle(Object object) {
        boolean bl;
        block12: {
            boolean bl2;
            block10: {
                boolean bl3;
                block9: {
                    this.mDbgLog.entering(this.getClass().getName(), "CanHandle");
                    Class<?> clazz = null;
                    try {
                        block11: {
                            try {
                                if (object == null) {
                                    this.mDbgLog.severe("Object null.");
                                    bl3 = false;
                                    Object var14_4 = null;
                                    break block9;
                                }
                                if (object instanceof String) {
                                    if (this.mSupportedSourceTypes.get(object) != null) {
                                        this.mDbgLog.fine("Matched supported type = " + object.toString());
                                        bl2 = true;
                                        break block10;
                                    }
                                    String string = (String)object;
                                    Iterator iterator = this.getSupportedSourceTypes();
                                    while (iterator.hasNext()) {
                                        if (!string.equals((String)iterator.next())) continue;
                                        this.mDbgLog.fine("It can handle = " + string);
                                        boolean bl4 = true;
                                        Object var14_6 = null;
                                        this.mDbgLog.exiting(this.getClass().getName(), "CanHandle");
                                        return bl4;
                                    }
                                    break block11;
                                }
                                clazz = object.getClass();
                                Iterator iterator = this.getSupportedSourceClasses();
                                while (iterator.hasNext()) {
                                    Class clazz2 = (Class)iterator.next();
                                    if (!clazz2.isInstance(object)) continue;
                                    this.mDbgLog.fine("Object is an instance. Need to ask the adapter.");
                                    this.mDbgLog.fine("Creating adapter instance...");
                                    AbstractAdapter abstractAdapter = this.createAdapterInstance();
                                    if (!abstractAdapter.canCreateDataControl(object)) continue;
                                    bl = true;
                                    break block12;
                                }
                            }
                            catch (Exception exception) {
                                this.mDbgLog.log(Level.SEVERE, "Exception: ", (Throwable)exception);
                                Object var14_9 = null;
                                this.mDbgLog.exiting(this.getClass().getName(), "CanHandle");
                                return false;
                            }
                        }
                        Object var14_8 = null;
                        this.mDbgLog.exiting(this.getClass().getName(), "CanHandle");
                        return false;
                    }
                    catch (Throwable throwable) {
                        Object var14_10 = null;
                        this.mDbgLog.exiting(this.getClass().getName(), "CanHandle");
                        throw throwable;
                    }
                }
                this.mDbgLog.exiting(this.getClass().getName(), "CanHandle");
                return bl3;
            }
            Object var14_5 = null;
            this.mDbgLog.exiting(this.getClass().getName(), "CanHandle");
            return bl2;
        }
        Object var14_7 = null;
        this.mDbgLog.exiting(this.getClass().getName(), "CanHandle");
        return bl;
    }

    private AdapterDefinition(Node node) {
        this.$init$();
        this.mDbgLog.entering(this.getClass().getName(), "Constructor(Node)");
        try {
            NodeAttributeHelper nodeAttributeHelper = new NodeAttributeHelper(node.getAttributes());
            this.mName = nodeAttributeHelper.getValue("Name");
            this.mDbgLog.fine("Adapter name: " + this.mName);
            String string = nodeAttributeHelper.getValue(ATTR_TYPE_CLASS);
            if (string == null) {
                this.mDbgLog.severe("Exception: No implementation class name is defined.");
                Class clazz = class$oracle$adf$model$ADFmMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$adf$model$ADFmMessageBundle = AdapterDefinition.class$("oracle.adf.model.ADFmMessageBundle");
                }
                throw new AdapterException(clazz, "35101", new Object[]{this.mName});
            }
            try {
                this.mDbgLog.fine("Trying to load class.");
                this.mClass = JBOClass.forName(string);
                this.mDbgLog.fine("Class load successful.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.mDbgLog.log(Level.SEVERE, "Exception: Class load failed - ", (Throwable)classNotFoundException);
                Class clazz = class$oracle$adf$model$ADFmMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$adf$model$ADFmMessageBundle = AdapterDefinition.class$("oracle.adf.model.ADFmMessageBundle");
                }
                throw new AdapterException(clazz, "35102", new Object[]{string}).setCause(classNotFoundException);
            }
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                XMLElement xMLElement = (XMLElement)nodeList.item(n2);
                if (TAG_SOURCE_TYPE.equalsIgnoreCase(xMLElement.getNodeName())) {
                    NodeList nodeList2 = xMLElement.getElementsByTagName(TAG_TYPE);
                    int n3 = nodeList2.getLength();
                    int n4 = 0;
                    while (n4 < n3) {
                        nodeAttributeHelper.setNamedNodeMap(nodeList2.item(n4).getAttributes());
                        this.mDbgLog.fine("Supports JDev Node: " + nodeAttributeHelper.getValue(ATTR_JDEV_NODE));
                        this.mSupportedSourceTypes.put(nodeAttributeHelper.getValue("Name"), nodeAttributeHelper.getValue(ATTR_JDEV_NODE));
                        ++n4;
                    }
                } else if (TAG_SCHEMA.equalsIgnoreCase(xMLElement.getNodeName())) {
                    nodeAttributeHelper.setNamedNodeMap(xMLElement.getAttributes());
                    this.mDbgLog.fine("Schema: " + nodeAttributeHelper.getValue(ATTR_LOCATION));
                    this.mSchema.put(nodeAttributeHelper.getValue(ATTR_NS), nodeAttributeHelper.getValue(ATTR_LOCATION));
                } else if (TAG_DEPENDENCIES.equalsIgnoreCase(xMLElement.getNodeName())) {
                    NodeList nodeList3 = xMLElement.getElementsByTagName(TAG_LIBRARY);
                    int n5 = nodeList3.getLength();
                    int n6 = 0;
                    while (n6 < n5) {
                        nodeAttributeHelper.setNamedNodeMap(nodeList3.item(n6).getAttributes());
                        this.mDbgLog.fine("Library: " + nodeAttributeHelper.getValue(ATTR_PATH));
                        this.mLibraries.add(nodeAttributeHelper.getValue(ATTR_PATH));
                        ++n6;
                    }
                } else if (TAG_JDEV_CTX_HOOK.equalsIgnoreCase(xMLElement.getNodeName())) {
                    this.mJDevCtxHookName = xMLElement.getAttribute(ATTR_JDEV_CTX_HOOK_CLASS);
                } else if (TAG_PROPERTIES.equalsIgnoreCase(xMLElement.getNodeName())) {
                    NodeList nodeList4 = xMLElement.getElementsByTagName(TAG_PROPERTY);
                    int n7 = nodeList4.getLength();
                    int n8 = 0;
                    while (n8 < n7) {
                        nodeAttributeHelper.setNamedNodeMap(nodeList4.item(n8).getAttributes());
                        this.mProperties.put(nodeAttributeHelper.getValue("Name"), nodeAttributeHelper.getValue(ATTR_PROP_VALUE));
                        ++n8;
                    }
                }
                ++n2;
            }
            Object var19_18 = null;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            throw throwable;
        }
    }

    private static void loadAdapterDefinition(InputStream inputStream) {
        try {
            try {
                if (inputStream == null) {
                    Class clazz = class$oracle$adf$model$ADFmMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$adf$model$ADFmMessageBundle = AdapterDefinition.class$("oracle.adf.model.ADFmMessageBundle");
                    }
                    throw new AdapterException(clazz, "35104");
                }
                DOMParser dOMParser = new DOMParser();
                dOMParser.setPreserveWhitespace(false);
                dOMParser.parse(inputStream);
                XMLDocument xMLDocument = dOMParser.getDocument();
                Element element = xMLDocument.getDocumentElement();
                NodeList nodeList = element.getChildNodes();
                int n = nodeList.getLength();
                NodeAttributeHelper nodeAttributeHelper = new NodeAttributeHelper();
                int n2 = 0;
                while (n2 < n) {
                    Node node = nodeList.item(n2);
                    if (TAG_ADAPTER.equalsIgnoreCase(node.getNodeName())) {
                        AdapterDefinition adapterDefinition = new AdapterDefinition(node);
                        sDefinitionStore.put(adapterDefinition.getName(), adapterDefinition);
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                Class clazz = class$oracle$adf$model$ADFmMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$adf$model$ADFmMessageBundle = AdapterDefinition.class$("oracle.adf.model.ADFmMessageBundle");
                }
                throw new AdapterException(clazz, "35104");
            }
            catch (SAXException sAXException) {
                Class clazz = class$oracle$adf$model$ADFmMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$adf$model$ADFmMessageBundle = AdapterDefinition.class$("oracle.adf.model.ADFmMessageBundle");
                }
                throw new AdapterException(clazz, "35105");
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            throw throwable;
        }
    }

    static {
        sLoaded = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

