/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCErrorHandlerImpl;
import oracle.adf.model.servlet.ApplicationParameters;
import oracle.adf.share.ADFContext;
import oracle.adf.share.Environment;
import oracle.jbo.JboException;
import oracle.jbo.SessionContext;
import oracle.jbo.common.DefLocaleContext;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.Lock;
import oracle.jbo.common.SessionContextManagerImpl;
import oracle.jbo.common.ampool.ContextPoolManager;
import oracle.jbo.common.ampool.PoolMgr;
import oracle.jbo.http.ORDRegisterer;
import oracle.jbo.pool.ResourcePoolManager;
import oracle.jbo.server.ConnectionPoolManagerFactory;
import oracle.jbo.uicli.mom.JUMetaObjectManager;

public abstract class BindingRequestHandler {
    private static String AUTH_SUCCESS_URL = "success_url";
    private static String AUTH_SERVLET_NAME = "adfAuthentication";
    public static final String SESSION_INVALIDATE_BINDINGCONTAINER_DEF = "adf_session_invalidate_bindingcontainer_def";
    private static String REQUEST_BINDINGS_INITIALIZED = "_request_bindings_initialized_";
    private static String SESSION_LOCK = "_session_lock_";
    private String mBindingContextDefName;
    private String mTargetEncoding;
    private String mUnauthorizedPage;
    private BindingContext mBindingContext;
    private boolean mWasRequestBindingsInitialized;
    private Lock mSessionLock;

    private /* synthetic */ void $init$() {
        this.mBindingContextDefName = null;
        this.mTargetEncoding = null;
        this.mUnauthorizedPage = null;
        this.mBindingContext = null;
        this.mWasRequestBindingsInitialized = true;
        this.mSessionLock = null;
    }

    public void setBindingContextDefName(String string) {
        this.mBindingContextDefName = string;
    }

    public void setTargetEncoding(String string) {
        this.mTargetEncoding = string;
    }

    public void setUnauthorizedPage(String string) {
        this.mUnauthorizedPage = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginRequest() {
        Environment environment;
        Map map;
        Map map2;
        ADFContext aDFContext;
        block20: {
            aDFContext = this.initADFContext();
            SessionContextManagerImpl.getInstance().setCurrentSession(this.createSessionContext(aDFContext));
            map2 = aDFContext.getSessionScope();
            map = aDFContext.getRequestScope();
            environment = aDFContext.getEnvironment();
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.mSessionLock = (Lock)map2.get(SESSION_LOCK);
                if (this.mSessionLock == null) {
                    this.mSessionLock = new Lock();
                    map2.put(SESSION_LOCK, this.mSessionLock);
                }
            }
            this.mSessionLock.lock(-1);
            if (this.mTargetEncoding != null) {
                try {
                    environment.setRequestCharacterEncoding(this.mTargetEncoding);
                }
                catch (IOException iOException) {
                    throw new JboException(iOException);
                }
            }
            this.mBindingContext = (BindingContext)map2.get("data");
            if (this.mBindingContext == null || this.mBindingContext.get("_is_initialized_") == null) {
                this.initializeBindingContext(aDFContext);
            }
            try {
                ORDRegisterer.registerRenderer((Map)map2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (!Diagnostic.isOn()) break block20;
                Diagnostic.println("**** FAILED To register ORDRegister");
            }
        }
        aDFContext.getADFConfig();
        if (map.get(REQUEST_BINDINGS_INITIALIZED) == null) {
            this.mWasRequestBindingsInitialized = false;
            map.put(REQUEST_BINDINGS_INITIALIZED, REQUEST_BINDINGS_INITIALIZED);
        }
        if (!this.mWasRequestBindingsInitialized) {
            this.invokeBeginRequest(aDFContext);
        }
        if (!this.isPageViewable()) {
            if (!aDFContext.getSecurityContext().isAuthenticated()) {
                map2.put(AUTH_SUCCESS_URL, environment.getRequestURI());
                String string = environment.encodeResourceURL(environment.getRequestContextPath() + "/" + AUTH_SERVLET_NAME + "?" + AUTH_SUCCESS_URL + "=" + environment.getRequestURI().substring(environment.getRequestContextPath().length()));
                try {
                    environment.redirect(string);
                }
                catch (IOException iOException) {
                    throw new JboException(iOException);
                }
            }
            if (this.mUnauthorizedPage != null && this.mUnauthorizedPage.length() > 0) {
                try {
                    environment.redirect(this.mUnauthorizedPage);
                }
                catch (IOException iOException) {
                    throw new JboException(iOException);
                }
            } else {
                this.handleAuthenticationFailure(aDFContext);
            }
            return false;
        }
        return true;
    }

    public void endRequest() {
        try {
            ADFContext aDFContext = ADFContext.getCurrent();
            if (!this.mWasRequestBindingsInitialized) {
                this.invokeEndRequest(aDFContext);
            }
            Object var3_2 = null;
            if (this.mSessionLock != null) {
                this.mSessionLock.unlock();
            }
            this.resetADFContext();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.mSessionLock != null) {
                this.mSessionLock.unlock();
            }
            this.resetADFContext();
            throw throwable;
        }
    }

    private boolean isPageViewable() {
        if (this.mBindingContext == null) {
            return true;
        }
        Environment environment = ADFContext.getCurrent().getEnvironment();
        String string = environment.getRequestPathInfo();
        if (string == null || string.length() == 0) {
            string = environment.getRequestServletPath();
        }
        if (string == null || string.length() == 0) {
            return true;
        }
        DCBindingContainer dCBindingContainer = this.mBindingContext.findBindingContainerByPath(string);
        if (dCBindingContainer == null) {
            return true;
        }
        Map map = ADFContext.getCurrent().getSessionScope();
        Object v = map.get(SESSION_INVALIDATE_BINDINGCONTAINER_DEF);
        if (v != null) {
            JUMetaObjectManager.getJUMom().invalidateBindingContainerDef(this.mBindingContext, dCBindingContainer.getDef().getFullName());
            map.remove(SESSION_INVALIDATE_BINDINGCONTAINER_DEF);
        }
        return dCBindingContainer.isViewable();
    }

    private void initializeBindingContext(ADFContext aDFContext) {
        SessionContext sessionContext;
        Environment environment = aDFContext.getEnvironment();
        Map map = aDFContext.getSessionScope();
        this.mBindingContext = (BindingContext)map.get("data");
        if (this.mBindingContext == null) {
            this.mBindingContext = this.createBindingContext(aDFContext);
        }
        if ((sessionContext = SessionContextManagerImpl.getInstance().getCurrentSession()) != null) {
            this.mBindingContext.setSessionContext(sessionContext);
        }
        ApplicationParameters applicationParameters = new ApplicationParameters();
        this.mBindingContext.setErrorHandler(new DCErrorHandlerImpl(true));
        applicationParameters.put("_binding_Context", this.mBindingContext);
        Properties properties = this.initializeContextForDataControl(aDFContext, new Properties());
        applicationParameters.put("_request_context", properties);
        this.mBindingContext.setLocaleContext(new DefLocaleContext(environment.getRequestLocale()));
        JUMetaObjectManager.loadCpx(this.mBindingContextDefName + ".cpx", applicationParameters);
        this.mBindingContext.put("_is_initialized_", "true");
        map.put("data", this.mBindingContext);
    }

    private void invokeBeginRequest(ADFContext aDFContext) {
        HashMap hashMap = this.initializeContextForBeginRequest(aDFContext, new HashMap(2));
        this.mBindingContext.beginRequest(aDFContext, hashMap);
    }

    private void invokeEndRequest(ADFContext aDFContext) {
        HashMap hashMap = this.initializeContextForEndRequest(aDFContext, new HashMap(2));
        this.mBindingContext.endRequest(aDFContext, hashMap);
    }

    protected HashMap initializeContextForBeginRequest(ADFContext aDFContext, HashMap hashMap) {
        return hashMap;
    }

    protected HashMap initializeContextForEndRequest(ADFContext aDFContext, HashMap hashMap) {
        return hashMap;
    }

    protected Properties initializeContextForDataControl(ADFContext aDFContext, Properties properties) {
        Principal principal = null;
        try {
            principal = aDFContext.getSecurityContext().getUserPrincipal();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (principal != null) {
            properties.put("jbo.userprincipal", principal);
        }
        return properties;
    }

    public static Object loadApplication() {
        if (JboEnvUtil.inOC4J()) {
            return ADFContext.getCurrent().getApplication().getId();
        }
        return null;
    }

    public static void destroyApplication(Object object) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("Destroying BindingFacesBridgeLifecycleListener.  Removing ApplicationPools...");
        }
        PoolMgr poolMgr = null;
        poolMgr = JboEnvUtil.inOC4J() && object != null ? ((ContextPoolManager)PoolMgr.getInstance()).getApplicationPoolMgr(object) : PoolMgr.getInstance();
        poolMgr.destroy();
        ((ResourcePoolManager)ConnectionPoolManagerFactory.getConnectionPoolManager()).classLoaderShuttingDown();
    }

    protected abstract ADFContext initADFContext();

    protected abstract void resetADFContext();

    protected abstract BindingContext createBindingContext(ADFContext var1);

    protected abstract SessionContext createSessionContext(ADFContext var1);

    protected abstract void handleAuthenticationFailure(ADFContext var1);

    public BindingRequestHandler() {
        this.$init$();
    }
}

