/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.util.Locale;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.DisplayValueRenderer;
import oracle.bali.inspector.ExtendedPropertyEditor;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorRenderer;
import oracle.bali.inspector.PropertyEditorValueEditor;

public class PropertyEditorAdapter
implements PropertyEditorFactory {
    private transient PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private PropertyEditor _editor;
    private Class _type;
    static /* synthetic */ Class class$java$lang$String;

    public PropertyEditorAdapter(PropertyEditor propertyEditor) {
        if (propertyEditor == null) {
            throw new IllegalArgumentException();
        }
        this._editor = propertyEditor;
        this._editor.addPropertyChangeListener(new PropListen(this));
    }

    public PropertyEditorAdapter(PropertyEditor propertyEditor, Class clazz) {
        this(propertyEditor);
        this._type = clazz;
    }

    public PropertyEditor getPropertyEditor() {
        return this._editor;
    }

    public Object getEditorValue() {
        return this.getPropertyEditor().getValue();
    }

    public void setEditorValue(Object object) {
        this.getPropertyEditor().setValue(object);
    }

    public boolean hasValueRenderer() {
        return true;
    }

    public TableCellRenderer getValueRenderer() {
        PropertyEditor propertyEditor = this.getPropertyEditor();
        if (propertyEditor.isPaintable()) {
            return PropertyEditorRenderer.getTableCellRenderer();
        }
        return DisplayValueRenderer.getTableCellRenderer();
    }

    public boolean hasInPlaceEditor() {
        return this.getPropertyEditor().getAsText() != null || (class$java$lang$String == null ? (class$java$lang$String = PropertyEditorAdapter.class$("java.lang.String")) : class$java$lang$String) == this._type;
    }

    public TableCellEditor getInPlaceEditor(Locale locale) {
        PropertyEditor propertyEditor = this.getPropertyEditor();
        String[] stringArray = propertyEditor.getTags();
        if (stringArray != null) {
            return PropertyEditorValueEditor.getComboBoxEditor(stringArray);
        }
        if (propertyEditor.getAsText() != null || this._type == (class$java$lang$String == null ? (class$java$lang$String = PropertyEditorAdapter.class$("java.lang.String")) : class$java$lang$String)) {
            return PropertyEditorValueEditor.getTextFieldEditor();
        }
        return null;
    }

    public boolean hasTearOffEditor() {
        ExtendedPropertyEditor extendedPropertyEditor = this._getExtendedEditor();
        return extendedPropertyEditor != null ? extendedPropertyEditor.supportsSmallCustomEditor() : false;
    }

    public Component getTearOffEditor() {
        ExtendedPropertyEditor extendedPropertyEditor = this._getExtendedEditor();
        return extendedPropertyEditor != null ? extendedPropertyEditor.getSmallCustomEditor() : null;
    }

    public boolean hasAdvancedEditor() {
        return this.getPropertyEditor().supportsCustomEditor();
    }

    public Component getAdvancedEditor() {
        PropertyEditor propertyEditor = this.getPropertyEditor();
        return propertyEditor.getCustomEditor();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private final ExtendedPropertyEditor _getExtendedEditor() {
        PropertyEditor propertyEditor = this.getPropertyEditor();
        return propertyEditor instanceof ExtendedPropertyEditor ? (ExtendedPropertyEditor)propertyEditor : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class PropListen
    implements PropertyChangeListener {
        private final WeakReference _adapterRef;
        private PropertyEditor _editorAttachedTo;

        public PropListen(PropertyEditorAdapter propertyEditorAdapter) {
            this._adapterRef = new WeakReference<PropertyEditorAdapter>(propertyEditorAdapter);
            this._editorAttachedTo = propertyEditorAdapter._editor;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyEditorAdapter propertyEditorAdapter = (PropertyEditorAdapter)this._adapterRef.get();
            if (propertyEditorAdapter == null) {
                if (this._editorAttachedTo != null) {
                    this._editorAttachedTo.removePropertyChangeListener(this);
                    this._editorAttachedTo = null;
                }
            } else {
                propertyEditorAdapter._changeSupport.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }
}

