/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.DisplayNameRenderer;
import oracle.bali.inspector.NullEditor;
import oracle.bali.inspector.PropertyFilterer;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.inspector.swing.AbstractTableCellEditor;

class GroupCellHandler
extends AbstractTableCellEditor
implements TableCellRenderer {
    private static final int _DEFAULT_INDENT_WIDTH = 7;
    private static final int _BUTTON_MARGIN = 2;
    private TableCellEditor _defaultEditor;
    private TableCellRenderer _defaultRenderer;
    private Icon _expandedIcon;
    private Icon _collapsedIcon;
    private Content _component;
    private JPanel _content;
    private JLabel _iconPanel;
    private IndentLayout _layout;
    private JPanel _editorComponent;
    private JPanel _editorContent;
    private Label _editorIcon;
    private JLabel _editorLabel;
    private IndentLayout _editorLayout;
    private int _levelColumnIndex = -1;
    private int _drillableColumnIndex = -1;
    private Border _noFocusBorder;
    private PropertyInspector _inspector;
    private boolean _foundDrillable;
    private Icon _spacer;

    public GroupCellHandler(PropertyInspector propertyInspector) {
        this(propertyInspector, null, null);
    }

    public GroupCellHandler(PropertyInspector propertyInspector, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        this._inspector = propertyInspector;
        if (tableCellEditor == null) {
            tableCellEditor = NullEditor.getTableCellEditor();
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = DisplayNameRenderer.getTableCellRenderer();
        }
        this._defaultRenderer = tableCellRenderer;
        this._defaultEditor = tableCellEditor;
        this._expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        this._collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        this._spacer = new Spacer();
        this._component = new Content();
        this._component.setBorder(null);
        this._component.setOpaque(true);
        this._layout = new IndentLayout();
        this._component.setLayout(this._layout);
        this._content = new ToolTipPanel();
        this._content.setBorder(null);
        this._content.setOpaque(false);
        this._content.setLayout(new BorderLayout(2, 0));
        this._iconPanel = new JLabel();
        this._iconPanel.setBorder(null);
        this._iconPanel.setOpaque(false);
        this._content.add("West", this._iconPanel);
        this._component.add(this._content);
        this._editorComponent = new JPanel();
        this._editorComponent.setOpaque(true);
        this._editorLayout = new IndentLayout();
        this._editorComponent.setLayout(this._editorLayout);
        this._editorContent = new JPanel();
        this._editorContent.setOpaque(false);
        this._editorContent.setLayout(new BorderLayout(2, 0));
        this._editorIcon = new Label();
        this._editorLabel = new JLabel();
        this._editorIcon.setOpaque(false);
        this._editorLabel.setOpaque(false);
        this._editorLabel.setBorder(new EmptyBorder(1, 2, 1, 2));
        this._editorContent.add("West", this._editorIcon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(2, 0));
        jPanel.add("West", this._editorContent);
        jPanel.add("Center", this._editorLabel);
        this._editorComponent.add(jPanel);
        this._updateNoFocusBorder();
    }

    public TableCellRenderer getDefaultRenderer() {
        return this._defaultRenderer;
    }

    public TableCellEditor getDefaultEditor() {
        return this._defaultEditor;
    }

    public void setIndicies(int n, int n2) {
        this._levelColumnIndex = n;
        this._drillableColumnIndex = n2;
        this._foundDrillable = false;
        PropertyModel propertyModel = this._inspector.getPropertyModel();
        propertyModel.startRead();
        try {
            int n3 = propertyModel.getRowCount();
            int n4 = 0;
            while (n4 < n3) {
                if (this._isCellDrillable(propertyModel, n4)) {
                    this._foundDrillable = true;
                    break;
                }
                ++n4;
            }
            Object var7_6 = null;
            propertyModel.stopRead();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            propertyModel.stopRead();
            throw throwable;
        }
    }

    public void updateUI() {
        this._expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        this._collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        this._updateNoFocusBorder();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        int n3 = this.getCellDepth(propertyModel, n);
        boolean bl3 = this.__cellHasChildren(propertyModel, n);
        Component component = this.getDefaultRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        this._layout.setIndent(this._getButtonX(n3));
        this._content.add("Center", component);
        if (bl3) {
            if (this.__isCellExpanded(propertyModel, n)) {
                this._iconPanel.setIcon(this._expandedIcon);
            } else {
                this._iconPanel.setIcon(this._collapsedIcon);
            }
        } else {
            this._iconPanel.setIcon(this._spacer);
        }
        if (bl2) {
            Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
            this._component.setBorder(border);
        } else {
            this._component.setBorder(this._noFocusBorder);
        }
        this._component.setAccessibleName(propertyModel.getPropertyDisplayName(n));
        return this._component;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        PropertyModel propertyModel = (PropertyModel)jTable.getModel();
        int n3 = this.getCellDepth(propertyModel, n);
        boolean bl2 = this.__cellHasChildren(propertyModel, n);
        Component component = this.getDefaultEditor().getTableCellEditorComponent(jTable, object, bl, n, n2);
        if (bl2) {
            if (this.__isCellExpanded(propertyModel, n)) {
                this._editorIcon.setIcon(this._expandedIcon);
            } else {
                this._editorIcon.setIcon(this._collapsedIcon);
            }
        } else {
            this._editorIcon.setIcon(this._spacer);
        }
        String string = propertyModel.getPropertyDisplayName(n);
        this._editorLabel.setText(string);
        this._editorIcon.setCell(n, propertyModel);
        this._editorLayout.setIndent(this._getButtonX(n3));
        if (component != null) {
            this._editorContent.add("Center", component);
        }
        return this._editorComponent;
    }

    public Object getCellEditorValue() {
        return this._editorLabel.getText();
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (mouseEvent.isConsumed()) {
                return false;
            }
            JTable jTable = (JTable)mouseEvent.getSource();
            if (!jTable.isEnabled()) {
                return false;
            }
            PropertyModel propertyModel = (PropertyModel)jTable.getModel();
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = jTable.rowAtPoint(point);
            int n2 = this.getCellDepth(propertyModel, n);
            int n3 = this._getButtonX(n2);
            int n4 = n3 + this._getButtonWidth();
            int n5 = mouseEvent.getX();
            if (this.__cellHasChildren(propertyModel, n)) {
                if (n5 >= n3 && n5 <= n4) {
                    boolean bl = !this.__isCellExpanded(propertyModel, n);
                    this.__setCellExpanded(propertyModel, n, bl);
                    return false;
                }
                n5 -= n4;
            } else {
                n5 -= n3 + this._spacer.getIconWidth();
            }
            MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n5, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            return this.getDefaultEditor().isCellEditable(mouseEvent2);
        }
        if (eventObject instanceof KeyEvent) {
            return false;
        }
        return false;
    }

    boolean __cellHasChildren(PropertyModel propertyModel, int n) {
        return this._getCellDepth(propertyModel, n) == 0 || this._isCellDrillable(propertyModel, n);
    }

    private int getCellDepth(PropertyModel propertyModel, int n) {
        int n2 = this._getCellDepth(propertyModel, n);
        if (n2 >= 0) {
            return n2;
        }
        return 0;
    }

    boolean __isCellExpanded(PropertyModel propertyModel, int n) {
        return ((PropertyFilterer)propertyModel).getExpansionState(n);
    }

    void __setCellExpanded(PropertyModel propertyModel, int n, boolean bl) {
        ((PropertyFilterer)propertyModel).setExpansionState(n, bl);
    }

    private int _getCellDepth(PropertyModel propertyModel, int n) {
        if (this._levelColumnIndex == -1) {
            return -1;
        }
        Object object = propertyModel.getValueAt(n, this._levelColumnIndex);
        if (object != null && object != PropertyModel.DOES_NOT_EXIST) {
            return (Integer)object;
        }
        return -1;
    }

    private boolean _isCellDrillable(PropertyModel propertyModel, int n) {
        if (this._drillableColumnIndex == -1) {
            return false;
        }
        Object object = propertyModel.getValueAt(n, this._drillableColumnIndex);
        if (object == PropertyModel.DOES_NOT_EXIST || object == null) {
            return false;
        }
        return Boolean.TRUE.equals(object);
    }

    private int _getButtonWidth() {
        return this._expandedIcon.getIconWidth();
    }

    private int _getButtonX(int n) {
        return n * 7 + 2;
    }

    private void _updateNoFocusBorder() {
        Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
        Insets insets = border.getBorderInsets(this._component);
        this._noFocusBorder = new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
    }

    private class Spacer
    implements Icon {
        private Spacer() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return GroupCellHandler.this._foundDrillable ? GroupCellHandler.this._expandedIcon.getIconWidth() : 0;
        }

        public int getIconHeight() {
            return GroupCellHandler.this._expandedIcon.getIconHeight();
        }
    }

    private class Label
    extends JLabel {
        private int _row;
        private PropertyModel _model;

        public Label() {
            this.enableEvents(16L);
        }

        public void setCell(int n, PropertyModel propertyModel) {
            this._row = n;
            this._model = propertyModel;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent) && this.getIcon() != null) {
                if (this.getIcon() == GroupCellHandler.this._expandedIcon) {
                    this._setExpanded(false);
                } else if (this.getIcon() == GroupCellHandler.this._collapsedIcon) {
                    this._setExpanded(true);
                }
            }
        }

        private void _setExpanded(boolean bl) {
            GroupCellHandler.this.__setCellExpanded(this._model, this._row, bl);
            GroupCellHandler.this.cancelCellEditing();
        }
    }

    private class Content
    extends ToolTipPanel {
        private String _name;

        private Content() {
        }

        public void setAccessibleName(String string) {
            this._name = string;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JComponent.AccessibleJComponent(){

                    public AccessibleRole getAccessibleRole() {
                        return AccessibleRole.LABEL;
                    }

                    public String getAccessibleName() {
                        if (this.accessibleName != null && !"".equals(this.accessibleName)) {
                            return this.accessibleName;
                        }
                        return _name;
                    }

                    public int getAccessibleChildCount() {
                        return 0;
                    }

                    public Accessible getAccessibleChild(int n) {
                        return null;
                    }
                };
            }
            return this.accessibleContext;
        }
    }

    private class ToolTipPanel
    extends JPanel {
        private ToolTipPanel() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Component component = this._getComponentAt(mouseEvent.getPoint());
            if (component != this && component instanceof JComponent) {
                Point point = mouseEvent.getPoint();
                point.translate(-component.getX(), -component.getY());
                mouseEvent = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                return ((JComponent)component).getToolTipText(mouseEvent);
            }
            return super.getToolTipText(mouseEvent);
        }

        private Component _getComponentAt(Point point) {
            Component[] componentArray = this.getComponents();
            int n = componentArray == null ? 0 : componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (componentArray[n2].contains(point)) {
                    return componentArray[n2];
                }
                ++n2;
            }
            return null;
        }
    }

    private class IndentLayout
    implements LayoutManager {
        private int _indent;

        private IndentLayout() {
        }

        public void setIndent(int n) {
            this._indent = n;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = container.getComponent(0).getPreferredSize();
            dimension.width += this._indent;
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = container.getComponent(0).getMinimumSize();
            dimension.width += this._indent;
            return dimension;
        }

        public void layoutContainer(Container container) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            Component component = container.getComponent(0);
            component.setBounds(insets.left + this._indent, insets.top, dimension.width - this._indent - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        }
    }
}

