/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class DistinctValue
extends OXMLFunction {
    private int numParams;

    DistinctValue(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "distinct-values";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE;
        }
        if (n == 1) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        Object object;
        Object object2;
        Object object3;
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        ItemTypeValueMap itemTypeValueMap = new ItemTypeValueMap();
        while (oXMLSequence.next()) {
            object3 = oXMLSequence.getItem();
            object2 = ((OXMLItem)object3).getItemType();
            if (((OXMLItem)object3).matchesType(OXMLSequenceType.TUNTYPED)) {
                object = oXMLFunctionContext.createItem();
                ((OXMLItem)object).copyItem((OXMLItem)object3);
                ((OXMLItem)object).convert(OXMLSequenceType.TSTRING);
                itemTypeValueMap.put(OXMLSequenceType.TSTRING, (OXMLItem)object, (OXMLItem)object3);
                continue;
            }
            if (((OXMLItem)object3).matchesType(OXMLSequenceType.NUMERIC_ONE)) {
                itemTypeValueMap.put(OXMLSequenceType.TDOUBLE, (OXMLItem)object3, (OXMLItem)object3);
                continue;
            }
            itemTypeValueMap.put(object2, (OXMLItem)object3, (OXMLItem)object3);
        }
        object3 = itemTypeValueMap.values();
        while (object3.hasNext()) {
            object2 = (TreeMap)object3.next();
            object = ((TreeMap)object2).values().iterator();
            while (object.hasNext()) {
                OXMLItem oXMLItem = oXMLFunctionContext.createItem();
                oXMLItem.copyItem((OXMLItem)object.next());
                oXMLSequence2.appendItem(oXMLItem);
            }
        }
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequence2);
        FNUtil.checkCollation(oXMLItem.getString());
        return this.invoke(oXMLFunctionContext, oXMLSequence);
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 1: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
                break;
            }
            case 2: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
            }
        }
        return oXMLSequence;
    }

    class ItemValueComparator
    implements Comparator {
        ItemValueComparator() {
        }

        public int compare(Object object, Object object2) {
            OXMLItem oXMLItem = (OXMLItem)object;
            OXMLItem oXMLItem2 = (OXMLItem)object2;
            int n = oXMLItem.getPrimitiveType();
            int n2 = oXMLItem2.getPrimitiveType();
            if ((n == 3 || n == 4) && Double.isNaN(oXMLItem.getDouble()) && (n2 == 3 || n2 == 4) && Double.isNaN(oXMLItem2.getDouble())) {
                return 0;
            }
            int n3 = -1;
            try {
                n3 = oXMLItem.compareValue(oXMLItem2);
            }
            catch (XQException xQException) {
                n3 = -1;
            }
            return n3;
        }
    }

    class ItemTypeComparator
    implements Comparator {
        ItemTypeComparator() {
        }

        public int compare(Object object, Object object2) {
            OXMLSequenceType oXMLSequenceType = (OXMLSequenceType)object;
            OXMLSequenceType oXMLSequenceType2 = (OXMLSequenceType)object2;
            return oXMLSequenceType.getPrimitiveId() - oXMLSequenceType2.getPrimitiveId();
        }
    }

    class ItemTypeValueMap {
        private TreeMap typeMap;

        ItemTypeValueMap() {
            this.typeMap = new TreeMap(new ItemTypeComparator());
        }

        void put(Object object, OXMLItem oXMLItem, OXMLItem oXMLItem2) {
            TreeMap<OXMLItem, OXMLItem> treeMap = (TreeMap<OXMLItem, OXMLItem>)this.typeMap.get(object);
            if (treeMap == null) {
                treeMap = new TreeMap<OXMLItem, OXMLItem>(new ItemValueComparator());
                this.typeMap.put(object, treeMap);
            }
            treeMap.put(oXMLItem, oXMLItem2);
        }

        Iterator values() {
            return this.typeMap.values().iterator();
        }
    }
}

