/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLReader;
import oracle.xml.util.ArrayPool;

public class XMLOutputStream {
    public static final int DEFAULT = 0;
    public static final int PRETTY = 1;
    public static final int COMPACT = 2;
    public static final int REUSE = 0;
    public static final int NO_REUSE = 1;
    static final int UTF8 = 1;
    static final int ASCII = 2;
    static final int UCS2_LE = 3;
    static final int UCS2_BE = 4;
    static final int UCS4_LE = 5;
    static final int UCS4_BE = 6;
    static final int OUTPUTSW = 7;
    private char highSurrogate = '\u0000';
    private static final char UNICODE_REPLACEMENT_CHARACTER = '\ufffd';
    private Writer outWriter;
    private OutputStream outStream;
    char[] charBuffer;
    int charIndex;
    int charDebugIndex = -1;
    byte[] byteBuffer;
    int byteIndex;
    int byteDebugIndex = -1;
    private boolean localErr;
    XMLError err;
    private int wrtstate;
    private int indent;
    private int outstyle;
    boolean mixed;
    private char[] nlChars;

    public void setEOLChars(String string) {
        this.nlChars = string.toCharArray();
    }

    public XMLOutputStream(OutputStream outputStream) {
        this.outStream = outputStream;
        this.outstyle = 1;
        this.mixed = false;
        this.indent = 0;
        String string = System.getProperty("line.separator");
        this.nlChars = string.toCharArray();
        this.wrtstate = 1;
        this.byteBuffer = ArrayPool.allocByteArrDefault();
    }

    public XMLOutputStream(Writer writer) {
        this.outWriter = writer;
        this.outstyle = 1;
        this.mixed = false;
        this.indent = 0;
        String string = System.getProperty("line.separator");
        this.nlChars = string.toCharArray();
        this.wrtstate = 7;
        this.charBuffer = ArrayPool.allocCharArrDefault();
    }

    public XMLOutputStream(PrintWriter printWriter) {
        this.outWriter = printWriter;
        this.outstyle = 1;
        this.mixed = false;
        this.indent = 0;
        String string = System.getProperty("line.separator");
        this.nlChars = string.toCharArray();
        this.wrtstate = 7;
        this.charBuffer = ArrayPool.allocCharArrDefault();
    }

    public void setEncoding(String string, boolean bl, boolean bl2) throws IOException {
        if (this.outWriter != null) {
            return;
        }
        if (string.equalsIgnoreCase("ISO-10646-UCS-2") || string.equalsIgnoreCase("UCS-2") || string.equalsIgnoreCase("UTF-16")) {
            this.wrtstate = bl ? 3 : 4;
            if (bl2) {
                if (bl) {
                    this.byteBuffer[this.byteIndex] = -2;
                    this.byteBuffer[this.byteIndex + 1] = -1;
                    this.byteIndex += 2;
                } else {
                    this.byteBuffer[this.byteIndex] = -1;
                    this.byteBuffer[this.byteIndex + 1] = -2;
                    this.byteIndex += 2;
                }
            }
            return;
        }
        if (string.equalsIgnoreCase("ISO-10646-UCS-4") || string.equalsIgnoreCase("UCS-4")) {
            this.wrtstate = bl ? 5 : 6;
            return;
        }
        if (string.toUpperCase().equals("ASCII")) {
            this.wrtstate = 2;
            return;
        }
        if (string.toUpperCase().equals("UTF-8")) {
            this.wrtstate = 1;
            return;
        }
        boolean bl3 = false;
        String string2 = (String)XMLReader.encodingMap.get(string.toUpperCase());
        if (string2 != null) {
            try {
                this.outWriter = new OutputStreamWriter(this.outStream, string2);
            }
            catch (Exception exception) {
                bl3 = true;
            }
        }
        if (bl3 || string2 == null) {
            bl3 = false;
            string2 = (String)XMLReader.encodingMap116.get(string.toUpperCase());
            if (string2 != null) {
                try {
                    this.outWriter = new OutputStreamWriter(this.outStream, string2);
                }
                catch (Exception exception) {
                    bl3 = true;
                }
            }
        }
        if (bl3 || string2 == null) {
            string2 = string;
            try {
                this.outWriter = new OutputStreamWriter(this.outStream, string2);
            }
            catch (Exception exception) {
                if (this.err == null) {
                    this.localErr = true;
                    this.err = new XMLError();
                }
                throw new IOException(this.err.getMessage1(231, string));
            }
        }
        this.wrtstate = 7;
        this.charBuffer = ArrayPool.allocCharArrDefault();
        ArrayPool.freeByteArrDefault(this.byteBuffer);
        this.byteBuffer = null;
    }

    public void flush() throws IOException {
        if (this.wrtstate == 7) {
            this.outWriter.write(this.charBuffer, 0, this.charIndex);
            this.charIndex = 0;
        } else {
            this.outStream.write(this.byteBuffer, 0, this.byteIndex);
            this.byteIndex = 0;
        }
    }

    public void flushDebugStream() throws IOException {
        if (this.wrtstate == 7) {
            this.outWriter.write(this.charBuffer, 0, this.charIndex);
            this.charIndex = 0;
        } else {
            this.outStream.write(this.byteBuffer, 0, this.byteIndex);
            this.byteIndex = 0;
        }
    }

    public void close() throws IOException {
        this.close(0);
    }

    public void close(int n) throws IOException {
        if (this.highSurrogate != '\u0000') {
            this.highSurrogate = '\u0000';
            this.write(65533);
        }
        this.flush();
        this.finalFlush();
        if (n == 1) {
            if (this.outWriter != null) {
                this.outWriter.close();
            }
            if (this.outStream != null) {
                this.outStream.close();
            }
        }
        if (this.charBuffer != null) {
            ArrayPool.freeCharArrDefault(this.charBuffer);
        }
        if (this.byteBuffer != null) {
            ArrayPool.freeByteArrDefault(this.byteBuffer);
        }
        try {
            if (this.localErr) {
                this.err.flushErrors();
            }
        }
        catch (XMLParseException xMLParseException) {
            throw new IOException(xMLParseException.getMessage());
        }
    }

    public void pop(int n) throws IOException {
        if (this.wrtstate == 7) {
            if (this.charIndex < n) {
                throw new IOException("Internal error while writing file");
            }
            this.charIndex -= n;
        } else {
            if (this.byteIndex < n) {
                throw new IOException("Internal error while writing file");
            }
            this.byteIndex -= n;
        }
    }

    public void write(int n) throws IOException {
        try {
            if (this.wrtstate == 1 || this.wrtstate == 6 || this.wrtstate == 5) {
                if (n >= 55296 && n <= 56319) {
                    if (this.highSurrogate != '\u0000') {
                        this.highSurrogate = '\u0000';
                        this.write(65533);
                    }
                    this.highSurrogate = (char)n;
                    return;
                }
                if (n >= 56320 && n <= 57343) {
                    if (this.highSurrogate == '\u0000') {
                        this.write(65533);
                        return;
                    }
                    int n2 = 65536 + (this.highSurrogate - 55296 << 10) + (n - 56320);
                    this.highSurrogate = '\u0000';
                    this.write(n2);
                    return;
                }
                if (this.highSurrogate != '\u0000') {
                    this.highSurrogate = '\u0000';
                    this.write(65533);
                }
            }
            switch (this.wrtstate) {
                case 1: {
                    if (n < 128) {
                        this.byteBuffer[this.byteIndex] = (byte)n;
                        ++this.byteIndex;
                        break;
                    }
                    this.writeUTF8Bytes(n);
                    break;
                }
                case 2: {
                    this.byteBuffer[this.byteIndex] = (byte)n;
                    ++this.byteIndex;
                    break;
                }
                case 3: {
                    int n3 = n >> 8;
                    int n4 = n & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)n3;
                    this.byteBuffer[this.byteIndex + 1] = (byte)n4;
                    this.byteIndex += 2;
                    break;
                }
                case 4: {
                    int n5 = n >> 8;
                    int n6 = n & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)n6;
                    this.byteBuffer[this.byteIndex + 1] = (byte)n5;
                    this.byteIndex += 2;
                    break;
                }
                case 5: {
                    int n7 = n >> 24;
                    int n8 = n >> 16 & 0xFF;
                    int n9 = n >> 8 & 0xFF;
                    int n10 = n & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)n10;
                    this.byteBuffer[this.byteIndex + 1] = (byte)n9;
                    this.byteBuffer[this.byteIndex + 2] = (byte)n8;
                    this.byteBuffer[this.byteIndex + 3] = (byte)n7;
                    this.byteIndex += 4;
                    break;
                }
                case 6: {
                    int n11 = n >> 24;
                    int n12 = n >> 16 & 0xFF;
                    int n13 = n >> 8 & 0xFF;
                    int n14 = n & 0xFF;
                    this.byteBuffer[this.byteIndex] = (byte)n11;
                    this.byteBuffer[this.byteIndex + 1] = (byte)n12;
                    this.byteBuffer[this.byteIndex + 2] = (byte)n13;
                    this.byteBuffer[this.byteIndex + 3] = (byte)n14;
                    this.byteIndex += 4;
                    break;
                }
                case 7: {
                    this.charBuffer[this.charIndex] = (char)n;
                    ++this.charIndex;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.flush();
            this.write(n);
        }
    }

    void writeUTF8Bytes(int n) throws IOException {
        if (n < 2048) {
            this.byteBuffer[this.byteIndex] = (byte)(0xC0 | n >> 6);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | n & 0x3F);
            this.byteIndex += 2;
        } else if (n < 65536) {
            this.byteBuffer[this.byteIndex] = (byte)(0xE0 | n >> 12);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | n >> 6 & 0x3F);
            this.byteBuffer[this.byteIndex + 2] = (byte)(0x80 | n & 0x3F);
            this.byteIndex += 3;
        } else {
            this.byteBuffer[this.byteIndex] = (byte)(0xF0 | n >> 18);
            this.byteBuffer[this.byteIndex + 1] = (byte)(0x80 | n >> 12 & 0x3F);
            this.byteBuffer[this.byteIndex + 2] = (byte)(0x80 | n >> 6 & 0x3F);
            this.byteBuffer[this.byteIndex + 3] = (byte)(0x80 | n & 0x3F);
            this.byteIndex += 4;
        }
    }

    public void writeChars(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        if (n == 1) {
            char c = string.charAt(0);
            if (c == '\n') {
                this.writeNewLineChars();
            } else {
                this.write(c);
            }
            return;
        }
        int n2 = 0;
        char c = string.charAt(n2);
        char c2 = string.charAt(n2 + 1);
        while (true) {
            if (c2 == '\n') {
                if (c != '\r') {
                    this.write(c);
                }
                this.writeNewLineChars();
                if ((n2 += 2) < n) {
                    if (n2 == n - 1) {
                        c = string.charAt(n2);
                        if (c == '\n') {
                            this.writeNewLineChars();
                        } else {
                            this.write(c);
                        }
                        return;
                    }
                    c = string.charAt(n2);
                    c2 = string.charAt(n2 + 1);
                    continue;
                }
                return;
            }
            this.write(c);
            c = c2;
            if (++n2 + 1 >= n) break;
            c2 = string.charAt(n2 + 1);
        }
        this.write(c);
    }

    void writeNewLineChars() throws IOException {
        int n = this.nlChars.length;
        for (int i = 0; i < n; ++i) {
            this.write(this.nlChars[i]);
        }
    }

    public void writeQuotedString(String string) throws IOException {
        char c = '\"';
        if (string.indexOf(34) >= 0 && string.indexOf(39) < 0) {
            c = '\'';
        }
        this.write(c);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (c == '\"') {
                    this.writeChars("&quot;");
                    continue;
                }
                this.writeChars("&apos;");
                continue;
            }
            this.write(c2);
        }
        this.write(c);
    }

    public void writeNewLine() throws IOException {
        if (this.outstyle == 1 && !this.mixed) {
            this.writeNewLineChars();
        }
    }

    public void addIndent(int n) {
        this.indent += n;
    }

    public void writeIndent() throws IOException {
        if (this.outstyle == 1 && !this.mixed) {
            for (int i = 0; i < this.indent; ++i) {
                this.writeChars("   ");
            }
        }
    }

    public void setOutputStyle(int n) {
        this.outstyle = n;
    }

    public int getOutputStyle() {
        return this.outstyle;
    }

    public void finalFlush() throws IOException {
        if (this.outWriter != null) {
            this.outWriter.flush();
        }
        if (this.outStream != null) {
            this.outStream.flush();
        }
    }
}

