/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DTDDecl
implements NamedNodeMap,
Serializable {
    XMLDocument doc;
    long cstate;
    Hashtable hash;
    Node[] items;
    int size;
    int flags;

    DTDDecl() {
        this.flags |= 1;
    }

    DTDDecl(Vector vector) {
        int n = 0;
        this.hash = new Hashtable(20);
        this.size = vector.size();
        this.items = new Node[this.size];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            this.items[n++] = node;
            this.hash.put(node.getNodeName(), node);
        }
        this.flags |= 1;
    }

    DTDDecl(Hashtable hashtable) {
        int n = 0;
        this.hash = hashtable;
        this.size = this.hash.size();
        this.items = new Node[this.size];
        Enumeration enumeration = this.hash.elements();
        while (enumeration.hasMoreElements()) {
            this.items[n++] = (Node)enumeration.nextElement();
        }
        this.flags |= 1;
    }

    DTDDecl(Hashtable hashtable, Hashtable hashtable2) {
        Node node;
        int n = 0;
        this.hash = new Hashtable(20);
        this.size = hashtable.size() + hashtable2.size();
        this.items = new Node[this.size];
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            this.items[n++] = node;
            this.hash.put(node.getNodeName(), node);
        }
        enumeration = hashtable2.elements();
        while (enumeration.hasMoreElements()) {
            node = (Node)enumeration.nextElement();
            this.items[n++] = node;
            this.hash.put(node.getNodeName(), node);
        }
        this.flags |= 1;
    }

    DTDDecl(XMLDocument xMLDocument, long l) {
        this.doc = xMLDocument;
        this.cstate = l;
        this.flags |= 2;
    }

    public Node getNamedItem(String string) {
        switch (this.flags & 3) {
            case 1: {
                Object v = this.hash.get(string);
                return (Node)v;
            }
            case 2: {
                long l = this.xdbGetNamedItem(this.doc.xdbGetCtx(), this.cstate, string);
                if (l == 0L) break;
                return this.doc.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public Node setNamedItem(Node node) throws DOMException {
        throw new XMLDOMException(7, 21010, XMLDocument.defErr);
    }

    public Node removeNamedItem(String string) throws DOMException {
        throw new XMLDOMException(7, 21010, XMLDocument.defErr);
    }

    public Node getNamedItemNS(String string, String string2) {
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        throw new XMLDOMException(7, 21010, XMLDocument.defErr);
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        throw new XMLDOMException(7, 21010, XMLDocument.defErr);
    }

    public Node item(int n) {
        switch (this.flags & 3) {
            case 1: {
                if (n >= this.size || n < 0) {
                    return null;
                }
                return this.items[n];
            }
            case 2: {
                long l = this.xdbGetNodeMapLength(this.doc.xdbGetCtx(), this.cstate);
                if (l == 0L) break;
                return this.doc.xdbGetNodeFromId(l);
            }
        }
        return null;
    }

    public int getLength() {
        switch (this.flags & 3) {
            case 1: {
                return this.size;
            }
            case 2: {
                return this.xdbGetNodeMapLength(this.doc.xdbGetCtx(), this.cstate);
            }
        }
        return -1;
    }

    private native long xdbGetNamedItem(long var1, long var3, String var5);

    private native long xdbGetNodeMapItem(long var1, long var3, int var5);

    private native int xdbGetNodeMapLength(long var1, long var3);
}

