/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import java.util.ArrayList;
import oracle.adf.model.BindingContext;
import oracle.jbo.CustomClassNotFoundException;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;
import oracle.jbo.uicli.binding.JUNavigationBarInterface;
import oracle.jbo.uicli.binding.JUStatusBarInterface;

public class JUUtil {
    public static String PROJECT_GLOBAL_VARIABLES = "PROJECT_GLOBAL_VARIABLES";

    public static Class findClass(String string) {
        try {
            Class clazz = JBOClass.forName((String)string);
            return clazz;
        }
        catch (Exception exception) {
            throw new CustomClassNotFoundException(string, exception);
        }
    }

    public static Object createNewInstance(String string) {
        Class clazz = JUUtil.findClass(string);
        try {
            Object t = clazz.newInstance();
            return t;
        }
        catch (Exception exception) {
            throw new CustomClassNotFoundException(string, exception);
        }
    }

    public static String generateFormName(JUFormBinding jUFormBinding) {
        Object object = jUFormBinding.getPanel();
        String string = object != null ? object.getClass().getName() : "noPanel_" + jUFormBinding.getClass().getName();
        return JboNameUtil.getInstNameFromDefName((String)string);
    }

    public static String generateIteratorName(JUIteratorBinding jUIteratorBinding) {
        String string = jUIteratorBinding.getClass().getName();
        return JboNameUtil.getInstNameFromDefName((String)string);
    }

    public static String generateControlName(JUControlBinding jUControlBinding) {
        Object object = jUControlBinding.getControl();
        String string = object != null ? object.getClass().getName() : "noCtrl_" + jUControlBinding.getClass().getName();
        return JboNameUtil.getInstNameFromDefName((String)string);
    }

    public static boolean isEmptyString(String string) {
        return string == null || string.equals("");
    }

    public static void registerNavigationBarInterface(JUFormBinding jUFormBinding, BindingContext bindingContext) {
        ArrayList arrayList = (ArrayList)bindingContext.get(PROJECT_GLOBAL_VARIABLES);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e instanceof JUNavigationBarInterface) {
                jUFormBinding.addNavigationBar((JUNavigationBarInterface)e);
            }
            ++n;
        }
    }

    public static void registerStatusBarInterface(JUFormBinding jUFormBinding, BindingContext bindingContext) {
        ArrayList arrayList = (ArrayList)bindingContext.get(PROJECT_GLOBAL_VARIABLES);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e instanceof JUStatusBarInterface) {
                jUFormBinding.addStatusBarInterface((JUStatusBarInterface)e);
            }
            ++n;
        }
    }

    public static void unRegisterNavigationBarInterface(JUFormBinding jUFormBinding, BindingContext bindingContext) {
        ArrayList arrayList = (ArrayList)bindingContext.get(PROJECT_GLOBAL_VARIABLES);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e instanceof JUNavigationBarInterface) {
                jUFormBinding.removeNavigationBar((JUNavigationBarInterface)e);
            }
            ++n;
        }
    }

    public static void unRegisterStatusBarInterface(JUFormBinding jUFormBinding, BindingContext bindingContext) {
        ArrayList arrayList = (ArrayList)bindingContext.get(PROJECT_GLOBAL_VARIABLES);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (e instanceof JUStatusBarInterface) {
                jUFormBinding.removeStatusBarInterface((JUStatusBarInterface)e);
            }
            ++n;
        }
    }
}

