/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import com.sun.java.util.collections.ArrayList;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.StringManager;
import oracle.jbo.format.Formatter;
import oracle.jbo.format.FormatterFactory;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.rules.JboPrecisionScaleValidator;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.uicli.binding.JUCtrlAttrsDef;
import oracle.jbo.uicli.binding.JUCtrlParameterBinding;

public class JUCtrlParameterDef
extends JUCtrlAttrsDef
implements AttributeHints,
AttributeDef {
    public static int PARAM_FINAL = 1;
    public static int PARAM_OPTIONAL = 2;
    public static int PARAM_MANDATORY = 3;
    public static int PARAM_DEFAULT = PARAM_OPTIONAL;
    private Class mJavaType;
    private int mScale;
    private int mPrecision;
    private boolean mReadOnly;
    private boolean mApplyPrecision;
    private int mOption;
    private final byte FORMAT_INFO_UNINITIALIZED;
    private final byte FORMAT_INFO_NOT_AVAILABLE;
    private final byte FORMAT_INFO_AVAILABLE;
    private byte mHasFormatInfo;
    public static final String PNAME_Value = "value";
    public static final String PNAME_Type = "type";
    public static final String PNAME_Scale = "scale";
    public static final String PNAME_Precision = "precision";
    public static final String PNAME_Option = "option";
    public static final String PNAME_ReadOnly = "readonly";
    public static final String PNAME_PrecisionRule = "applyPrecision";
    private static /* synthetic */ Class class$java$lang$String;

    private /* synthetic */ void $init$() {
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = JUCtrlParameterDef.class$("java.lang.String");
        }
        this.mJavaType = clazz;
        this.mScale = -1;
        this.mPrecision = 0;
        this.mOption = PARAM_DEFAULT;
        this.FORMAT_INFO_UNINITIALIZED = (byte)-1;
        this.FORMAT_INFO_NOT_AVAILABLE = 0;
        this.FORMAT_INFO_AVAILABLE = 1;
        this.mHasFormatInfo = (byte)-1;
    }

    public JUCtrlParameterDef() {
        this.$init$();
    }

    protected void initSubType() {
        this.setSubType("Parameter");
    }

    protected DCControlBinding createControlBindingInstance(Object object, DCBindingContainer dCBindingContainer) {
        return new JUCtrlParameterBinding(object, this.getColumnName());
    }

    public final byte getAttributeKind() {
        return 3;
    }

    public final String getColumnName() {
        return this.getExpression();
    }

    public final String getExpression() {
        return this.getAttrNames()[0];
    }

    public final String getColumnNameForQuery() {
        return this.getExpression();
    }

    public final int getIndex() {
        return 0;
    }

    public final Class getJavaType() {
        return this.mJavaType;
    }

    public final int getSQLType() {
        return -1;
    }

    public final int getScale() {
        return this.mScale;
    }

    public final int getPrecision() {
        return this.mPrecision;
    }

    public final boolean isSelected() {
        return false;
    }

    public final boolean isQueriable() {
        return false;
    }

    public final boolean isReadOnly() {
        return this.mReadOnly;
    }

    public final byte getUpdateableFlag() {
        return this.mReadOnly ? (byte)0 : 2;
    }

    public final boolean isPrimaryKey() {
        return false;
    }

    public final boolean isApplyPrecision() {
        return this.mApplyPrecision;
    }

    public final boolean isMandatory() {
        return this.mOption == PARAM_MANDATORY;
    }

    public final boolean isOptional() {
        return this.mOption == PARAM_OPTIONAL;
    }

    public final boolean isFinal() {
        return this.mOption == PARAM_FINAL;
    }

    public int getOptionFlag() {
        return this.mOption;
    }

    public final AttributeHints getUIHelper() {
        return this;
    }

    public final Class getElemType() {
        return null;
    }

    public final int getElemSQLType() {
        return -1;
    }

    final String resolveResourceProperty(String string, LocaleContext localeContext) {
        Class clazz = null;
        String string2 = null;
        String string3 = this.getBindingContainerDef().getMessageBundleClassName();
        if (string3 != null) {
            try {
                clazz = JBOClass.forName((String)string3);
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            if (clazz != null) {
                String string4 = this.getName() + "_" + string;
                string2 = StringManager.getLocalizedString((String)clazz.getName(), (String)string4, null, (Locale)(localeContext != null ? localeContext.getLocale() : null), (boolean)false);
            }
        }
        return string2;
    }

    public final String getLabel(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("LABEL", localeContext);
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    public final String getTooltip(LocaleContext localeContext) {
        return this.resolveResourceProperty("TOOLTIP", localeContext);
    }

    public final String getDisplayHint(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYHINT", localeContext);
        if (string == null) {
            string = "Display";
        }
        return string;
    }

    public final int getControlType(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("CONTROLTYPE", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 100;
    }

    public final int getDisplayWidth(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYWIDTH", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return this.getPrecision();
    }

    public final int getDisplayHeight(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYHEIGHT", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 1;
    }

    public final String getHint(LocaleContext localeContext, String string) {
        if (string.equals("LABEL")) {
            return this.getLabel(localeContext);
        }
        if (string.equals("TOOLTIP")) {
            return this.getTooltip(localeContext);
        }
        if (string.equals("DISPLAYWIDTH")) {
            return Integer.toString(this.getDisplayWidth(localeContext));
        }
        if (string.equals("DISPLAYHEIGHT")) {
            return Integer.toString(this.getDisplayHeight(localeContext));
        }
        if (string.equals("CONTROLTYPE")) {
            return Integer.toString(this.getControlType(localeContext));
        }
        if (string.equals("DISPLAYHINT")) {
            return this.getDisplayHint(localeContext);
        }
        return this.resolveResourceProperty(string, localeContext);
    }

    public final String getHintValue(LocaleContext localeContext, String string) {
        return this.resolveResourceProperty(string, localeContext);
    }

    public final String getFormat(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        return this.resolveResourceProperty("FMT_FORMAT", localeContext);
    }

    public final String getFormatterClassName(LocaleContext localeContext) {
        return this.resolveResourceProperty("FMT_FORMATTER", localeContext);
    }

    public final Formatter getFormatter(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        return FormatterFactory.getFormatter((String)this.getFormatterClassName(localeContext), (LocaleContext)localeContext);
    }

    public final boolean hasFormatInformation(LocaleContext localeContext) {
        if (this.mHasFormatInfo == -1) {
            String string = this.getFormatterClassName(localeContext);
            this.mHasFormatInfo = string == null || string.equals("") ? (byte)0 : 1;
        }
        return this.mHasFormatInfo == 1;
    }

    public final String getFormattedAttribute(AttributeList attributeList, LocaleContext localeContext) {
        Object object = attributeList.getAttribute(this.getIndex());
        if (object == null) {
            return null;
        }
        if ("".equals(object)) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return object.toString();
        }
        try {
            String string;
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            String string3 = string = formatter.format(string2, object);
            return string3;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public final Object parseFormattedAttribute(String string, LocaleContext localeContext) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return string;
        }
        try {
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            Object object = formatter.parse(string2, string);
            if (object == null) {
                String string3 = string;
                return string3;
            }
            Object object2 = object;
            return object2;
        }
        catch (ParseException parseException) {
            String string4 = string;
            return string4;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public final boolean displayInShortForm(LocaleContext localeContext) {
        return "Summary".equals(this.resolveResourceProperty("FORMTYPE", localeContext));
    }

    public final String getLocaleName(LocaleContext localeContext, String string) {
        return JboNameUtil.getLocaleName((LocaleContext)localeContext, (String)string);
    }

    protected void retrieveFromXML(DefElement defElement, HashMap hashMap) {
        String string;
        super.retrieveFromXML(defElement, hashMap);
        JUCtrlParameterDef.readXMLString(defElement, PNAME_Type, hashMap);
        JUCtrlParameterDef.readXMLInt(defElement, PNAME_Scale, hashMap);
        JUCtrlParameterDef.readXMLInt(defElement, PNAME_Precision, hashMap);
        JUCtrlParameterDef.readXMLInt(defElement, PNAME_Option, hashMap);
        JUCtrlParameterDef.readXMLBoolean(defElement, PNAME_ReadOnly, hashMap);
        JUCtrlParameterDef.readXMLBoolean(defElement, PNAME_PrecisionRule, hashMap);
        ArrayList arrayList = defElement.readStringArrayListElement("AttrNames");
        if ((arrayList == null || arrayList.size() == 0) && (string = defElement.readString(PNAME_Value)) != null) {
            hashMap.put("AttrNames", new String[]{string});
        }
    }

    public void init(HashMap hashMap) {
        super.init(hashMap);
        Object v = hashMap.get(PNAME_Type);
        if (v != null) {
            try {
                this.mJavaType = JBOClass.forName((String)((String)v));
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        if ((v = hashMap.get(PNAME_Scale)) != null) {
            this.mScale = JUCtrlParameterDef.convertToInt(v);
        }
        if ((v = hashMap.get(PNAME_Precision)) != null) {
            this.mPrecision = JUCtrlParameterDef.convertToInt(v);
        }
        if ((v = hashMap.get(PNAME_Option)) != null) {
            this.mOption = JUCtrlParameterDef.convertToInt(v);
        }
        if ((v = hashMap.get(PNAME_ReadOnly)) != null) {
            this.mReadOnly = JUCtrlParameterDef.convertToBoolean(v);
        }
        if ((v = hashMap.get(PNAME_PrecisionRule)) != null) {
            this.mApplyPrecision = JUCtrlParameterDef.convertToBoolean(v);
        }
        if (this.mApplyPrecision) {
            JboPrecisionScaleValidator jboPrecisionScaleValidator = new JboPrecisionScaleValidator();
            jboPrecisionScaleValidator.setPrecision(this.mPrecision);
            jboPrecisionScaleValidator.setScale(this.mScale);
            this.addValidator((JboValidatorInterface)jboPrecisionScaleValidator);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

