/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.generic.DCGenericRowSetIteratorImpl;
import oracle.adf.model.generic.RowImpl;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.JboEvent;
import oracle.jbo.Key;
import oracle.jbo.NavigationEvent;
import oracle.jbo.Row;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.uicli.binding.JUAccessorIteratorDef;
import oracle.jbo.uicli.binding.JUCtrlHierBinding;
import oracle.jbo.uicli.binding.JUCtrlHierTypeBinding;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;

public class JUCtrlHierNodeBinding
extends JUCtrlValueBinding {
    protected JUCtrlHierTypeBinding mTypeBinding;
    protected JUCtrlHierBinding mHierBinding;
    protected JUCtrlHierNodeBinding mParentNode;
    protected DCIteratorBinding mChildIterBinding;
    protected Object mNodeValue;
    protected Key mRowKey;
    WeakReference mRowRef;
    protected boolean mExpandable;
    protected ArrayList mChildren;
    boolean mSyncWhenNeeded;
    public static final String ATTR_HIER_TYPE = "hierType";
    public static final String ATTR_CHILDREN = "children";
    public static final String ATTR_PARENT = "parent";
    public static final String ATTR_ROW_KEY = "rowKey";
    public static final String ATTR_PROMPT = "prompt";
    public static final String ATTR_HIER_BINDING = "hierbinding";
    public static final String ATTR_ROW = "row";
    public static final String ATTR_ROW_DATA_PROVIDER = "dataProvider";

    private /* synthetic */ void $init$() {
        this.mSyncWhenNeeded = false;
    }

    public JUCtrlHierNodeBinding(JUCtrlHierBinding jUCtrlHierBinding, JUCtrlHierNodeBinding jUCtrlHierNodeBinding, JUIteratorBinding jUIteratorBinding, JUCtrlHierTypeBinding jUCtrlHierTypeBinding, Row row, boolean bl) {
        super(jUCtrlHierBinding.getControl(), jUCtrlHierNodeBinding != null ? jUCtrlHierNodeBinding.getChildIteratorBinding() : jUIteratorBinding, jUCtrlHierTypeBinding != null && jUCtrlHierTypeBinding.getAttrNames() != null ? jUCtrlHierTypeBinding.getAttrNames() : new String[]{});
        this.$init$();
        this.mExpandable = bl;
        this.mHierBinding = jUCtrlHierBinding;
        this.mParentNode = jUCtrlHierNodeBinding;
        this.mChildIterBinding = jUIteratorBinding;
        String[] stringArray = jUCtrlHierTypeBinding.getAccessorNames();
        this.mTypeBinding = jUCtrlHierTypeBinding;
        if ((stringArray == null || stringArray.length == 1) && jUIteratorBinding != null && jUIteratorBinding != this.getIteratorBinding()) {
            jUIteratorBinding.addValueBinding(this);
        }
        if (jUCtrlHierNodeBinding != null) {
            jUCtrlHierNodeBinding.addChild(this);
        }
        boolean bl2 = true;
        if (row != null) {
            this.mRowRef = new WeakReference<Row>(row);
            this.mRowKey = row.getKey();
            if (jUCtrlHierTypeBinding != null) {
                this.refresh(row);
                bl2 = false;
            }
        }
        if (bl2) {
            this.mNodeValue = jUIteratorBinding.getName();
        }
        if (jUIteratorBinding != null && jUCtrlHierNodeBinding != null) {
            jUIteratorBinding.setAllowFindMode(false);
        }
        this.setFormBinding(jUCtrlHierBinding.getFormBinding());
    }

    public void release(int n) {
        JUCtrlHierBinding jUCtrlHierBinding = this.getHierBinding();
        if (this.mParentNode != null) {
            this.mParentNode.removeChild(this);
            this.mChildIterBinding = null;
            this.mRowRef = null;
        }
        if (this.mChildren != null) {
            ArrayList arrayList = (ArrayList)this.mChildren.clone();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                ((JUCtrlHierNodeBinding)arrayList.get(n2)).release(n);
                ++n2;
            }
            this.mChildren = null;
        }
        if (jUCtrlHierBinding != null && jUCtrlHierBinding.internalGetRootNodeBinding() == this) {
            jUCtrlHierBinding.clearRootBinding();
        }
        super.release(DCDataControl.REL_ALL_REFS);
    }

    public JUCtrlHierBinding getHierBinding() {
        return this.mHierBinding;
    }

    public JUCtrlHierNodeBinding getParent() {
        return this.mParentNode;
    }

    public Key getRowKey() {
        return this.mRowKey;
    }

    public DCIteratorBinding getChildIteratorBinding() {
        return this.mChildIterBinding;
    }

    protected boolean isAutoSyncEnabled() {
        return this.mSyncWhenNeeded || this.mHierBinding.isAutoSyncEnabled();
    }

    public void setAutoSyncEnabled(boolean bl) {
        this.mSyncWhenNeeded = bl;
    }

    public void executeQueryIfNeeded() {
        if (this.mChildIterBinding != null) {
            boolean bl;
            boolean bl2 = bl = this.mChildren == null;
            if (this.mChildIterBinding.hasRSI()) {
                this.mChildIterBinding.executeQueryIfNeeded();
            }
            if (bl) {
                Row[] rowArray = null;
                if (this.mParentNode != null) {
                    DCDataControl dCDataControl = this.mChildIterBinding.getDataControl();
                    if (dCDataControl.syncNeeded() && this.isAutoSyncEnabled() && !this.mChildIterBinding.hasRSI()) {
                        this.mChildIterBinding.executeQuery();
                        if (!this.mChildIterBinding.hasRSI()) {
                            this.mChildren = this.mHierBinding.syncAndExpand(dCDataControl, this);
                            return;
                        }
                    } else if (!this.mChildIterBinding.isRefreshed() && !this.mChildIterBinding.hasRSI()) {
                        this.mChildIterBinding.executeQuery();
                    }
                }
                rowArray = this.mChildIterBinding.getAllRowsInRange();
                this.myUpdateValuesFromRows(rowArray, true);
            }
        }
        if (this.mChildren == null) {
            this.mChildren = new ArrayList(0);
        }
    }

    ArrayList internalGetChildren() {
        return this.mChildren;
    }

    public ArrayList getChildren(String string) {
        String[] stringArray = this.getHierTypeBinding().getAccessorNames();
        if (stringArray != null && stringArray.length > 1) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    ArrayList arrayList = this.getChildren();
                    return ((JUCtrlHierNodeBinding)arrayList.get(n)).getChildren();
                }
                ++n;
            }
        }
        return this.getChildren();
    }

    public ArrayList getChildren() {
        JUCtrlHierNodeBinding jUCtrlHierNodeBinding;
        if (this.mChildren == null && this.mExpandable) {
            this.executeQueryIfNeeded();
        }
        if (this.getIteratorBinding() == null && (jUCtrlHierNodeBinding = this.getHierBinding().findNodeByKeyPath(this.getKeyPath())) != null) {
            this.mChildren = jUCtrlHierNodeBinding.internalGetChildren();
        }
        if (this.mHierBinding.getRootNodeBinding() == this && this.getIteratorBinding().getDataControl().syncNeeded() && this.mChildren != null && this.mChildren.size() > 0) {
            ((JUCtrlHierNodeBinding)this.mChildren.get(0)).getChildren();
        }
        return this.mChildren != null ? (ArrayList)this.mChildren.clone() : null;
    }

    public void addChild(JUCtrlHierNodeBinding jUCtrlHierNodeBinding) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList(2);
        }
        this.mChildren.add(jUCtrlHierNodeBinding);
    }

    public boolean removeChild(JUCtrlHierNodeBinding jUCtrlHierNodeBinding) {
        if (jUCtrlHierNodeBinding.mChildren != null) {
            int n = jUCtrlHierNodeBinding.mChildren.size() - 1;
            while (n >= 0) {
                jUCtrlHierNodeBinding.removeChild((JUCtrlHierNodeBinding)jUCtrlHierNodeBinding.mChildren.get(n));
                --n;
            }
            jUCtrlHierNodeBinding.mChildren = null;
        }
        if (this.mChildren != null) {
            DCIteratorBinding dCIteratorBinding = jUCtrlHierNodeBinding.getChildIteratorBinding();
            if (dCIteratorBinding != null) {
                dCIteratorBinding.removeValueBinding(jUCtrlHierNodeBinding);
                ArrayList arrayList = dCIteratorBinding.getValueBindingList();
                if (arrayList == null || arrayList.size() == 0) {
                    RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
                    dCIteratorBinding.release();
                    if (rowSetIterator instanceof DCGenericRowSetIteratorImpl) {
                        rowSetIterator.closeRowSetIterator();
                    }
                }
                jUCtrlHierNodeBinding.mChildIterBinding = null;
            }
            dCIteratorBinding = jUCtrlHierNodeBinding.getIteratorBinding();
            dCIteratorBinding.removeValueBinding(jUCtrlHierNodeBinding);
            this.getBindingContainer().removeControlBinding(jUCtrlHierNodeBinding);
            return this.mChildren.remove(jUCtrlHierNodeBinding);
        }
        return false;
    }

    protected JUCtrlHierNodeBinding findChildNode(Key key) {
        JUCtrlHierNodeBinding jUCtrlHierNodeBinding = null;
        ArrayList arrayList = this.getChildren();
        if (arrayList != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                jUCtrlHierNodeBinding = (JUCtrlHierNodeBinding)arrayList.get(n2);
                if (key.equals((Object)jUCtrlHierNodeBinding.mRowKey)) {
                    return jUCtrlHierNodeBinding;
                }
                ++n2;
            }
        }
        return null;
    }

    protected JUCtrlHierNodeBinding findMatchingNode(Key key) {
        if (this.mParentNode == null) {
            return this.findChildNode(key);
        }
        if (this.mParentNode != null && key.equals((Object)this.getRowKey())) {
            return this;
        }
        return null;
    }

    public void updateRowInserted(InsertEvent insertEvent) {
        if (this.mChildIterBinding != null && this.mChildIterBinding.isBoundRowIteratorEvent((JboEvent)insertEvent) && !this.getIteratorBinding().isFindMode()) {
            this.myUpdateValuesFromRows(this.mChildIterBinding.getAllRowsInRange(), true);
        }
    }

    public void updateRowDeleted(DeleteEvent deleteEvent) {
        if (this.mChildIterBinding != null && this.mChildIterBinding.isBoundRowIteratorEvent((JboEvent)deleteEvent) && !this.getIteratorBinding().isFindMode()) {
            this.myUpdateValuesFromRows(this.mChildIterBinding.getAllRowsInRange(), true);
        }
    }

    void refresh(Row row) {
        String[] stringArray = this.getAttributeNames();
        this.mNodeValue = row != null && stringArray != null ? (stringArray.length == 1 ? row.getAttribute(stringArray[0]) : JUCtrlHierNodeBinding.getMergedAttributeValues(this.getAttributes(row, this.getAttributeDefs()))) : null;
    }

    public void updateValuesFromRow(Row row) {
        JUCtrlHierNodeBinding jUCtrlHierNodeBinding;
        if (row != null && this.getIteratorBinding() != null && (jUCtrlHierNodeBinding = this.findMatchingNode(row.getKey())) != null) {
            jUCtrlHierNodeBinding.refresh(row);
        }
    }

    public void updateValuesFromRows(Row[] rowArray, boolean bl) {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (this.mParentNode == null && jUIteratorBinding != null && !jUIteratorBinding.isFindMode()) {
            this.myUpdateValuesFromRows(rowArray, bl);
        }
    }

    public void myUpdateValuesFromRows(Row[] rowArray, boolean bl) {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        if (jUIteratorBinding != null && jUIteratorBinding.isFindMode()) {
            return;
        }
        JUCtrlHierBinding jUCtrlHierBinding = this.getHierBinding();
        if (bl && this.mChildren != null) {
            int n = this.mChildren.size() - 1;
            while (n >= 0) {
                JUCtrlHierNodeBinding jUCtrlHierNodeBinding = (JUCtrlHierNodeBinding)this.mChildren.get(n);
                this.removeChild(jUCtrlHierNodeBinding);
                jUCtrlHierNodeBinding.release(DCDataControl.REL_ALL_REFS);
                --n;
            }
            this.mChildren = null;
        }
        if (rowArray == null) {
            return;
        }
        JUCtrlHierTypeBinding[] jUCtrlHierTypeBindingArray = jUCtrlHierBinding.getTypeBindings();
        String string = this.mChildIterBinding.getIteratorDefName();
        JUCtrlHierTypeBinding jUCtrlHierTypeBinding = null;
        int n = jUCtrlHierTypeBindingArray != null ? jUCtrlHierTypeBindingArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            if (!jUCtrlHierTypeBindingArray[n2].isDiscrColumnType() && jUCtrlHierTypeBindingArray[n2].matchViewObjectType(string)) {
                jUCtrlHierTypeBinding = jUCtrlHierTypeBindingArray[n2];
                break;
            }
            ++n2;
        }
        boolean bl2 = jUIteratorBinding.getDataControl().syncNeeded();
        if (jUCtrlHierTypeBinding != null) {
            int n3 = 0;
            while (n3 < rowArray.length) {
                Row row = rowArray[n3];
                if (row != null) {
                    boolean bl3 = false;
                    JUIteratorBinding jUIteratorBinding2 = null;
                    String string2 = jUCtrlHierTypeBinding.getAccessorName();
                    if (string2 != null) {
                        jUIteratorBinding2 = this.createAccessorIteratorBinding(row, string2);
                        bl3 = bl2 || jUIteratorBinding2.hasRSI() && jUIteratorBinding2.getRowSetIterator() != null;
                    }
                    JUCtrlHierNodeBinding jUCtrlHierNodeBinding = jUCtrlHierBinding.createNodeBinding(this, jUIteratorBinding2, jUCtrlHierTypeBinding, row, bl3);
                    if (row != null) {
                        jUCtrlHierNodeBinding.setupAccessors(row);
                    }
                }
                ++n3;
            }
        } else {
            ArrayList<JUCtrlHierTypeBinding> arrayList = new ArrayList<JUCtrlHierTypeBinding>(n);
            int n4 = 0;
            while (n4 < n) {
                if (jUCtrlHierTypeBindingArray[n4].isDiscrColumnType()) {
                    arrayList.add(jUCtrlHierTypeBindingArray[n4]);
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < rowArray.length) {
                Row row = rowArray[n5];
                if (row != null) {
                    boolean bl4 = false;
                    JUIteratorBinding jUIteratorBinding3 = null;
                    jUCtrlHierTypeBinding = null;
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        JUCtrlHierTypeBinding jUCtrlHierTypeBinding2 = (JUCtrlHierTypeBinding)((Object)iterator.next());
                        if (!jUCtrlHierTypeBinding2.matchRowDiscrColumn(row)) continue;
                        jUCtrlHierTypeBinding = jUCtrlHierTypeBinding2;
                        break;
                    }
                    if (jUCtrlHierTypeBinding != null) {
                        String string3 = jUCtrlHierTypeBinding.getAccessorName();
                        if (string3 != null) {
                            jUIteratorBinding3 = this.createAccessorIteratorBinding(row, string3);
                            bl4 = bl2 || jUIteratorBinding3.hasRSI() && jUIteratorBinding3.getRowSetIterator() != null;
                        }
                        JUCtrlHierNodeBinding jUCtrlHierNodeBinding = jUCtrlHierBinding.createNodeBinding(this, jUIteratorBinding3, jUCtrlHierTypeBinding, row, bl4);
                        if (row != null) {
                            jUCtrlHierNodeBinding.setupAccessors(row);
                        }
                    }
                }
                ++n5;
            }
        }
    }

    protected void setupAccessors(Row row) {
        JUCtrlHierTypeBinding[] jUCtrlHierTypeBindingArray = this.mTypeBinding.getAccessorTypeBindings();
        if (jUCtrlHierTypeBindingArray != null) {
            String[] stringArray = this.mTypeBinding.getAccessorNames();
            int n = 0;
            while (n < jUCtrlHierTypeBindingArray.length) {
                JUCtrlHierNodeBinding jUCtrlHierNodeBinding = this.mHierBinding.createNodeBinding(this, n > 0 ? this.createAccessorIteratorBinding(row, stringArray[n]) : (JUIteratorBinding)this.mChildIterBinding, jUCtrlHierTypeBindingArray[n], null, true);
                jUCtrlHierNodeBinding.mNodeValue = stringArray[n];
                ++n;
            }
            this.mChildIterBinding = null;
        }
    }

    private JUIteratorBinding createAccessorIteratorBinding(Row row, String string) {
        JUIteratorBinding jUIteratorBinding = this.getIteratorBinding();
        JUAccessorIteratorDef jUAccessorIteratorDef = new JUAccessorIteratorDef(string, this.mChildIterBinding.getName(), true);
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("Refresh", "never");
        jUAccessorIteratorDef.init(hashMap);
        DCDataControl dCDataControl = this.getIteratorBinding().getDataControl();
        DCBindingContainer dCBindingContainer = this.getBindingContainer();
        JUIteratorBinding jUIteratorBinding2 = (JUIteratorBinding)jUAccessorIteratorDef.createIterBinding(dCDataControl, dCBindingContainer, jUIteratorBinding.getRowSetIterator(), row, string);
        String string2 = jUIteratorBinding2.getName();
        if (string2 == null) {
            string2 = string;
            while (dCBindingContainer.findIteratorBinding(string2 = JboNameUtil.getInstNameFromDefName((String)string2)) != null || dCBindingContainer.findCtrlBinding(string2) != null) {
            }
            jUIteratorBinding2.setName(string2);
        }
        dCBindingContainer.addIteratorBinding(jUIteratorBinding2.getName(), jUIteratorBinding2);
        return jUIteratorBinding2;
    }

    public String toString() {
        if (this.mNodeValue == null) {
            return "";
        }
        return this.mNodeValue.toString();
    }

    public RowSetIterator getParentRowSetIterator() {
        return this.getIteratorBinding().getRowSetIterator();
    }

    public final JUCtrlHierTypeBinding getHierTypeBinding() {
        return this.mTypeBinding;
    }

    protected Object internalGet(String string) {
        if (ATTR_CHILDREN == (string = string.intern())) {
            this.mInternalGet_KeyResolved = true;
            return this.getChildren();
        }
        if (ATTR_ROW == string) {
            this.mInternalGet_KeyResolved = true;
            return this.getRow();
        }
        if (ATTR_ROW_DATA_PROVIDER == string) {
            Row row = this.internalGetRow();
            if (row instanceof RowImpl) {
                this.mInternalGet_KeyResolved = true;
                return ((RowImpl)row).getDataProvider();
            }
        } else {
            if (ATTR_ROW_KEY == string) {
                this.mInternalGet_KeyResolved = true;
                return this.getRowKey();
            }
            if (ATTR_PARENT == string) {
                this.mInternalGet_KeyResolved = true;
                return this.getParent();
            }
            if (ATTR_HIER_TYPE == string) {
                this.mInternalGet_KeyResolved = true;
                return this.getHierTypeBinding();
            }
            if (ATTR_PROMPT == string) {
                this.mInternalGet_KeyResolved = true;
                return this.mNodeValue;
            }
            if (ATTR_HIER_BINDING == string) {
                this.mInternalGet_KeyResolved = true;
                return this.getHierBinding();
            }
            if ("rowKeyStr" == string) {
                this.mInternalGet_KeyResolved = true;
                Key key = this.getRowKey();
                return key != null ? key.toStringFormat(true) : "";
            }
        }
        if (this.getIteratorBinding() != null) {
            if (this.lookupAttributeDef(string) != null) {
                this.mInternalGet_KeyResolved = true;
                return this.getInputValue(this, this.getAttributeIndexOf(string));
            }
            String[] stringArray = this.getHierTypeBinding().getAccessorNames();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    String string2 = stringArray[n];
                    if (string.equals(string2)) {
                        this.mInternalGet_KeyResolved = true;
                        ArrayList arrayList = this.getChildren(string2);
                        if (arrayList != null && arrayList.size() == 1) {
                            return arrayList.get(0);
                        }
                        return arrayList;
                    }
                    ++n;
                }
            }
            return super.internalGet(string);
        }
        JUCtrlHierNodeBinding jUCtrlHierNodeBinding = this.getHierBinding().findNodeByKeyPath(this.getKeyPath());
        if (jUCtrlHierNodeBinding != null) {
            this.mInternalGet_KeyResolved = true;
            return jUCtrlHierNodeBinding.internalGet(string);
        }
        return null;
    }

    public Row getRow() {
        if (this.getRowIterator() == null) {
            return null;
        }
        return this.internalGetRow();
    }

    protected Row internalGetRow() {
        if (this.mRowRef != null) {
            Row row = (Row)this.mRowRef.get();
            if (row == null) {
                Row[] rowArray = this.getRowIterator().findByKey(this.mRowKey, 1);
                if (rowArray.length == 0 || rowArray[0] == null) {
                    throw new RowNotFoundException(false, this.getIteratorBinding().getDisplayName(), this.mRowKey);
                }
                row = rowArray[0];
            }
            return row;
        }
        return null;
    }

    public void refreshControl() {
        if (this.getRowIterator() == null) {
            return;
        }
        this.refresh(this.internalGetRow());
    }

    public void updateNavigated(NavigationEvent navigationEvent) {
    }

    public void updateRangeScrolled(ScrollEvent scrollEvent) {
    }

    public void addControlToPanel(Object object, Object object2, Object object3) {
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public ArrayList getKeyPath() {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        JUCtrlHierNodeBinding jUCtrlHierNodeBinding = this;
        while (jUCtrlHierNodeBinding != null) {
            if (jUCtrlHierNodeBinding.getRowKey() == null) break;
            arrayList.add(0, jUCtrlHierNodeBinding.getRowKey());
            jUCtrlHierNodeBinding = jUCtrlHierNodeBinding.getParent();
        }
        return arrayList;
    }
}

