/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.utils;

import java.util.Hashtable;
import oracle.adf.model.ADFmMessageBundle;
import oracle.adf.model.meta.OperationDefinition;
import oracle.binding.meta.ArrayListDefinitionContainer;
import oracle.binding.meta.DataControlDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContainer;
import oracle.binding.meta.MethodReturnDefinition;
import oracle.binding.meta.ParameterDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.binding.metaimpl.BaseValueObjectDefinition;

public class StandardOperationDef
implements OperationDefinition {
    private int mId;
    private DataControlDefinition mDataControlDefinition;
    private ArrayListDefinitionContainer mParameters;
    private StructureDefinition mParent;
    private String mName;
    private String mFullName;
    private Hashtable mProperties;
    private boolean mAllowAddParameters;

    public StandardOperationDef(int n, String string) {
        this.mId = n;
        this.mName = string;
        this.mAllowAddParameters = false;
        this.mParameters = new ArrayListDefinitionContainer();
        String string2 = StandardOperationDef.getDefaultLabelForId(n);
        this.setProperty("LABEL", string2);
        switch (this.mId) {
            case 96: 
            case 98: 
            case 99: {
                this.mParameters.add((Object)new StandardOpParameterDefinition());
                break;
            }
            case 40: {
                this.setProperty("LABEL", ADFmMessageBundle.getResString("Create"));
                break;
            }
            case 95: {
                this.mAllowAddParameters = true;
            }
        }
    }

    public static int getOperationCodeFromId(String string) {
        if (string.equals("First")) {
            return 12;
        }
        if (string.equals("Last")) {
            return 13;
        }
        if (string.equals("Next")) {
            return 10;
        }
        if (string.equals("Previous")) {
            return 11;
        }
        if (string.equals("NextSet")) {
            return 14;
        }
        if (string.equals("PreviousSet")) {
            return 15;
        }
        if (string.equals("Find")) {
            return 3;
        }
        if (string.equals("Execute")) {
            return 0;
        }
        if (string.equals("IteratorExecute")) {
            return 2;
        }
        if (string.equals("Create")) {
            return 41;
        }
        if (string.equals("CreateInsert")) {
            return 40;
        }
        if (string.equals("Delete")) {
            return 30;
        }
        if (string.equals("Commit")) {
            return 100;
        }
        if (string.equals("Rollback")) {
            return 101;
        }
        if (string.equals("removeRowWithKey")) {
            return 99;
        }
        if (string.equals("setCurrentRowWithKey")) {
            return 96;
        }
        if (string.equals("setCurrentRowWithKeyValue")) {
            return 98;
        }
        if (string.equals("ExecuteWithParams")) {
            return 95;
        }
        return 999;
    }

    public static String getDefaultNameForId(int n) {
        switch (n) {
            case 12: {
                return "First";
            }
            case 13: {
                return "Last";
            }
            case 10: {
                return "Next";
            }
            case 11: {
                return "Previous";
            }
            case 14: {
                return "NextSet";
            }
            case 15: {
                return "PreviousSet";
            }
            case 1: 
            case 3: {
                return "Find";
            }
            case 0: {
                return "Execute";
            }
            case 2: {
                return "Execute";
            }
            case 41: {
                return "Create";
            }
            case 40: {
                return "CreateInsert";
            }
            case 30: {
                return "Delete";
            }
            case 100: {
                return "Commit";
            }
            case 101: {
                return "Rollback";
            }
            case 99: {
                return "removeRowWithKey";
            }
            case 96: {
                return "setCurrentRowWithKey";
            }
            case 98: {
                return "setCurrentRowWithKeyValue";
            }
            case 95: {
                return "ExecuteWithParams";
            }
        }
        return "";
    }

    public static String getDefaultKeyForId(int n) {
        switch (n) {
            case 12: {
                return "First";
            }
            case 13: {
                return "Last";
            }
            case 10: {
                return "Next";
            }
            case 11: {
                return "Previous";
            }
            case 14: {
                return "NextSet";
            }
            case 15: {
                return "PreviousSet";
            }
            case 1: 
            case 3: {
                return "Find";
            }
            case 0: {
                return "Execute";
            }
            case 2: {
                return "IteratorExecute";
            }
            case 41: {
                return "Create";
            }
            case 40: {
                return "CreateInsert";
            }
            case 30: {
                return "Delete";
            }
            case 100: {
                return "Commit";
            }
            case 101: {
                return "Rollback";
            }
            case 99: {
                return "removeRowWithKey";
            }
            case 96: {
                return "setCurrentRowWithKey";
            }
            case 98: {
                return "setCurrentRowWithKeyValue";
            }
            case 95: {
                return "ExecuteWithParams";
            }
        }
        return "";
    }

    public static String getDefaultLabelForId(int n) {
        String string = StandardOperationDef.getDefaultKeyForId(n);
        if (string.equals("")) {
            return "";
        }
        return ADFmMessageBundle.getResString(string);
    }

    public StandardOperationDef(int n) {
        this(n, StandardOperationDef.getDefaultNameForId(n));
    }

    public DefinitionContainer getOperationParameters() {
        return this.mParameters;
    }

    public MethodReturnDefinition getOperationReturnType() {
        return null;
    }

    public int getOperationId() {
        return this.mId;
    }

    public void setDataControlDefinition(DataControlDefinition dataControlDefinition) {
        this.mDataControlDefinition = dataControlDefinition;
    }

    public DataControlDefinition getDataControlDefinition() {
        if (this.mDataControlDefinition != null) {
            return this.mDataControlDefinition;
        }
        if (this.mParent != null) {
            return this.mParent.getDataControlDefinition();
        }
        return null;
    }

    public void setParent(StructureDefinition structureDefinition) {
        this.mParent = structureDefinition;
    }

    public Definition getDefinitionParent() {
        return this.mParent;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public void addParameter(String string, String string2, String string3) {
        if (this.mAllowAddParameters) {
            this.mParameters.add((Object)new StandardOpParameterDefinition(string, string2, string3));
        }
    }

    public void setFullName(String string) {
        this.mFullName = string;
    }

    public String getFullName() {
        if (this.mFullName != null) {
            return this.mFullName;
        }
        if (this.mParent != null) {
            return this.mParent.getFullName() + "." + this.getName();
        }
        return this.getName();
    }

    public Object getProperty(String string) {
        if (this.mProperties == null) {
            return null;
        }
        return this.mProperties.get(string);
    }

    public Hashtable getProperties() {
        return this.mProperties;
    }

    public void setProperty(String string, Object object) {
        if (this.mProperties == null) {
            this.mProperties = new Hashtable();
        }
        this.mProperties.put(string, object);
    }

    public int getDefinitionType() {
        return 60;
    }

    public boolean isStatic() {
        return false;
    }

    public class StandardOpParameterDefinition
    extends BaseValueObjectDefinition
    implements ParameterDefinition {
        public StandardOpParameterDefinition() {
            super("rowKey", (Definition)StandardOperationDef.this, "rowKey", "java.lang.String");
        }

        public StandardOpParameterDefinition(String string, String string2, String string3) {
            super(string, (Definition)StandardOperationDef.this, string3, string2);
        }

        public boolean isStructured() {
            return false;
        }

        public StructureDefinition getStructure() {
            return null;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isScalarCollection() {
            return false;
        }

        public int getDefinitionType() {
            return 70;
        }
    }
}

