/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.generic;

import com.sun.java.util.collections.ArrayList;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.generic.AttributeDefImpl;
import oracle.adf.model.generic.BeanUtils;
import oracle.adf.model.generic.DCGenericDataControl;
import oracle.adf.model.generic.DCGenericRowContext;
import oracle.adf.model.generic.RowImpl;
import oracle.adf.model.generic.StructureDefImpl;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboSyncLock;
import oracle.jbo.Key;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowComparator;
import oracle.jbo.RowIterator;
import oracle.jbo.RowMatch;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetManagementEvent;
import oracle.jbo.ScrollEvent;
import oracle.jbo.SortCriteria;
import oracle.jbo.StructureDef;
import oracle.jbo.UpdateEvent;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewCriteria;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.RowSetHelper;
import oracle.jbo.common.RowSetIteratorHelper;

public class DCRowSetIteratorImpl
extends RowSetHelper
implements RowSetIterator {
    ViewCriteria mVC;
    RowMatch mRowMatch;
    protected DCDataControl mApp;
    protected List dataRows;
    protected List orgDataRows;
    private String mProviderMethodResultLoc;
    private int mProviderMethodResultUseCount;
    protected Object mProvider;
    protected Iterator mProviderIter;
    protected StructureDef mStructureDef;
    protected String mAccessorName;
    protected Row mCurrentRow;
    private boolean mHasAllRows;
    private boolean mFetchedAllRows;
    private int cursor;
    private int rangeSize;
    private int rangeStart;
    private int hasNext;
    private int mCurrentRowSlot;
    private boolean mValidationFlag;
    private boolean mExecuted;
    private JboSyncLock mSyncLock;
    private boolean mRebuilt;
    static AttributeDef[] mStaticRowNumKeyDef = null;
    private static Iterator NULL_COLL_ITERATOR = new java.util.ArrayList(0).iterator();
    private SortCriteria[] mSC;
    public static final int REQ_FIRST = 9;
    public static final int REQ_PREVIOUS = 10;
    public static final int REQ_NEXT = 11;
    public static final int REQ_LAST = 12;

    private /* synthetic */ void $init$() {
        this.dataRows = new java.util.ArrayList();
        this.orgDataRows = null;
        this.mProviderMethodResultUseCount = 0;
        this.mHasAllRows = false;
        this.mFetchedAllRows = false;
        this.cursor = -1;
        this.rangeSize = -1;
        this.rangeStart = 0;
        this.mCurrentRowSlot = 2;
        this.mExecuted = false;
        this.mSyncLock = null;
        this.mRebuilt = true;
    }

    protected DCRowSetIteratorImpl(DCDataControl dCDataControl, Collection collection, String string) {
        this.$init$();
        this.mApp = dCDataControl;
        this.mProvider = collection;
        this.mProviderIter = collection.iterator();
        this.mExecuted = true;
        this.init(string);
    }

    protected DCRowSetIteratorImpl(DCDataControl dCDataControl, Iterator iterator, String string) {
        this.$init$();
        this.mApp = dCDataControl;
        this.mProvider = iterator;
        this.mProviderIter = iterator;
        this.mExecuted = true;
        this.init(string);
    }

    protected DCRowSetIteratorImpl(DCDataControl dCDataControl, Object object, String string) {
        this.$init$();
        this.mApp = dCDataControl;
        this.mProvider = object;
        this.mExecuted = object != null;
        if (this.mExecuted) {
            this.buildProviderIterator(object);
        }
        this.init(string);
    }

    public DCRowSetIteratorImpl(DCDataControl dCDataControl, Object object, String string, StructureDef structureDef) {
        this.$init$();
        this.mApp = dCDataControl;
        this.mProvider = object;
        this.mProviderIter = null;
        this.mExecuted = object != null;
        if (this.mExecuted) {
            this.buildProviderIterator(object);
        }
        this.init(string);
        this.mStructureDef = structureDef;
    }

    public final Object getSyncLock() {
        if (this.mSyncLock == null) {
            this.mSyncLock = new JboSyncLock();
        }
        return this.mSyncLock;
    }

    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(String string) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.resetCrack();
            this.setName(string);
        }
    }

    protected DCDataControl getDataControl() {
        return this.mApp;
    }

    public void rebuildIteratorUpto(int n) {
        this.restoreCurrency(true);
    }

    public final void setProviderMethodResultName(String string) {
        this.mProviderMethodResultLoc = string;
    }

    public final String getProviderMethodResultName() {
        return this.mProviderMethodResultLoc;
    }

    public final void setProviderMethodResultUseCount(int n) {
        this.mProviderMethodResultUseCount = n;
    }

    public final int getProviderMethodResultUseCount() {
        return this.mProviderMethodResultUseCount;
    }

    public final void setAccessorName(String string) {
        this.mAccessorName = string;
    }

    public final String getAccessorName() {
        return this.mAccessorName;
    }

    protected int syncIterator(int n) {
        this.getRowAtAbsoluteIndex(n);
        int n2 = this.dataRows.size();
        if (n >= n2 || n <= -1 || n2 <= 0) {
            if (n2 <= 0) {
                this.cursor = -1;
            }
            return -1;
        }
        this.cursor = n;
        this.hasNext = n != n2 - 1 ? 1 : -1;
        Row row = this.mCurrentRow;
        this.mCurrentRow = (Row)this.dataRows.get(this.cursor);
        if (n > 0) {
            // empty if block
        }
        this.mCurrentRowSlot = this.mCurrentRow != null ? 0 : 2;
        if (this.mCurrentRow != row) {
            this.notifyNavigationEvent(row, this.mCurrentRow);
        }
        return this.cursor;
    }

    /*
     * Unable to fully structure code
     */
    static Iterator getIteratorForArray(Object var0, Class var1_1) {
        block26: {
            block25: {
                var2_2 = null;
                try {
                    var3_3 = (Object[])var0;
                    var2_2 = new java.util.ArrayList<Object>(var3_3.length);
                    var4_4 = 0;
                    while (var4_4 < var3_3.length) {
                        var2_2.add(var3_3[var4_4]);
                        ++var4_4;
                    }
                    var23_5 = var2_2.iterator();
                    return var23_5;
                }
                catch (ClassCastException var5_6) {
                    var6_7 = var1_1.getName();
                    if (!var6_7.startsWith("[I")) break block25;
                    var7_8 = (int[])var0;
                    var2_2 = new java.util.ArrayList<E>(var7_8.length);
                    var8_9 = 0;
                    ** while (var8_9 < var7_8.length)
                }
lbl-1000:
                // 1 sources

                {
                    var2_2.add(new Integer(var7_8[var8_9]));
                    ++var8_9;
                    continue;
lbl24:
                    // 1 sources

                    break block26;
                }
            }
            if (var6_7.startsWith("[Z")) {
                var9_10 = (boolean[])var0;
                var2_2 = new java.util.ArrayList<E>(var9_10.length);
                var10_11 = 0;
                while (var10_11 < var9_10.length) {
                    var2_2.add(new Boolean(var9_10[var10_11]));
                    ++var10_11;
                }
            } else if (var6_7.startsWith("[B")) {
                var11_12 = (byte[])var0;
                var2_2 = new java.util.ArrayList<E>(var11_12.length);
                var12_13 = 0;
                while (var12_13 < var11_12.length) {
                    var2_2.add(new Byte(var11_12[var12_13]));
                    ++var12_13;
                }
            } else if (var6_7.startsWith("[D")) {
                var13_14 = (double[])var0;
                var2_2 = new java.util.ArrayList<E>(var13_14.length);
                var14_15 = 0;
                while (var14_15 < var13_14.length) {
                    var2_2.add(new Double(var13_14[var14_15]));
                    ++var14_15;
                }
            } else if (var6_7.startsWith("[J")) {
                var15_16 = (long[])var0;
                var2_2 = new java.util.ArrayList<E>(var15_16.length);
                var16_17 = 0;
                while (var16_17 < var15_16.length) {
                    var2_2.add(new Long(var15_16[var16_17]));
                    ++var16_17;
                }
            } else if (var6_7.startsWith("[S")) {
                var17_18 = (short[])var0;
                var2_2 = new java.util.ArrayList<E>(var17_18.length);
                var18_19 = 0;
                while (var18_19 < var17_18.length) {
                    var2_2.add(new Short(var17_18[var18_19]));
                    ++var18_19;
                }
            } else if (var6_7.startsWith("[F")) {
                var19_20 = (float[])var0;
                var2_2 = new java.util.ArrayList<E>(var19_20.length);
                var20_21 = 0;
                while (var20_21 < var19_20.length) {
                    var2_2.add(new Float(var19_20[var20_21]));
                    ++var20_21;
                }
            } else if (var6_7.startsWith("[C")) {
                var21_22 = (char[])var0;
                var2_2 = new java.util.ArrayList<E>(var21_22.length);
                var22_23 = 0;
                while (var22_23 < var21_22.length) {
                    var2_2.add(new Character(var21_22[var22_23]));
                    ++var22_23;
                }
            } else {
                throw new UnsupportedOperationException("Invalid primitive type Array");
            }
        }
        return var2_2.iterator();
    }

    void fetchDataSource() {
        this.mRebuilt = true;
        this.clearCurrentData();
        this.mProvider = this.fetchProvider();
        this.buildProviderIterator(this.mProvider);
    }

    protected Object fetchProvider() {
        if (this.mProvider == null && !this.mHasAllRows && this.mApp != null) {
            this.mProvider = this.mApp.getMethodResults().get(this.getProviderMethodResultName());
        }
        return this.mProvider;
    }

    private void buildProviderIterator(Object object) {
        Iterator iterator = null;
        if (object instanceof Iterator) {
            iterator = (Iterator)object;
        } else if (object instanceof Collection) {
            iterator = ((Collection)object).iterator();
            if (this.useListAdapter() && object instanceof List) {
                this.dataRows = new MyListAdapter((List)object);
                this.mHasAllRows = true;
            }
        } else if (object instanceof Enumeration) {
            iterator = new EnumerationIterator((Enumeration)object);
        } else if (object != null) {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                iterator = DCRowSetIteratorImpl.getIteratorForArray(object, clazz);
            } else {
                java.util.ArrayList<Object> arrayList = new java.util.ArrayList<Object>(3);
                arrayList.add(object);
                iterator = arrayList.iterator();
            }
        } else {
            Diagnostic.println((String)"Null data returned for an accessor. Assuming empty iterator");
            iterator = NULL_COLL_ITERATOR;
        }
        this.mProviderIter = iterator;
        this.mExecuted = true;
        this.resetCrack();
        this.notifyRangeRefreshed(0);
    }

    void bringRows(int n) {
        if (!this.mHasAllRows) {
            if (this.mProviderIter == null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println((String)("DCRowSetIteratorImpl:" + this.getName() + " fetch data source."));
                }
                this.fetchDataSource();
                if (this.mHasAllRows) {
                    return;
                }
            }
            int n2 = this.dataRows.size();
            boolean bl = this.mRowMatch != null;
            RowMatch rowMatch = this.mRowMatch;
            if (this.mSC != null) {
                n = -1;
            }
            if (Diagnostic.isOn() && n == -1 && this.rangeSize != -1) {
                Diagnostic.println((String)("DCRowSetIteratorImpl " + this.getName() + " fetching all rows from dataProvider"));
            }
            while (this.mProviderIter.hasNext() && (n2 <= n || n == -1)) {
                Row row = this.internalCreateRowInstanceFor(this.mProviderIter.next());
                if (rowMatch != null && !rowMatch.rowQualifies(row)) continue;
                this.dataRows.add(row);
                ++n2;
            }
            this.mFetchedAllRows = this.mHasAllRows = this.mProviderIter.hasNext() ^ true;
            if (this.mSC != null) {
                this.sortRows(this.mSC);
            }
            if (Diagnostic.isOn() && this.mHasAllRows) {
                Diagnostic.println((String)("DCRowSetIteratorImpl:" + this.getName() + " fetched all rows."));
            }
        }
    }

    private final void resetCrack() {
        this.cursor = -1;
        this.hasNext = -1;
        this.mCurrentRow = null;
        this.mCurrentRowSlot = 2;
    }

    final void setDataRows(java.util.ArrayList arrayList) {
        this.resetCrack();
        this.dataRows = arrayList;
        this.orgDataRows = null;
        this.notifyRangeRefreshed(0);
    }

    void clearClientSide() {
        this.clearCurrentData();
    }

    public void clearCurrentData() {
        this.dataRows = new java.util.ArrayList();
        this.orgDataRows = null;
        this.mProviderIter = null;
        this.mProvider = null;
        this.mExecuted = false;
        this.mHasAllRows = false;
        this.mFetchedAllRows = false;
        this.resetCrack();
    }

    boolean isExecuted() {
        return this.mExecuted;
    }

    public void closeRowSetIterator() {
        this.clearClientSide();
        if (!this.hasManagementListeners()) {
            return;
        }
        this.fireMgmtIteratorClosed(new RowSetManagementEvent((RowSetIterator)this, 1));
    }

    public RowSet getRowSet() {
        return null;
    }

    public Object getDataProvider() {
        return this.mProvider;
    }

    public RowSetIterator getRowSetIterator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row next() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.mCurrentRowSlot == 0 || this.mCurrentRowSlot == 2 ? this.cursor + 1 : this.cursor;
            this.syncIterator(n);
            this.scrollRangeTo(n);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row previous() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.mCurrentRowSlot == 0 || this.mCurrentRowSlot == 3 ? this.cursor - 1 : (this.mCurrentRowSlot == 1 && this.cursor >= this.dataRows.size() ? this.dataRows.size() - 1 : this.cursor);
            this.syncIterator(n);
            this.scrollRangeTo(n);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row first() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.cursor = 0;
            this.scrollRangeTo(this.cursor);
            this.syncIterator(0);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row last() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.getRowCount() - 1;
            if (this.mCurrentRowSlot == 0 || this.mCurrentRowSlot == 2) {
                this.cursor = n;
            }
            this.cursor = this.syncIterator(this.cursor < 0 ? 0 : this.cursor);
            this.scrollRangeTo(this.cursor);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.resetCrack();
        }
    }

    public boolean hasNext() {
        int n;
        if (this.mCurrentRowSlot == 2) {
            n = 0;
        } else {
            if (this.mCurrentRowSlot == 3) {
                return false;
            }
            n = this.cursor + 1;
            if (this.mCurrentRowSlot == 1) {
                --n;
            }
        }
        if (n < this.dataRows.size()) {
            return true;
        }
        if (this.mHasAllRows) {
            return false;
        }
        if (this.hasNext != 0) {
            if (this.mProviderIter == null) {
                this.fetchDataSource();
            }
            int n2 = this.hasNext = this.mProviderIter.hasNext() ? 1 : 0;
            if (this.hasNext == 0) {
                this.mHasAllRows = true;
                this.mFetchedAllRows = true;
                this.hasNext = this.dataRows.size() > n ? 1 : 0;
            }
        }
        return this.hasNext == 1;
    }

    public boolean hasPrevious() {
        if (this.cursor <= 0) {
            if (this.mCurrentRowSlot == 3) {
                return this.dataRows.size() > 0;
            }
            return false;
        }
        return true;
    }

    public boolean isRangeAtBottom() {
        return this.rangeSize > -1 ? this.rangeStart + this.rangeSize >= this.dataRows.size() && this.mHasAllRows : true;
    }

    public boolean isRangeAtTop() {
        return this.getRealRangeStart() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchedRowCount() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.dataRows.size();
            return n;
        }
    }

    public int getRowCount() {
        if (this.mProvider instanceof Collection && this.mRowMatch == null) {
            return ((Collection)this.mProvider).size();
        }
        this.bringRows(-1);
        return this.getFetchedRowCount();
    }

    private boolean isIndexValid(int n) {
        if (n >= 0) {
            if (n >= this.getFetchedRowCount()) {
                this.bringRows(n);
                if (n >= this.getFetchedRowCount()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int setRangeSize(int n) {
        if (n != 0) {
            this.rangeSize = n;
        }
        return this.rangeSize;
    }

    public int getRangeSize() {
        return this.rangeSize;
    }

    private int getRealRangeSize() {
        return this.rangeSize > 0 ? this.rangeSize : this.dataRows.size();
    }

    public int getRowCountInRange() {
        return this.getRowsInRange().size();
    }

    private int getRealRangeStart() {
        return this.rangeSize > 0 ? this.rangeStart : 0;
    }

    public int getRangeStart() {
        return this.rangeStart;
    }

    public int setRangeStart(int n) {
        int n2 = this.rangeStart;
        int n3 = this.rangeStart = this.isIndexValid(n) ? n : 0;
        if (n2 != this.rangeStart) {
            this.notifyRangeScrolled(n2);
        }
        return this.rangeStart;
    }

    public int getEstimatedRangePageCount() {
        return 1;
    }

    public int scrollToRangePage(int n) {
        return 0;
    }

    public int scrollRange(int n) {
        int n2 = this.rangeStart;
        this.setRangeStart(this.rangeStart + n);
        int n3 = this.rangeStart - n2;
        return n3;
    }

    public int scrollRangeTo(Row row, int n) {
        int n2 = this.rangeStart;
        int n3 = this.dataRows.indexOf(row);
        if (n3 < 0) {
            throw new InvalidParamException("DCRowSetIteratorImpl.scrollRangeTo", "row", (Object)row.getClass().getName(), "not in the collection");
        }
        int n4 = n3 - n2 - n;
        return this.scrollRange(n4);
    }

    private void scrollRangeTo(int n) {
        int n2 = this.getRangeSize();
        if (n2 > 0) {
            int n3 = n / n2;
            int n4 = n3 * n2;
            this.setRangeStart(n4);
        }
    }

    private final Row findRowInCache(Key key) {
        Key key2;
        if (this.mCurrentRow != null && (key2 = this.mCurrentRow.getKey()) != null && key2.equals((Object)key)) {
            return this.mCurrentRow;
        }
        Iterator iterator = this.dataRows.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            key2 = row.getKey();
            if (key2 == null || !key2.equals((Object)key)) continue;
            return row;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getRow(Key key) {
        Object object = this.getSyncLock();
        synchronized (object) {
            Row row = this.findRowInCache(key);
            if (row == null) {
                if (this.mProviderIter == null) {
                    this.fetchDataSource();
                }
                if (this.mProviderIter != null) {
                    RowMatch rowMatch = this.mRowMatch;
                    while (this.mProviderIter.hasNext()) {
                        Row row2 = this.internalCreateRowInstanceFor(this.mProviderIter.next());
                        if (rowMatch != null && !rowMatch.rowQualifies(row2)) continue;
                        this.dataRows.add(row2);
                        Key key2 = row2.getKey();
                        if (key2 == null || !key2.equals((Object)key)) continue;
                        Row row3 = row2;
                        return row3;
                    }
                }
            }
            Row row4 = row;
            return row4;
        }
    }

    String toUpperFirst(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        return new StringBuffer(string.length()).append(Character.toUpperCase(stringBuffer.charAt(0))).append(stringBuffer.substring(1)).toString();
    }

    public StructureDef getStructureDef() {
        return this.mStructureDef;
    }

    public Row getRowAtRangeIndex(int n) {
        int n2 = this.toAbsoluteIndex(n);
        return this.getRowAtAbsoluteIndex(n2);
    }

    private Row getRowAtAbsoluteIndex(int n) {
        if (this.mProviderIter == null) {
            this.fetchDataSource();
        }
        int n2 = this.dataRows.size();
        if (this.mProviderIter != null) {
            this.bringRows(n);
            if (n < n2 && n >= 0) {
                return (Row)this.dataRows.get(n);
            }
        }
        return null;
    }

    public Row getCurrentRow() {
        return this.mCurrentRow;
    }

    public int getCurrentRowIndex() {
        return this.cursor;
    }

    public int getCurrentRowSlot() {
        return this.mCurrentRowSlot;
    }

    public int getIterMode() {
        return 0;
    }

    public void setIterMode(int n) {
    }

    public void setRowValidation(boolean bl) {
        this.mValidationFlag = bl;
    }

    public boolean isRowValidation() {
        return this.mValidationFlag;
    }

    protected boolean containsRow(Row row) {
        return this.getRow(row.getKey()) != null;
    }

    protected void setAttributeValue(RowImpl rowImpl, String string, Object object) {
        if (rowImpl.isProviderMap()) {
            ((Map)rowImpl.getDataProvider()).put(string, object);
        } else {
            BeanUtils.setProperty((Object)rowImpl.getDataProvider(), (String)string, (Object)object);
        }
    }

    void sortRows(SortCriteria[] sortCriteriaArray) {
        if (this.isSortable()) {
            Row row = this.mCurrentRow;
            if (sortCriteriaArray == null || sortCriteriaArray.length == 0) {
                this.mSC = null;
                this.dataRows = this.orgDataRows != null ? this.orgDataRows : this.dataRows;
                this.orgDataRows = null;
            } else if (this.dataRows != null) {
                this.bringRows(-1);
                Row[] rowArray = this.dataRows.toArray(new Row[this.dataRows.size()]);
                Arrays.sort(rowArray, new RowComparator(sortCriteriaArray));
                this.mSC = sortCriteriaArray;
                if (this.orgDataRows == null) {
                    this.orgDataRows = this.dataRows;
                }
                this.dataRows = new java.util.ArrayList(rowArray.length);
                int n = 0;
                while (n < rowArray.length) {
                    this.dataRows.add(rowArray[n]);
                    ++n;
                }
            }
            this.resetCrack();
            this.notifyNavigationEvent(row, this.mCurrentRow);
            this.notifyRangeRefreshed(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentRow(Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.containsRow(row)) {
                boolean bl = false;
                return bl;
            }
            if (this.mCurrentRow != null && this.mCurrentRow == row) {
                boolean bl = true;
                return bl;
            }
            int n = this.dataRows.indexOf(row);
            if (n < 0) {
                this.bringRows(-1);
                n = this.dataRows.indexOf(row);
            }
            boolean bl = this.setCurrentRowAtAbsoluteIndex(n);
            return bl;
        }
    }

    public boolean setCurrentRowAtRangeIndex(int n) {
        int n2 = this.toAbsoluteIndex(n);
        return this.setCurrentRowAtAbsoluteIndex(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setCurrentRowAtAbsoluteIndex(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.isIndexValid(n)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.syncIterator(n) >= 0;
            return bl;
        }
    }

    public Row createRow() {
        return this.createAndInitRow(null);
    }

    public Row createAndInitRow(AttributeList attributeList) {
        throw new UnsupportedOperationException("createAndInitRow()");
    }

    public void insertRow(Row row) {
        if (!this.containsRow(row)) {
            this.insertRowAtAbsoluteIndex(this.cursor, row);
        }
    }

    public void insertRowAtRangeIndex(int n, Row row) {
        if (!this.containsRow(row)) {
            int n2 = this.toAbsoluteIndex(n);
            this.insertRowAtAbsoluteIndex(n2, row);
        }
    }

    private void insertRowAtAbsoluteIndex(int n, Row row) {
        if (n >= this.getFetchedRowCount()) {
            this.bringRows(n);
        }
        boolean bl = false;
        if (n >= this.getFetchedRowCount()) {
            bl = true;
        } else if (n < 0) {
            bl = true;
        }
        int n2 = this.dataRows.size();
        if (bl) {
            this.dataRows.add(row);
            n = n2;
        } else {
            this.dataRows.add(n, row);
        }
        if (this.orgDataRows != null && this.orgDataRows != this.dataRows) {
            this.orgDataRows.add(row);
        }
        this.resetIndexBasedKeys(n);
        this.notifyRowInserted(row, n, n2);
        this.syncIterator(n);
    }

    void resetIndexBasedKeys(int n) {
        block3: {
            block2: {
                if (!(this.getStructureDef() instanceof StructureDefImpl)) break block2;
                java.util.ArrayList arrayList = ((StructureDefImpl)this.getStructureDef()).getKeyAttrsList();
                int n2 = arrayList.size();
                if (n2 != 0) break block3;
                n2 = this.dataRows.size();
                int n3 = n;
                while (n3 < n2) {
                    ((RowImpl)this.dataRows.get(n3)).resetKey();
                    ++n3;
                }
                break block3;
            }
            int n4 = this.dataRows.size();
            int n5 = n;
            while (n5 < n4) {
                ((RowImpl)this.dataRows.get(n5)).resetKey();
                ++n5;
            }
        }
    }

    protected Object getMasterRowDataProvider() {
        return null;
    }

    void doRemoveRow(Row row, boolean bl) {
        if (row != null) {
            boolean bl2;
            int n = this.dataRows.indexOf(row);
            boolean bl3 = this.cursor == n;
            this.mRebuilt = false;
            boolean bl4 = bl2 = bl ? this.mApp.removeRowData(new DCGenericRowContext(row, this, this.mStructureDef, this.getMasterRowDataProvider())) : this.mApp.removeRowDataFromCollection(new DCGenericRowContext(row, this, this.mStructureDef, this.getMasterRowDataProvider()));
            if (bl2 && !this.mRebuilt) {
                this.mRebuilt = true;
                if (bl3) {
                    this.mCurrentRow = null;
                    this.mCurrentRowSlot = 1;
                }
                int n2 = this.dataRows.size();
                if (!bl2) {
                    if (n < this.dataRows.size()) {
                        this.dataRows.remove(n);
                        if (this.orgDataRows != null && this.orgDataRows != this.dataRows) {
                            this.orgDataRows.remove(((RowImpl)row).getDataProvider());
                        }
                    }
                    this.resetIndexBasedKeys(n);
                } else if (n == n2) {
                    this.cursor = n;
                } else {
                    this.cursor = n == 0 ? 0 : n - 1;
                    this.resetIndexBasedKeys(n);
                }
                this.notifyRowDeleted(row, n, n2--, n2, bl);
            }
        }
    }

    public void removeCurrentRow() {
        this.doRemoveRow(this.getCurrentRow(), true);
    }

    public void removeCurrentRowFromCollection() {
        this.doRemoveRow(this.getCurrentRow(), false);
    }

    public Row removeCurrentRowAndRetain() {
        Row row = this.getCurrentRow();
        this.removeCurrentRowFromCollection();
        return row;
    }

    public Class getMessageBundleClass() {
        if (this.mStructureDef instanceof StructureDefImpl) {
            return ((StructureDefImpl)this.mStructureDef).getMessageBundleClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRangeIndexOf(Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (row == null) {
                int n = -1;
                return n;
            }
            int n = this.dataRows.indexOf(row);
            if (this.rangeSize == -1) {
                int n2 = n;
                return n2;
            }
            int n3 = n - this.rangeStart;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumerateRowsInRange() {
        Object object = this.getSyncLock();
        synchronized (object) {
            1 var2_2 = new 1();
            return var2_2;
        }
    }

    public Row[] getFilteredRows(String string, Object object) {
        return this.getFilteredRowsInRange(string, object);
    }

    public Row[] getFilteredRowsInRange(String string, Object object) {
        return RowSetIteratorHelper.getFilteredRowsInRange((RowSetIterator)this, (String)string, (Object)object);
    }

    public Row[] getAllRowsInRange() {
        List list = this.getRowsInRange();
        return list.toArray(new Row[list.size()]);
    }

    private List getRowsInRange() {
        if (this.rangeSize < 1) {
            this.bringRows(-1);
            return this.dataRows;
        }
        if (this.rangeStart < 0) {
            this.rangeStart = 0;
        }
        int n = this.rangeStart + this.rangeSize;
        this.bringRows(n);
        if (n > this.dataRows.size()) {
            n = this.dataRows.size();
        }
        return this.dataRows.subList(this.rangeStart, n);
    }

    protected boolean useListAdapter() {
        return false;
    }

    private int toAbsoluteIndex(int n) {
        int n2 = n + this.getRealRangeStart();
        return n2;
    }

    public Row[] getNextRangeSet() {
        return this.getRangeSet(this.isRangeAtBottom(), true);
    }

    public Row[] getPreviousRangeSet() {
        return this.getRangeSet(this.isRangeAtTop(), false);
    }

    private Row[] getRangeSet(boolean bl, boolean bl2) {
        if (bl) {
            return new Row[0];
        }
        int n = this.getRealRangeSize();
        if (!bl2) {
            n = -n;
        }
        this.scrollRange(n);
        Row[] rowArray = this.getAllRowsInRange();
        if (bl2) {
            this.setCurrentRowAtRangeIndex(0);
        } else {
            this.setCurrentRowAtRangeIndex(rowArray.length - 1);
        }
        return rowArray;
    }

    public RowSet[] getDetailRowSets() {
        return null;
    }

    public RowSet createDetailRowSet(String string, String string2) {
        throw new UnsupportedOperationException("createDetailRowSet()");
    }

    public final void notifyRangeRefreshed(int n) {
        Row[] rowArray = this.dataRows.toArray(new Row[this.dataRows.size()]);
        this.fireRangeRefreshed(new RangeRefreshEvent((RowSetIterator)this, n, rowArray.length, rowArray));
    }

    final void notifyRangeScrolled(int n) {
        this.fireRangeScrolled(new ScrollEvent((RowSetIterator)this, n));
    }

    protected void notifyNavigationEvent(Row row, Row row2) {
        if (this.hasListeners()) {
            this.fireNavigationEvent(new NavigationEvent((NavigatableRowIterator)this, row, row2));
        }
    }

    final void notifyRowInserted(Row row, int n, int n2) {
        if (this.hasListeners()) {
            InsertEvent insertEvent = new InsertEvent((NavigatableRowIterator)this, row, n, n2, this.dataRows.size());
            this.fireRowInserted(insertEvent);
        }
    }

    final void notifyRowDeleted(Row row, int n, int n2, int n3, boolean bl) {
        if (this.hasListeners()) {
            DeleteEvent deleteEvent = new DeleteEvent((NavigatableRowIterator)this, row, n, n2, n3, bl);
            this.fireRowDeleted(deleteEvent);
        }
    }

    final void notifyRowUpdated(Row row, int n, int[] nArray) {
        if (this.hasListeners()) {
            UpdateEvent updateEvent = new UpdateEvent((RowSetIterator)this, row, n, nArray);
            this.fireRowUpdated(updateEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AttributeDef[] getRowNumKeyDefArray() {
        if (mStaticRowNumKeyDef == null) {
            Iterator iterator = NULL_COLL_ITERATOR;
            synchronized (iterator) {
                try {
                    AttributeDefImpl attributeDefImpl = new AttributeDefImpl(null);
                    attributeDefImpl.init("ROWNUM", null, -1, "java.lang.Integer", "java.lang.Integer", false, false, (byte)0, false, false, null);
                    mStaticRowNumKeyDef = new AttributeDefImpl[]{attributeDefImpl};
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return mStaticRowNumKeyDef;
    }

    public Key createKey(String string) {
        block4: {
            StructureDef structureDef = this.getStructureDef();
            if (structureDef instanceof StructureDefImpl) {
                java.util.ArrayList arrayList = ((StructureDefImpl)structureDef).getKeyAttrsList();
                try {
                    if (arrayList.size() > 0) {
                        Key key = new Key(string, arrayList.toArray(new AttributeDef[arrayList.size()]));
                        return key;
                    }
                    Key key = new Key(string, this.getRowNumKeyDefArray());
                    return key;
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block4;
                    Diagnostic.printStackTrace((Throwable)exception);
                }
            }
        }
        return null;
    }

    public Key createKey(AttributeList attributeList) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] findByKey(Key key, int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            Row row = this.getRow(key);
            if (row != null) {
                Row[] rowArray = new Row[]{row};
                return rowArray;
            }
            Row[] rowArray = new Row[]{};
            return rowArray;
        }
    }

    ViewCriteria getViewCriteria() {
        return this.mVC;
    }

    void applyViewCriteria(ViewCriteria viewCriteria) {
        this.mVC = viewCriteria;
    }

    void executeCriteria(ViewCriteria viewCriteria, RowMatch rowMatch) {
        this.applyViewCriteria(viewCriteria);
        this.mRowMatch = rowMatch;
    }

    protected boolean isSortable() {
        return true;
    }

    public RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        DCDataControl dCDataControl = this.getDataControl();
        if (dCDataControl instanceof DCGenericDataControl) {
            DCGenericDataControl dCGenericDataControl = (DCGenericDataControl)dCDataControl;
            if (!this.mHasAllRows) {
                this.bringRows(-1);
            }
            RowMatch rowMatch = dCGenericDataControl.createCriteriaRowMatch(this, viewCriteria);
            java.util.ArrayList<Row> arrayList = new java.util.ArrayList<Row>(10);
            int n3 = this.getFetchedRowCount();
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3 && (n == -1 || n4 < n)) {
                Row row = this.getRowAtAbsoluteIndex(n5);
                if (rowMatch == null || rowMatch.rowQualifies(row)) {
                    arrayList.add(row);
                    ++n4;
                }
                ++n5;
            }
            return this.createFilteredRowSetIterator(arrayList);
        }
        return null;
    }

    protected RowSetIterator createFilteredRowSetIterator(Object object) {
        return this.getDataControl().createRowSetIteratorImpl(null, this.getStructureDef().getFullName(), object, null);
    }

    public Row[] findByEntity(int n, int n2) {
        throw new UnsupportedOperationException("findByEntity()");
    }

    public Hashtable getProperties() {
        return null;
    }

    public boolean isNameGenerated() {
        return false;
    }

    void restoreCurrency(boolean bl) {
        int n = this.cursor;
        if (n > -1) {
            this.resetCrack();
        }
        this.clearCurrentData();
        if (bl && n > -1 && this.syncIterator(n) == -1 && this.dataRows.size() > 0) {
            this.syncIterator(this.dataRows.size() - 1);
        }
    }

    protected ArrayList getListenersList() {
        return super.getListenersList();
    }

    protected Row internalCreateRowInstanceFor(Object object) {
        StructureDefImpl structureDefImpl;
        if (object instanceof Row) {
            return (Row)object;
        }
        if (this.mStructureDef instanceof StructureDefImpl && (structureDefImpl = (StructureDefImpl)this.mStructureDef).isElementsScalar(object)) {
            object = new ScalarRowMap(structureDefImpl.getName(), object);
        }
        return new RowImpl(object, this);
    }

    public VariableValueManager getVariableManager() {
        return null;
    }

    public boolean hasVariables() {
        return false;
    }

    public VariableValueManager ensureVariableManager() {
        return null;
    }

    public final class 1
    implements Enumeration {
        Iterator al;

        private /* synthetic */ void $init$() {
            this.al = DCRowSetIteratorImpl.this.getRowsInRange().iterator();
        }

        public boolean hasMoreElements() {
            return this.al.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Object object = DCRowSetIteratorImpl.this.getSyncLock();
            synchronized (object) {
                Object e = this.al.next();
                return e;
            }
        }

        public /* synthetic */ 1() {
            this.$init$();
        }
    }

    public class EnumerationIterator
    implements Iterator {
        Enumeration mEnum;

        EnumerationIterator(Enumeration enumeration) {
            this.mEnum = enumeration;
        }

        public boolean hasNext() {
            return this.mEnum.hasMoreElements();
        }

        public Object next() {
            return this.mEnum.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException("EnumerationIterator.remove");
        }
    }

    public class ScalarRowMap
    extends AbstractMap {
        java.util.ArrayList _oneEntryArray;

        private /* synthetic */ void $init$() {
            this._oneEntryArray = new java.util.ArrayList(1);
        }

        ScalarRowMap(String string, Object object) {
            this.$init$();
            this._oneEntryArray.add(object);
        }

        public Set entrySet() {
            return new 1();
        }

        public Object get(Object object) {
            return this._oneEntryArray.get(0);
        }

        public final class 1
        extends AbstractSet {
            public Iterator iterator() {
                return ScalarRowMap.this._oneEntryArray.iterator();
            }

            public int size() {
                return ScalarRowMap.this._oneEntryArray.size();
            }

            public boolean removeAll(Collection collection) {
                throw new UnsupportedOperationException("removeAll");
            }
        }
    }

    private final class MyListAdapter
    extends AbstractList {
        private List _table;

        MyListAdapter(List list) {
            this._table = list;
        }

        public int size() {
            return this._table.size();
        }

        public Object get(int n) {
            return DCRowSetIteratorImpl.this.internalCreateRowInstanceFor(this._table.get(n));
        }
    }
}

