/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.binding;

import java.util.ArrayList;
import java.util.List;
import oracle.adf.model.PermissionInfo;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIExecutable;
import oracle.adf.model.binding.DCIExecutableDef;
import oracle.adf.model.binding.PermissionBinding;
import oracle.jbo.common.JboAbstractMap;
import oracle.jbo.common.JboNameUtil;

public abstract class DCExecutableBinding
extends JboAbstractMap
implements DCIExecutable {
    String mName;
    private DCIExecutableDef mExecDef;
    private transient int mRefreshOption;
    private transient String mRefreshExpression;
    private transient boolean mRefreshed;
    private transient ArrayList mDependents;
    private transient DCBindingContainer mBC;
    protected PermissionInfo mPermissionInfo;
    protected boolean mInternalGet_KeyResolved;
    static final String GET_Def = "def";
    static final String GET_Name = "name";
    static final String GET_RefreshParametersChanged = "refreshParametersChanged";
    static final String GET_Refreshed = "refreshed";

    private /* synthetic */ void $init$() {
        this.mRefreshOption = -1;
        this.mRefreshExpression = null;
        this.mRefreshed = false;
        this.mDependents = null;
        this.mPermissionInfo = null;
    }

    public final String getName() {
        return this.mName;
    }

    public final void setName(String string) {
        this.mName = string;
    }

    public final void setRefreshOption(int n) {
        this.mRefreshOption = n;
    }

    public final void setRefreshExpression(String string) {
        this.mRefreshExpression = string;
    }

    public final int getRefreshOption() {
        return this.mRefreshOption;
    }

    public final String getRefreshExpression() {
        return this.mRefreshExpression;
    }

    public Object get(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            this.mInternalGet_KeyResolved = false;
            Object object2 = this.internalGet(string);
            if (object2 != null || this.mInternalGet_KeyResolved) {
                return object2;
            }
            if (!(string = JboNameUtil.toUpperCaseFirstChar((String)string)).equals(object) && ((object2 = this.internalGet(string)) != null || this.mInternalGet_KeyResolved)) {
                return object2;
            }
        }
        return super.get(object);
    }

    protected Object internalGet(String string) {
        Object var2_2 = null;
        if ((string = string.intern()) == GET_Name) {
            this.mInternalGet_KeyResolved = true;
            return this.getName();
        }
        if (string == GET_Def) {
            this.mInternalGet_KeyResolved = true;
            return this.getExecutableDef();
        }
        if (string == GET_Refreshed) {
            this.mInternalGet_KeyResolved = true;
            return new Boolean(this.isRefreshed());
        }
        if (string == GET_RefreshParametersChanged) {
            this.mInternalGet_KeyResolved = true;
            return new Boolean(this.hasRefreshParametersChanged());
        }
        return super.internalGet(string);
    }

    public abstract int getExecutableType();

    public void release(int n) {
        this.mRefreshed = false;
        if (n == DCDataControl.REL_ALL_REFS && this.mBC != null) {
            this.mBC.removeExecutableBinding(this.getName());
        }
    }

    public abstract boolean hasRefreshParametersChanged();

    public DCIExecutableDef getExecutableDef() {
        return this.mExecDef;
    }

    public void setBindingContainer(DCBindingContainer dCBindingContainer) {
        this.mBC = dCBindingContainer;
    }

    public DCBindingContainer getBindingContainer() {
        return this.mBC;
    }

    public void setExecutableDef(DCIExecutableDef dCIExecutableDef) {
        this.mExecDef = dCIExecutableDef;
        if (dCIExecutableDef != null) {
            this.setRefreshOption(dCIExecutableDef.getRefreshOption());
            this.setRefreshExpression(dCIExecutableDef.getRefreshExpression());
        }
    }

    private final boolean isRefreshable(int n) {
        DCBindingContainer dCBindingContainer = this.getBindingContainer();
        DCIExecutableDef dCIExecutableDef = this.getExecutableDef();
        return dCIExecutableDef != null ? dCBindingContainer.isRefreshed() && dCIExecutableDef.isRefreshable(dCBindingContainer, this, n) : true;
    }

    public boolean refreshIfNeeded() {
        if (this.isRefreshed()) {
            return true;
        }
        if (this.getRefreshOption() == 32768) {
            this.refresh(32768);
            return true;
        }
        if (this.isRefreshable(-1)) {
            this.refresh(-1);
            return true;
        }
        return false;
    }

    public void setRefreshed(boolean bl) {
        boolean bl2 = this.mRefreshed != bl;
        this.mRefreshed = bl;
        if (bl2) {
            this.resetDependentsRefresh();
        }
    }

    protected List getDependents() {
        return this.mDependents;
    }

    protected void resetDependentsRefresh() {
        if (this.mDependents != null) {
            int n = 0;
            while (n < this.mDependents.size()) {
                ((DCExecutableBinding)this.mDependents.get(n)).setRefreshed(false);
                ++n;
            }
        }
    }

    public boolean isRefreshed() {
        return this.mRefreshed;
    }

    public void addDependentExecutable(DCExecutableBinding dCExecutableBinding) {
        if (this.mDependents == null) {
            this.mDependents = new ArrayList(4);
        }
        if (!this.mDependents.contains(dCExecutableBinding)) {
            this.mDependents.add(dCExecutableBinding);
        }
    }

    public void removeDependentExecutable(DCExecutableBinding dCExecutableBinding) {
        if (this.mDependents != null) {
            this.mDependents.remove(dCExecutableBinding);
            if (this.mDependents.size() == 0) {
                this.mDependents = null;
            }
        }
    }

    public String getPermissionTargetName() {
        if (this.mBC != null) {
            return this.mBC.getDef().getFullName();
        }
        return null;
    }

    public PermissionInfo getPermissionInfo() {
        if (this.mPermissionInfo == null) {
            this.mPermissionInfo = new PermissionBinding(this.getPermissionTargetName(), 2);
        }
        return this.mPermissionInfo;
    }

    public DCExecutableBinding() {
        this.$init$();
    }
}

