/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter.dataformat;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import oracle.adf.model.adapter.AdapterContext;
import oracle.adf.model.adapter.AdapterException;
import oracle.adf.model.adapter.dataformat.AccessorDef;
import oracle.adf.model.adapter.dataformat.AttributeDef;
import oracle.adf.model.adapter.dataformat.FormatHelper;
import oracle.adf.model.adapter.dataformat.FormatStructureHandler;
import oracle.adf.model.adapter.dataformat.StructureDef;
import oracle.adf.model.adapter.dataformat.xml.SchemaMetadata;
import oracle.adf.model.adapter.dataformat.xml.SchemaParser;
import oracle.adf.model.adapter.dataformat.xml.TypeMap;
import oracle.adf.model.adapter.utils.Utility;
import oracle.adf.model.utils.SimpleStringBuffer;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.perf.Timer;
import oracle.binding.meta.ArrayListDefinitionContainer;
import oracle.binding.meta.AttributeDefinition;
import oracle.binding.meta.Definition;
import oracle.binding.meta.DefinitionContext;
import oracle.binding.meta.NamedDefinition;
import oracle.binding.meta.StructureDefinition;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstrainingFacet;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.parser.v2.XMLAttr;
import org.w3c.dom.Node;

public class XSDHandler
implements FormatStructureHandler {
    public static final String TYPE = "type";
    public static final String ENUMERATION = "enumeration";
    public static final String MIN_OCCURS = "minOccurs";
    public static final String MAX_OCCURS = "maxOccurs";
    public static final String NILLABLE = "nillable";
    public static final String NAMESPACE = "targetNamespace";
    public static final String LEAFELEMENT_DATA = "_text";
    public static final String ARRAY_ITEM = "item";
    private String mRootBindPath;
    SchemaParser mParser;
    XMLSchema mXMLSchema;
    Map mTypesSet;
    String[] mNamespaceURLs;
    StructureDefinition mTree;
    private String mRootName;
    private String mRootElemName;
    private String mFirstElemName;
    private long mID;
    private ADFLogger mLogger;
    private static Timer sBuildTimer = Timer.createTimer((Level)Level.FINER, (String)"/oracle/adf/model/adapter/dataformat/XSDHandler", (String)"build", (String)"Building structure definition from schema");

    private /* synthetic */ void $init$() {
        this.mRootBindPath = null;
        this.mRootElemName = null;
        this.mFirstElemName = null;
        this.mID = 0L;
        this.mLogger = AdapterContext.getDefaultContext().getLogger();
    }

    public XSDHandler() {
        this.$init$();
        this.mParser = new SchemaParser();
    }

    public XSDHandler(String string) {
        this();
        this.mRootName = string;
    }

    public void setRootElementName(String string) {
        this.mRootElemName = string;
    }

    public void addSchema(String string) throws AdapterException {
        try {
            this.mParser.addSchema(string);
        }
        catch (Exception exception) {
            throw new AdapterException(exception);
        }
    }

    public void addSchema(URL uRL) throws AdapterException {
        try {
            this.mParser.addSchema(uRL);
        }
        catch (Exception exception) {
            throw new AdapterException(exception);
        }
    }

    public void addSchema(Reader reader) {
        this.mParser.addSchema(reader);
    }

    public void addSchema(InputStream inputStream) {
        this.mParser.addSchema(inputStream);
    }

    public void addSchema(Node node) {
        this.mParser.addSchema(node);
    }

    public void setRootBindingPath(String string) {
        this.mRootBindPath = string;
    }

    public void build() throws AdapterException {
        try {
            try {
                this.mLogger.finer("Start parsing the XML schema.");
                sBuildTimer.start();
                if (this.mXMLSchema == null) {
                    this.mXMLSchema = this.mParser.parse();
                }
                if (this.mNamespaceURLs == null) {
                    this.mNamespaceURLs = this.getAllTargetNS();
                }
                this.mTypesSet = this.buildElementSet();
                this.mTree = this.buildSchemaTree();
                sBuildTimer.stop();
            }
            catch (Exception exception) {
                this.mLogger.warning("Failed to create tree from the XSD provided. Cause: " + exception.toString());
                throw new AdapterException(exception);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            sBuildTimer.cleanup();
            throw throwable;
        }
        sBuildTimer.cleanup();
    }

    public StructureDefinition getSchemaTree() {
        return this.mTree;
    }

    public Object getType(String string, String string2) {
        Map map;
        Object var3_3 = null;
        Utility.ASSERT(this.mTypesSet != null);
        if (this.mTypesSet.containsKey(string) && (map = (Map)this.mTypesSet.get(string)).containsKey(string2)) {
            var3_3 = map.get(string2);
        }
        return var3_3;
    }

    public boolean isElementFormDefault(String string) {
        boolean bl = false;
        SchemaMetadata schemaMetadata = this.mParser.getSchemaMetadata(string);
        if (schemaMetadata != null) {
            bl = schemaMetadata.isElementFormDefault();
        }
        return bl;
    }

    public boolean isAttributeFormDefault(String string) {
        boolean bl = false;
        SchemaMetadata schemaMetadata = this.mParser.getSchemaMetadata(string);
        if (schemaMetadata != null) {
            bl = schemaMetadata.isAttributeFormDefault();
        }
        return bl;
    }

    public String getSchemaProperty(String string, String string2) {
        String string3 = null;
        SchemaMetadata schemaMetadata = this.mParser.getSchemaMetadata(string);
        if (schemaMetadata != null) {
            string3 = schemaMetadata.getProperty(string2);
        }
        return string3;
    }

    public boolean isNamespaceDefined(String string) {
        return this.mTypesSet.containsKey(string);
    }

    public StructureDefinition getStructure(String string, DefinitionContext definitionContext) {
        this.mRootName = string;
        if (this.mTree == null) {
            this.build();
        }
        return this.mTree;
    }

    public List getTopLevelElements() {
        if (this.mXMLSchema == null) {
            try {
                this.mXMLSchema = this.mParser.parse();
            }
            catch (Exception exception) {
                this.mLogger.warning("Failed to create tree from the XSD provided. Cause: " + exception.toString());
                throw new AdapterException(exception);
            }
        }
        Utility.ASSERT(this.mXMLSchema != null);
        if (this.mNamespaceURLs == null) {
            this.mNamespaceURLs = this.getAllTargetNS();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            XMLSchemaNode xMLSchemaNode = this.mXMLSchema.getSchemaByTargetNS(this.mNamespaceURLs[n]);
            XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
            int n2 = 0;
            while (n2 < xSDNodeArray.length) {
                arrayList.add(xSDNodeArray[n2].getName());
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    private String[] getAllTargetNS() {
        Utility.ASSERT(this.mXMLSchema != null);
        String[] stringArray = this.mXMLSchema.getAllTargetNS();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].compareTo("http://www.w3.org/2001/XMLSchema") != 0) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private Map buildElementSet() {
        Utility.ASSERT(this.mXMLSchema != null);
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            XMLSchemaNode xMLSchemaNode = this.mXMLSchema.getSchemaByTargetNS(this.mNamespaceURLs[n]);
            XSDNode[] xSDNodeArray = xMLSchemaNode.getComplexTypeSet();
            XSDNode[] xSDNodeArray2 = xMLSchemaNode.getSimpleTypeSet();
            XSDNode[] xSDNodeArray3 = xMLSchemaNode.getElementSet();
            ArrayList<XSDNode> arrayList = new ArrayList<XSDNode>();
            int n2 = 0;
            while (n2 < xSDNodeArray.length) {
                arrayList.add(xSDNodeArray[n2]);
                ++n2;
            }
            int n3 = 0;
            while (n3 < xSDNodeArray2.length) {
                arrayList.add(xSDNodeArray2[n3]);
                ++n3;
            }
            int n4 = 0;
            while (n4 < xSDNodeArray3.length) {
                arrayList.add(xSDNodeArray3[n4]);
                if (n == 0 && n4 == 0) {
                    this.mFirstElemName = xSDNodeArray3[n4].getName();
                }
                ++n4;
            }
            hashMap.put(this.mNamespaceURLs[n], arrayList.iterator());
            ++n;
        }
        return hashMap;
    }

    private StructureDefinition buildSchemaTree() {
        StructureDef structureDef = new StructureDef(this.mRootName);
        int n = 0;
        Iterator iterator = this.getTopLevelTypes();
        while (iterator.hasNext()) {
            Iterator iterator2 = (Iterator)iterator.next();
            while (iterator2.hasNext()) {
                XSDNode xSDNode = (XSDNode)iterator2.next();
                int n2 = xSDNode.getNodeType();
                String string = Utility.normalizeString(xSDNode.getName());
                this.mLogger.finest(string);
                String string2 = xSDNode.getTargetNS();
                if (n2 == 2) {
                    int n3 = ((XSDSimpleType)xSDNode).getBasicType();
                    AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n3));
                    attributeDef.addProperty("LeafElement_hint", "LeafElement_no_attribute");
                    this.setAttributeProperty((XSDSimpleType)xSDNode, attributeDef);
                    this.addType(string2, string, (Object)attributeDef);
                    this.mLogger.finest("Created a simple type attribute.");
                    continue;
                }
                if (n2 == 1) {
                    String string3 = new SimpleStringBuffer(50).append(this.mRootName).append("_").append(string).toString();
                    StructureDef structureDef2 = new StructureDef(string3, (Definition)structureDef);
                    AccessorDef accessorDef = new AccessorDef(string, (StructureDefinition)structureDef, structureDef2, false);
                    this.resolveComplexType((XSDComplexType)xSDNode, structureDef2);
                    this.addType(string2, string, (Object)accessorDef);
                    this.mLogger.finest("Created an accessor to represent the complex type.");
                    continue;
                }
                if (n2 == 3) {
                    if (this.mRootElemName != null) {
                        if (!this.mRootElemName.equals(xSDNode.getName())) continue;
                        this.resolveTopLevelElements((XSDElement)xSDNode, structureDef);
                        continue;
                    }
                    if (this.mFirstElemName == null || !this.mFirstElemName.equals(xSDNode.getName())) continue;
                    this.resolveTopLevelElements((XSDElement)xSDNode, structureDef);
                    continue;
                }
                if (n2 != 0) continue;
                AccessorDef accessorDef = new AccessorDef("any", (StructureDefinition)structureDef, "org.w3c.dom.Element");
                this.addType(string2, "any", (Object)accessorDef);
                structureDef.addAccessor(accessorDef);
                this.mLogger.finest("Added accessor for the type 'any'.");
            }
            ++n;
        }
        return structureDef;
    }

    private void resolveComplexType(XSDComplexType xSDComplexType, StructureDef structureDef) {
        XSDAttribute[] xSDAttributeArray = xSDComplexType.getAttributeDeclarations();
        int n = 0;
        while (n < xSDAttributeArray.length) {
            String string = Utility.normalizeString(xSDAttributeArray[n].getName());
            XSDSimpleType xSDSimpleType = (XSDSimpleType)xSDAttributeArray[n].getType();
            int n2 = xSDSimpleType.getBasicType();
            AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n2));
            structureDef.addAttribute((AttributeDefinition)attributeDef);
            this.setAttributeProperty(xSDSimpleType, attributeDef);
            XSDAnnotation xSDAnnotation = xSDAttributeArray[n].getAnnotation();
            if (xSDAnnotation != null) {
                attributeDef.addProperty(string, xSDAnnotation.getAttributes());
            }
            ++n;
        }
        XSDNode[] xSDNodeArray = xSDComplexType.getElementSet();
        if (xSDNodeArray == null) {
            return;
        }
        int n3 = 0;
        while (n3 < xSDNodeArray.length) {
            String string = Utility.normalizeString(xSDNodeArray[n3].getName());
            int n4 = xSDNodeArray[n3].getNodeType();
            StructureDef structureDef2 = null;
            if (n4 == 2) {
                int n5 = ((XSDSimpleType)xSDNodeArray[n3]).getBasicType();
                AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n5));
                attributeDef.addProperty("LeafElement_hint", "LeafElement_no_attribute");
                this.setAttributeProperty((XSDSimpleType)xSDNodeArray[n3], attributeDef);
                structureDef.addAttribute((AttributeDefinition)attributeDef);
            } else if (n4 == 3) {
                this.resolveElement((XSDElement)xSDNodeArray[n3], structureDef);
            } else if (n4 == 5) {
                if (string == null && (string = ((XSDGroup)xSDNodeArray[n3]).getRefLocalname()) != null) {
                    String string2 = new SimpleStringBuffer(50).append(this.mRootName).append("_").append(string).toString();
                    structureDef2 = new StructureDef(string2, (Definition)structureDef);
                    AccessorDef accessorDef = new AccessorDef(string, (StructureDefinition)structureDef, structureDef2, false);
                    structureDef2.setParentType(1);
                    this.addType(xSDNodeArray[n3].getTargetNS(), string, (Object)accessorDef);
                    structureDef.addAccessor(accessorDef);
                }
                this.resolveGroup((XSDGroup)xSDNodeArray[n3], structureDef2 == null ? structureDef : structureDef2);
            } else if (n4 == 0) {
                AccessorDef accessorDef = new AccessorDef("any", (StructureDefinition)structureDef, "org.w3c.dom.Element");
                structureDef.addAccessor(accessorDef);
            }
            ++n3;
        }
    }

    private void resolveGroup(XSDGroup xSDGroup, StructureDef structureDef) {
        Vector vector = xSDGroup.getNodeVector();
        int n = 0;
        while (n < vector.size()) {
            XSDNode xSDNode = (XSDNode)vector.elementAt(n);
            int n2 = xSDNode.getNodeType();
            if (n2 == 5) {
                this.resolveGroup((XSDGroup)xSDNode, structureDef);
            } else if (n2 == 3) {
                this.resolveElement((XSDElement)xSDNode, structureDef);
            } else if (n2 == 0) {
                AccessorDef accessorDef = new AccessorDef("any", (StructureDefinition)structureDef, "org.w3c.dom.Element");
                structureDef.addAccessor(accessorDef);
            }
            ++n;
        }
    }

    private void resolveElement(XSDElement xSDElement, StructureDef structureDef) {
        XSDNode xSDNode = xSDElement.getType();
        int n = xSDNode.getNodeType();
        String string = Utility.normalizeString(xSDElement.getName());
        int n2 = xSDElement.getMaxOccurs();
        if (n == 1) {
            Object object = this.getType(xSDElement.getTargetNS(), string);
            AccessorDef accessorDef = null;
            StructureDef structureDef2 = null;
            if (object == null) {
                XSDComplexType xSDComplexType;
                String string2 = new SimpleStringBuffer(50).append(this.mRootName).append("_").append(string).toString();
                structureDef2 = new StructureDef(string2, (Definition)structureDef);
                accessorDef = new AccessorDef(string, (StructureDefinition)structureDef, structureDef2, n2 > 0);
                if (n2 > 0) {
                    accessorDef.setCollectionStructure(FormatHelper.createStandardCollectionOpStructure((NamedDefinition)structureDef));
                }
                if ((xSDComplexType = (XSDComplexType)xSDNode).isSimpleContent()) {
                    String string3 = LEAFELEMENT_DATA;
                    XSDSimpleType xSDSimpleType = xSDComplexType.getSimpleType();
                    int n3 = xSDSimpleType.getBasicType();
                    AttributeDef attributeDef = new AttributeDef(string3, structureDef2, TypeMap.getJavaType(n3));
                    structureDef2.addAttribute((AttributeDefinition)attributeDef);
                    this.setAttributeProperty(xSDSimpleType, attributeDef);
                    accessorDef.addProperty("LeafElement_hint", "LeafElement_with_attribute");
                }
                this.addType(xSDElement.getTargetNS(), string, (Object)accessorDef);
                this.resolveComplexType((XSDComplexType)xSDNode, structureDef2);
            } else {
                accessorDef = (AccessorDef)((Object)object);
                String string4 = new SimpleStringBuffer(50).append(this.mRootName).append("_").append(string).toString();
                structureDef2 = new StructureDef(string4, (Definition)structureDef);
                accessorDef = accessorDef.clone(structureDef, accessorDef.getName());
            }
            structureDef.addAccessor(accessorDef);
            this.setElementProperty(xSDElement, accessorDef);
        } else if (n == 2) {
            int n4 = ((XSDSimpleType)xSDNode).getBasicType();
            AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n4));
            attributeDef.addProperty("LeafElement_hint", "LeafElement_no_attribute");
            structureDef.addAttribute((AttributeDefinition)attributeDef);
            this.setAttributeProperty((XSDSimpleType)xSDNode, attributeDef);
            this.setElementProperty(xSDElement, attributeDef);
        }
    }

    private void resolveTopLevelElements(XSDElement xSDElement, StructureDef structureDef) {
        String string = Utility.normalizeString(xSDElement.getName());
        int n = xSDElement.getMaxOccurs();
        XSDNode xSDNode = xSDElement.getType();
        String string2 = xSDNode.getTargetNS();
        int n2 = xSDNode.getNodeType();
        if (n2 == 1) {
            String string3 = new SimpleStringBuffer(50).append(this.mRootName).append("_").append(string).toString();
            StructureDef structureDef2 = new StructureDef(string3, (Definition)structureDef);
            AccessorDef accessorDef = new AccessorDef(string, (StructureDefinition)structureDef, structureDef2, n > 0);
            if (n > 0) {
                accessorDef.setCollectionStructure(FormatHelper.createStandardCollectionOpStructure((NamedDefinition)structureDef));
            }
            if (this.mRootBindPath != null) {
                accessorDef.setBindPath(new SimpleStringBuffer(50).append(structureDef.getFullName()).append(".").append(this.mRootBindPath).toString());
            }
            structureDef2.setParentType(1);
            this.resolveComplexType((XSDComplexType)xSDNode, structureDef2);
            this.setElementProperty(xSDElement, accessorDef);
            this.addType(string2, string, (Object)accessorDef);
            structureDef.addAccessor(accessorDef);
            this.mLogger.finest("Added accessor for this type to the structure.");
        } else if (n2 == 2) {
            int n3 = ((XSDSimpleType)xSDNode).getBasicType();
            AttributeDef attributeDef = new AttributeDef(string, structureDef, TypeMap.getJavaType(n3));
            attributeDef.addProperty("LeafElement_hint", "LeafElement_no_attribute");
            this.setAttributeProperty((XSDSimpleType)xSDNode, attributeDef);
            this.setElementProperty(xSDElement, attributeDef);
            this.addType(string2, string, (Object)attributeDef);
            structureDef.addAttribute((AttributeDefinition)attributeDef);
            this.mLogger.finest("Added as a leaf element.");
        }
    }

    private void setElementProperty(XSDElement xSDElement, AttributeDef attributeDef) {
        int n = xSDElement.getMinOccurs();
        int n2 = xSDElement.getMaxOccurs();
        boolean bl = xSDElement.isNillable();
        attributeDef.addProperty(MIN_OCCURS, String.valueOf(n));
        attributeDef.addProperty(MAX_OCCURS, String.valueOf(n2));
        attributeDef.addProperty(NILLABLE, String.valueOf(bl));
        attributeDef.addProperty(NAMESPACE, xSDElement.getTargetNS());
    }

    private void setAttributeProperty(XSDSimpleType xSDSimpleType, AttributeDef attributeDef) throws AdapterException {
        HashMap hashMap = new HashMap();
        this.setBaseType(xSDSimpleType, hashMap);
        this.getFacets(xSDSimpleType, hashMap);
        attributeDef.addProperties(hashMap);
    }

    private void setBaseType(XSDSimpleType xSDSimpleType, Map map) throws AdapterException {
        try {
            XSDSimpleType xSDSimpleType2;
            String string = xSDSimpleType.getName();
            Hashtable hashtable = XSDSimpleType.getBuiltInDatatypes();
            if (string == null) {
                xSDSimpleType2 = xSDSimpleType.getBase();
                if (xSDSimpleType2 == null) {
                    xSDSimpleType2 = xSDSimpleType.getItemType();
                }
                string = xSDSimpleType2.getName();
            } else {
                xSDSimpleType2 = xSDSimpleType;
            }
            while (!hashtable.containsKey(string)) {
                XSDSimpleType xSDSimpleType3 = xSDSimpleType2.getBase();
                string = (xSDSimpleType2 = xSDSimpleType3 == null ? xSDSimpleType2.getItemType() : xSDSimpleType3).getName();
                if (string != null) continue;
                string = XSDTypeConstants.STRING;
                break;
            }
            map.put(TYPE, string);
        }
        catch (XSDException xSDException) {
            throw new AdapterException(xSDException);
        }
    }

    private void getFacets(XSDSimpleType xSDSimpleType, Map map) {
        XSDConstrainingFacet[] xSDConstrainingFacetArray = xSDSimpleType.getFacets();
        if (xSDConstrainingFacetArray != null) {
            int n = 0;
            while (n < xSDConstrainingFacetArray.length) {
                if (xSDConstrainingFacetArray[n] != null) {
                    Object object = xSDConstrainingFacetArray[n].getLexicalEnumeration();
                    if (object == null) {
                        object = xSDConstrainingFacetArray[n].getLexicalValue();
                    }
                    if (object != null) {
                        map.put(xSDConstrainingFacetArray[n].getName(), object);
                    }
                }
                ++n;
            }
        }
    }

    private boolean addType(String string, String string2, Object object) {
        boolean bl = false;
        if (this.mTypesSet.containsKey(string)) {
            Map map = (Map)this.mTypesSet.get(string);
            if (!map.containsKey(string2)) {
                map.put(string2, object);
            }
            bl = true;
        }
        return bl;
    }

    private Iterator getTopLevelTypes() {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            Iterator iterator = (Iterator)this.mTypesSet.get(this.mNamespaceURLs[n]);
            arrayList.add(iterator);
            this.mTypesSet.put(this.mNamespaceURLs[n], new HashMap());
            ++n;
        }
        return arrayList.iterator();
    }

    private String getNextID() {
        return "XSD" + String.valueOf(this.mID++);
    }

    public void printTree(StructureDefinition structureDefinition, int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        String string = new String(cArray);
        ArrayListDefinitionContainer arrayListDefinitionContainer = (ArrayListDefinitionContainer)structureDefinition.getAttributeDefinitions();
        int n2 = 0;
        while (n2 < arrayListDefinitionContainer.size()) {
            AttributeDefinition attributeDefinition = (AttributeDefinition)arrayListDefinitionContainer.item(n2);
            System.out.println(string + "  " + attributeDefinition.getName() + ": " + attributeDefinition.getJavaTypeString());
            this.printProperties(((AttributeDef)attributeDefinition).getProperties(), string + "  ");
            ++n2;
        }
        ArrayListDefinitionContainer arrayListDefinitionContainer2 = (ArrayListDefinitionContainer)structureDefinition.getAccessorDefinitions();
        int n3 = 0;
        while (n3 < arrayListDefinitionContainer2.size()) {
            AccessorDef accessorDef = (AccessorDef)arrayListDefinitionContainer2.item(n3);
            StructureDef structureDef = (StructureDef)accessorDef.getStructure();
            if (structureDef == null) {
                System.out.println(string + accessorDef.getName() + ": " + accessorDef.getJavaTypeString());
                this.printProperties(accessorDef.getProperties(), string + "  ");
            } else {
                System.out.println(string + structureDef.getName());
                this.printProperties(accessorDef.getProperties(), string);
                this.printTree(structureDef, n + 2);
            }
            ++n3;
        }
    }

    public void printProperties(Map map, String string) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = map.get(string2);
            if (v instanceof Vector) {
                Iterator iterator2 = ((Vector)v).iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (e instanceof XMLAttr) {
                        System.out.println(string + "  " + string2 + ":" + ((XMLAttr)e).getNodeValue());
                        continue;
                    }
                    System.out.println(string + "  " + string2 + ":" + e);
                }
                continue;
            }
            if (!(v instanceof String)) continue;
            System.out.println(string + "  " + string2 + ":" + v);
        }
    }

    public void printAllTypes() {
        if (this.mNamespaceURLs == null) {
            System.out.println("Object is not initialised. Call getSchemaTree() method.");
            return;
        }
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            Map map = (Map)this.mTypesSet.get(this.mNamespaceURLs[n]);
            Iterator iterator = map.keySet().iterator();
            System.out.println("-----| Namespace |-----" + this.mNamespaceURLs[n]);
            while (iterator.hasNext()) {
                System.out.println("  " + (String)iterator.next());
            }
            ++n;
        }
    }

    public void printSchemaMetadata() {
        if (this.mNamespaceURLs == null) {
            System.out.println("Object is not initialised. Call getSchemaTree() method.");
            return;
        }
        System.out.println("-----| Schema metadata |-----");
        int n = 0;
        while (n < this.mNamespaceURLs.length) {
            System.out.println("Namespace: " + this.mNamespaceURLs[n]);
            System.out.println("  isElementFormDefault: " + this.isElementFormDefault(this.mNamespaceURLs[n]));
            System.out.println("  isAttributeFormDefault: " + this.isAttributeFormDefault(this.mNamespaceURLs[n]));
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            XSDHandler xSDHandler = new XSDHandler("XMLDC1");
            if (stringArray.length < 1) {
                return;
            }
            System.setProperty("http.proxyHost", "www-proxy.us.oracle.com");
            System.setProperty("http.proxyPort", "80");
            int n = 0;
            while (n < stringArray.length) {
                URL uRL = new URL(stringArray[n]);
                InputStream inputStream = uRL.openStream();
                xSDHandler.addSchema(new InputStreamReader(inputStream));
                ++n;
            }
            xSDHandler.build();
            StructureDefinition structureDefinition = xSDHandler.getSchemaTree();
            System.out.println(structureDefinition.getName());
            xSDHandler.printTree(structureDefinition, 0);
            xSDHandler.printAllTypes();
            xSDHandler.printSchemaMetadata();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

