/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCBindingContainerReference;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCDataControlManagement;
import oracle.adf.model.binding.DCDataControlReference;
import oracle.adf.model.binding.DCErrorHandler;
import oracle.adf.share.ADFContext;
import oracle.adf.share.Environment;
import oracle.binding.BindingContainer;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.SessionContext;
import oracle.jbo.common.DefLocaleContext;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.StringManager;
import oracle.jbo.mom.DefinitionObject;
import oracle.jbo.uicli.mom.JUApplicationDefImpl;
import oracle.jbo.uicli.mom.JUMetaObjectManager;

public class BindingContext
implements Map,
Serializable {
    static final long serialVersionUID = 3114329020915398600L;
    public static final String RESERVED_BINDINGS = "bindings";
    public static final String CONTEXT_HELPER = "_dc_hlp_";
    public static final String BINDINGS_HELPER = "_bc_hlp_";
    public static final String CONTEXT_ID = "data";
    public static final String DEFAULT_DATA_CONTROL = "_default_datacontrol_";
    public static final String LOCALE_CONTEXT = "_locale_context_";
    public static final String ERROR_HANDLER = "_error_handler_";
    public static final String MAP_RESOLVER = "_map_resolver_";
    public static final String HTTP_REQUEST = "_http_request_";
    public static final String HTTP_RESPONSE = "_http_response_";
    public static final String INPUT_VALUE_HANDLERS = "_InputValueHandlers_";
    public static final String APPLICATION_DEF = "_def_";
    public static final String IS_INITIALIZED = "_is_initialized_";
    public static byte CLIENT_TYPE_ABSTRACT = 0;
    public static byte CLIENT_TYPE_JCLIENT = 1;
    private byte mClient;
    private HashMap mPersistentStates;
    private transient HashMap mDefaultMap;
    private transient HashMap mDCMap;
    private transient Object[] mDCArray;
    private transient HashMap mBCMap;
    private transient Object[] mBCArray;
    private transient JUApplicationDefImpl mDef;
    private transient SessionContext mSessionContext;

    private /* synthetic */ void $init$() {
        this.mClient = CLIENT_TYPE_ABSTRACT;
        this.mPersistentStates = null;
        this.mSessionContext = null;
    }

    public BindingContext(int n) {
        this.$init$();
        this.initialize(n);
    }

    public BindingContext() {
        this(10);
    }

    public DefinitionObject getDef() {
        if (this.mDef == null) {
            this.initDef();
        }
        return this.mDef;
    }

    private void initialize(int n) {
        if (this.mDefaultMap == null) {
            this.mDefaultMap = new HashMap(n);
        }
        if (this.mDCMap == null) {
            this.mDCMap = new HashMap(n);
        }
        if (this.mBCMap == null) {
            this.mBCMap = new HashMap(n);
        }
    }

    public void setLocaleContext(LocaleContext localeContext) {
        this.put(LOCALE_CONTEXT, localeContext);
    }

    public LocaleContext getLocaleContext() {
        LocaleContext localeContext = (LocaleContext)this.get(LOCALE_CONTEXT);
        if (localeContext == null) {
            localeContext = new DefLocaleContext(StringManager.getDefaultLocale());
            this.setLocaleContext(localeContext);
        }
        return localeContext;
    }

    public void setErrorHandler(DCErrorHandler dCErrorHandler) {
        this.put(ERROR_HANDLER, dCErrorHandler);
    }

    public void setClientAppType(byte by) {
        this.mClient = by;
        if (by == CLIENT_TYPE_JCLIENT) {
            JUMetaObjectManager.getJUMom().setJClientDefFactory(null);
        }
    }

    public boolean isJClientApp() {
        return this.mClient == CLIENT_TYPE_JCLIENT;
    }

    public boolean isGenericApp() {
        return this.mClient == CLIENT_TYPE_ABSTRACT;
    }

    public final DCErrorHandler getErrorHandler() {
        return (DCErrorHandler)this.get(ERROR_HANDLER);
    }

    public final BindingContainer setCurrentBindingsEntry(BindingContainer bindingContainer) {
        BindingContainer bindingContainer2 = (BindingContainer)this.mDefaultMap.get(RESERVED_BINDINGS);
        if (bindingContainer != null) {
            this.mDefaultMap.put(RESERVED_BINDINGS, bindingContainer);
        } else {
            this.mDefaultMap.remove(RESERVED_BINDINGS);
        }
        return bindingContainer2;
    }

    public DCDataControl getDefaultDataControl() {
        Object object = (DCDataControl)this.get(DEFAULT_DATA_CONTROL);
        if (object == null) {
            Object[] objectArray = this.dataControlsArray();
            int n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                if (object instanceof DCDataControlReference) {
                    object = this.get(((DCDataControlReference)object).getName());
                }
                if (object instanceof DCDataControl) break;
                ++n;
            }
        }
        return object;
    }

    public void initializeSessionContext(SessionContext sessionContext) {
        this.mSessionContext = sessionContext;
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.mSessionContext = sessionContext;
        Object[] objectArray = this.dataControlsArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof DCDataControl) {
                ((DCDataControl)objectArray[n]).setSessionContext(sessionContext);
            }
            ++n;
        }
    }

    public SessionContext getSessionContext() {
        return this.mSessionContext;
    }

    public void release() {
        Object[] objectArray = this.dataControlsArray();
        int n = 0;
        while (n < objectArray.length) {
            ((DCDataControlManagement)objectArray[n]).release();
            ++n;
        }
        Object[] objectArray2 = this.bindingContainersArray();
        int n2 = 0;
        while (n2 < objectArray2.length) {
            if (objectArray2[n2] instanceof DCBindingContainer) {
                ((DCBindingContainer)objectArray2[n2]).release();
            }
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.mClient);
        objectOutputStream.writeObject(this.mPersistentStates);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initialize(10);
        this.mClient = objectInputStream.readByte();
        this.mPersistentStates = (HashMap)objectInputStream.readObject();
    }

    public DCDataControl findDataControl(String string) {
        return (DCDataControl)this.get(string);
    }

    public DCBindingContainer findBindingContainer(String string) {
        return (DCBindingContainer)this.get(string);
    }

    public Serializable findPersistentState(String string) {
        Serializable serializable = null;
        if (this.mPersistentStates != null) {
            serializable = (Serializable)this.mPersistentStates.get(string);
        }
        return serializable;
    }

    public void addPersistentState(String string, Serializable serializable) {
        if (this.mPersistentStates == null) {
            this.mPersistentStates = new HashMap(5);
        }
        this.mPersistentStates.put(string, serializable);
    }

    public void removePersistentState(String string) {
        if (this.mPersistentStates != null) {
            this.mPersistentStates.remove(string);
        }
    }

    public Iterator valuesIterator() {
        HashMap hashMap = (HashMap)this.mDefaultMap.clone();
        return hashMap.values().iterator();
    }

    public Iterator dataControlsIterator() {
        HashMap hashMap = (HashMap)this.mDCMap.clone();
        return hashMap.values().iterator();
    }

    public Iterator bindingContainersIterator() {
        HashMap hashMap = (HashMap)this.mBCMap.clone();
        return hashMap.values().iterator();
    }

    private Object[] dataControlsArray() {
        if (this.mDCArray == null) {
            this.mDCArray = this.mDCMap.values().toArray();
        }
        return this.mDCArray;
    }

    private Object[] bindingContainersArray() {
        if (this.mBCArray == null) {
            this.mBCArray = this.mBCMap.values().toArray();
        }
        return this.mBCArray;
    }

    public Iterator keysIterator() {
        HashMap hashMap = (HashMap)this.mDefaultMap.clone();
        return hashMap.keySet().iterator();
    }

    public int size() {
        return this.mDefaultMap.size();
    }

    public boolean isEmpty() {
        return this.mDefaultMap.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this.mDefaultMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mDefaultMap.containsValue(object);
    }

    public Object get(Object object) {
        if (CONTEXT_ID.equals(object)) {
            return this;
        }
        if (HTTP_REQUEST.equals(object)) {
            return ADFContext.getCurrent().getEnvironment().getRequest();
        }
        Object object2 = this.mDCMap.get(object);
        if (object2 != null) {
            block12: {
                if (object2 instanceof DCDataControlReference) {
                    Object object3 = this.remove(object);
                    try {
                        object2 = ((DCDataControlReference)object2).getDataControl(this);
                        this.put(object, object2);
                        object3 = null;
                        Object var6_4 = null;
                        if (object3 == null) break block12;
                        this.put(object, object3);
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        if (object3 != null) {
                            this.put(object, object3);
                        }
                        throw throwable;
                    }
                    {
                    }
                }
            }
            return object2;
        }
        object2 = this.mBCMap.get(object);
        if (object2 != null) {
            block13: {
                if (object2 instanceof DCBindingContainerReference) {
                    Object object4 = this.remove(object);
                    try {
                        object2 = ((DCBindingContainerReference)object2).getBindingContainer();
                        this.put(object, object2);
                        object4 = null;
                        Object var8_8 = null;
                        if (object4 == null) break block13;
                        this.put(object, object4);
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (object4 != null) {
                            this.put(object, object4);
                        }
                        throw throwable;
                    }
                    {
                    }
                }
            }
            return object2;
        }
        object2 = this.mDefaultMap.get(object);
        return object2;
    }

    public Object put(Object object, Object object2) {
        if (object2 instanceof DCDataControl || object2 instanceof DCDataControlReference) {
            DCDataControl dCDataControl;
            this.mDCMap.put(object, object2);
            this.mDCArray = null;
            if (object2 instanceof DCDataControl && (dCDataControl = (DCDataControl)object2).getBindingContext() != this) {
                dCDataControl.setBindingContext(this);
            }
        } else if (object2 instanceof DCBindingContainer || object2 instanceof DCBindingContainerReference) {
            this.mBCMap.put(object, object2);
            this.mBCArray = null;
        }
        return this.mDefaultMap.put(object, object2);
    }

    public Object remove(Object object) {
        this.mBCMap.remove(object);
        this.mBCArray = null;
        this.mDCMap.remove(object);
        this.mDCArray = null;
        return this.mDefaultMap.remove(object);
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        Object k = iterator.next();
        while (k != null) {
            this.put(k, map.get(k));
            k = iterator.next();
        }
    }

    public void clear() {
        this.mDCMap.clear();
        this.mDCArray = null;
        this.mBCMap.clear();
        this.mBCArray = null;
        this.mDefaultMap.clear();
    }

    public Set keySet() {
        return this.mDefaultMap.keySet();
    }

    public Collection values() {
        return this.mDefaultMap.values();
    }

    public Set entrySet() {
        return this.mDefaultMap.entrySet();
    }

    public Object getBindingInputHandler(String string) {
        Map map = (Map)this.get(INPUT_VALUE_HANDLERS);
        if (map != null) {
            Object object = map.get(string);
            if (object instanceof String) {
                try {
                    Class clazz = JBOClass.forName((String)((String)object));
                    object = JBOClass.newInstance((Class)clazz);
                    map.put(string, object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new JboException((Throwable)classNotFoundException);
                }
            }
            return object;
        }
        return null;
    }

    public void setBindingInputHandlers(Map map) {
        HashMap hashMap = (HashMap)this.get(INPUT_VALUE_HANDLERS);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.put(INPUT_VALUE_HANDLERS, hashMap);
        }
        hashMap.putAll(map);
    }

    void initDef() {
        if (this.mDef == null && this.mDefaultMap != null && this.mDefaultMap.containsKey(APPLICATION_DEF)) {
            this.mDef = (JUApplicationDefImpl)((Object)this.mDefaultMap.get(APPLICATION_DEF));
        }
    }

    public DCBindingContainer findBindingContainerByPath(String string) {
        String string2;
        if (this.mDef == null) {
            this.initDef();
        }
        if (this.mDef != null && (string2 = this.mDef.findBindingContainerIdByPath(string, this)) != null) {
            return this.findBindingContainer(string2);
        }
        return null;
    }

    public String findBindingContainerIdByPath(String string) {
        if (this.mDef == null) {
            this.initDef();
        }
        return this.mDef != null ? this.mDef.findBindingContainerIdByPath(string, this) : null;
    }

    void beginRequest(ADFContext aDFContext, HashMap hashMap) {
        Environment environment = aDFContext.getEnvironment();
        this.setLocaleContext((LocaleContext)new DefLocaleContext(environment.getRequestLocale()));
        Object[] objectArray = this.dataControlsArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof DCDataControl) {
                ((DCDataControl)objectArray[n]).setSessionContext(this.mSessionContext);
            }
            ++n;
        }
        Object[] objectArray2 = this.bindingContainersArray();
        int n2 = 0;
        while (n2 < objectArray2.length) {
            if (objectArray2[n2] instanceof DCBindingContainer) {
                ((DCBindingContainer)objectArray2[n2]).resetInputState();
            }
            ++n2;
        }
        objectArray = this.dataControlsArray();
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] instanceof DCDataControlManagement) {
                ((DCDataControlManagement)objectArray[n3]).beginRequest(hashMap);
            }
            ++n3;
        }
    }

    void endRequest(ADFContext aDFContext, HashMap hashMap) {
        Object[] objectArray = this.dataControlsArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof DCDataControlManagement) {
                ((DCDataControlManagement)objectArray[n]).endRequest(hashMap);
            }
            ++n;
        }
    }
}

