/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.SQLException;
import sqlj.runtime.profile.ref.Flushable;
import sqlj.runtime.profile.ref.ObjectPool;

public class LRUObjectPool
implements ObjectPool {
    private int m_maxSize;
    private int m_curSize;
    private LRUNode m_head;

    public LRUObjectPool(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(n + "");
        }
        this.m_maxSize = n;
        this.m_curSize = 0;
        this.m_head = new LRUNode(true);
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    public void setMaxSize(int n) throws SQLException {
        if (n < 0) {
            throw new IllegalArgumentException(n + "");
        }
        this.m_maxSize = n;
        this.checkSize();
    }

    public int getSize() {
        return this.m_curSize;
    }

    public Object createKey() {
        return new LRUNode();
    }

    public void addEntry(Object object, Flushable flushable) throws SQLException {
        LRUNode lRUNode = (LRUNode)object;
        lRUNode.setFlushable(flushable);
        ++this.m_curSize;
        this.m_head.addAsNext(lRUNode);
        this.checkSize();
    }

    private void checkSize() throws SQLException {
        SQLException sQLException = null;
        while (this.m_curSize > this.m_maxSize) {
            try {
                this.flushEntry();
            }
            catch (SQLException sQLException2) {
                if (sQLException == null) {
                    sQLException = sQLException2;
                    continue;
                }
                sQLException2.setNextException(sQLException2);
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
    }

    public Flushable flushEntry() throws SQLException {
        if (this.m_curSize > 0) {
            --this.m_curSize;
            LRUNode lRUNode = this.m_head.getPrevious();
            Flushable flushable = lRUNode.removeFromList();
            flushable.flush(lRUNode);
            return flushable;
        }
        return null;
    }

    public Flushable removeEntry(Object object) {
        --this.m_curSize;
        return ((LRUNode)object).removeFromList();
    }

    private static class LRUNode {
        private LRUNode m_next;
        private LRUNode m_prev;
        private Flushable m_flushable;

        LRUNode() {
        }

        LRUNode(boolean bl) {
            if (bl) {
                this.m_next = this.m_prev = this;
            }
        }

        Flushable removeFromList() {
            if (this.m_flushable != null) {
                this.m_next.m_prev = this.m_prev;
                this.m_prev.m_next = this.m_next;
                Flushable flushable = this.m_flushable;
                this.m_flushable = null;
                return flushable;
            }
            return null;
        }

        void addAsNext(LRUNode lRUNode) {
            lRUNode.m_next = this.m_next;
            lRUNode.m_prev = this;
            this.m_next.m_prev = lRUNode;
            this.m_next = lRUNode;
        }

        LRUNode getPrevious() {
            return this.m_prev;
        }

        void setFlushable(Flushable flushable) {
            if (this.m_flushable != null) {
                throw new IllegalArgumentException();
            }
            this.m_flushable = flushable;
        }
    }
}

