/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.sql.BLOB;
import oracle.sqlj.runtime.OraRTResultSet;
import oracle.sqlj.runtime.OraRTStatement;
import oracle.sqlj.runtime.OraTypeClosure;
import oracle.sqlj.runtime.OraTypeInfo;
import oracle.sqlj.runtime.error.OraCustomizationErrors;

public class OraSerializableClosure
implements OraTypeClosure {
    private boolean m_blobsStreamable = false;

    OraSerializableClosure(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            int n = databaseMetaData.getDriverMajorVersion();
            int n2 = databaseMetaData.getDriverMinorVersion();
            this.m_blobsStreamable = n > 8 || n == 8 && n2 > 0;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Object getObject(OraRTResultSet oraRTResultSet, int n, Class clazz, OraTypeInfo oraTypeInfo) throws SQLException {
        int n2 = oraTypeInfo.getSQLType();
        if (n2 == -2) {
            byte[] byArray = oraRTResultSet.getOracleResultSet().getBytes(n);
            if (byArray == null) {
                return null;
            }
            return this.stream2Object(new ByteArrayInputStream(byArray));
        }
        if (n2 == 2004) {
            BLOB bLOB = oraRTResultSet.getOracleResultSet().getBLOB(n);
            return bLOB == null ? null : this.stream2Object(bLOB.getBinaryStream());
        }
        OraCustomizationErrors.raise_INVALID_SQL_SERIALIZATION_TYPE(n2);
        return null;
    }

    public Object getObject(OraRTStatement oraRTStatement, int n, Class clazz, OraTypeInfo oraTypeInfo) throws SQLException {
        int n2 = oraTypeInfo.getSQLType();
        if (n2 == -2) {
            byte[] byArray = oraRTStatement.getOracleCallableStatement().getBytes(n);
            return byArray == null ? null : this.stream2Object(new ByteArrayInputStream(byArray));
        }
        if (n2 == 2004) {
            BLOB bLOB = oraRTStatement.getOracleCallableStatement().getBLOB(n);
            return bLOB == null ? null : this.stream2Object(bLOB.getBinaryStream());
        }
        OraCustomizationErrors.raise_INVALID_SQL_SERIALIZATION_TYPE(n2);
        return null;
    }

    public void registerParameter(OraRTStatement oraRTStatement, int n, OraTypeInfo oraTypeInfo) throws SQLException {
        oraRTStatement.getRTCallableStatement().registerOutParameter(n, oraTypeInfo.getSQLType());
    }

    public void setObject(OraRTStatement oraRTStatement, int n, Object object, OraTypeInfo oraTypeInfo) throws SQLException {
        int n2 = oraTypeInfo.getSQLType();
        if (n2 == -2) {
            byte[] byArray = this.object2Bytes(object);
            if (byArray == null) {
                oraRTStatement.getOraclePreparedStatement().setNull(n, -2);
            } else {
                oraRTStatement.getOraclePreparedStatement().setBytes(n, byArray);
            }
        } else if (n2 == 2004) {
            if (object == null) {
                oraRTStatement.getOraclePreparedStatement().setNull(n, 2004);
            } else if (this.m_blobsStreamable) {
                byte[] byArray = this.object2Bytes(object);
                oraRTStatement.getOraclePreparedStatement().setBinaryStream(n, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            } else {
                OraCustomizationErrors.raise_NO_BLOB_STREAMING();
            }
        } else {
            OraCustomizationErrors.raise_INVALID_SQL_SERIALIZATION_TYPE(n2);
        }
    }

    private Object stream2Object(InputStream inputStream) throws SQLException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    private byte[] object2Bytes(Object object) throws SQLException {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }
}

