/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.quadros;

import br.gov.rs.tce.adf.util.DataBindingHelper;
import br.gov.rs.tce.adf.util.TCETable;
import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.ContasRemessaBean;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.QuadroContas;
import br.gov.rs.tce.pad.beans.TelaPopup;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.modelo.action.ActionModeloPopup;
import br.gov.rs.tce.pad.modelo.action.ActionModeloPopupSelecao;
import br.gov.rs.tce.pad.modelo.action.ActionTrataPopupSelecao;
import br.gov.rs.tce.pad.modelo.action.PopupSelecaoAction;
import br.gov.rs.tce.pad.modelo.servico.ContasModuleImpl;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.panel.quadros.TelaQuadroComum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.AttributeDef;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUCtrlRangeBinding;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.jui.JUTableBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PopupSelecaoContas
extends JDialog {
    private static final Log log = LogFactory.getLog(PopupSelecaoContas.class);
    public static final int ID_EVENTO_ATUALIZA_QUADRO_CONTAS = 1;
    public static final String CMD_ATUALIZA_QUADRO_CONTAS = "atualizaContas";
    private JPanel pnlRodape = new JPanel();
    private BorderLayout layoutFrame = new BorderLayout();
    private JScrollPane spTabela = new JScrollPane();
    private TCETable tblListagem = new TCETable();
    private JButton btnOk = new JButton();
    private JButton btnCancelar = new JButton();
    private BindingContext _bindingContext;
    private JUPanelBinding _panelBinding;
    private PopupSelecaoAction acaoAtualizaContas;
    private Integer _tipoConta;
    private Integer _cdPlanilha;
    private boolean _selecaoMultipla;
    private String _tableBindingControlName;
    private String _formatoCodigoConta;
    private ActionListener _atualizaQuadroContasListener;
    private static final Object[][] TAMANHO_COLUNAS = new Object[][]{{"Estado", 24}, {"CdConta", 135}, {"CdUnidade", 58}, {"DsConta", 194}, {"Valor", 94}};
    public static final String POPUP_SELECAO_ITER = "PopupSelecaoIterator";
    public static final String FORMATO_CODIGO_CONTA_PADRAO = "00000000000000000000";
    public static final String PARAM_CODIGO_CONTA_PROPERTY = "formato-codigo-conta";
    public static final String PARAM_ACTION_MODELO_POPUP_SELECAO = "action-modelo-popup";

    public PopupSelecaoContas(JFrame owner) {
        super((Frame)owner, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }
        });
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(575, 350));
        this.setMinimumSize(new Dimension(510, 300));
        this.getContentPane().setLayout(this.layoutFrame);
        this.pnlRodape.setSize(new Dimension(556, 20));
        this.pnlRodape.setPreferredSize(new Dimension(10, 30));
        this.tblListagem.setAutoResizeMode(4);
        this.btnOk.setText("Ok");
        this.btnOk.setMnemonic('O');
        this.btnOk.setToolTipText("Confirmar sele\u00e7\u00e3o de conta(s).");
        this.btnOk.setPreferredSize(new Dimension(65, 23));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupSelecaoContas.this.btnOk_actionPerformed(e);
            }
        });
        this.btnCancelar.setText("Fechar");
        this.btnCancelar.setMnemonic('F');
        this.btnCancelar.setToolTipText("Sair da tela cancelando as altera\u00e7\u00f5es.");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupSelecaoContas.this.btnCancelar_actionPerformed(e);
            }
        });
        this.pnlRodape.add((Component)this.btnOk, null);
        this.pnlRodape.add((Component)this.btnCancelar, null);
        this.getContentPane().add((Component)this.pnlRodape, "South");
        this.spTabela.getViewport().add((Component)this.tblListagem, null);
        this.getContentPane().add((Component)this.spTabela, "Center");
        this.tblListagem.setModel((TableModel)this._panelBinding.bindUIControl("PopupSelecaoView", (Object)this.tblListagem));
        this.inicializaPropriedadesTela();
    }

    private void inicializaPropriedadesTela() {
        this.tblListagem.getTableHeader().setReorderingAllowed(false);
        TableModel mdl = this.tblListagem.getModel();
        TableColumnModel modeloColunasTotal = this.tblListagem.getColumnModel();
        for (int i = 0; i < modeloColunasTotal.getColumnCount(); ++i) {
            TableColumn coluna = modeloColunasTotal.getColumn(i);
            coluna.setResizable(false);
        }
        PopupSelecaoContas.inicializaTableRenderers(this.tblListagem, this._formatoCodigoConta, this._tableBindingControlName, this._panelBinding);
    }

    private void preparaBindingContext(BindingContext bindCtx) {
        this._bindingContext = bindCtx;
        if (this._panelBinding.getPanel() == null) {
            this._panelBinding = this._panelBinding.setup(bindCtx, (Object)this);
            this._panelBinding.refreshControl();
            try {
                this.jbInit();
                this._panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this._panelBinding.reportException((Throwable)ex);
            }
        }
    }

    public void initializaDataBindings(BindingContext bindCtx, String nomeViewObject, String[] colunas, Integer tipoConta, Integer cdPlanilha, boolean selecaoMultipla, ActionListener listenerAtualizaContas) {
        if (bindCtx == null) {
            throw new IllegalArgumentException("BindingContext n\u00e3o pode ser nulo");
        }
        if (nomeViewObject == null) {
            throw new IllegalArgumentException("Nome do viewObject n\u00e3o pode ser nulo.");
        }
        if (tipoConta == null) {
            throw new IllegalArgumentException("O tipo de conta n\u00e3o pode ser nulo");
        }
        this._tipoConta = tipoConta;
        this._cdPlanilha = cdPlanilha;
        this._panelBinding = new JUPanelBinding();
        this._selecaoMultipla = selecaoMultipla;
        this._bindingContext = bindCtx;
        this._atualizaQuadroContasListener = listenerAtualizaContas;
        DCIteratorBinding iter = DataBindingHelper.adicionaIteratorBinding(bindCtx, this._panelBinding, POPUP_SELECAO_ITER, "ContasModuleDataControl", "PopupSelecaoView");
        JUTableBinding dcControl = DataBindingHelper.adicionaTableBinding(this._bindingContext, this._panelBinding, "PopupSelecaoView", colunas, iter.getName());
        this._tableBindingControlName = dcControl.getName();
        this.preparaBindingContext(bindCtx);
    }

    static void removeControlBinding(DCBindingContainer bc, String name) {
        DCControlBinding binding = bc.findCtrlBinding(name);
        if (binding != null) {
            binding.getDCIteratorBinding().removeValueBinding(binding);
            bc.removeControlBinding(binding);
        }
    }

    private static void addDynamicRangeBinding(DCBindingContainer bc, String bindingName, String iterName) {
        JUCtrlRangeBinding dynamicRangeBinding = new JUCtrlRangeBinding(null, bc.findIteratorBinding(iterName), null);
        bc.addControlBinding(bindingName, (DCControlBinding)dynamicRangeBinding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnOk_actionPerformed(ActionEvent e) {
        try {
            Row linha;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.finalizaBindings();
            LinkedList<ContasRemessaBean> listaContas = new LinkedList<ContasRemessaBean>();
            ViewObject voPopup = DatacontrolHelper.getContasModuleAppModule(this._bindingContext).findViewObject("PopupSelecaoView");
            log.info((Object)("btnOk_actionPerformed: voPopup: PopupSelecaoView / " + voPopup.getClass().getName()));
            if (!this._selecaoMultipla) {
                linha = voPopup.getCurrentRow();
                Key chaveLinhaSelecionada = linha.getKey();
                if (((Boolean)linha.getAttribute("EstadoInicial")).equals(Boolean.TRUE)) {
                    return;
                }
                linha = voPopup.first();
                while (linha != null) {
                    if (((Boolean)linha.getAttribute("EstadoInicial")).equals(Boolean.TRUE) && chaveLinhaSelecionada.equals((Object)linha.getKey())) {
                        listaContas.add(this.criaContasRemessaBean(linha, "N", this._cdPlanilha));
                    }
                    linha = voPopup.next();
                }
                listaContas.add(this.criaContasRemessaBean(voPopup.getRow(chaveLinhaSelecionada), "S", this._cdPlanilha));
            } else {
                linha = voPopup.first();
                while (linha != null) {
                    Boolean marcada = (Boolean)linha.getAttribute("Estado");
                    Boolean marcadaInicial = (Boolean)linha.getAttribute("EstadoInicial");
                    if (marcada.booleanValue() != marcadaInicial.booleanValue()) {
                        String status = null;
                        if (marcadaInicial.booleanValue() && !marcada.booleanValue()) {
                            log.info((Object)("- btnOk[N]: linha: " + linha + " / marcadaInicial=" + marcadaInicial + " ; marcada=" + marcada));
                            status = "N";
                        } else if (!marcadaInicial.booleanValue() && marcada.booleanValue()) {
                            log.info((Object)("- btnOk[S]: linha: " + linha + " / marcadaInicial=" + marcadaInicial + " ; marcada=" + marcada));
                            status = "S";
                        }
                        listaContas.add(this.criaContasRemessaBean(linha, status, this._cdPlanilha));
                    }
                    linha = voPopup.next();
                }
            }
            if (this.acaoAtualizaContas != null && listaContas.size() > 0) {
                log.info((Object)("btnOk_actionPerformed: acaoAtualizaContas=" + this.acaoAtualizaContas.getClass().getName() + " lista=" + listaContas));
                this.acaoAtualizaContas.atualizaContas(listaContas);
                this._atualizaQuadroContasListener.actionPerformed(new ActionEvent(this, 1, CMD_ATUALIZA_QUADRO_CONTAS));
            }
            DCDataControl dc = this._bindingContext.findDataControl("ContasModuleDataControl");
            ContasModuleImpl ser = (ContasModuleImpl)dc.getDataProvider();
            ser.getTransaction().commit();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dispose();
        }
    }

    private ContasRemessaBean criaContasRemessaBean(Row linha, String status, Integer cdPlanilha) {
        ContasRemessaBean crBean = new ContasRemessaBean();
        crBean.setTipo(this._tipoConta);
        crBean.setCdPlanilha(cdPlanilha);
        crBean.setCdRecurso((BigDecimal)(linha.getAttribute("CdRecurso") == null ? new BigDecimal(0) : linha.getAttribute("CdRecurso")));
        crBean.setConta((BigDecimal)linha.getAttribute("CdConta"));
        crBean.setUnidade((String)linha.getAttribute("CdUnidade"));
        crBean.setDescricao((String)linha.getAttribute("DsConta"));
        crBean.setStatus(status);
        crBean.setVlrContabil((BigDecimal)linha.getAttribute("Valor"));
        return crBean;
    }

    private void finalizaBindings() {
        this._panelBinding.release(DCDataControl.REL_VIEW_REFS);
        this._bindingContext.remove((Object)this._panelBinding.getName());
        this._panelBinding.release();
    }

    private void btnCancelar_actionPerformed(ActionEvent e) {
        this.finalizaBindings();
        this.dispose();
    }

    public void setAcaoAtualizaContas(PopupSelecaoAction acaoAtualizaContas) {
        this.acaoAtualizaContas = acaoAtualizaContas;
    }

    public static final void exibePopupSelecaoContas(Integer tipoConta, String tituloPopup, boolean selecaoMultipla, ConsultaSQL consultaOrigem, String[] colunas, ActionListener listenerEventoPopup, BindingContext ctx, Component parent, Integer cdPlanilha, IdentificadorConta identificadorConta) {
        TelaPopup telaPopup = new TelaPopup();
        telaPopup.setSelecaoMultipla(selecaoMultipla);
        telaPopup.setTitulo(tituloPopup);
        telaPopup.setColunasQuadro(colunas);
        PopupSelecaoContas.exibePopupSelecaoContas(tipoConta, telaPopup, consultaOrigem, listenerEventoPopup, ctx, parent, cdPlanilha, identificadorConta);
    }

    public static final void exibePopupSelecaoContas(QuadroContas quadroContas, Remessa remessa, TipoBancoDados tpBanco, BindingContext ctx, ActionListener listenerEventoPopup, Component parent, Integer cdPlanilha, IdentificadorConta identificadorConta) {
        TelaPopup telaPopup = quadroContas.getTelaPopup();
        ConsultaSQL consultaPopup = null;
        try {
            consultaPopup = telaPopup.recuperaSQLDadosPopup(remessa, tpBanco);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (consultaPopup == null) {
            consultaPopup = quadroContas.recuperaSQLInsereContasRemessa(remessa, tpBanco);
        }
        Parametro paramFormatoCdConta = quadroContas.getParametroPorNome(PARAM_CODIGO_CONTA_PROPERTY);
        String formatoCdConta = null;
        formatoCdConta = paramFormatoCdConta != null ? paramFormatoCdConta.getValor() : FORMATO_CODIGO_CONTA_PADRAO;
        PopupSelecaoContas.exibePopupSelecaoContas(quadroContas.getTipoConta(), telaPopup, consultaPopup, listenerEventoPopup, ctx, parent, cdPlanilha, identificadorConta, formatoCdConta);
    }

    public static final void exibePopupSelecaoContas(Integer tipoConta, TelaPopup telaPopup, ConsultaSQL consultaOrigem, ActionListener listenerEventoPopup, BindingContext ctx, Component parent, Integer cdPlanilha, IdentificadorConta identificadorConta) {
        PopupSelecaoContas.exibePopupSelecaoContas(tipoConta, telaPopup, consultaOrigem, listenerEventoPopup, ctx, parent, cdPlanilha, identificadorConta, FORMATO_CODIGO_CONTA_PADRAO);
    }

    public static final void exibePopupSelecaoContas(Integer tipoConta, TelaPopup telaPopup, ConsultaSQL consultaOrigem, ActionListener listenerEventoPopup, BindingContext ctx, Component parent, Integer cdPlanilha, IdentificadorConta identificadorConta, String formatoCodigoConta) {
        JFrame frame = TelaQuadroComum.findJFrameParent(parent);
        PopupSelecaoContas popup = new PopupSelecaoContas(frame);
        String paramPopupSelecao = telaPopup.getParametroPorNome(PARAM_ACTION_MODELO_POPUP_SELECAO);
        ActionModeloPopup actionPopup = null;
        try {
            actionPopup = (ActionModeloPopup)Class.forName(paramPopupSelecao).newInstance();
        }
        catch (Exception e) {
            log.info((Object)"Classe modelo pop-up n\u00e3o localizada, abrindo default: ActionModeloPopupSelecao");
            actionPopup = new ActionModeloPopupSelecao();
        }
        log.info((Object)("Abrindo pop-up com consulta: " + consultaOrigem.getCodigo()));
        popup.setFormatoCodigoConta(formatoCodigoConta);
        actionPopup.preparaModelo(tipoConta, identificadorConta, telaPopup, consultaOrigem, ctx);
        String tituloPopup = telaPopup.getTitulo();
        popup.setTitle(tituloPopup == null ? "Sele\u00e7\u00e3o de contas" : tituloPopup);
        String[] colunas = telaPopup.getColunasQuadro();
        if (telaPopup.isSelecaoMultipla()) {
            String[] colunasNova = new String[colunas.length + 1];
            colunasNova[0] = "Estado";
            System.arraycopy(colunas, 0, colunasNova, 1, colunas.length);
            colunas = colunasNova;
        }
        popup.initializaDataBindings(ctx, "PopupSelecaoView", colunas, tipoConta, cdPlanilha, telaPopup.isSelecaoMultipla(), listenerEventoPopup);
        popup.setLocationRelativeTo(frame);
        popup.setAcaoAtualizaContas(new ActionTrataPopupSelecao(listenerEventoPopup, identificadorConta, ctx));
        popup.ajustaTamanhoColunas(colunas);
        popup.show();
    }

    private void ajustaTamanhoColunas(String[] colunas) {
        int countCol = this.tblListagem.getColumnModel().getColumnCount();
        block0: for (int i = 0; i < countCol; ++i) {
            TableColumn coluna = this.tblListagem.getColumnModel().getColumn(i);
            for (int j = 0; j < TAMANHO_COLUNAS.length; ++j) {
                Object[] tamanho = TAMANHO_COLUNAS[j];
                if (!tamanho[0].equals(colunas[i])) continue;
                coluna.setPreferredWidth((Integer)tamanho[1]);
                continue block0;
            }
        }
    }

    private static void inicializaTableRenderers(JTable tabela, String formatoCodigoConta, String nomeTableCtrlBinding, JUPanelBinding panelBinding) {
        if (tabela == null) {
            return;
        }
        if (panelBinding == null) {
            throw new IllegalArgumentException("PanelBinding n\u00e3o pode ser nulo");
        }
        JUControlBinding ctrBinding = panelBinding.findControlBinding(nomeTableCtrlBinding);
        if (ctrBinding == null) {
            throw new IllegalArgumentException("N\u00e3o foi possivel localizar o Controlbinding: " + nomeTableCtrlBinding);
        }
        AttributeDef[] defs = ((JUCtrlValueBinding)ctrBinding).getAttributeDefs();
        for (int i = 0; i < defs.length; ++i) {
            Class type = defs[i].getJavaType();
            DefaultTableCellRenderer renderer = null;
            if ("CdConta".equals(defs[i].getName())) {
                TableColumn coluna = tabela.getColumnModel().getColumn(i);
                coluna.setCellRenderer(PopupSelecaoContas.criaTableCellRendererCdConta(formatoCodigoConta.length()));
                continue;
            }
            if (!Number.class.isAssignableFrom(type)) continue;
            renderer = TelaQuadroComum.NUMERO_ALINHADO_DIR_RENDERER_HABILITADO;
            tabela.getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
    }

    private static DefaultTableCellRenderer criaTableCellRendererCdConta(final int qtdDigitos) {
        DefaultTableCellRenderer cdContaRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                if (value != null) {
                    String newValue = value.toString();
                    super.setValue(newValue.substring(newValue.length() - qtdDigitos, newValue.length()));
                } else {
                    super.setValue(null);
                }
            }

            public boolean isCellEditable(EventObject eo) {
                return false;
            }
        };
        cdContaRenderer.setHorizontalAlignment(4);
        return cdContaRenderer;
    }

    public void setFormatoCodigoConta(String formatoCodigoConta) {
        this._formatoCodigoConta = formatoCodigoConta;
    }
}

