/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.ConstantesArquivos;
import br.gov.rs.tce.pad.modelo.RemessaControle;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import br.gov.rs.tce.pad.util.CopiaArquivoEvent;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaFinalizacao;
import br.gov.rs.tce.pad.visao.panel.TelaUC100;
import br.gov.rs.tce.pad.visao.panel.TelaUC205;
import br.gov.rs.tce.ws.responsaveis.client.ResponsaveisWSClient;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.ws.WebServiceException;
import oracle.adf.model.BindingContext;

public class ActionAvancarUC205
extends PadAbstractAction {
    private String resposta = null;
    private int sequencia = 1;

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        boolean retorno = false;
        TelaUC205 t = (TelaUC205)tela;
        if (!tela.validaTela()) {
            return false;
        }
        if (!this.testaConexaoInternet()) {
            this.exibeMensagemWarning("N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o TCE. Favor verifique sua conex\u00e3o com a internet. Caso o erro persista, entre em contato com o TCE.");
            return false;
        }
        if (!t.getAvancar()) {
            this.resposta = t.getArquivo();
            if (this.resposta != null) {
                ServicoPAD ser = ActionAvancarUC205.getServicoPADAppModule(binding);
                File f = null;
                f = new File(this.resposta);
                RemessaControle ctrl = new RemessaControle(new Remessa(), new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP));
                PadWizardForm form = PadWizardHelper.getInstance().getForm();
                NotificaEventos notifica = null;
                RemessaInfo remInfo = null;
                try {
                    this.setSequencia(1);
                    notifica = new NotificaEventos(form);
                    remInfo = ctrl.recuperaArquivosRemessa(f, notifica);
                }
                catch (Exception e) {
                    log.error((Object)"erro ao recuperar arquivo de remessa", (Throwable)e);
                    ActionAvancarUC205.exibeMensagemAviso("Ocorreu um problema na recupera\u00e7\u00e3o do arquivo de remessa.", form);
                    return false;
                }
                if (remInfo == null) {
                    return false;
                }
                ser.limpaRemessa();
                Remessa remessaPrincipal = DatacontrolHelper.getRemessaSemAnoBiDataControl(binding);
                remessaPrincipal.setCdEntidade(remInfo.getCodigoEntidade());
                remessaPrincipal.setCdRemessa(remInfo.getCodigoRemessa());
                remessaPrincipal.setRemessaInfo(remInfo);
                remessaPrincipal.setDataFinal(remInfo.getDataFinalRemessa());
                try {
                    ser.insereRemessa(remInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new PADActionException(e.getMessage(), e);
                }
                retorno = false;
                t.setAvancar(true);
                TelaFinalizacao.setCdOrgao(remInfo.getCodigoEntidade());
                TelaFinalizacao.setAnoExercicio(remInfo.getAnoExercicio());
            }
        } else {
            retorno = true;
        }
        return retorno;
    }

    private void exibeMensagemWarning(String mensagem) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        JOptionPane.showMessageDialog(form, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    private boolean testaConexaoInternet() {
        try {
            ResponsaveisWSClient.initalize();
        }
        catch (WebServiceException e) {
            return false;
        }
        return true;
    }

    public void setSequencia(int sequencia) {
        this.sequencia = sequencia;
    }

    public int getSequencia() {
        return this.sequencia;
    }

    class NotificaEventos
    implements ChangeListener {
        Component _form;

        NotificaEventos(Component form) {
            this._form = form;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            CopiaArquivoEvent copia = (CopiaArquivoEvent)event;
            CompactacaoHelper comp = (CompactacaoHelper)event.getSource();
            switch (copia.getSituacao()) {
                case -5: {
                    JOptionPane.showMessageDialog(this._form, "Arquivo de remessa n\u00e3o \u00e9 valido. Insira o arquivo com a Remessa e ap\u00f3s clique em \"Avan\u00e7ar\".", "Informa\u00e7\u00e3o", 0);
                    comp.setSituacao(false);
                    break;
                }
                case -3: {
                    ActionAvancarUC205.this.setSequencia(ActionAvancarUC205.this.getSequencia() + 1);
                    File f = null;
                    f = ActionAvancarUC205.this.getSequencia() >= 10 ? new File(ActionAvancarUC205.this.resposta.substring(0, ActionAvancarUC205.this.resposta.length() - 2) + ActionAvancarUC205.this.getSequencia()) : new File(ActionAvancarUC205.this.resposta.substring(0, ActionAvancarUC205.this.resposta.length() - 2) + "0" + ActionAvancarUC205.this.getSequencia());
                    if (f.exists()) {
                        comp.setSituacao(true);
                        ActionAvancarUC205.this.resposta = f.getAbsolutePath();
                        TelaUC100 tela = new TelaUC100();
                        tela.setArquivo(ActionAvancarUC205.this.resposta);
                        break;
                    }
                    if (ActionAvancarUC205.this.resposta.startsWith("C")) {
                        JOptionPane.showMessageDialog(this._form, "Sequencia de arquivo de remessa n\u00e3o localizado no caminho informado. \n\rVoc\u00ea deve colocar todos os arquivos da remessa da entidade no mesmo diret\u00f3rio.", "Informa\u00e7\u00e3o", 0);
                        comp.setSituacao(false);
                        break;
                    }
                    comp.setSituacao(JOptionPane.showConfirmDialog(this._form, copia.getMensagem(), "Informa\u00e7\u00e3o", 2) == 0);
                    break;
                }
                case -7: {
                    JOptionPane.showConfirmDialog(this._form, "Disquete ou Cd n\u00e3o localizados. Favor inserir midia.", "Informa\u00e7\u00e3o", 2);
                    comp.setSituacao(false);
                }
            }
        }
    }
}

