/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import br.gov.rs.tce.pad.util.CopiaArquivoEvent;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC103;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;

public class ActionAvancarUC103
extends PadAbstractAction {
    private ProgressBarBoundedRangeModel _modelProgressArquivo = null;
    private BindingContext _binding;
    private TelaUC103 _tela;

    public ActionAvancarUC103() {
        this.setCriaThreadTratamentoAcao(true);
    }

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        System.out.println("Action Avan\u00e7ar da TelaUC103 executada...");
        ServicoPAD ser = ActionAvancarUC103.getServicoPADAppModule(binding);
        boolean retorno = true;
        this._tela = (TelaUC103)tela;
        Remessa rem = this.getRemessaPrincipal(binding);
        this._binding = binding;
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        retorno = false;
        ActionAvancarUC103.exibeMensagemAviso("Voc\u00ea deve selecionar a unidade de disquetes para a grava\u00e7\u00e3o dos arquivos de informa\u00e7\u00f5es.", form);
        this._tela.acaoBanner(false);
        this._tela.setStatusBotoes(true);
        if (this._tela.isBackup() && retorno && this.verificaPeriodo(rem) && ser.existeIndiretasConsolidacao()) {
            ActionAvancarUC103.exibeMensagemAviso("Lembre-se de realizar a consolida\u00e7\u00e3o", this._tela);
        }
        return retorno;
    }

    private boolean verificaPeriodo(Remessa remessa) {
        String tpEntrega = remessa.getTipoEntrega() == null ? "" : remessa.getTipoEntrega();
        int periodo = remessa.getPeriodoInformacoes();
        boolean retorno = false;
        if (tpEntrega.equals("S") && (periodo == 3 || periodo == 6)) {
            retorno = true;
        }
        if (tpEntrega.equals("Q") && (periodo == 2 || periodo == 4 || periodo == 6)) {
            retorno = true;
        }
        return retorno;
    }

    private boolean exibeMensagemConfirmacao(String mensagem) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        return JOptionPane.showConfirmDialog(form, mensagem, "Aten\u00e7\u00e3o", 2) == 0;
    }

    public class ProgressBarBoundedRangeModel
    extends DefaultBoundedRangeModel
    implements ChangeListener {
        private String labelEtiqueta = "";
        private BindingContext binding = null;

        ProgressBarBoundedRangeModel() {
            this.setMaximum(100);
            this.setValue(0);
        }

        @Override
        public void stateChanged(final ChangeEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CopiaArquivoEvent copia = (CopiaArquivoEvent)event;
                    CompactacaoHelper comp = (CompactacaoHelper)event.getSource();
                    switch (copia.getSituacao()) {
                        case -3: {
                            if (ActionAvancarUC103.this.exibeMensagemConfirmacao(copia.getMensagem())) break;
                            comp.setSituacao(false);
                            break;
                        }
                        case -4: {
                            if (copia.getArquivoAtual() == copia.getTotalArquivos()) break;
                            ProgressBarBoundedRangeModel.this.fireEmiteEtiqueta();
                            break;
                        }
                        default: {
                            ProgressBarBoundedRangeModel.this.setValue(copia.getSituacao());
                        }
                    }
                }
            });
        }

        public void fireEmiteEtiqueta() {
            this.fireEmiteEtiqueta(true);
        }

        public void fireEmiteEtiqueta(boolean isDisquete) {
        }

        public void setLabelEtiqueta(String label) {
            this.labelEtiqueta = label;
        }

        public String getLabelEtiqueta() {
            return this.labelEtiqueta;
        }

        public void setBindingContext(BindingContext binding) {
            this.binding = binding;
        }
    }
}

