/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC060;
import java.sql.Date;
import java.text.MessageFormat;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC060
extends PadAbstractAction {
    private static final String MENSAGEM_VALIDACAO = "A data da publica\u00e7\u00e3o em {0} no {1} {2} n\u00e3o pode ser inferior a data de fechamento do {2} e tamb\u00e9m n\u00e3o pode superar a data de preenchimento em mais de sessenta dias.";

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        ServicoPAD ser = ActionAvancarUC060.getServicoPADAppModule(binding);
        ViewObject vo = ser.findViewObject("TabelaDePublicacoesDaRemessaView");
        Row row = vo.first();
        Date primeiroSMural = null;
        Date primeiroSJornal = null;
        Date primeiroSInter = null;
        Date segundoSMural = null;
        Date segundoSJornal = null;
        Date segundoSInter = null;
        Date primeiroQMural = null;
        Date primeiroQJornal = null;
        Date primeiroQInter = null;
        Date segundoQMural = null;
        Date segundoQJornal = null;
        Date segundoQInter = null;
        Date terceiroQMural = null;
        Date terceiroQJornal = null;
        Date terceiroQInter = null;
        if (row != null) {
            primeiroSMural = (Date)row.getAttribute("Primeirosmura");
            primeiroSJornal = (Date)row.getAttribute("Primeirosjorn");
            primeiroSInter = (Date)row.getAttribute("Primeirosinte");
            segundoSMural = (Date)row.getAttribute("Segundosmura");
            segundoSJornal = (Date)row.getAttribute("Segundosjorn");
            segundoSInter = (Date)row.getAttribute("Segundosinte");
            primeiroQMural = (Date)row.getAttribute("Primeiroqmura");
            primeiroQJornal = (Date)row.getAttribute("Primeiroqjorn");
            primeiroQInter = (Date)row.getAttribute("Primeiroqinte");
            segundoQMural = (Date)row.getAttribute("Segundoqmura");
            segundoQJornal = (Date)row.getAttribute("Segundoqjorn");
            segundoQInter = (Date)row.getAttribute("Segundoqinte");
            terceiroQMural = (Date)row.getAttribute("Terceiroqmura");
            terceiroQJornal = (Date)row.getAttribute("Terceiroqjorn");
            terceiroQInter = (Date)row.getAttribute("Terceiroqinte");
        }
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        Remessa remessa = ActionAvancarUC060.getRemessaDataControl(binding);
        TelaUC060 tela60 = (TelaUC060)tela;
        int anoExercicio = remessa.getAnoExercicio();
        if (tela60.verificaDataInformada()) {
            ActionAvancarUC060.exibeMensagemAviso("Se a data de publica\u00e7\u00e3o n\u00e3o for informada, \u00e9 preciso desabilitar o campo correspondente!.", form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(primeiroSMural, 3, anoExercicio, "S")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "primeiro", "semestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(primeiroSJornal, 3, anoExercicio, "S")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "primeiro", "semestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(primeiroSInter, 3, anoExercicio, "S")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "primeiro", "semestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(segundoSMural, 6, anoExercicio, "S")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "segundo", "semestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(segundoSJornal, 6, anoExercicio, "S")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "segundo", "semestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(segundoSInter, 6, anoExercicio, "S")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "segundo", "semestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(primeiroQMural, 2, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "primeiro", "quadrimestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(primeiroQJornal, 2, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "primeiro", "quadrimestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(primeiroQInter, 2, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "primeiro", "quadrimestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(segundoQMural, 4, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "segundo", "quadrimestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(segundoQJornal, 4, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "segundo", "quadrimestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(segundoQInter, 4, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "segundo", "quadrimestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(terceiroQMural, 6, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "terceiro", "quadrimestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(terceiroQJornal, 6, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "terceiro", "quadrimestre"), form);
            return false;
        }
        if (!ActionAvancarUC060.validaDataPeriodo(terceiroQInter, 6, anoExercicio, "Q")) {
            ActionAvancarUC060.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "terceiro", "quadrimestre"), form);
            return false;
        }
        System.out.println("Action Avan\u00e7ar da TelaUC060 executada...");
        return true;
    }

    public static boolean validaDataPeriodo(Date dataPublicacao, int periodo, int anoExercicio, String tipoPeriodo) {
        boolean retorno = false;
        Date dataMaxima = null;
        Date dataHoje = new Date(System.currentTimeMillis());
        if (dataPublicacao == null) {
            retorno = true;
        } else {
            dataMaxima = ActionAvancarUC060.getDataPeriodo(periodo, anoExercicio, tipoPeriodo);
            float diffDiasPublicacaoHoje = (dataPublicacao.getTime() - dataHoje.getTime()) / 86400000L;
            if (dataMaxima.getTime() - dataPublicacao.getTime() < 0L && diffDiasPublicacaoHoje < 60.0f) {
                retorno = true;
            }
        }
        return retorno;
    }

    private static Date getDataPeriodo(int periodo, int anoExercicio, String tipoPeriodo) {
        Date retorno = null;
        if (tipoPeriodo.equals("S")) {
            retorno = periodo < 4 ? Date.valueOf(anoExercicio + "-06-30") : Date.valueOf(anoExercicio + "-12-31");
        } else {
            switch (periodo) {
                case 1: 
                case 2: {
                    retorno = Date.valueOf(anoExercicio + "-04-30");
                    break;
                }
                case 3: 
                case 4: {
                    retorno = Date.valueOf(anoExercicio + "-08-31");
                    break;
                }
                case 5: 
                case 6: {
                    retorno = Date.valueOf(anoExercicio + "-12-31");
                }
            }
        }
        return retorno;
    }
}

