/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.commons.sql.ClausulaWhere;
import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.MesList;
import br.gov.rs.tce.pad.excecao.FormatoInvalidoException;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.ContasModuleImpl;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DateUtils;
import br.gov.rs.tce.pad.util.PropertiesUtil;
import br.gov.rs.tce.pad.util.ValidaCNPJ;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaFinalizacao;
import br.gov.rs.tce.pad.visao.panel.TelaUC039;
import br.gov.rs.tce.pad.visao.panel.TelaUC041;
import br.gov.rs.tce.pad.visao.panel.TelaUC041A;
import br.gov.rs.tce.pad.visao.panel.TelaUC060;
import br.gov.rs.tce.pad.visao.panel.TelaUC060B;
import br.gov.rs.tce.pad.visao.panel.TelaUC201;
import br.gov.rs.tce.ws.validacao.client.Recebimento;
import br.gov.rs.tce.ws.validacao.client.SiapcLicitaconClient;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionAvancarUC039
extends PadAbstractAction {
    private static Log log = LogFactory.getLog(ActionAvancarUC039.class);

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        boolean consSiapc;
        Recebimento rec;
        System.setProperty("user.timezone", "America/Sao_Paulo");
        String geraErro = PropertiesUtil.carregaProperty("pad.geraErroUC039");
        if (geraErro != null) {
            ServicoPADImpl.erroProposital("Erro na ActionAvancarUC039");
        }
        TelaUC039 _tela = (TelaUC039)tela;
        Remessa remessa = ActionAvancarUC039.getRemessaSemAnoBiDataControl(binding);
        boolean resposta = true;
        boolean possuiCamaraIntegrada = false;
        boolean deletarLinhas = false;
        if (!this.validaCNPJ(_tela)) {
            return false;
        }
        if (!_tela.validaCampos(remessa.getTipoSetor())) {
            return false;
        }
        ServicoPAD ser = ActionAvancarUC039.getServicoPADAppModule(binding);
        ViewObject voRemessa = ser.findViewObject("RemessasDaEntidade");
        Row remessaRow = voRemessa.getCurrentRow();
        remessaRow.setAttribute("CamaraIntegrada", (Object)"N");
        log.info((Object)("[PAD_MENSAL=true] PeriodoInformacoes = " + remessaRow.getAttribute("PeriodoInformacoes")));
        MesList ml = _tela.getMesSelecionado();
        log.info((Object)("mes-selecionado: " + (Object)((Object)ml) + " / " + ml.name() + " / " + ml.getMes()));
        remessaRow.setAttribute("PeriodoInformacoes", (Object)ml.getBimestre());
        remessaRow.setAttribute("Mes", (Object)ml.getMes());
        ActionAvancarUC039.atualizaCNPJ(_tela.getCnpjEntidade(), binding, remessa);
        if (remessa != null) {
            int periodoAnterior = remessa.getPeriodoInformacoes();
            int anoExercicioAnterior = remessa.getAnoExercicio();
            int anoExercicioAtual = _tela.getAnoExercicio();
            remessa.setPeriodoInformacoes((Integer)remessaRow.getAttribute("PeriodoInformacoes"));
            remessa.setMes((int)((Integer)remessaRow.getAttribute("Mes")));
            remessa.setTipoOperacao(1);
            if (periodoAnterior != remessa.getPeriodoInformacoes() || anoExercicioAnterior != anoExercicioAtual) {
                ser.limpaDadosMudancaPeriodo();
                remessa.setCargaArquivosSelecaoEfetuada(false);
                remessaRow.setAttribute("SituacaoCarga", (Object)0);
            }
            remessaRow.setAttribute("DtFinalCompl", null);
        }
        if (_tela.getAnoExercicio() != 0) {
            Integer ano = _tela.getAnoExercicio();
            if (ano.intValue() != remessa.getAnoExercicio()) {
                ser.limpaDadosMudancaPeriodo();
            }
            remessaRow.setAttribute("AnoExercicio", (Object)ano);
            remessa.setAnoExercicio(ano);
            remessa.setCnpjEntidade(_tela.getCnpjEntidade());
        }
        Row entidadeRow = (Row)remessaRow.getAttribute("EntidadesView");
        Integer cdEntidade = null;
        if (entidadeRow != null) {
            cdEntidade = (Integer)entidadeRow.getAttribute("CdEntidade");
            String tipoEntidade = (String)entidadeRow.getAttribute("TipoSetorGov");
            Integer cdEntidadeOriginal = remessa.getCdEntidade();
            String tipoEntidadeOriginal = remessa.getTipoSetor();
            if (cdEntidadeOriginal != null && cdEntidadeOriginal.intValue() != cdEntidade.intValue()) {
                deletarLinhas = true;
            }
            if (tipoEntidadeOriginal != null && !tipoEntidadeOriginal.equals(tipoEntidade)) {
                deletarLinhas = true;
            }
            if (deletarLinhas) {
                resposta = _tela.limpaTabelasCadastros();
                if (resposta) {
                    TelaUC041._habilitarTelaUC041 = 1;
                    TelaUC041A._habilitarTelaUC041A = 1;
                    TelaUC060._habilitarTelaUC060 = 1;
                    TelaUC060B._habilitarTelaUC060B = 1;
                    TelaUC201._habilitarTelaUC201 = 1;
                    voRemessa.first();
                    voRemessa.previous();
                    Object[] valores = new Object[voRemessa.getAttributeCount()];
                    while (voRemessa.hasNext()) {
                        Row linha = voRemessa.next();
                        linha.setAttribute("ObsFinais", (Object)"");
                        linha.setAttribute("ManifestacaoConclusiva", (Object)"");
                        String principal = (String)linha.getAttribute("RemessaPrincipal");
                        if (principal != null && principal.equals("S")) {
                            for (int i = 0; i < linha.getAttributeCount(); ++i) {
                                valores[i] = linha.getAttribute(i);
                            }
                        }
                        linha.remove();
                    }
                    this.salvaDadosRemessa(binding);
                    Row rowNova = voRemessa.createRow();
                    for (int i = 0; i < valores.length; ++i) {
                        Object value;
                        if (voRemessa.getAttributeDef(i).getUpdateableFlag() != 2 || (value = valores[i]) == null) continue;
                        rowNova.setAttribute(i, valores[i]);
                    }
                    remessa.setCargaArquivosSelecaoEfetuada(false);
                    rowNova.setAttribute("SituacaoCarga", (Object)0);
                    rowNova.setAttribute("CamaraIntegrada", (Object)(possuiCamaraIntegrada ? "S" : "N"));
                    voRemessa.insertRow(rowNova);
                } else {
                    remessa.setCdEntidade(cdEntidadeOriginal);
                    remessa.setTipoSetor(tipoEntidadeOriginal);
                }
            }
        }
        if (resposta) {
            remessa.setCdEntidade(cdEntidade);
            ser.atualizaCampoRemessa("VersaoPad", "25.1.1.0");
            this.salvaDadosRemessa(binding);
            ser.limpaDadosConsolidacao();
            if (remessa.getTipoSetor().equals("P")) {
                String respPer025 = null;
                respPer025 = possuiCamaraIntegrada ? "S" : "N";
                ActionAvancarUC039.getServicoPADAppModule(binding).insereRespostaRemessa(ActionAvancarUC039.getRemessaDataControl(binding), String.valueOf(25), respPer025, null, true);
            }
            if (remessa.getTipoSetor().equals("P") && remessa.isPossuiCamaraIntegrada()) {
                ViewObject voEntidades = ser.findViewObject("TodasEntidadesView");
                voEntidades.setWhereClause("(TIPO_SETOR_GOV = ? AND CD_ENTIDADE_PAI = ?)");
                voEntidades.setWhereClauseParam(0, (Object)"C");
                voEntidades.setWhereClauseParam(1, (Object)remessa.getCdEntidade());
                voEntidades.executeQuery();
                if (voEntidades.first() == null) {
                    ActionAvancarUC039.exibeMensagemAviso("A camara integrada desta prefeitura n\u00e3o consta na base de dados. Entrar em contato com o Tribunal de Contas do Estado.", _tela);
                    return false;
                }
            }
            if (deletarLinhas) {
                ser.removePublicacoesRemessa(remessa, null, true);
                ser.removeConsorcios(remessa, null, true);
            }
            ser.removePublicacoesRemessa(remessa, this.criaFiltroRemovePublicacaoAntiga(ser, remessa), true);
            ser.removeAdministradoresRemessa(remessa, this.criaFiltroRemoveAdministradoresAntigos(ser, remessa), true);
            ser.removeSubstituicoesAnosAnteriores();
            if (deletarLinhas || TelaUC039.limpaTabelasArquivos == 1) {
                PadWizardForm form = PadWizardHelper.getInstance().getForm();
                form.defineCursor(3);
                ActionAvancarUC039.exibeMensagemAviso("O PAD ir\u00e1 limpar as tabelas de arquivos, esse processo poder\u00e1 demorar alguns minutos.", _tela);
                form.defineCursor(3);
                ser.limpaTabelasArquivos(remessa.isCargaArquivosSelecaoEfetuada());
                TelaUC039.limpaTabelasArquivos = 0;
            }
        }
        Boolean condicaoAdversa = !this.validaBanco(binding) || _tela.validaResponsaveis();
        if (resposta && condicaoAdversa.booleanValue()) {
            TelaUC039.removeResponsaveis(binding);
            RemessasViewRowImpl remessasViewRow = _tela.getRemessasViewRow();
            if (!TelaUC039.consultaResponsaveis(binding, remessasViewRow)) {
                return false;
            }
            this.salvaDadosRemessa(binding);
        }
        if ((rec = SiapcLicitaconClient.selectDadosUltimoRecebimento(remessa.getCdEntidade(), DatabaseHelper.getConnection(ser))) != null) {
            log.info((Object)("Recebimento: ano=" + rec.getAnoRecebimento() + " ; cd_recebimento = " + rec.getCdRecebimento() + " ; atual = " + rec.getAtual()));
        } else {
            log.info((Object)"Recebimento eh null");
        }
        if (_tela.alteradoOrgaoOuAno() || _tela.reconsultarSiapcLicitacon || rec == null) {
            consSiapc = TelaUC039.consultaSiapcLicitacon(binding);
            if (!consSiapc) {
                return false;
            }
            _tela.reconsultarSiapcLicitacon = false;
        } else {
            consSiapc = TelaUC039.consultaLicitacon(binding);
            if (!consSiapc) {
                return false;
            }
        }
        DCDataControl dc = binding.findDataControl("ContasModuleDataControl");
        ContasModuleImpl contas = (ContasModuleImpl)dc.getDataProvider();
        try {
            contas.setAnoBiGrupoContas(contas.createAnoBiGrupoContas());
            this.salvaDadosRemessa(binding);
        }
        catch (Exception e) {
            ActionAvancarUC039.exibeMensagemErro("Ano e bimestre n\u00e3o localizados na tabela de contas desta vers\u00e3o do PAD.", _tela);
            return false;
        }
        TelaFinalizacao.setEscolhido(this.getRemessasViewRowImpl(binding).getEscolhidoPre());
        TelaFinalizacao.setCdOrgao(this.getRemessasViewRowImpl(binding).getCdEntidade().intValue());
        TelaFinalizacao.setAnoExercicio(this.getRemessasViewRowImpl(binding).getAnoExercicio());
        return resposta;
    }

    private boolean validaBanco(BindingContext binding) {
        ServicoPADImpl ser = (ServicoPADImpl)ActionAvancarUC039.getServicoPADAppModule(binding);
        ViewObject voResponsaveis = ser.findViewObject("Responsaveis");
        ViewObject voSubstituicoes = ser.findViewObject("SubstituicoesView");
        return voResponsaveis.getRowCount() != 0 || voSubstituicoes.getRowCount() != 0;
    }

    private RemessasViewRowImpl getRemessasViewRowImpl(BindingContext binding) {
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ViewObject voRemCam = ser.findViewObject("RemessasDaEntidade");
        RemessasViewRowImpl remViewRow = (RemessasViewRowImpl)voRemCam.getCurrentRow();
        return remViewRow;
    }

    public ClausulaWhere criaFiltroRemovePublicacaoAntiga(ServicoPAD servico, Remessa remessa) {
        TipoBancoDados tpDB = DatabaseHelper.recuperaTipoBancoDados(servico);
        ClausulaWhere whereTotal = new ClausulaWhere("", "AND", tpDB);
        ClausulaWhere whereParcial = new ClausulaWhere("", "OR", tpDB);
        ClausulaWhere whereTpPublicacao = new ClausulaWhere("", "AND", tpDB);
        whereTpPublicacao.addCondicaoString("TP_PUBLICACAO", "T", "!=");
        ClausulaWhere whereBi = new ClausulaWhere("", "AND", tpDB);
        whereBi.addCondicaoComparacaoData("DT_PUBLICACAO", DateUtils.getUltimoDataMes(remessa.getAnoExercicio() - 1, 11), " < ");
        whereBi.addCondicaoString("TP_PERIODO", "B", " = ");
        ClausulaWhere whereBi_A = new ClausulaWhere("", "AND", tpDB);
        whereBi_A.addCondicaoComparacaoData("DT_PUBLICACAO", DateUtils.getUltimoDataMes(remessa.getAnoExercicio() - 1, 11), " < ");
        whereBi_A.addCondicaoString("TP_PERIODO", "Q", " = ");
        whereBi_A.addCondicaoString("TP_PUBLICACAO", "A", " = ");
        ClausulaWhere whereQua = new ClausulaWhere("", "AND", tpDB);
        whereQua.addCondicaoNumerica("PERIODO", Math.abs(remessa.getPeriodoInformacoes() * 2 / 4), " > ");
        whereQua.addCondicaoString("TP_PERIODO", "Q", " = ");
        ClausulaWhere whereSem = new ClausulaWhere("", "AND", tpDB);
        whereSem.addCondicaoNumerica("PERIODO", Math.abs(remessa.getPeriodoInformacoes() * 2 / 6), " > ");
        whereSem.addCondicaoString("TP_PERIODO", "S", " = ");
        whereParcial.addInnerWhereClause(whereBi);
        whereParcial.addInnerWhereClause(whereBi_A);
        whereParcial.addInnerWhereClause(whereQua);
        whereParcial.addInnerWhereClause(whereSem);
        whereTotal.addInnerWhereClause(whereTpPublicacao);
        whereTotal.addInnerWhereClause(whereParcial);
        return whereTotal;
    }

    public ClausulaWhere criaFiltroRemoveAdministradoresAntigos(ServicoPAD servico, Remessa remessa) {
        TipoBancoDados tpDB = DatabaseHelper.recuperaTipoBancoDados(servico);
        ClausulaWhere whereTotal = new ClausulaWhere("", "OR", tpDB);
        ClausulaWhere whereA = new ClausulaWhere("", "AND", tpDB);
        whereA.addCondicaoComparacaoData("DT_TERMINO", DateUtils.getUltimoDataMes(remessa.getAnoExercicio() - 1, 11), " <= ");
        whereTotal.addInnerWhereClause(whereA);
        return whereTotal;
    }

    private boolean validaCNPJ(TelaUC039 _tela) {
        boolean retorno = true;
        try {
            if (_tela.getCnpjEntidade().equals("")) {
                ActionAvancarUC039.exibeMensagemAviso("O CNPJ precisa ser informado.", _tela);
                retorno = false;
            } else if (!ValidaCNPJ.validaCnpj(_tela.getCnpjEntidade())) {
                ActionAvancarUC039.exibeMensagemAviso("O CNPJ informado \u00e9 inv\u00e1lido.", _tela);
                retorno = false;
            }
        }
        catch (FormatoInvalidoException e) {
            retorno = false;
            e.printStackTrace();
            ActionAvancarUC039.exibeMensagemAviso("O CNPJ informado \u00e9 inv\u00e1lido.", _tela);
            return retorno;
        }
        return retorno;
    }

    static void atualizaCNPJ(String cnpj, BindingContext binding, Remessa remessa) {
        ServicoPAD servico = ActionAvancarUC039.getServicoPADAppModule(binding);
        ViewObject voRemessaTmp = servico.findViewObject("RemessasDaEntidade");
        Row remessaRowTmp = voRemessaTmp.getCurrentRow();
        Row entidadeRowTmp = (Row)remessaRowTmp.getAttribute("EntidadesView");
        Integer cdEntidadeTmp = (Integer)entidadeRowTmp.getAttribute("CdEntidade");
        while (cnpj.length() < 14) {
            cnpj = "0" + cnpj;
        }
        servico.atualizaCNPJEntidade(cdEntidadeTmp.toString(), cnpj);
        log.info((Object)("atualizaCNPJ: cnpj: " + cnpj));
        remessa.setCnpjEntidade(cnpj);
    }

    static Integer getMesFromPeriodoInformacoes(Row remessaRow) {
        Object o = remessaRow.getAttribute("PeriodoInformacoes");
        if (o instanceof Integer) {
            return (Integer)o * 2;
        }
        log.warn((Object)("PeriodoInformacoes not an Integer: " + o));
        return null;
    }
}

