/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.util.ValidaPadraoNumerico;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.panel.CusteioBean;
import br.gov.rs.tce.pad.visao.panel.CusteioNavigationBar;
import br.gov.rs.tce.pad.visao.panel.CusteioNavigationModel;
import br.gov.rs.tce.pad.visao.panel.CusteioTableModel;
import br.gov.rs.tce.pad.visao.panel.TelaUC228BVariousListener;
import br.gov.rs.tce.pad.visao.swing.DecimalInputVerifier;
import br.gov.rs.tce.pad.visao.swing.NumberCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.jui.JUPanelBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC228B
extends JPanel
implements JUPanel,
PadModelo {
    private static final long serialVersionUID = 1L;
    static final String PATTERN_CODIGO_ND = "#.#.##.##.##";
    static final Log log = LogFactory.getLog(TelaUC228B.class);
    private final JPanel pnlSul = new JPanel();
    private CusteioNavigationBar navBar;
    static final ValidaPadraoNumerico validaCodigoND = new ValidaPadraoNumerico("#.#.##.##.##", 8);
    static final int CAMPOS_DESCRICAO_MAXLEN = 500;
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC216UIModel");
    private final JPanel dataPanel = new JPanel();
    private final BorderLayout borderLayout = new BorderLayout();
    private final GridLayout gridLayout = new GridLayout();
    private final JTable tableCusteio = new JTable();
    private final CusteioTableModel tableCusteioModel = new CusteioTableModel();
    private final JScrollPane scroller = new JScrollPane();
    public static final NumberFormat nf = NumberFormat.getNumberInstance(DecimalInputVerifier.ptBR);

    private void jbInit() throws Exception {
        this.dataPanel.setLayout(this.gridLayout);
        this.dataPanel.setMinimumSize(new Dimension(100, 100));
        this.dataPanel.setBounds(new Rectangle(0, 100, 620, 200));
        this.dataPanel.setPreferredSize(new Dimension(620, 120));
        this.setLayout(this.borderLayout);
        this.setBounds(new Rectangle(0, 0, 620, 320));
        this.tableCusteio.setModel(this.tableCusteioModel);
        this.scroller.setSize(new Dimension(620, 200));
        this.scroller.setPreferredSize(new Dimension(620, 120));
        this.navBar = new CusteioNavigationBar(this);
        this.navBar.setFloatable(false);
        this.navBar.setHasExecuteButton(false);
        this.navBar.setHasFindButton(false);
        this.scroller.getViewport().add((Component)this.tableCusteio, null);
        this.dataPanel.add(this.scroller);
        this.add((Component)this.dataPanel, "Center");
        this.pnlSul.add((Component)((Object)this.navBar), null);
        this.add((Component)this.pnlSul, "South");
        this.navBar.setModel(new CusteioNavigationModel(this.tableCusteioModel));
        this.navBar.setHasNavigationButtons(false);
        this.navBar.setHasTransactionButtons(false);
        this.preparaColunasTabela();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    private void preparaColunasTabela() {
        TableColumnModel mdl = this.tableCusteio.getColumnModel();
        NumberCellRenderer dtcrRight = new NumberCellRenderer(nf);
        mdl.getColumn(0).setHeaderValue("CNPJ");
        mdl.getColumn(0).setPreferredWidth(110);
        mdl.getColumn(1).setHeaderValue("\u00d3rg\u00e3o");
        mdl.getColumn(1).setPreferredWidth(250);
        mdl.getColumn(2).setHeaderValue("C\u00f3digo ND");
        mdl.getColumn(2).setPreferredWidth(100);
        mdl.getColumn(3).setHeaderValue("Valor");
        mdl.getColumn(3).setPreferredWidth(100);
        mdl.getColumn(3).setCellRenderer(dtcrRight);
        TelaUC228BVariousListener thelistener = new TelaUC228BVariousListener(this);
        this.tableCusteio.addPropertyChangeListener(thelistener);
        this.tableCusteio.addMouseListener(thelistener);
        DefaultCellEditor cellEditorDesabilitado = this.getDisabledCellEditor();
        for (int i = 0; i < mdl.getColumnCount(); ++i) {
            mdl.getColumn(i).setCellEditor(cellEditorDesabilitado);
        }
        MouseListener[] listeners = this.tableCusteio.getTableHeader().getMouseListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.tableCusteio.getTableHeader().removeMouseListener(listeners[i]);
        }
        this.tableCusteio.getTableHeader().setReorderingAllowed(false);
        this.tableCusteio.getTableHeader().setResizingAllowed(false);
        this.tableCusteio.grabFocus();
    }

    private DefaultCellEditor getDisabledCellEditor() {
        JTextField tf = new JTextField();
        tf.setEditable(false);
        return new DefaultCellEditor(tf);
    }

    @Override
    public void preparaTela() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        this.navBar.selectedRow = null;
        this.navBar.refreshButtons();
        this.tableCusteioModel.removeAll();
        ViewObject voj = ser.findViewObject("JustificativasDaRemessa");
        voj.executeQuery();
        log.info((Object)("voj.rc = " + voj.getRowCount() + " ; voj.rcir = " + voj.getRowCountInRange() + " ; voj.getAttributeCount() = " + voj.getAttributeCount()));
        int i = -1;
        int beanId = -1;
        CusteioBean cb = null;
        while (voj.hasNext()) {
            Row r = voj.next();
            int cdPlanilha = (Integer)r.getAttribute("CdPlanilha");
            beanId = cdPlanilha / 10;
            log.info((Object)("[" + i + "]: cdPlanilha = " + cdPlanilha + " ; beanId = " + beanId));
            if (beanId > i) {
                if (cb == null) {
                    log.warn((Object)("add null CusteioBean!?! beanId=" + beanId + "/" + i));
                } else {
                    log.info((Object)("add CusteioBean, beanId=" + beanId + "/" + i + "/" + cb));
                    this.tableCusteioModel.add(cb);
                }
                cb = new CusteioBean();
                ++i;
            }
            if (cb == null) continue;
            int propIndex = cdPlanilha % 10;
            Class<?> propClass = CusteioBean.typeByIndex(propIndex);
            if (propClass.equals(Double.class)) {
                Double valor = null;
                Object o = r.getAttribute("VlModelo");
                if (o instanceof Double) {
                    valor = (Double)o;
                } else if (o instanceof BigDecimal) {
                    valor = ((BigDecimal)o).doubleValue();
                } else if (o != null) {
                    log.info((Object)("unknown class: " + o.getClass()));
                    valor = 0.0;
                } else {
                    log.info((Object)("null VlModelo value: " + o));
                    valor = 0.0;
                }
                cb.setByIndex(propIndex, valor);
                continue;
            }
            String texto = (String)r.getAttribute("Texto");
            cb.setByIndex(propIndex, texto);
        }
        if (cb != null) {
            log.info((Object)("add [last] CusteioBean, beanId=" + beanId + "/" + i + "/" + cb));
            this.tableCusteioModel.add(cb);
        }
        this.tableCusteioModel.resetChanged();
    }

    @Override
    public void finalizaTela() {
        log.info((Object)"finalizaTela...");
        if (this.tableCusteioModel.hasChanged()) {
            this.salvaDadosTela();
        }
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    public void salvaDadosTela() {
        log.info((Object)"salvaDadosTela...");
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ser.getTransaction().commit();
        Remessa remessa = ser.getRemessaPrincipal();
        ser.removeJustificativasRemessa(remessa, TipoJustificativa.CUSTEIO_OUTROS_ENTES);
        ViewObject voj = ser.findViewObject("JustificativasDaRemessa");
        voj.clearCache();
        ser.getTransaction().commit();
        voj.reset();
        for (int i = 0; i < this.tableCusteioModel.getRowCount(); ++i) {
            CusteioBean cb = this.tableCusteioModel.get(i);
            for (int j = 0; j < 6; ++j) {
                Row row = voj.createRow();
                int cdPlanilha = 10 * i + j;
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("TipoPlanilha", (Object)TipoJustificativa.CUSTEIO_OUTROS_ENTES.getCodigo());
                row.setAttribute("CdPlanilha", (Object)cdPlanilha);
                Class<?> propClass = CusteioBean.typeByIndex(j);
                if (propClass.equals(Double.class)) {
                    row.setAttribute("VlModelo", (Object)BigDecimal.valueOf((Double)cb.getByIndex(j)));
                } else {
                    row.setAttribute("Texto", cb.getByIndex(j));
                }
                voj.insertRow(row);
            }
        }
        ser.getTransaction().commit();
    }

    public int getRowCount() {
        return this.tableCusteioModel.getRowCount();
    }

    void tableRowClicked() {
        this.navBar.rowClicked(this.tableCusteio.getSelectedRow());
    }

    void tableRowDoubleClicked() {
        log.info((Object)("tableCusteio.getSelectedRow(): " + this.tableCusteio.getSelectedRow()));
        this.navBar.editSelectedRow();
    }

    static {
        if (nf instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)nf;
            df.setDecimalSeparatorAlwaysShown(true);
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(2);
            df.setGroupingSize(3);
            log.info((Object)"using DecimalFormat");
        } else {
            log.warn((Object)"NOT using DecimalFormat");
        }
    }
}

