/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardControle;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.TelaUC036;
import br.gov.rs.tce.pad.visao.panel.TelaUC100;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;
import oracle.adf.model.BindingContext;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC205
extends JPanel
implements JUPanel,
PadModelo {
    private static Log log = LogFactory.getLog(TelaUC205.class);
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC205UIModel");
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel pnlSul = new JPanel();
    private JPanel pnlNort = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private JLabel lblPerInfDesc = new JLabel();
    private JLabel lblTpPeriodicidadeDesc = new JLabel();
    private JLabel lblTpPeriodicidade = new JLabel();
    private JLabel lblPerInfo = new JLabel();
    private JULabel lblCnpj = new JULabel();
    private JTextField tfCnpj = new JTextField();
    private JULabel lblNome = new JULabel();
    private JTextField tfNome = new JTextField();
    private JULabel lblDataHora = new JULabel();
    private JTextField tfDataHora = new JTextField();
    private JULabel lblCdBarras = new JULabel();
    private JTextField tfCdBarras = new JTextField();
    private JLabel jLabel1 = new JLabel();
    private JTextField txtArquivo = new JTextField();
    private JButton btProcurar = new JButton();
    private String path = null;
    private boolean flagAvancar = false;

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.add((Component)this.pnlNort, "North");
        this.add((Component)this.pnlSul, "South");
        this.pnlNort.setLayout((LayoutManager)this.xYLayout1);
        this.pnlNort.add((Component)this.jLabel1, new XYConstraints(50, 15, 520, 40));
        this.pnlNort.add((Component)this.btProcurar, new XYConstraints(455, 70, 115, 25));
        this.pnlNort.add((Component)this.txtArquivo, new XYConstraints(50, 70, 390, 25));
        this.jLabel1.setText("<html>Para fazer o envio, \u00e9 necess\u00e1rio informar o arquivo de remessa contendo os dados da Entidade</html>");
        this.jLabel1.setAlignmentY(2.0f);
        this.btProcurar.setText("Procurar");
        this.btProcurar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaUC205.this.btnProcurar_actionPerformed(e);
            }
        });
        this.tfCdBarras.setEditable(false);
        this.tfCnpj.setEditable(false);
        this.tfDataHora.setEditable(false);
        this.tfNome.setEditable(false);
        this.pnlSul.setLayout((LayoutManager)this.xYLayout1);
        this.pnlSul.setBorder(BorderFactory.createTitledBorder("Dados da Entidade"));
        this.pnlSul.add((Component)this.lblNome, new XYConstraints(10, 5, 40, 20));
        this.pnlSul.add((Component)this.lblCnpj, new XYConstraints(10, 35, 30, 20));
        this.pnlSul.add((Component)this.lblCdBarras, new XYConstraints(10, 65, 125, 20));
        this.pnlSul.add((Component)this.lblPerInfo, new XYConstraints(10, 95, 140, 20));
        this.pnlSul.add((Component)this.lblTpPeriodicidade, new XYConstraints(10, 125, 125, 20));
        this.pnlSul.add((Component)this.lblDataHora, new XYConstraints(10, 155, 135, 20));
        this.pnlSul.add((Component)this.tfNome, new XYConstraints(50, 5, 390, 20));
        this.pnlSul.add((Component)this.tfCnpj, new XYConstraints(45, 35, 115, 20));
        this.pnlSul.add((Component)this.tfCdBarras, new XYConstraints(110, 65, 150, 20));
        this.pnlSul.add((Component)this.lblPerInfDesc, new XYConstraints(150, 95, 170, 20));
        this.pnlSul.add((Component)this.lblTpPeriodicidadeDesc, new XYConstraints(135, 125, 150, 20));
        this.pnlSul.add((Component)this.tfDataHora, new XYConstraints(135, 155, 150, 20));
        this.lblTpPeriodicidade.setText("Tipo da Periodicidade:");
        this.lblPerInfo.setText("Per\u00edodo de Informa\u00e7\u00f5es:");
        this.tfCnpj.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfNome.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfDataHora.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfCdBarras.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.txtArquivo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TelaUC205.this.setAvancar(false);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TelaUC205.this.setAvancar(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TelaUC205.this.setAvancar(false);
            }
        });
        this.lblCnpj.setText("Cnpj:");
        this.tfCnpj.setDocument((Document)this.panelBinding.bindUIControl("EntidadeDaRemessaCnpj", (Object)this.tfCnpj));
        this.lblNome.setText("Nome:");
        this.tfNome.setDocument((Document)this.panelBinding.bindUIControl("EntidadeDaRemessaNome", (Object)this.tfNome));
        this.lblCdBarras.setText("Codigo de Barras:");
        this.tfCdBarras.setDocument((Document)this.panelBinding.bindUIControl("RemessasDaEntidadeCodBarras", (Object)this.tfCdBarras));
        this.lblDataHora.setText("Data e Hora Gera\u00e7\u00e3o:");
        this.tfNome.setEnabled(true);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC205 panel = new TelaUC205();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    private void btnProcurar_actionPerformed(ActionEvent e) {
        this.selecionaArquivo();
    }

    private void selecionaArquivo() {
        if (this.path == null) {
            this.path = "C:/";
        }
        JFileChooser fc = new JFileChooser(new File(this.path));
        fc.setFileSelectionMode(0);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean ok = false;
                if (file != null) {
                    boolean bl = ok = file.getName().endsWith(".dat") || file.getName().indexOf(".p0") > 0;
                }
                if (!ok) {
                    ok = file.isDirectory();
                }
                return ok;
            }

            @Override
            public String getDescription() {
                return "Troca de informa\u00e7\u00f5es (*.dat;*.p0*)";
            }
        };
        fc.setFileFilter(ff);
        if (fc.showOpenDialog(this) == 0 && fc.getSelectedFile() != null && fc.getSelectedFile().exists()) {
            this.path = fc.getSelectedFile().getAbsolutePath();
            this.txtArquivo.setText(this.path);
        }
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
        PadWizardControle control = PadWizardHelper.getInstance().getForm().getPagina().getPadWizardControle();
        control.setaNomeAvancar("Carregar");
        this.escondePnlSul();
        this.flagAvancar = false;
        TelaUC100.setTipoOperacaoConsolidacao(false);
        TelaUC036.setEntrouTelaEnvio(true);
    }

    public void setAvancar(boolean valor) {
        this.flagAvancar = valor;
        PadWizardControle control = PadWizardHelper.getInstance().getForm().getPagina().getPadWizardControle();
        if (valor) {
            control.setaNomeAvancar("Avan\u00e7ar >");
            this.setDadosEntidadeRemessa();
            this.mostraPnlSul();
        } else {
            control.setaNomeAvancar("Carregar");
            this.escondePnlSul();
        }
    }

    public boolean getAvancar() {
        return this.flagAvancar;
    }

    public void mostraPnlSul() {
        this.pnlSul.setVisible(true);
    }

    public void escondePnlSul() {
        this.pnlSul.setVisible(false);
    }

    private void setDadosEntidadeRemessa() {
        BindingContext binding = this.panelBinding.getBindingContext();
        Remessa remessa = DatacontrolHelper.getRemessaSemAnoBiDataControl(binding);
        log.info((Object)("setDadosEntidadeRemessa: cdEntidade: " + remessa.getCdEntidade() + "; ano: " + remessa.getAnoExercicio()));
        int periodoInf = remessa.getRemessaInfo().getPeriodoInformacoes();
        Integer mesInf = remessa.getRemessaInfo().getMesInformacoes();
        Integer anoInf = remessa.getRemessaInfo().getAnoExercicio();
        String tpEntrega = remessa.getRemessaInfo().getTipoEntrega();
        String versao = remessa.getRemessaInfo().getVersao();
        Date dtFinal = remessa.getRemessaInfo().getDataFinalRemessa();
        String codArqComplementares = remessa.getRemessaInfo().getCodigoArquivosComplementares();
        if (dtFinal != null) {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            Calendar cal = Calendar.getInstance();
            cal.setTime(dtFinal);
            cal.set(5, 1);
            cal.set(2, 0);
            this.lblPerInfDesc.setText(df.format(cal.getTime()) + " a " + df.format(dtFinal));
        } else if (mesInf == null) {
            switch (periodoInf) {
                case 1: {
                    this.lblPerInfDesc.setText("1\u00ba Bimestre");
                    break;
                }
                case 2: {
                    this.lblPerInfDesc.setText("2\u00ba Bimestre");
                    break;
                }
                case 3: {
                    this.lblPerInfDesc.setText("3\u00ba Bimestre");
                    break;
                }
                case 4: {
                    this.lblPerInfDesc.setText("4\u00ba Bimestre");
                    break;
                }
                case 5: {
                    this.lblPerInfDesc.setText("5\u00ba Bimestre");
                    break;
                }
                case 6: {
                    this.lblPerInfDesc.setText("6\u00ba Bimestre");
                }
            }
        } else {
            this.lblPerInfDesc.setText(mesInf + "\u00ba m\u00eas de " + anoInf);
        }
        if (tpEntrega != null && dtFinal == null) {
            this.lblTpPeriodicidade.setText("Tipo da Periodicidade:");
            if (tpEntrega.equals("Q")) {
                this.lblTpPeriodicidadeDesc.setText("Quadrimestral");
            } else if (tpEntrega.equals("S")) {
                this.lblTpPeriodicidadeDesc.setText("Semestral");
            }
        } else if (dtFinal != null) {
            this.lblTpPeriodicidade.setText("Tipo de Arquivos:");
            this.lblTpPeriodicidadeDesc.setText(this.getLabelTipoArqComplementar(codArqComplementares));
        } else {
            this.lblTpPeriodicidade.setText("");
        }
        String format = "dd/MM/yyyy HH:mm:ss";
        SimpleDateFormat df = new SimpleDateFormat(format);
        String dateStr = df.format(remessa.getRemessaInfo().getDataGeracao()).toString();
        this.tfDataHora.setText(dateStr);
        log.info((Object)("setDadosEntidadeRemessa: versaoPAD: " + versao + " ; tpEntrega: " + tpEntrega + " ; dtFinal: " + dtFinal));
    }

    String getLabelTipoArqComplementar(String cdTpArq) {
        if (cdTpArq == null) {
            return "";
        }
        if (cdTpArq.equals("FP") || cdTpArq.equals("PDFP")) {
            return "Folha de Pagamento";
        }
        if (cdTpArq.equals("PDLD")) {
            return "Livro Di\u00e1rio Geral";
        }
        if (cdTpArq.equals("PDRP")) {
            return "Receita P\u00fablica";
        }
        return cdTpArq;
    }

    @Override
    public final void finalizaTela() {
        PadWizardControle control = PadWizardHelper.getInstance().getForm().getPagina().getPadWizardControle();
        control.setaNomeAvancar("Avan\u00e7ar >");
    }

    public String getArquivo() {
        return this.txtArquivo.getText();
    }

    public void setArquivo(String texto) {
        this.txtArquivo.setText(texto);
    }

    @Override
    public boolean validaTela() {
        File f = new File(this.txtArquivo.getText());
        if (!f.exists()) {
            this.exibeMensagemWarning("Selecione o arquivo de envio");
            return false;
        }
        if (!f.getName().toLowerCase().startsWith("remessa")) {
            this.exibeMensagemWarning("Arquivo inv\u00e1lido. Arquivo deve ser do tipo 'remessa.dat' ou 'remessa.p0*'");
            return false;
        }
        return true;
    }

    public void exibeMensagemWarning(String mensagem) {
        JOptionPane.showMessageDialog(this, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    class MyJTextField
    extends JTextField {
        public MyJTextField() {
            this.setEditable(false);
            FocusAdapter list = new FocusAdapter(){
                public int conta;

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            };
            this.addFocusListener(list);
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private Color unselectedForeground;
        private Color unselectedBackground;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    super.setForeground(Color.WHITE);
                    super.setBackground(UIManager.getColor("Table.selectionBackground"));
                }
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setValue(value);
            if (value != null) {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }
}

