/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.resource.PadImage;
import br.gov.rs.tce.pad.util.CopiaArquivoEvent;
import br.gov.rs.tce.pad.visao.PadWizardControle;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC103;
import br.gov.rs.tce.pad.visao.panel.action.ActionAvancarUC103;
import java.awt.Component;
import java.awt.Cursor;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC103Model
implements ImportacaoListener {
    private TelaUC103 _tela;
    private boolean _contaTempo = true;
    private DateFormat _formatoTempo = new SimpleDateFormat("mm:ss");
    private String _tempoDecorrido = new String();
    private Remessa _remessa = null;
    private Thread _thTimer = null;
    private ProgressBarBoundedRangeModel _modelProgressArquivo = null;
    private PadWizardControle _controle = null;
    static MensagemInstancia mensagem = MensagemFactory.getInstancia().constroiMensagem("MSG_UC055_01");
    private static Log log = LogFactory.getLog(TelaUC103Model.class);

    public TelaUC103Model(TelaUC103 tela) {
        this._tela = tela;
        this._controle = PadWizardHelper.getInstance().getForm().getPagina().getPadWizardControle();
    }

    public boolean execute(BindingContext binding) {
        boolean verificacaoOk = true;
        boolean avancaTela = false;
        Connection conexao = null;
        try {
            verificacaoOk = this.executaGravacao(binding, conexao);
        }
        catch (Exception e) {
            log.error((Object)"Erro ao executar ActionAcvancarUC103", (Throwable)e);
            avancaTela = false;
            throw new PADActionException("TelaUC103", ActionAvancarUC103.class.toString(), e);
        }
        return avancaTela;
    }

    public boolean executaGravacao(BindingContext binding, Connection conexao) throws Exception {
        boolean verificacaoOk = true;
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        this._remessa = PadAbstractAction.getRemessaDataControl(binding);
        form.setCursor(new Cursor(3));
        try {
            this._tela.setProgressoArquivoModel(this._modelProgressArquivo);
            this._contaTempo = false;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
        finally {
            form.setCursor(new Cursor(0));
            this._contaTempo = false;
        }
        return verificacaoOk;
    }

    @Override
    public void trataEvento(ImportacaoEvento evento) {
        switch (evento.getTipoEvento()) {
            case 0: {
                this._modelProgressArquivo.setMaximum((int)(evento.getMetadadosArquivoAtual().getTamanhoArquivo() / 1000L));
            }
        }
    }

    private String formataTempo(long tempo) {
        Date date = new Date(tempo);
        this._tempoDecorrido = this._formatoTempo.format(date);
        return this._tempoDecorrido;
    }

    private boolean exibeMensagemConfirmacao(String mensagem) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        return JOptionPane.showConfirmDialog(form, mensagem, "Aten\u00e7\u00e3o", 2) == 0;
    }

    class PadTableRenderer
    extends DefaultTableCellRenderer {
        private ImageIcon erroIcon = PadImage.createImageIcon("imagens/erroxp.gif");
        private ImageIcon informacaoIcon = PadImage.createImageIcon("imagens/ixp.gif");
        private ImageIcon avisoIcon = PadImage.createImageIcon("imagens/avisoxp.gif");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String status = (String)table.getModel().getValueAt(row, column);
            if (status != null) {
                if (status.equals("W")) {
                    this.setIcon(this.avisoIcon);
                } else if (status.equals("E")) {
                    this.setIcon(this.erroIcon);
                } else if (status.equals("I")) {
                    this.setIcon(this.informacaoIcon);
                }
                this.setHorizontalAlignment(0);
            } else {
                this.setIcon(null);
            }
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    class ProgressBarBoundedRangeModel
    extends DefaultBoundedRangeModel
    implements ChangeListener {
        ProgressBarBoundedRangeModel() {
            this.setMaximum(100);
            this.setValue(0);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            CopiaArquivoEvent comp = (CopiaArquivoEvent)event;
            this.setValue(comp.getSituacao());
        }
    }
}

