/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.AttributedString;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class TelaUC103B
extends JPanel
implements JUPanel,
PadModelo {
    public static final String CD = "CD";
    public static final String ORIGINAL = "ORIGINAL";
    public static final String BACKUP = "BACKUP";
    public static final String CONSOLIDADO = "CONSOLIDADO";
    private String _qualMidia;
    private String _discoAtual;
    private String _totalDiscos;
    private String _tipoImpressao;
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC103BUIModel");
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel PnlNort = new JPanel();
    private JPanel PnlCenter = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private XYLayout xYLayout2 = new XYLayout();
    private JTextArea textEtiqueta = new JTextArea();
    private ScrollPane scrollPaneEtiqueta = new ScrollPane();
    private BindingContext _bindingContext;
    private String _nomeEntidade;

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(429, 286));
        this.add((Component)this.PnlCenter, "Center");
        this.PnlNort.setSize(new Dimension(220, 150));
        this.PnlNort.setPreferredSize(new Dimension(375, 100));
        this.PnlNort.setMaximumSize(new Dimension(800, 600));
        this.PnlNort.setMinimumSize(new Dimension(275, 40));
        this.PnlNort.setLayout((LayoutManager)this.xYLayout2);
        this.PnlNort.setBorder(BorderFactory.createEtchedBorder(1));
        this.PnlCenter.setLayout((LayoutManager)this.xYLayout1);
        this.PnlCenter.setSize(new Dimension(425, 175));
        this.PnlCenter.setMaximumSize(new Dimension(800, 600));
        this.PnlCenter.setPreferredSize(new Dimension(400, 175));
        this.PnlCenter.setMinimumSize(new Dimension(100, 100));
        this.PnlCenter.setBorder(BorderFactory.createEtchedBorder(1));
        String[] aux = this.criaEtiqueta(this.getMidia(), false);
        this.textEtiqueta.setText(aux[0]);
        this.scrollPaneEtiqueta.add((Component)this.textEtiqueta, null);
        this.PnlNort.add((Component)this.scrollPaneEtiqueta, new XYConstraints(5, 5, 390, 250));
        this.PnlCenter.add((Component)this.PnlNort, new XYConstraints(5, 5, 405, 265));
    }

    private String[] criaEtiqueta(String midia, boolean isPrint) {
        String perAte;
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this._bindingContext);
        Remessa _remessa = this.getRemessaPrincipal(ser);
        RemessaInfo remInfo = DatacontrolHelper.getRemessaDataControl(this._bindingContext).getRemessaInfo();
        String nomeEntidade = ser.getNomeEntidade(_remessa);
        DCDataControl dc = this._bindingContext.findDataControl("RemessaDataControl");
        Remessa remessaDC = (Remessa)dc.getDataProvider();
        this.setNomeDaEntidade(nomeEntidade);
        StringBuffer etiqueta = new StringBuffer();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        int mesPeriodo = _remessa.getMesFinalInformacoes() + 1;
        int anoRef = _remessa.getAnoExercicio();
        java.util.Date dtFinalRequisicao = _remessa.getDataFinal();
        String disOri = "1";
        String perDe = "01/01/" + anoRef;
        boolean index = false;
        ArrayList<String> linhas = new ArrayList<String>();
        if (remessaDC.getTipoOperacao() == 6) {
            perAte = new SimpleDateFormat("dd/MM/yyyy").format(dtFinalRequisicao);
        } else if (mesPeriodo == 1 || mesPeriodo == 3 || mesPeriodo == 5 || mesPeriodo == 7 || mesPeriodo == 8 || mesPeriodo == 10 || mesPeriodo == 12) {
            perAte = "31/";
            perAte = mesPeriodo < 10 ? perAte + "0" + mesPeriodo + "/" + anoRef : perAte + mesPeriodo + "/" + anoRef;
        } else if (mesPeriodo == 4 || mesPeriodo == 6 || mesPeriodo == 9 || mesPeriodo == 11) {
            perAte = "30/";
            perAte = mesPeriodo < 10 ? perAte + "0" + mesPeriodo + "/" + anoRef : perAte + mesPeriodo + "/" + anoRef;
        } else {
            perAte = anoRef % 4 == 0 && anoRef % 100 != 0 || anoRef % 400 == 0 ? "29/0" + mesPeriodo + "/" + anoRef : "28/0" + mesPeriodo + "/" + anoRef;
        }
        if (isPrint) {
            linhas.add(new String("==================================="));
        } else {
            etiqueta.append("=============================================\n");
        }
        if (isPrint) {
            linhas.add(new String("  Tribunal de Contas do Estado do R.S.\n\n"));
        } else {
            etiqueta.append("  Tribunal de Contas do Estado do R.S.\n\n");
        }
        if (isPrint) {
            linhas.add(new String("  SIAPC - Vers\u00e3o 25.1.1.0\n"));
        } else {
            etiqueta.append("  SIAPC - Vers\u00e3o 25.1.1.0\n");
        }
        if (isPrint) {
            linhas.add(new String("  PAD - Programa Autenticador de Dados\n\n"));
        } else {
            etiqueta.append("  PAD - Programa Autenticador de Dados\n\n");
        }
        if (isPrint) {
            linhas.add(new String("  " + nomeEntidade + "\n"));
        } else {
            etiqueta.append("  " + nomeEntidade + "\n");
        }
        if (isPrint) {
            linhas.add(new String("  CNPJ: " + _remessa.getCnpjEntidade() + "\n"));
        } else {
            etiqueta.append("  CNPJ: " + _remessa.getCnpjEntidade() + "\n");
        }
        if (isPrint) {
            linhas.add(new String("  Ano de Refer\u00eancia: " + anoRef + "\n"));
        } else {
            etiqueta.append("  Ano de Refer\u00eancia: " + anoRef + "\n");
        }
        if (isPrint) {
            linhas.add(new String("  Per\u00edodo: " + perDe + " at\u00e9 " + perAte + "\n"));
        } else {
            etiqueta.append("  Per\u00edodo: " + perDe + " at\u00e9 " + perAte + "\n");
        }
        if (CONSOLIDADO.equals(this._tipoImpressao) || "CONSOLIDA\u00c7\u00c3O".equals(this._tipoImpressao) || "BACKUP CONSOLIDA\u00c7\u00c3O".equals(this._tipoImpressao)) {
            if (isPrint) {
                linhas.add(new String("  C\u00f3digo Mod. 9: " + (remInfo == null ? "" : remInfo.getCodBarrasModelo9()) + "\n"));
            } else {
                etiqueta.append("  C\u00f3digo Mod. 9: " + (remInfo == null ? "" : remInfo.getCodBarrasModelo9()) + "\n");
            }
        } else if (isPrint) {
            linhas.add(new String("  C\u00f3digo RVE: " + (remInfo == null ? "" : remInfo.getCodBarrasRve()) + "\n"));
            if (remInfo != null && remInfo.getCodBarrasRdi() != null) {
                linhas.add(new String("  C\u00f3digo RDI: " + remInfo.getCodBarrasRdi() + "\n"));
            }
        } else {
            etiqueta.append("  C\u00f3digo RVE: " + (remInfo == null ? "" : remInfo.getCodBarrasRve()) + "\n");
            if (remInfo != null && remInfo.getCodBarrasRdi() != null) {
                etiqueta.append("  C\u00f3digo RDI: " + remInfo.getCodBarrasRdi() + "\n");
            }
        }
        if (midia.equalsIgnoreCase("DISQUETE")) {
            if (isPrint) {
                linhas.add(new String("  Data Gera\u00e7\u00e3o " + midia + ": " + (remInfo == null ? "" : formatter.format(remInfo.getDataGeracao())) + "\n"));
            } else {
                etiqueta.append("  Data Gera\u00e7\u00e3o " + midia + ": " + (remInfo == null ? "" : formatter.format(remInfo.getDataGeracao())) + "\n");
            }
            if (isPrint) {
                linhas.add(new String("  Disquete " + this.getTipoImpressao() + " - " + this._discoAtual + " de " + this._totalDiscos + "\n"));
            } else {
                etiqueta.append("  Disquete " + this.getTipoImpressao() + " - " + this._discoAtual + " de " + this._totalDiscos + "\n");
            }
        } else {
            if (isPrint) {
                linhas.add(new String("  Data Gera\u00e7\u00e3o " + midia + ": " + (remInfo == null ? "" : formatter.format(remInfo.getDataGeracao())) + "\n"));
            } else {
                etiqueta.append("  Data Gera\u00e7\u00e3o " + midia + ": " + (remInfo == null ? "" : formatter.format(remInfo.getDataGeracao())) + "\n");
            }
            if (isPrint) {
                linhas.add(new String("  CD " + this.getTipoImpressao() + " - " + this._discoAtual + " de " + this._totalDiscos + "\n"));
            } else {
                etiqueta.append("  CD " + this.getTipoImpressao() + " - " + this._discoAtual + " de " + this._totalDiscos + "\n");
            }
        }
        if (isPrint) {
            linhas.add(new String("==================================="));
        } else {
            etiqueta.append("=============================================\n");
        }
        String[] retorno = !isPrint ? new String[]{etiqueta.toString()} : linhas.toArray(new String[linhas.size()]);
        return retorno;
    }

    private void setNomeDaEntidade(String nomeEntidade) {
        this._nomeEntidade = nomeEntidade;
    }

    public String getNomeDaEntidade() {
        return this._nomeEntidade;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        this._bindingContext = bindCtx;
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    @Override
    public void preparaTela() {
        System.out.println("preparaTela");
    }

    @Override
    public void finalizaTela() {
        System.out.println("finalizaTela");
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    private void btnCancelar_actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public void buttonOk_actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        PageFormat documentPageFormat = new PageFormat();
        documentPageFormat.setOrientation(1);
        book.append(new Document(), documentPageFormat);
        printJob.setPageable(book);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
    }

    public void setMidia(String pMidia) {
        this._qualMidia = pMidia;
    }

    public String getMidia() {
        return this._qualMidia;
    }

    public void setTipoImpressao(String pTipoImpressao) {
        this._tipoImpressao = pTipoImpressao;
    }

    public String getTipoImpressao() {
        return this._tipoImpressao;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC103B panel = new TelaUC103B();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(500, 400)));
        panel.revalidate();
    }

    public void setDiscoAtual(String disco) {
        this._discoAtual = disco;
    }

    public void setTotalDiscos(String total) {
        this._totalDiscos = total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Remessa getRemessaPrincipal(ServicoPAD padModule) {
        ViewObject remessasView = null;
        ViewObject entidadeView = null;
        Remessa remessa = null;
        try {
            remessasView = padModule.createViewObjectFromQueryStmt("RemessaPrincipal", "Select * from remessas where remessa_principal = 'S'");
            remessasView.executeQuery();
            Row remessaRow = remessasView.first();
            if (remessaRow == null) {
                remessasView = padModule.createViewObjectFromQueryStmt("RemessaPrincipal_1", "Select * from remessas");
                remessasView.executeQuery();
                remessaRow = remessasView.first();
            }
            remessa = new Remessa();
            remessa.setDiretorioOrigem((String)remessaRow.getAttribute("DIR_ARQUIVOS"));
            Integer anoExercicio = ((BigDecimal)remessaRow.getAttribute("ANO_EXERCICIO")).intValue();
            if (anoExercicio != null) {
                remessa.setAnoExercicio(anoExercicio);
            }
            String tpEntrega = (String)remessaRow.getAttribute("TP_ENTREGA");
            remessa.setTipoEntrega(tpEntrega);
            Integer peridodo = ((BigDecimal)remessaRow.getAttribute("PERIODO_INFORMACOES")).intValue();
            remessa.setPeriodoInformacoes(peridodo);
            remessa.setCdRemessa(1);
            remessa.setCargaArquivosSelecaoEfetuada(((BigDecimal)remessaRow.getAttribute("SITUACAO_CARGA")).intValue() == 1);
            remessa.setCdEntidade(((BigDecimal)remessaRow.getAttribute("CD_ENTIDADE")).intValue());
            remessa.setDataFinal((Date)remessaRow.getAttribute("DT_FINAL_COMPL"));
            entidadeView = padModule.createViewObjectFromQueryStmt("EntidadePrincipal", "Select * from entidades where cd_entidade = " + remessa.getCdEntidade());
            entidadeView.executeQuery();
            Row entidadeRow = entidadeView.first();
            if (entidadeRow != null) {
                remessa.setCnpjEntidade((String)entidadeRow.getAttribute("CNPJ"));
                remessa.setTipoSetor((String)entidadeRow.getAttribute("TIPO_SETOR_GOV"));
            }
        }
        finally {
            if (remessasView != null) {
                remessasView.remove();
            }
            if (entidadeView != null) {
                entidadeView.remove();
            }
        }
        return remessa;
    }

    private class Document
    implements Printable {
        private Document() {
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int page) {
            String nomeEntidade = TelaUC103B.this.getNomeDaEntidade();
            double widthEntity = 0.5;
            double linha4 = 1.1;
            if (nomeEntidade != null) {
                if (nomeEntidade.length() <= 12) {
                    widthEntity = 0.6;
                } else if (nomeEntidade.length() > 12 && nomeEntidade.length() <= 22) {
                    widthEntity = 0.9;
                } else if (nomeEntidade.length() > 22) {
                    widthEntity = 1.2;
                }
            }
            int POINTS_PER_INCH = 140;
            int SIZE_FONT = 9;
            int LARGURA_ETIQUETA = 205;
            int COMPRIMENTO_ETIQUETA = 150;
            double POSICAO_LATERAL = 0.1;
            double POSICAO_SUPERIOR = 0.01;
            if (TelaUC103B.this.getMidia().equalsIgnoreCase(TelaUC103B.CD)) {
                POINTS_PER_INCH = 215;
                SIZE_FONT = 15;
                LARGURA_ETIQUETA = 350;
                COMPRIMENTO_ETIQUETA = 335;
                POSICAO_LATERAL = 0.15;
                POSICAO_SUPERIOR = 0.2;
                linha4 = 1.2;
                if (nomeEntidade != null) {
                    if (nomeEntidade.length() <= 12) {
                        widthEntity = 0.7;
                    } else if (nomeEntidade.length() > 12 && nomeEntidade.length() <= 22) {
                        widthEntity = 1.1;
                    } else if (nomeEntidade.length() > 23) {
                        widthEntity = 1.3;
                    }
                }
            }
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            g2d.setPaint(Color.black);
            g2d.setStroke(new BasicStroke(1.0f));
            Rectangle2D.Double border = new Rectangle2D.Double(0.0, 0.0, LARGURA_ETIQUETA, COMPRIMENTO_ETIQUETA);
            g2d.draw(border);
            String[] aaa = TelaUC103B.this.criaEtiqueta(TelaUC103B.this.getMidia(), true);
            Point2D.Double pen = new Point2D.Double(POSICAO_LATERAL * (double)POINTS_PER_INCH, POSICAO_SUPERIOR * (double)POINTS_PER_INCH);
            double width = 1.3 * (double)POINTS_PER_INCH;
            if (TelaUC103B.this.getMidia().equalsIgnoreCase(TelaUC103B.CD)) {
                width = 1.45 * (double)POINTS_PER_INCH;
            }
            for (int a = 0; a < aaa.length; ++a) {
                TextLayout layout;
                AttributedString paragraphText = new AttributedString(aaa[a]);
                paragraphText.addAttribute(TextAttribute.FONT, new Font("serif", 0, SIZE_FONT));
                LineBreakMeasurer lineBreaker = new LineBreakMeasurer(paragraphText.getIterator(), new FontRenderContext(null, true, true));
                Vector<TextLayout> lines = new Vector<TextLayout>();
                while ((layout = lineBreaker.nextLayout((float)width)) != null) {
                    lines.add(layout);
                }
                for (int i = 0; i < lines.size(); ++i) {
                    layout = (TextLayout)lines.get(i);
                    TextLayout justifyLayout = i != lines.size() - 1 ? layout.getJustifiedLayout((float)width) : layout;
                    pen.y += (double)justifyLayout.getAscent();
                    justifyLayout.draw(g2d, (float)pen.x, (float)pen.y);
                    pen.y += (double)(justifyLayout.getDescent() + justifyLayout.getLeading());
                }
            }
            return 0;
        }
    }
}

