/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.resource.PadImage;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.PadTableRenderer;
import br.gov.rs.tce.pad.visao.panel.PopUpJustificativas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.Row;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class TelaUC091
extends JPanel
implements JUPanel,
PadModelo {
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC091UIModel");
    private JScrollPane spTabela = new JScrollPane();
    private BorderLayout borderLayout1 = new BorderLayout();
    private PopUpJustificativas justif;
    private ImageIcon blackIcon = PadImage.createImageIcon("imagens/icone_black.gif");
    private ImageIcon redIcon = PadImage.createImageIcon("imagens/icone_red.gif");
    private ImageIcon greenIcon = PadImage.createImageIcon("imagens/icone_green.gif");
    private ImageIcon blueIcon = PadImage.createImageIcon("imagens/icone_blue.gif");
    private JTable tblJustificativas = new JTable();
    private JPanel jPanel1 = new JPanel();
    private JLabel lblLegenda = new JLabel();
    private XYLayout xYLayout1 = new XYLayout();
    private JLabel lblBlack = new JLabel();
    private JLabel lblGreen = new JLabel();
    private JLabel jLabel4 = new JLabel();
    private JLabel jLabel5 = new JLabel();
    protected static final DefaultTableCellRenderer NUMERO_ALINHADO_ESQ_RENDERER_HABILITADO = new DefaultTableCellRenderer();
    private static DefaultCellEditor CELL_EDITOR_DESABILITADO;
    private static final int[] TAMANHO_COLUNAS;

    public TelaUC091() {
        JTextField tf = new JTextField();
        tf.setBackground(Color.LIGHT_GRAY);
        CELL_EDITOR_DESABILITADO = new DefaultCellEditor(tf){

            @Override
            public boolean isCellEditable(EventObject eo) {
                return false;
            }
        };
    }

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.tblJustificativas.setModel((TableModel)this.panelBinding.bindUIControl("JustificativasDaRemessa", (Object)this.tblJustificativas));
        this.tblJustificativas.setEnabled(true);
        this.tblJustificativas.setAutoResizeMode(0);
        this.spTabela.getViewport().add((Component)this.tblJustificativas, null);
        this.add((Component)this.spTabela, "Center");
        this.jPanel1.setLayout((LayoutManager)this.xYLayout1);
        int col1width = 300;
        int col2width = 235;
        this.jPanel1.add((Component)this.jLabel5, new XYConstraints(330, 45, col2width, 15));
        this.jPanel1.add((Component)this.jLabel4, new XYConstraints(330, 25, col2width, 15));
        this.jPanel1.add((Component)this.lblGreen, new XYConstraints(20, 45, col1width, 15));
        this.jPanel1.add((Component)this.lblBlack, new XYConstraints(20, 25, col1width, 15));
        this.jPanel1.add((Component)this.lblLegenda, new XYConstraints(10, 5, 160, 15));
        this.add((Component)this.jPanel1, "South");
        this.jPanel1.setPreferredSize(new Dimension(362, 64));
        this.jLabel5.setIcon(this.redIcon);
        this.jLabel4.setIcon(this.blueIcon);
        this.lblGreen.setIcon(this.greenIcon);
        this.lblBlack.setIcon(this.blackIcon);
        this.jLabel5.setText("Percentual acima do limite legal");
        this.jLabel4.setText("Percentual acima do limite prudencial");
        this.lblGreen.setText("Percentual acima do limite para emiss\u00e3o do alerta");
        this.lblBlack.setText("Percentual inferior ao limite de alerta");
        this.lblLegenda.setText("Legenda coluna de Alerta:");
        this.tblJustificativas.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TelaUC091.this.trataPopUpJustificativa(e);
            }
        });
        this.preparaColunasTabela();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
    }

    private void trataPopUpJustificativa(MouseEvent e) {
        if (e.getClickCount() == 2) {
            BindingContext binding = this.panelBinding.getBindingContext();
            ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(binding);
            DCIteratorBinding iter = this.panelBinding.findIteratorBinding("JustificativasDaRemessaIterator");
            Row r = iter.getCurrentRow();
            if ((Integer)r.getAttribute("NivelAlerta") < 3) {
                return;
            }
            PadWizardForm form = PadWizardHelper.getInstance().getForm();
            if (this.justif == null) {
                this.justif = new PopUpJustificativas(form);
            }
            this.justif.setJustificativa((String)r.getAttribute("Texto"));
            this.justif.setTitle("Indique as provid\u00eancias adotadas ou a adotar");
            this.justif.show();
            if (this.justif.isSalvaJustificativa()) {
                r.setAttribute("Texto", (Object)this.justif.getJustificativa());
                if (r != null) {
                    if (this.justif != null && !this.justif.getJustificativa().equals("")) {
                        r.setAttribute("Situacao", (Object)1);
                    } else {
                        r.setAttribute("Situacao", (Object)0);
                    }
                }
                ser.getTransaction().commit();
            }
        }
    }

    private void preparaColunasTabela() {
        TableColumnModel mdl = this.tblJustificativas.getColumnModel();
        this.tblJustificativas.setCellEditor(CELL_EDITOR_DESABILITADO);
        block5: for (int i = 0; i < mdl.getColumnCount(); ++i) {
            TableColumn c = mdl.getColumn(i);
            c.setPreferredWidth(TAMANHO_COLUNAS[i]);
            c.setCellEditor(CELL_EDITOR_DESABILITADO);
            switch (i) {
                case 1: 
                case 2: {
                    c.setCellRenderer(NUMERO_ALINHADO_ESQ_RENDERER_HABILITADO);
                    continue block5;
                }
                case 3: {
                    c.setCellRenderer(new LimitesTableCellRenderer());
                    continue block5;
                }
                case 4: {
                    c.setCellRenderer(new PadTableRenderer());
                    c.setHeaderValue("Provid\u00eancias");
                }
            }
        }
        this.tblJustificativas.getTableHeader().setReorderingAllowed(false);
        this.tblJustificativas.getTableHeader().setResizingAllowed(false);
    }

    public int getExisteJustificativas() {
        return 0;
    }

    @Override
    public final void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    static {
        TAMANHO_COLUNAS = new int[]{310, 110, 70, 50, 70};
        NUMERO_ALINHADO_ESQ_RENDERER_HABILITADO.setHorizontalAlignment(4);
    }

    class LimitesTableCellRenderer
    extends DefaultTableCellRenderer {
        Integer nivelAlerta = null;

        LimitesTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            this.nivelAlerta = (Integer)table.getValueAt(rowIndex, vColIndex);
            if (this.nivelAlerta == null) {
                this.nivelAlerta = -1;
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            if (this.nivelAlerta == null) {
                this.nivelAlerta = -1;
            }
            boolean drawLabel = false;
            switch (this.nivelAlerta) {
                case 3: {
                    g.setColor(Color.RED);
                    break;
                }
                case 2: {
                    g.setColor(Color.BLUE);
                    break;
                }
                case 1: {
                    g.setColor(Color.GREEN);
                    break;
                }
                case 0: {
                    g.setColor(Color.BLACK);
                    break;
                }
                default: {
                    this.setValue("ERRO");
                    drawLabel = true;
                }
            }
            if (drawLabel) {
                super.paint(g);
            } else {
                g.fillOval(20, 2, 10, 10);
            }
        }
    }
}

