/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.beans.types.TipoEntidadesList;
import br.gov.rs.tce.pad.excecao.ImportacaoException;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.modelo.servico.acessodados.common.HistoricoVerificacaoView;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.modelo.verificacao.VerificacaoArquivosControle;
import br.gov.rs.tce.pad.resource.PadImage;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.PropertiesUtil;
import br.gov.rs.tce.pad.visao.PadWizardControle;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC055;
import br.gov.rs.tce.pad.visao.panel.action.ActionAvancarUC055;
import java.awt.Component;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.adf.model.BindingContext;
import oracle.jbo.ApplicationModule;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC055Model
implements ImportacaoListener {
    private ModeloTabelaVerificacao _modeloTabelaVerificacao;
    private SituacaoVerificacao _situacao;
    private TableColumnModel _columnModel;
    private TelaUC055 _tela;
    private boolean _contaTempo = true;
    private String _tempoDecorrido = new String();
    private Remessa _remessa = null;
    private VerificacaoArquivosControle _verificacao = null;
    private Thread _thTimer = null;
    private Thread _thBanco = null;
    private int _quantidadeErros = 0;
    private ProgressBarBoundedRangeModel _modelProgressRemessa = null;
    private ProgressBarBoundedRangeModel _modelProgressArquivo = null;
    private PadWizardControle _controle = null;
    private ContasModule _module = null;
    private ServicoPAD _servicoPAD = null;
    private java.util.Date _dtVereficacao = null;
    static MensagemInstancia mensagem = MensagemFactory.getInstancia().constroiMensagem("MSG_UC055_01");
    private boolean _permiteAvancarComErros = false;
    private static Log log = LogFactory.getLog(TelaUC055Model.class);

    public TelaUC055Model(TelaUC055 tela) {
        this._tela = tela;
        this._situacao = new SituacaoVerificacao();
        this._controle = PadWizardHelper.getInstance().getForm().getPagina().getPadWizardControle();
        this._permiteAvancarComErros = PropertiesUtil.getPropertyPermiteAvancarComErros();
    }

    public boolean execute(BindingContext binding) {
        boolean verificacaoOk = true;
        boolean avancaTela = false;
        Connection conexao = null;
        this._situacao.zeraSituacaoVerificao();
        this._modeloTabelaVerificacao.inicializaMensagens();
        this._contaTempo = true;
        this._quantidadeErros = 0;
        this._tela.setNumeroErros("");
        try {
            if (this.mostraAviso() == 0) {
                this.setButtonsState(false);
                this._module = DatacontrolHelper.getContasModuleAppModule(binding);
                this._servicoPAD = DatacontrolHelper.getServicoPADAppModule(binding);
                this._servicoPAD.limpaJustificativasPosVerificacaoArquivos();
                this._module.limpaContasRemessa(IdentificadorConta.IDENTIFICADOR_CONTA_MODELO);
                this._module.limpaContasRemessa(IdentificadorConta.IDENTIFICADOR_CONTA_MODELO_SAUDE);
                this._module.limpaContasRemessa(IdentificadorConta.IDENTIFICADOR_CONTA_MODELO_EDUCACAO);
                this._module.limpaContasRemessa(IdentificadorConta.IDENTIFICADOR_CONTA_CAM_EXEC_INDEPENDENTE);
                this._module.limpaContasRemessa(IdentificadorConta.IDENTIFICADOR_CONTA_REMUNERACAO_VEREADORES_ARTIGO29);
                this._module.limpaContasRemessa(IdentificadorConta.IDENTIFICADOR_CONTA_REMUNERACAO_VEREADORES_DESPESA);
                this._module.limpaContasRemessa(IdentificadorConta.IDENTIFICADOR_CONTA_REMUNERACAO_VEREADORES_RP);
                this._module.limpaContasRemessaContrapartida();
                this._module.limpaRpRecursos();
                conexao = this.criaConexaoDB(this._module);
                log.info((Object)"vai realizar verificacao...");
                verificacaoOk = this.executaVerificacao(binding, conexao);
                log.info((Object)("realizou verificacao, ok? " + verificacaoOk));
                this._servicoPAD.getTransaction().commit();
                log.info((Object)"commit!");
                if (verificacaoOk) {
                    this.ajustaBotaoAvancar("Avan\u00e7ar >");
                    ActionAvancarUC055.setExecutaVerificacao(0);
                }
            }
        }
        catch (ImportacaoException e) {
            log.warn((Object)("ImportacaoException: " + (Object)((Object)e)), (Throwable)((Object)e));
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Erro ao executar ActionAcvancarUC055", (Throwable)e);
            avancaTela = false;
            ActionAvancarUC055.setExecutaVerificacao(1);
            throw new PADActionException("TelaUC055", ActionAvancarUC055.class.toString(), e);
        }
        finally {
            this.setButtonsState(true);
            this.realizaCommit(conexao);
            log.info((Object)"commit2!");
        }
        return avancaTela;
    }

    public boolean executaVerificacao(BindingContext bindingContext, Connection conexao) throws Exception {
        boolean verificacaoOk = true;
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        this._remessa = PadAbstractAction.getRemessaDataControl(bindingContext);
        this._situacao.setRemessa(this._remessa);
        form.setCursor(new Cursor(3));
        try {
            this.disparaTempo();
            List<Arquivo> list = this.inicializaArquivos(this._remessa);
            if (this._remessa.getTipoOperacao() == 6) {
                log.debug((Object)("list-v0: " + list));
                ServicoPAD servPAD = DatacontrolHelper.getServicoPADAppModule(bindingContext);
                list = servPAD.removeArqComplementaresNaoSelecinados(list);
            }
            log.info((Object)("list-arquivos: " + list));
            this._modelProgressRemessa = new ProgressBarBoundedRangeModel(list.size(), 1);
            this._modelProgressArquivo = new ProgressBarBoundedRangeModel();
            this._tela.setProgressoRemessaModel(this._modelProgressRemessa);
            this._tela.setProgressoArquivoModel(this._modelProgressArquivo);
            this._verificacao.setValidaDependencias(true);
            this._verificacao.verificaArquivos(this._situacao, conexao, this, list);
            this._remessa.adicionaIdentificadoresArquivo(this._situacao);
            ServicoPAD servicoPAD = DatacontrolHelper.getServicoPADAppModule(bindingContext);
            servicoPAD.salvaIdentificadoresIntegridadeArquivos(this._remessa);
            this._dtVereficacao = new java.util.Date(System.currentTimeMillis());
            this._modelProgressRemessa.increment(this._modelProgressRemessa.getMaximum());
            this.insertMensagemInstancia(this._servicoPAD, this._situacao, new Date(this._dtVereficacao.getTime()));
            bindingContext.put((Object)"MensagemInstanciaList", this._situacao.getMensagens());
            this._remessa.setVerificacaoEfetuada(true);
            if (this._quantidadeErros == 0 || this._permiteAvancarComErros) {
                if (!(this._remessa.getTipoOperacao() == 6 || "T".equals(this._remessa.getTipoSetor()) || "O".equals(this._remessa.getTipoSetor()) || "E".equals(this._remessa.getTipoSetor()))) {
                    log.info((Object)("Inicia Carga Empenhos_aux = " + new java.util.Date()));
                    this._tela.setArquivoAtual("CARREGANDO TABELAS AUXILIARES DA LRF, AGUARDE...");
                    this._module.populaEmpenhosAux(this._remessa);
                    log.info((Object)("Final Carga Empenhos_aux = " + new java.util.Date()));
                }
                this._tela.setArquivoAtual("CARREGANDO TABELAS AUXILIARES, AGUARDE...");
                this._module.populaPosVerificacao(this._remessa);
                if (this._quantidadeErros == 0) {
                    this._tela.setArquivoAtual("A VERIFICA\u00c7\u00c3O DOS ARQUIVOS FOI FINALIZADA SEM ERROS.");
                } else {
                    this._tela.setArquivoAtual("A VERIFICA\u00c7\u00c3O DOS ARQUIVOS FOI FINALIZADA COM ERROS, POR\u00c9M PERMITINDO AVAN\u00c7AR");
                }
            } else {
                this._tela.setArquivoAtual("A VERIFICA\u00c7\u00c3O DOS ARQUIVOS FOI FINALIZADA COM ERROS.");
                verificacaoOk = false;
            }
            this._contaTempo = false;
        }
        catch (Exception e) {
            log.error((Object)e);
            verificacaoOk = false;
            throw e;
        }
        finally {
            form.setCursor(new Cursor(0));
            this._thTimer.interrupt();
            this.setButtonsState(true);
            this._contaTempo = false;
        }
        return verificacaoOk;
    }

    @Override
    public void trataEvento(ImportacaoEvento evento) {
        switch (evento.getTipoEvento()) {
            case 0: {
                this._tela.setArquivoAtual("VERIFICANDO O ARQUIVO " + evento.getNomeArquivo() + ", AGUARDE...");
                this._tela.setDiretorioOrigem("Diret\u00f3rio Padr\u00e3o dos Arquivos de Informa\u00e7\u00f5es: " + evento.getSituacaoVerificacao().getRemessa().getDiretorioOrigem());
                this._modelProgressArquivo.setMaximum((int)(evento.getMetadadosArquivoAtual().getTamanhoArquivo() / 1000L));
                break;
            }
            case 3: {
                this._modelProgressArquivo.increment((int)(evento.getMetadadosArquivoAtual().getBytesLidos() / 1000L));
                break;
            }
            case 6: {
                this._tela.setArquivoAtual("EXECUTANDO REGRA: " + evento.getCodigoMensagemRegra());
                break;
            }
            case 1: {
                this._modelProgressArquivo.increment(this._modelProgressArquivo.getMaximum());
                break;
            }
            case 7: {
                this._modelProgressRemessa.increment();
                this._modelProgressArquivo.increment(this._modelProgressArquivo.getMaximum());
                this._quantidadeErros += evento.getMetadadosArquivoAtual().getNumeroErrosPorTipo("E");
                this._tela.setNumeroErros(String.valueOf(this._quantidadeErros));
                this._modeloTabelaVerificacao.fireTableDataChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertMensagemInstancia(ServicoPAD module, SituacaoVerificacao verificacao, Date date) throws Exception {
        ViewObject vo = null;
        Row row = null;
        BigDecimal cdVerificacao = null;
        try {
            HistoricoVerificacaoView historicoVerificacao = (HistoricoVerificacaoView)module.findViewObject("HistoricoVerificacaoDaRemessa");
            vo = module.createViewObjectFromQueryStmt("MaxHistoricoVerificacao", "SELECT MAX(cd_verificacao) cd_verificacao FROM historico_verificacao");
            if (vo == null) {
                throw new Exception("N\u00e3o foi poss\u00edvel executar o SQL que retorna o pr\u00f3ximo c\u00f3digo para armazenar os hist\u00f3ricos da verifica\u00e7\u00e3o.");
            }
            vo.first();
            row = vo.getCurrentRow();
            if (row != null && ((cdVerificacao = (BigDecimal)row.getAttribute(0)) == null || cdVerificacao.intValue() == 0)) {
                cdVerificacao = new BigDecimal(0);
            }
            if (cdVerificacao != null) {
                Iterator<MensagemInstancia> mensagensIterator = verificacao.getMensagens().iterator();
                if (!mensagensIterator.hasNext()) {
                    MensagemInstancia mensagem = new MensagemInstancia();
                    mensagem.setIndicador(1);
                    historicoVerificacao.insereMensagem(verificacao.getRemessa(), mensagem, cdVerificacao.intValue() + 1, date);
                } else {
                    while (mensagensIterator.hasNext()) {
                        MensagemInstancia mensagemInstancia = mensagensIterator.next();
                        historicoVerificacao.insereMensagem(verificacao.getRemessa(), mensagemInstancia, cdVerificacao.intValue() + 1, date);
                    }
                }
            }
        }
        finally {
            vo.remove();
        }
    }

    private List<Arquivo> inicializaArquivos(Remessa remessa) {
        log.debug((Object)("remessa.getTipoOperacao = " + remessa.getTipoOperacao()));
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML(this._servicoPAD.resolveArquivoConfigFluxo(remessa.getTipoOperacao()));
        this._verificacao = new VerificacaoArquivosControle(arquivos);
        String lei = TipoEntidadesList.getLeiPorTipoSetor(this._remessa.getTipoSetor());
        List<Arquivo> arqSelecionados = arquivos.getArquivosPorLeiEntidade(lei, this._remessa.getTipoSetor(), this._remessa.getPeriodoInformacoes(), this._remessa.getMes(), this._remessa.getTipoOperacao());
        return arqSelecionados;
    }

    private void setButtonsState(boolean enable) {
        this._controle.habilitaBotaoImprimir(enable);
        this._controle.habilitaBotaoVoltar(enable);
        this._controle.habilitaBotaoFechar(enable);
    }

    private void realizaCommit(Connection conexao) {
        try {
            if (conexao != null) {
                conexao.commit();
            }
        }
        catch (Exception e) {
            log.error((Object)"Erro ao realizar o commit.", (Throwable)e);
            throw new PADActionException("TelaUC055", ActionAvancarUC055.class.toString(), e);
        }
    }

    private Connection criaConexaoDB(ApplicationModule module) {
        Connection conexao = null;
        try {
            conexao = DatabaseHelper.getConnection(module);
            if (conexao.isClosed()) {
                throw new SQLException("Conex\u00e3o com banco de dados fechada");
            }
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        return conexao;
    }

    private int mostraAviso() {
        int option = 1;
        Object[] options = new Object[]{"    Ok    ", " Cancelar "};
        option = JOptionPane.showOptionDialog(PadWizardHelper.getInstance().getForm(), mensagem.getTexto(), "Aviso de Verifica\u00e7\u00e3o", 0, 2, null, options, options[0]);
        return option;
    }

    private void ajustaBotaoAvancar(String nome) {
        this._controle.setaNomeAvancar(nome);
    }

    public TableCellRenderer criateTableCellRenderer() {
        return new PadTableRenderer();
    }

    public TableModel getModeloTabelaVerificacao() {
        this._modeloTabelaVerificacao = new ModeloTabelaVerificacao();
        return this._modeloTabelaVerificacao;
    }

    private String formataTempo(long tempo) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(tempo);
        c.add(11, -21);
        DecimalFormat formatter = new DecimalFormat("00");
        String _tempoDecorrido = formatter.format(c.get(11));
        _tempoDecorrido = _tempoDecorrido + ":" + formatter.format(c.get(12));
        _tempoDecorrido = _tempoDecorrido + ":" + formatter.format(c.get(13));
        return _tempoDecorrido;
    }

    private void disparaTempo() {
        this._thTimer = new Thread(){
            long iniTime = System.currentTimeMillis();

            @Override
            public void run() {
                while (TelaUC055Model.this._contaTempo) {
                    long tempoTranscorrido = System.currentTimeMillis() - this.iniTime;
                    TelaUC055Model.this._tela.setTempoDecorrido(TelaUC055Model.this.formataTempo(tempoTranscorrido));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        this._thTimer.start();
    }

    private void criaRemessaTemporaria() {
        this._remessa = new Remessa();
        this._remessa.setAnoExercicio(2005);
        this._remessa.setCnpjEntidade("90898487000164");
        this._remessa.setCdEntidade(63900);
        this._remessa.setCdRemessa(1);
        this._remessa.setDiretorioOrigem("C:/Projeto/WorkAreas/exemplos 2005/6bi05-PMCotipor\u00e3_ctasnovas2");
        this._remessa.setPeriodoInformacoes(6);
        this._remessa.setTipoSetor("P");
    }

    class PadTableRenderer
    extends DefaultTableCellRenderer {
        private ImageIcon erroIcon = PadImage.createImageIcon("imagens/erroxp.gif");
        private ImageIcon informacaoIcon = PadImage.createImageIcon("imagens/ixp.gif");
        private ImageIcon avisoIcon = PadImage.createImageIcon("imagens/avisoxp.gif");
        private ImageIcon questIcon = PadImage.createImageIcon("imagens/questxp.gif");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String status = (String)table.getModel().getValueAt(row, column);
            if (status != null) {
                if (status.equals("W")) {
                    this.setIcon(this.avisoIcon);
                } else if (status.equals("E")) {
                    this.setIcon(this.erroIcon);
                } else if (status.equals("I")) {
                    this.setIcon(this.informacaoIcon);
                } else if (status.equals("J")) {
                    this.setIcon(this.questIcon);
                }
                this.setHorizontalAlignment(0);
            } else {
                this.setIcon(null);
            }
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    class ModeloTabelaVerificacao
    extends AbstractTableModel {
        List _data = null;
        TableColumnModel columnModel;
        String[] columnNames = new String[]{"Status", "Nome do Arquivo", "C\u00f3digo do Erro", "Descri\u00e7\u00e3o do Erro"};

        public ModeloTabelaVerificacao() {
            this.inicializaMensagens();
        }

        public void inicializaMensagens() {
            MensagemInstancia mensagem = new MensagemInstancia();
            this._data = new LinkedList();
            for (int index = 0; index < 15; ++index) {
                this._data.add(mensagem);
            }
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int row, int col) {
            String value = null;
            MensagemInstancia msg = (MensagemInstancia)this._data.get(row);
            switch (col) {
                case 0: {
                    value = msg.getTipo();
                    break;
                }
                case 1: {
                    value = msg.getArquivo();
                    break;
                }
                case 2: {
                    value = msg.getCodigoMensagem();
                    break;
                }
                case 3: {
                    value = msg.getTexto();
                }
            }
            return value;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        public MensagemInstancia getRow(int row) {
            MensagemInstancia msg = (MensagemInstancia)this._data.get(row);
            return msg;
        }

        @Override
        public void fireTableDataChanged() {
            if (TelaUC055Model.this._situacao.getMensagens().size() < 15) {
                for (int index = 0; index < TelaUC055Model.this._situacao.getMensagens().size(); ++index) {
                    if (index < 15) {
                        this._data.set(index, TelaUC055Model.this._situacao.getMensagens().get(index));
                        continue;
                    }
                    this._data.add(TelaUC055Model.this._situacao.getMensagens().get(index));
                }
            } else {
                this._data = TelaUC055Model.this._situacao.getMensagens();
            }
            super.fireTableDataChanged();
        }
    }

    class ProgressBarBoundedRangeModel
    extends DefaultBoundedRangeModel {
        int defaultIncrement = 0;

        ProgressBarBoundedRangeModel() {
            this(0, 0);
        }

        ProgressBarBoundedRangeModel(int maximun, int increment) {
            this.defaultIncrement = increment;
            this.setMaximum(maximun);
            this.setValue(0);
        }

        ProgressBarBoundedRangeModel(int maximun) {
            this(maximun, 0);
        }

        public void increment() {
            this.setValue(this.getValue() + this.defaultIncrement);
            this.fireStateChanged();
        }

        public void increment(int increment) {
            this.setValue(this.getValue() + increment);
            this.fireStateChanged();
        }
    }
}

