/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.TelaUC216;
import br.gov.rs.tce.pad.visao.swing.PadFoneField;
import br.gov.rs.tce.pad.visao.swing.PadTextFieldBinding;
import br.gov.rs.tce.pad.visao.util.DocumentSizeFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import oracle.adf.model.BindingContext;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class TelaUC040
extends JPanel
implements JUPanel,
PadModelo {
    public static final String SIM = "S";
    public static final String NAO = "N";
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC040UIModel");
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private XYLayout xYLayout1 = new XYLayout();
    private JCheckBox ckbPrestadora = new JCheckBox();
    private JPanel pnlSistemas = new JPanel();
    private JULabel lblName = new JULabel();
    private JULabel lblTelefone = new JULabel();
    private JULabel lblCnpj = new JULabel();
    private JULabel lblEmail = new JULabel();
    private JULabel lblResponsavel = new JULabel();
    private JTextField tfNome = new JTextField();
    private JTextField tfCnpj = new JTextField();
    private JTextField tfResponsavel = new JTextField();
    private JTextField tfEmail = new JTextField();
    private JCheckBox ckbContabil = new JCheckBox();
    private JCheckBox ckbFinaceiro = new JCheckBox();
    private JCheckBox ckbPatrimonial = new JCheckBox();
    private JCheckBox ckbPessoal = new JCheckBox();
    private JCheckBox ckbOrcamentario = new JCheckBox();
    private JCheckBox ckbTributario = new JCheckBox();
    private JCheckBox ckbFolhaPagamento = new JCheckBox();
    private JCheckBox ckbOutros = new JCheckBox();
    private JCheckBox ckbNenhum = new JCheckBox();
    private JTextField tfOutros = new JTextField();
    private PadFoneField tfTelefone = new PadFoneField("(**)#######*", "Campo Telefone deve estar preenchido adequadamente.");

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(620, 320));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.ckbPrestadora.setText("A entidade n\u00e3o possui Prestadora de Servi\u00e7os de Inform\u00e1tica");
        this.ckbPrestadora.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaUC040.this.ckbPrestadora_actionPerformed(e);
            }
        });
        this.tfNome.setPreferredSize(new Dimension(260, 20));
        this.tfNome.setMaximumSize(new Dimension(260, 20));
        this.tfNome.setMinimumSize(new Dimension(260, 20));
        this.tfCnpj.setPreferredSize(new Dimension(110, 20));
        this.tfCnpj.setMaximumSize(new Dimension(110, 20));
        this.tfCnpj.setMinimumSize(new Dimension(110, 20));
        this.tfResponsavel.setPreferredSize(new Dimension(260, 20));
        this.tfResponsavel.setMinimumSize(new Dimension(260, 20));
        this.tfResponsavel.setMaximumSize(new Dimension(260, 20));
        this.tfEmail.setPreferredSize(new Dimension(260, 20));
        this.tfEmail.setMaximumSize(new Dimension(260, 20));
        this.tfEmail.setMinimumSize(new Dimension(260, 20));
        this.pnlSistemas.setLayout((LayoutManager)this.xYLayout1);
        this.pnlSistemas.setBorder(BorderFactory.createTitledBorder("Possui Sistemas:"));
        this.ckbContabil.setText("Cont\u00e1bil");
        this.ckbContabil.setBounds(new Rectangle(26, 45, 61, 23));
        this.ckbFinaceiro.setText("Financeiro");
        this.ckbPatrimonial.setText("Patrimonial");
        this.ckbPessoal.setText("Pessoal");
        this.ckbOrcamentario.setText("Or\u00e7ament\u00e1rio");
        this.ckbTributario.setText("Tribut\u00e1rio");
        this.ckbFolhaPagamento.setText("Folha de Pagamento");
        this.ckbOutros.setText("Outros");
        this.ckbOutros.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TelaUC040.this.ckbOutros_itemStateChanged(e);
            }
        });
        this.ckbOutros.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaUC040.this.controlaCbOutros(e);
            }
        });
        this.ckbNenhum.setText("Nenhum");
        this.ckbNenhum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaUC040.this.ckbNenhum_actionPerformed(e);
            }
        });
        this.tfTelefone.setSize(new Dimension(110, 20));
        this.tfTelefone.setMinimumSize(new Dimension(110, 22));
        this.tfTelefone.setMaximumSize(new Dimension(110, 22));
        this.tfTelefone.setPreferredSize(new Dimension(110, 22));
        this.jPanel1.add((Component)this.ckbPrestadora, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 2), 0, 0));
        this.jPanel1.add((Component)this.tfNome, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.jPanel1.add((Component)this.lblCnpj, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 2), 0, 0));
        this.jPanel1.add((Component)this.tfCnpj, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.jPanel1.add((Component)this.lblTelefone, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 10, 0), 0, 0));
        this.jPanel1.add((Component)this.tfTelefone, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), -11, 0));
        this.jPanel1.add((Component)this.lblResponsavel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 2), 0, 0));
        this.jPanel1.add((Component)this.tfResponsavel, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.jPanel1.add((Component)this.lblEmail, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 2), 0, 0));
        this.jPanel1.add((Component)this.tfEmail, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jPanel1, "Center");
        this.pnlSistemas.add((Component)this.tfOutros, new XYConstraints(80, 225, 155, 20));
        this.pnlSistemas.add((Component)this.ckbNenhum, new XYConstraints(20, 255, 81, 23));
        this.pnlSistemas.add((Component)this.ckbOutros, new XYConstraints(20, 225, 60, 23));
        this.pnlSistemas.add((Component)this.ckbFolhaPagamento, new XYConstraints(20, 195, 139, 23));
        this.pnlSistemas.add((Component)this.ckbTributario, new XYConstraints(20, 165, 87, 23));
        this.pnlSistemas.add((Component)this.ckbOrcamentario, new XYConstraints(20, 135, 120, 23));
        this.pnlSistemas.add((Component)this.ckbPessoal, new XYConstraints(20, 105, 87, 23));
        this.pnlSistemas.add((Component)this.ckbPatrimonial, new XYConstraints(20, 75, 93, 23));
        this.pnlSistemas.add((Component)this.ckbFinaceiro, new XYConstraints(20, 45, 91, 23));
        this.pnlSistemas.add((Component)this.ckbContabil, new XYConstraints(20, 15, 80, 23));
        this.add((Component)this.pnlSistemas, "West");
        this.lblName.setText("Nome:");
        this.tfNome.setDocument((Document)this.panelBinding.bindUIControl("Nome1", (Object)this.tfNome));
        this.lblCnpj.setText("CNPJ:");
        this.tfCnpj.setDocument((Document)this.panelBinding.bindUIControl("Cnpj1", (Object)this.tfCnpj));
        this.lblTelefone.setText("Telefone:");
        this.tfResponsavel.setDocument((Document)this.panelBinding.bindUIControl("Responsavel", (Object)this.tfResponsavel));
        this.tfEmail.setDocument((Document)this.panelBinding.bindUIControl("Email", (Object)this.tfEmail));
        this.lblEmail.setText("E-mail:");
        this.lblResponsavel.setText("Respons\u00e1vel:");
        this.tfTelefone.setDocument(PadTextFieldBinding.createAttributeBinding((JUFormBinding)this.panelBinding, this.tfTelefone, "PrestadoraServicoRemessa", null, "PrestadoraServicoView1Iterator", "Telefone"));
        this.preparaTamanhoCampos();
    }

    private void preparaTamanhoCampos() {
        int MAX_CHARACTERS_PREFMUNICIPAL = 14;
        int MAX_CHARACTERS_NOME = 100;
        int MAX_CHARACTERS_EMAIL = 50;
        int MAX_CHARACTERS_OUTROS = 100;
        int MAX_CHARACTERS_RESPONSAVEL = 100;
        int MAX_CHARACTERS_CNPJ = 18;
        ((AbstractDocument)this.tfCnpj.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_CNPJ));
        ((AbstractDocument)this.tfEmail.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_EMAIL));
        ((AbstractDocument)this.tfNome.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_NOME));
        ((AbstractDocument)this.tfOutros.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_OUTROS));
        ((AbstractDocument)this.tfResponsavel.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_RESPONSAVEL));
        ((AbstractDocument)this.tfCnpj.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_PREFMUNICIPAL));
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC040 panel = new TelaUC040();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
        BindingContext binding = this.panelBinding.getBindingContext();
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(binding);
        Remessa rem = DatacontrolHelper.getRemessaDataControl(binding);
        this.limpaCampos();
        this.populaCheckBoxPerguntas(ser, rem);
        this.controlaDadosPrestadora();
        this.controlaInformacoresSistemas();
    }

    private void populaCheckBoxPerguntas(ServicoPAD ser, Remessa remessa) {
        String resposta = null;
        resposta = ser.getRespostaPergunta(12, remessa);
        if (SIM.equals(resposta)) {
            this.ckbContabil.setSelected(true);
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(13, remessa))) {
            this.ckbFinaceiro.setSelected(true);
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(14, remessa))) {
            this.ckbPatrimonial.setSelected(true);
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(15, remessa))) {
            this.ckbPessoal.setSelected(true);
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(16, remessa))) {
            this.ckbOrcamentario.setSelected(true);
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(17, remessa))) {
            this.ckbTributario.setSelected(true);
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(18, remessa))) {
            this.ckbFolhaPagamento.setSelected(true);
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(19, remessa))) {
            this.ckbOutros.setSelected(true);
            this.tfOutros.setText(ser.getTextoPergunta(19, remessa));
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(20, remessa))) {
            this.ckbNenhum.setSelected(true);
        }
        if (SIM.equals(resposta = ser.getRespostaPergunta(21, remessa))) {
            this.ckbPrestadora.setSelected(true);
        }
    }

    private void ckbPrestadora_actionPerformed(ActionEvent e) {
        this.controlaDadosPrestadora();
    }

    private void controlaDadosPrestadora() {
        this.setEnabledPrestadoraValidation(!this.ckbPrestadora.isSelected());
        if (this.ckbPrestadora.isSelected()) {
            this.tfNome.setEditable(false);
            this.tfNome.setText("");
            this.tfCnpj.setEditable(false);
            this.tfCnpj.setText("");
            this.tfTelefone.setEditable(false);
            this.tfTelefone.setText("");
            this.tfResponsavel.setEditable(false);
            this.tfResponsavel.setText("");
            this.tfEmail.setEditable(false);
            this.tfEmail.setText("");
        } else {
            this.tfNome.setEditable(true);
            this.tfCnpj.setEditable(true);
            this.tfTelefone.setEditable(true);
            this.tfResponsavel.setEditable(true);
            this.tfEmail.setEditable(true);
        }
    }

    public void setEnabledPrestadoraValidation(boolean habilita) {
        BindingContext binding = this.panelBinding.getBindingContext();
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(binding);
        ser.findViewObject("PrestadoraServicoRemessa").setRowValidation(habilita);
    }

    public Map<String, String> getSistemas() {
        HashMap<String, String> sistemas = new HashMap<String, String>();
        if (this.ckbContabil.isSelected()) {
            sistemas.put(String.valueOf(12), SIM);
        } else {
            sistemas.put(String.valueOf(12), NAO);
        }
        if (this.ckbFinaceiro.isSelected()) {
            sistemas.put(String.valueOf(13), SIM);
        } else {
            sistemas.put(String.valueOf(13), NAO);
        }
        if (this.ckbPatrimonial.isSelected()) {
            sistemas.put(String.valueOf(14), SIM);
        } else {
            sistemas.put(String.valueOf(14), NAO);
        }
        if (this.ckbPessoal.isSelected()) {
            sistemas.put(String.valueOf(15), SIM);
        } else {
            sistemas.put(String.valueOf(15), NAO);
        }
        if (this.ckbOrcamentario.isSelected()) {
            sistemas.put(String.valueOf(16), SIM);
        } else {
            sistemas.put(String.valueOf(16), NAO);
        }
        if (this.ckbTributario.isSelected()) {
            sistemas.put(String.valueOf(17), SIM);
        } else {
            sistemas.put(String.valueOf(17), NAO);
        }
        if (this.ckbFolhaPagamento.isSelected()) {
            sistemas.put(String.valueOf(18), SIM);
        } else {
            sistemas.put(String.valueOf(18), NAO);
        }
        if (this.ckbOutros.isSelected()) {
            sistemas.put(String.valueOf(19), this.tfOutros.getText());
        } else {
            sistemas.put(String.valueOf(19), NAO);
        }
        if (this.ckbNenhum.isSelected()) {
            sistemas.put(String.valueOf(20), SIM);
        } else {
            sistemas.put(String.valueOf(20), NAO);
        }
        if (this.ckbPrestadora.isSelected()) {
            sistemas.put(String.valueOf(21), SIM);
        } else {
            sistemas.put(String.valueOf(21), NAO);
        }
        return sistemas;
    }

    private void ckbNenhum_actionPerformed(ActionEvent e) {
        this.controlaInformacoresSistemas();
    }

    private void controlaSelecaoNenhum() {
        JCheckBox[] checkBoxes = new JCheckBox[]{this.ckbContabil, this.ckbFinaceiro, this.ckbPatrimonial, this.ckbPessoal, this.ckbOrcamentario, this.ckbTributario, this.ckbFolhaPagamento, this.ckbOutros};
        boolean temSelecionado = false;
        for (int i = 0; i < checkBoxes.length; ++i) {
            if (!checkBoxes[i].isSelected()) continue;
            temSelecionado = true;
        }
        if (temSelecionado) {
            this.showMessageWarning("Existiam sistemas selecionados que ser\u00e3o desmarcados.");
        }
    }

    private void controlaInformacoresSistemas() {
        if (this.ckbNenhum.isSelected()) {
            this.controlaSelecaoNenhum();
            this.ckbContabil.setSelected(false);
            this.ckbContabil.setEnabled(false);
            this.ckbFinaceiro.setSelected(false);
            this.ckbFinaceiro.setEnabled(false);
            this.ckbPatrimonial.setSelected(false);
            this.ckbPatrimonial.setEnabled(false);
            this.ckbPessoal.setSelected(false);
            this.ckbPessoal.setEnabled(false);
            this.ckbOrcamentario.setSelected(false);
            this.ckbOrcamentario.setEnabled(false);
            this.ckbTributario.setSelected(false);
            this.ckbTributario.setEnabled(false);
            this.ckbFolhaPagamento.setSelected(false);
            this.ckbFolhaPagamento.setEnabled(false);
            this.ckbOutros.setSelected(false);
            this.ckbOutros.setEnabled(false);
            this.tfOutros.setText("");
            this.tfOutros.setEnabled(false);
        } else {
            this.ckbContabil.setEnabled(true);
            this.ckbFinaceiro.setEnabled(true);
            this.ckbPatrimonial.setEnabled(true);
            this.ckbPessoal.setEnabled(true);
            this.ckbOrcamentario.setEnabled(true);
            this.ckbTributario.setEnabled(true);
            this.ckbFolhaPagamento.setEnabled(true);
            this.ckbOutros.setEnabled(true);
        }
    }

    public boolean gravarPrestadoraServico() {
        return this.ckbPrestadora.isSelected();
    }

    public boolean isMarcouCheckBox() {
        if (!(this.ckbContabil.isSelected() || this.ckbFinaceiro.isSelected() || this.ckbPatrimonial.isSelected() || this.ckbPessoal.isSelected() || this.ckbOrcamentario.isSelected() || this.ckbTributario.isSelected() || this.ckbFolhaPagamento.isSelected() || this.ckbOutros.isSelected() || this.ckbNenhum.isSelected())) {
            this.showMessageWarning("\u00c9 preciso especificar os sistemas informatizados existentes na \nentidade ou selecionar a op\u00e7\u00e3o 'Nenhum' caso esta n\u00e3o possua sistemas.");
            return false;
        }
        return true;
    }

    public boolean isPreencheuTodosCampos() {
        if (this.ckbOutros.isSelected() && this.tfOutros.getText().trim().equals("")) {
            this.showMessageWarning("\u00c9 preciso informar no campo 'Outros' qual o(s) sistema(s) utilizado(s).");
            return false;
        }
        if ((this.tfNome.getText().equals("") || this.tfCnpj.getText().equals("") || this.tfTelefone.getText().equals("") || this.tfTelefone.getText().trim().equals("(  )") || this.tfResponsavel.getText().equals("") || this.tfEmail.getText().equals("")) && !this.ckbPrestadora.isSelected()) {
            this.showMessageWarning("\u00c9 preciso preencher todos os campos.");
            return false;
        }
        return true;
    }

    public void showMessageWarning(String mensagem) {
        PadWizardForm frame = PadWizardHelper.getInstance().getForm();
        JOptionPane.showMessageDialog(frame, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    private void controlaCbOutros(ActionEvent e) {
    }

    private void ckbOutros_itemStateChanged(ItemEvent e) {
        if (!this.ckbOutros.isSelected()) {
            this.tfOutros.setEnabled(false);
            this.tfOutros.setText("");
        } else {
            this.tfOutros.setEnabled(true);
        }
    }

    @Override
    public final void finalizaTela() {
    }

    public boolean validaResponsaveis() {
        try {
            TelaUC216.buscarResponsaveisComplementares((JUFormBinding)this.panelBinding);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean validaTela() {
        if (this.tfCnpj.getText() == null || this.tfCnpj.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "CNPJ deve ser informado", "Informa\u00e7\u00e3o", 1);
            return false;
        }
        return true;
    }

    public void limpaCampos() {
        this.ckbContabil.setSelected(false);
        this.ckbFinaceiro.setSelected(false);
        this.ckbPatrimonial.setSelected(false);
        this.ckbPessoal.setSelected(false);
        this.ckbOrcamentario.setSelected(false);
        this.ckbTributario.setSelected(false);
        this.ckbFolhaPagamento.setSelected(false);
        this.ckbOutros.setSelected(false);
        this.tfOutros.setText("");
        this.ckbNenhum.setSelected(false);
        this.ckbPrestadora.setSelected(false);
    }
}

