/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.adf.util.TCETable;
import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.decisao.NavegacaoTelasControle;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.panel.PadTableRenderer;
import br.gov.rs.tce.pad.visao.panel.PopUpJustificativas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaJustificativaPadrao
extends JPanel
implements JUPanel,
PadModelo {
    private static final long serialVersionUID = 1L;
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaJustificativaPadraoUIModel");
    private JScrollPane jScrollPane1 = new JScrollPane();
    private TCETable tblJustificativas = new TCETable();
    private static DefaultCellEditor CELL_EDITOR_DESABILITADO;
    private int cdPlanilha = 0;
    private int tipoPlanilha = 0;
    private int[] TAMANHO_COLUNAS = new int[]{380, 176, 42};
    private static Log log;

    public void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.tblJustificativas.setEditingColumn(3);
        this.tblJustificativas.setEditingRow(3);
        this.tblJustificativas.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TelaJustificativaPadrao.this.trataPopUpJustificativa(e);
            }
        });
        this.jScrollPane1.getViewport().add((Component)this.tblJustificativas, null);
        DefaultListSelectionModel selModel = new DefaultListSelectionModel();
        selModel.setSelectionMode(0);
        this.tblJustificativas.setSelectionModel(selModel);
        this.add((Component)this.jScrollPane1, "Center");
        this.add(Box.createRigidArea(new Dimension(0, 10)), "First");
        this.add(Box.createRigidArea(new Dimension(0, 16)), "Last");
        this.add(Box.createRigidArea(new Dimension(10, 0)), "Before");
        this.add(Box.createRigidArea(new Dimension(10, 0)), "After");
        this.tblJustificativas.setModel((TableModel)this.panelBinding.bindUIControl("JustificativasDaRemessa", (Object)this.tblJustificativas));
        this.tblJustificativas.getColumnModel().getColumn(2).setCellRenderer(new PadTableRenderer());
        log.info((Object)("TelaJustificativaPadrao: header da tabela = " + this.tblJustificativas.getColumnModel().getColumn(1).getHeaderValue()));
        this.tblJustificativas.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tmodel = this.tblJustificativas.getColumnModel();
        this.tblJustificativas.setAutoResizeMode(4);
        for (int i = 0; i < tmodel.getColumnCount(); ++i) {
            TableColumn c = tmodel.getColumn(i);
            c.setResizable(false);
            c.setCellEditor(CELL_EDITOR_DESABILITADO);
            c.setPreferredWidth(this.TAMANHO_COLUNAS[i]);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaJustificativaPadrao panel = new TelaJustificativaPadrao();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TelaJustificativaPadrao.this.refreshTela();
            }
        });
    }

    public void refreshTela() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        NavegacaoTelasControle navegacao = (NavegacaoTelasControle)this.panelBinding.getBindingContext().findDataControl("NavegacaoDataControl");
        Tela tela = navegacao.getConfigTelaAtual();
        TableColumnModel tmodel = this.tblJustificativas.getColumnModel();
        if (tmodel.getColumnCount() > 0) {
            TableColumn c = null;
            c = tmodel.getColumn(0);
            String tituloColuna1 = tela.getParametroPorNome("tituloColuna1");
            String tituloColuna2 = tela.getParametroPorNome("tituloColuna2");
            if (tituloColuna1 != null) {
                c.setHeaderValue(tituloColuna1);
            } else if ("UC045A".equals(tela.getCodigo())) {
                c.setHeaderValue("A\u00e7\u00e3o realizada");
            } else if ("UC080".equals(tela.getCodigo())) {
                c.setHeaderValue("Contas selecionadas de forma manual");
            } else if ("UC219".equals(tela.getCodigo())) {
                c.setHeaderValue("Justificativas de valida\u00e7\u00e3o");
            } else {
                c.setHeaderValue("Nome da Planilha");
            }
            if (tituloColuna2 != null) {
                TableColumn c2 = tmodel.getColumn(1);
                c2.setHeaderValue(tituloColuna2);
            }
        }
        try {
            Remessa rem = ser.getRemessaPrincipal();
            ViewObject voR = ser.findViewObject("RemessasDaEntidade");
            voR.setWhereClause("CD_ENTIDADE = " + rem.getCdEntidade() + " AND REMESSA_PRINCIPAL = 'S'");
            voR.setWhereClauseParams(null);
            voR.executeQuery();
            ViewObject vo = ser.findViewObject("EntidadeDaRemessa");
            vo.setWhereClause("CD_ENTIDADE = " + rem.getCdEntidade());
            vo.setWhereClauseParams(null);
            vo.executeQuery();
            ViewObject voJ = ser.findViewObject("JustificativasDaRemessa");
            voJ.executeQuery();
            voJ.first();
            this.setCursor(Cursor.getPredefinedCursor(0));
            int rc = this.tblJustificativas.getRowCount();
            log.info((Object)("rowcount = " + rc + " ; vo.rc = " + voJ.getRowCount() + " ; vo.rcir = " + voJ.getRowCountInRange() + " ; voR=" + voR.getRowCount() + " ; voE=" + vo.getRowCount() + " ; cdEnt = " + rem.getCdEntidade()));
            if (rc > 0) {
                this.tblJustificativas.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception e) {
            log.error((Object)"Erro ao preparar tela justificativa padr\u00e3o", (Throwable)e);
            e.printStackTrace();
        }
        try {
            this.tblJustificativas.repaint();
            this.tblJustificativas.updateUI();
        }
        catch (Exception e) {
            log.error((Object)"Erro ao renderizar tela justificativa padr\u00e3o.", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void trataPopUpJustificativa(MouseEvent e) {
        int column = 0;
        int row = this.tblJustificativas.getSelectedRow();
        if (e.getClickCount() == 2) {
            for (int i = 0; i <= 2; ++i) {
                if (!this.tblJustificativas.getColumnName(i).equals("Justificativa")) continue;
                column = i;
            }
            DCIteratorBinding iter = this.panelBinding.findIteratorBinding("JustificativasDaRemessaIterator");
            Row r = iter.getCurrentRow();
            PopUpJustificativas justif = new PopUpJustificativas((JFrame)SwingUtilities.getWindowAncestor(this));
            NavegacaoTelasControle navegacao = (NavegacaoTelasControle)this.panelBinding.getBindingContext().findDataControl("NavegacaoDataControl");
            Tela tela = navegacao.getConfigTelaAtual();
            String tituloPopup = tela.getParametroPorNome("tituloPopup");
            if (tituloPopup != null) {
                justif.setTitle(tituloPopup);
            } else if ("UC045A".equals(tela.getCodigo())) {
                justif.setTitle("Justifica as altera\u00e7\u00f5es efetuadas");
            } else if ("UC080".equals(tela.getCodigo())) {
                justif.setTitle("Justifica a Sele\u00e7\u00e3o Manual");
            } else if ("UC219".equals(tela.getCodigo())) {
                justif.setTitle("Justifica a Situa\u00e7\u00e3o");
            }
            if (tela.getParametroPorNome("popupMostraPergunta") != null) {
                String nomePlanilha = (String)r.getAttribute("NomePlanilha");
                justif.setPergunta(nomePlanilha);
            }
            justif.setJustificativa((String)r.getAttribute("Texto"));
            if ("UC203A".equals(tela.getCodigo())) {
                // empty if block
            }
            justif.show();
            if (justif.isSalvaJustificativa()) {
                String textoDigitado = justif.getJustificativa();
                r.setAttribute("Texto", (Object)textoDigitado);
                if (r != null) {
                    if (textoDigitado != null && !textoDigitado.trim().equals("")) {
                        r.setAttribute("Situacao", (Object)1);
                    } else {
                        r.setAttribute("Situacao", (Object)0);
                    }
                }
            }
        }
    }

    @Override
    public final void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    private final void exibeMensagemAviso(String mensagem, Component parent) {
        JOptionPane.showMessageDialog(parent, mensagem, "Informa\u00e7\u00e3o", 1);
    }

    static {
        log = LogFactory.getLog(TelaJustificativaPadrao.class);
        JTextField tf = new JTextField();
        tf.setBackground(Color.LIGHT_GRAY);
        tf.setBorder(new LineBorder(Color.RED));
        CELL_EDITOR_DESABILITADO = new DefaultCellEditor(tf){

            @Override
            public boolean isCellEditable(EventObject eo) {
                return false;
            }
        };
    }
}

