/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.visao.panel.CusteioBean;
import br.gov.rs.tce.pad.visao.panel.TelaUC228B;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class CusteioTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<CusteioBean> beans = new ArrayList<CusteioBean>();
    private boolean changed = false;

    CusteioTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.beans.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex > this.getRowCount() || columnIndex > this.getColumnCount()) {
            return null;
        }
        CusteioBean bean = this.beans.get(rowIndex);
        if (bean == null) {
            TelaUC228B.log.warn((Object)("null bean? rowIndex=" + rowIndex + " ; columnIndex=" + columnIndex + " ; beans.size()=" + this.beans.size()));
            return null;
        }
        return this.getPropertyAtColumn(bean, columnIndex);
    }

    CusteioBean get(int i) {
        return this.beans.get(i);
    }

    void add(CusteioBean bean) {
        this.beans.add(bean);
        this.changed = true;
        this.fireTableDataChanged();
    }

    void remove(int i) {
        this.beans.remove(i);
        this.changed = true;
        this.fireTableDataChanged();
    }

    void update(int i, CusteioBean bean) {
        this.beans.set(i, bean);
        this.changed = true;
        this.fireTableDataChanged();
    }

    void removeAll() {
        this.beans.clear();
        this.changed = true;
        this.fireTableDataChanged();
    }

    Object getPropertyAtColumn(CusteioBean bean, int col) {
        switch (col) {
            case 0: {
                return bean.cnpj;
            }
            case 1: {
                return bean.nomeOrgao;
            }
            case 2: {
                return bean.codigoND;
            }
            case 3: {
                return bean.valor;
            }
        }
        return null;
    }

    void resetChanged() {
        this.changed = false;
    }

    boolean hasChanged() {
        return this.changed;
    }
}

