/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao;

import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.verificacao.VerificacaoArquivosControle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import oracle.adf.model.BindingContext;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PadVerificacaoBeta
extends JFrame {
    BindingContext ctx = null;
    VerificacaoArquivosControle verificacao;
    private ComboBoxModel comboBoxModel1;
    private JPanel jPanel1 = new JPanel();
    private JScrollPane jScrollPane1 = null;
    private ComboBoxModel comboBoxModel2;
    private ComboBoxModel comboBoxModel3;
    boolean contaTempo = true;
    DateFormat formatoTempo = new SimpleDateFormat("mm:ss");
    String tempoDecorrido = new String();
    public static final String DIR_PROPERTY = "dir";
    public static final String EXERCICIO = "exercicio";
    public static final String CNPJ = "cnpj";
    public static final String TIPO_SETOR = "tipo-setor";
    public static final String PERIODO = "periodo";
    static Log log = LogFactory.getLog(PadVerificacaoBeta.class);
    Connection conexao = null;
    private JPanel jPanel2 = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private JComboBox jComboBox2 = new JComboBox();
    private JComboBox jComboBox3 = new JComboBox();
    private JLabel jLabel5 = new JLabel();
    private JButton jButton2 = new JButton();
    private JTextField edAno = new JTextField();
    private JLabel jLabel4 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JComboBox jComboBox1 = new JComboBox();
    private JLabel jLabel2 = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private JTextField edCnpj = new JTextField();
    private JTextField edDiretorio = new JTextField();
    private JPanel jPanel3 = new JPanel();
    private XYLayout xYLayout2 = new XYLayout();
    private JButton jButton1 = new JButton();
    private JProgressBar progresso = new JProgressBar();
    private JLabel lblArquivo = new JLabel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JLabel jLabel6 = new JLabel();
    private JLabel lblTempo = new JLabel();
    private XYLayout xYLayout3 = new XYLayout();
    private JTable jTable1 = new JTable();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout3 = new BorderLayout();
    Thread thBanco = null;

    public PadVerificacaoBeta() {
        this.initializeADFModel();
        this.progresso.setStringPainted(true);
        Object[] itens = new Object[]{"1o. Bimestre", "2o. Bimestre", "3o. Bimestre", "4o. Bimestre", "5o. Bimestre", "6o. Bimestre"};
        this.comboBoxModel1 = new DefaultComboBoxModel<Object>(itens);
        TableColumnModel tm = this.jTable1.getColumnModel();
        this.jTable1.setAutoResizeMode(0);
        Object[] itens2 = new Object[]{"P - Prefeitura", "C - Camara", "A - Autarquia", "F - Funda\u00e7\u00e3o 4320/64", "S - Consorcio 6404/76", "E - Empresa", "T - Funda\u00e7\u00e3o - 6404/76", "O - Cons\u00f3rcio - 4320/64"};
        this.comboBoxModel2 = new DefaultComboBoxModel<Object>(itens2);
        Object[] itens3 = new Object[]{"Verificar os arquivos de informa\u00e7\u00f5es complementares", "Verificar os arquivos de informa\u00e7\u00f5es"};
        this.comboBoxModel3 = new DefaultComboBoxModel<Object>(itens3);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File f = new File("config.properties");
        if (f.exists()) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(f));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.edDiretorio.setText(prop.getProperty(DIR_PROPERTY));
            this.edAno.setText(prop.getProperty(EXERCICIO));
            this.edCnpj.setText(prop.getProperty(CNPJ));
            this.jComboBox2.setSelectedIndex(Integer.parseInt(prop.getProperty(TIPO_SETOR)));
            this.jComboBox1.setSelectedIndex(Integer.parseInt(prop.getProperty(PERIODO)));
        } else {
            this.comboBoxModel1.setSelectedItem(itens[0]);
            this.comboBoxModel2.setSelectedItem(itens2[0]);
            this.comboBoxModel3.setSelectedItem(itens3[0]);
            this.edAno.setText("2004");
            this.edDiretorio.setText("C:\\");
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Properties prop = new Properties();
                prop.setProperty(PadVerificacaoBeta.DIR_PROPERTY, PadVerificacaoBeta.this.edDiretorio.getText());
                prop.setProperty(PadVerificacaoBeta.EXERCICIO, PadVerificacaoBeta.this.edAno.getText());
                prop.setProperty(PadVerificacaoBeta.PERIODO, Integer.toString(PadVerificacaoBeta.this.jComboBox1.getSelectedIndex()));
                prop.setProperty(PadVerificacaoBeta.CNPJ, PadVerificacaoBeta.this.edCnpj.getText());
                prop.setProperty(PadVerificacaoBeta.TIPO_SETOR, Integer.toString(PadVerificacaoBeta.this.jComboBox2.getSelectedIndex()));
                try {
                    prop.store(new FileOutputStream("config.properties"), null);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                PadVerificacaoBeta.this.shutdown();
            }
        });
        this.setDefaultCloseOperation(3);
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(640, 500));
        this.setTitle("M\u00f3dulo Validador/Extrator Dados");
        this.jPanel1.setLayout((LayoutManager)this.xYLayout3);
        this.jPanel2.setLayout((LayoutManager)this.xYLayout1);
        this.jPanel2.setPreferredSize(new Dimension(595, 120));
        this.jComboBox2.setModel(this.comboBoxModel2);
        this.jComboBox3.setModel(this.comboBoxModel3);
        this.jLabel5.setText("Tipo setor:");
        this.jButton2.setText("Procurar");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PadVerificacaoBeta.this.jButton2_actionPerformed(e);
            }
        });
        this.jLabel4.setText("Ano exerc\u00edcio:");
        this.jLabel3.setText("Per\u00edodo:");
        this.jComboBox1.setModel(this.comboBoxModel1);
        this.jLabel2.setText("CNPJ:");
        this.jLabel1.setText("Diret\u00f3rio:");
        this.jPanel3.setLayout((LayoutManager)this.xYLayout2);
        this.jPanel3.setBorder(BorderFactory.createEtchedBorder(0));
        this.jButton1.setText("Verificar");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PadVerificacaoBeta.this.jButton1_actionPerformed(e);
            }
        });
        this.jLabel6.setText("Vers\u00e3o 1.0 - Beta");
        this.lblTempo.setText("00:00");
        this.lblTempo.setToolTipText("null");
        this.jPanel2.add((Component)this.jLabel6, new XYConstraints(510, 5, 110, 15));
        this.jPanel2.add((Component)this.edDiretorio, new XYConstraints(90, 10, 295, 20));
        this.jPanel2.add((Component)this.edCnpj, new XYConstraints(90, 35, 110, 20));
        this.jPanel2.add((Component)this.jLabel1, new XYConstraints(10, 15, 50, 15));
        this.jPanel2.add((Component)this.jLabel2, new XYConstraints(10, 40, 35, 15));
        this.jPanel2.add((Component)this.jComboBox1, new XYConstraints(215, 85, 140, 20));
        this.jPanel2.add((Component)this.jLabel3, new XYConstraints(165, 90, 45, 15));
        this.jPanel2.add((Component)this.jLabel4, new XYConstraints(10, 90, 75, 15));
        this.jPanel2.add((Component)this.edAno, new XYConstraints(90, 85, 65, 20));
        this.jPanel2.add((Component)this.jButton2, new XYConstraints(395, 10, 95, 20));
        this.jPanel2.add((Component)this.jLabel5, new XYConstraints(10, 65, 55, 15));
        this.jPanel2.add((Component)this.jComboBox2, new XYConstraints(90, 60, 140, 20));
        this.jPanel2.add((Component)this.jComboBox3, new XYConstraints(90, 50, 140, 20));
        this.jPanel3.add((Component)this.lblTempo, new XYConstraints(585, 5, 40, 15));
        this.jPanel3.add((Component)this.lblArquivo, new XYConstraints(5, 30, 480, 15));
        this.jPanel3.add((Component)this.progresso, new XYConstraints(5, 5, 575, 20));
        this.jPanel3.add((Component)this.jButton1, new XYConstraints(495, 30, 115, 25));
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1 = new JScrollPane(this.jTable1);
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void jButton1_actionPerformed(ActionEvent e) {
        final SituacaoVerificacao situacao = new SituacaoVerificacao();
        final ModeloTabelaVerificacao listener = new ModeloTabelaVerificacao(situacao);
        this.jTable1.setModel(listener);
        Remessa rem = new Remessa();
        rem.setAnoExercicio(Integer.parseInt(this.edAno.getText()));
        rem.setCnpjEntidade(this.edCnpj.getText());
        rem.setDiretorioOrigem(this.edDiretorio.getText());
        String sel = (String)this.comboBoxModel1.getSelectedItem();
        rem.setPeriodoInformacoes(Integer.parseInt(sel.substring(0, 1)));
        sel = (String)this.comboBoxModel2.getSelectedItem();
        rem.setTipoSetor(sel.substring(0, 1));
        sel = (String)this.comboBoxModel3.getSelectedItem();
        if ("Verificar os arquivos de informa\u00e7\u00f5es complementares".equals(sel)) {
            rem.setTipoOperacao(6);
        } else {
            rem.setTipoOperacao(1);
        }
        situacao.setRemessa(rem);
        if (this.conexao == null) {
            this.thBanco = new Thread(){

                @Override
                public void run() {
                    PadVerificacaoBeta.this.lblArquivo.setText("Abrindo banco de dados...");
                    PadVerificacaoBeta.this.conexao = PadVerificacaoBeta.this.criaConexaoDB();
                    PadVerificacaoBeta.this.lblArquivo.setText("Banco de dados aberto.");
                }
            };
            this.thBanco.start();
        }
        final PadVerificacaoBeta f = this;
        final Thread thTimer = new Thread(){
            long iniTime = System.currentTimeMillis();

            @Override
            public void run() {
                while (PadVerificacaoBeta.this.contaTempo) {
                    long tempoTranscorrido = System.currentTimeMillis() - this.iniTime;
                    PadVerificacaoBeta.this.lblTempo.setText(PadVerificacaoBeta.this.formataTempo(tempoTranscorrido));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        Thread th = new Thread(){

            @Override
            public void run() {
                f.setCursor(Cursor.getPredefinedCursor(3));
                PadVerificacaoBeta.this.lblArquivo.setText("Carregando regras de verifica\u00e7\u00e3o e configura\u00e7\u00e3o de arquivos cont\u00e1beis...");
                Arquivos arquivos = null;
                arquivos = 6 == situacao.getRemessa().getTipoOperacao() ? (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-complementares") : (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal");
                PadVerificacaoBeta.this.lblArquivo.setText("Regras de verifica\u00e7\u00e3o e configura\u00e7\u00e3o de arquivos cont\u00e1bies carregados.");
                PadVerificacaoBeta.this.verificacao = new VerificacaoArquivosControle(arquivos);
                try {
                    if (PadVerificacaoBeta.this.thBanco != null) {
                        try {
                            PadVerificacaoBeta.this.thBanco.join();
                        }
                        catch (InterruptedException ie) {
                            ie.printStackTrace();
                        }
                    }
                    if (PadVerificacaoBeta.this.conexao == null) {
                        JOptionPane.showMessageDialog(f, "N\u00e3o foi possivel abrir o banco de dados.");
                        return;
                    }
                    thTimer.start();
                    PadVerificacaoBeta.this.verificacao.verificaArquivos(situacao, PadVerificacaoBeta.this.conexao, listener);
                    PadVerificacaoBeta.this.contaTempo = false;
                    JOptionPane.showMessageDialog(f, "Verifica\u00e7\u00e3o finalizada.");
                    if (PadVerificacaoBeta.this.conexao != null) {
                        try {
                            PadVerificacaoBeta.this.conexao.commit();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    log.error((Object)e);
                    JOptionPane.showMessageDialog(f, "Ocorreu um erro durante a execu\u00e7\u00e3o, entre em contato com a equipe da AdvancedIT. (" + e.getMessage() + ").");
                }
                finally {
                    f.setCursor(Cursor.getPredefinedCursor(0));
                    PadVerificacaoBeta.this.contaTempo = false;
                }
            }
        };
        th.start();
    }

    private Connection criaConexaoDB() {
        Connection conexao = null;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            conexao = DriverManager.getConnection("jdbc:derby:./database", "PADWEB", "PADWEB");
            conexao.setAutoCommit(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conexao;
    }

    private Connection criaConexaoOracleDB() {
        Connection conexao = null;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
            conexao = DriverManager.getConnection("jdbc:oracle:thin:@orades:1521:orades", "padweb", "padweb");
            conexao.setAutoCommit(false);
        }
        catch (Exception e) {
            System.out.println("criaConexaoOracleDB: exception: " + e);
        }
        return conexao;
    }

    public void shutdown() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            this.conexao = null;
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
        log.info((Object)"Database shut down normally");
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PadVerificacaoBeta v = new PadVerificacaoBeta();
                v.setVisible(true);
            }
        });
    }

    private void jButton2_actionPerformed(ActionEvent e) {
        String filename = "C:/";
        JFileChooser fc = new JFileChooser(new File(filename));
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this) == 0) {
            if (fc.getSelectedFile().exists()) {
                this.edDiretorio.setText(fc.getSelectedFile().getAbsolutePath());
            } else {
                JOptionPane.showMessageDialog(this, "O diretorio informado n\u00e3o existe ou \u00e9 inv\u00e1lido.");
            }
        }
    }

    private void initializeADFModel() {
    }

    private String formataTempo(long tempo) {
        Date date = new Date(tempo);
        this.tempoDecorrido = this.formatoTempo.format(date);
        return this.tempoDecorrido;
    }

    class ModeloTabelaVerificacao
    extends AbstractTableModel
    implements ImportacaoListener {
        SituacaoVerificacao _situacao;
        String[] columnNames = new String[]{"Num.", "Tipo", "Arquivo", "C\u00f3digo", "Texto"};

        public ModeloTabelaVerificacao(SituacaoVerificacao situacao) {
            this._situacao = situacao;
        }

        @Override
        public Object getValueAt(int row, int col) {
            MensagemInstancia msg = this._situacao.getMensagens().get(row);
            Object value = null;
            switch (col) {
                case 0: {
                    value = msg.getIndicador();
                    break;
                }
                case 1: {
                    value = msg.getTipo();
                    break;
                }
                case 2: {
                    value = msg.getArquivo();
                    break;
                }
                case 3: {
                    value = msg.getCodigoMensagem();
                    break;
                }
                case 4: {
                    value = msg.getTexto();
                }
            }
            return value;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public int getRowCount() {
            return this._situacao.getMensagens().size();
        }

        public SituacaoVerificacao getSituacao() {
            return this._situacao;
        }

        @Override
        public void trataEvento(ImportacaoEvento evento) {
            if (evento.getTipoEvento() == 0) {
                PadVerificacaoBeta.this.progresso.setString(null);
                PadVerificacaoBeta.this.lblArquivo.setText("Carregando: " + evento.getNomeArquivo());
                PadVerificacaoBeta.this.progresso.setMaximum((int)(evento.getMetadadosArquivoAtual().getTamanhoArquivo() / 1000L));
                PadVerificacaoBeta.this.progresso.setValue(0);
            } else if (evento.getTipoEvento() != 3) {
                if (evento.getTipoEvento() == 6) {
                    PadVerificacaoBeta.this.progresso.setString("Executando regra: " + evento.getCodigoMensagemRegra());
                } else if (evento.getTipoEvento() == 1) {
                    PadVerificacaoBeta.this.progresso.setValue(PadVerificacaoBeta.this.progresso.getMaximum());
                    this.fireTableDataChanged();
                }
            }
        }
    }
}

