/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao;

import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.NavegacaoHelper;
import br.gov.rs.tce.pad.util.TimeZoneUtils;
import br.gov.rs.tce.pad.util.VersaoUtils;
import br.gov.rs.tce.pad.visao.PadErrorDialog;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.util.SplashScreen;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCErrorHandler;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.DefLocaleContext;
import oracle.jbo.uicli.jui.JUEnvInfoProvider;
import oracle.jbo.uicli.mom.JUMetaObjectManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PadDesktop {
    private static Log log = LogFactory.getLog(PadDesktop.class);
    private BindingContext ctx;
    static final String versaoTeste = "" != null && !"".equals("") ? "".trim() + ("master" != null && !"".equals("master") && !"master".equals("master") ? "-master" : "") : "";
    static final String versaoLayout = ConfiguracaoControle.versaoArquivos != null ? " [layout=" + ConfiguracaoControle.versaoArquivos + "]" : "";
    private static boolean _cargaBancoDados = false;

    public PadDesktop() {
        log.info((Object)("PAD " + PadDesktop.getVersaoTitulo()));
        this.initializeADFModel();
    }

    public static void main(String[] args) {
        try {
            TimeZoneUtils.resetJavaTimeZoneToZone("America/Sao_Paulo");
            NavegacaoHelper.init("DESKTOP");
            int screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
            int fontSize = (int)Math.round(8.0 * (double)screenRes / 72.0);
            Font font = new Font("Microsoft Sans Serif", 0, fontSize);
            UIManager.put("Label.font", font);
            UIManager.put("Button.font", font);
            UIManager.put("CheckBox.font", font);
            UIManager.put("RadioButton.font", font);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.error((Object)"Erro ao definir LookAndFeel", (Throwable)e);
        }
        new PadDesktop();
    }

    public static String getVersaoTitulo() {
        return "25.1.1.0" + versaoTeste + versaoLayout;
    }

    public static boolean validaVersaoJava(JFrame frame) {
        int versaoJava = VersaoUtils.getJavaVersion();
        if (versaoJava <= 6) {
            log.error((Object)("versaoJava [" + versaoJava + "] <= 6: vers\u00e3o n\u00e3o suportada"));
            PadDesktop.exibeMensagemWarning(frame, "Foi detectado que o PAD est\u00e1 sendo executado com uma m\u00e1quina virtual Java n\u00e3o suportada (vers\u00e3o " + versaoJava + " - menor que 7)");
            frame.setTitle("PAD " + PadDesktop.getVersaoTitulo() + " (Vers\u00e3o do Java n\u00e3o suportada)");
            return false;
        }
        if (versaoJava == 7) {
            log.warn((Object)("versaoJava [" + versaoJava + "] = 7: possivelmente n\u00e3o ser\u00e1 suportada em vers\u00f5es futuras do PAD"));
            try {
                Class<?> clazz = Class.forName("com.sun.xml.ws.spi.ProviderImpl");
            }
            catch (LinkageError e) {
                log.error((Object)("versaoJava [" + versaoJava + "]: classe ProviderImpl n\u00e3o acess\u00edvel"), (Throwable)e);
                PadDesktop.exibeMensagemWarning(frame, "Foi detectado que o PAD est\u00e1 sendo executado com uma m\u00e1quina virtual Java que em brve n\u00e3o ser\u00e1 mais suportada (vers\u00e3o 7).\nDeve ser usada uma vers\u00e3o do PAD apropriada a esta vers\u00e3o do Java (vers\u00e3o para Java 7/8).");
                return false;
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("versaoJava [" + versaoJava + "]: Erro inesperado: " + e.getMessage()), (Throwable)e);
            }
            PadDesktop.exibeMensagemWarning(frame, "Foi detectado que o PAD est\u00e1 sendo executado com uma m\u00e1quina virtual Java que em breve n\u00e3o ser\u00e1 mais suportada (vers\u00e3o 7)");
        } else if (versaoJava == 8) {
            log.info((Object)("versaoJava [" + versaoJava + "] ok (java8)"));
        } else {
            try {
                Class<?> clazz = Class.forName("javax.xml.ws.soap.SOAPFaultException");
                log.info((Object)("versaoJava [" + versaoJava + "] ok"));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("versaoJava [" + versaoJava + "]: classes SOAP n\u00e3o dispon\u00edveis"), (Throwable)e);
                PadDesktop.exibeMensagemWarning(frame, "Foi detectado que o PAD est\u00e1 sendo executado com uma m\u00e1quina virtual Java recente (vers\u00e3o " + versaoJava + ").\nDeve ser usada uma vers\u00e3o do PAD apropriada a esta vers\u00e3o do Java.");
                return false;
            }
        }
        return true;
    }

    private void initializeADFModel() {
        final PadWizardForm pad = new PadWizardForm("PAD " + PadDesktop.getVersaoTitulo());
        String image = "/br/gov/rs/tce/pad/resource/imagens/abertura_2025.jpg";
        SplashScreen splashScreen = new SplashScreen(image, PadDesktop.getVersaoTitulo());
        splashScreen.splash();
        boolean valido = PadDesktop.validaVersaoJava(pad);
        if (!valido) {
            System.exit(1);
        }
        Thread thCarregaDatabindings = new Thread("Th-Carrega-Databindings.cpx"){

            @Override
            public void run() {
                try {
                    JUMetaObjectManager.setErrorHandler((DCErrorHandler)new PadErrorDialog(pad));
                    JUMetaObjectManager mgr = JUMetaObjectManager.getJUMom();
                    mgr.setJClientDefFactory(null);
                    PadDesktop.this.ctx = new BindingContext();
                    PadDesktop.this.ctx.put((Object)"_envInfo_Provider", (Object)new JUEnvInfoProvider());
                    PadDesktop.this.ctx.setLocaleContext((LocaleContext)new DefLocaleContext(null));
                    HashMap<String, BindingContext> map = new HashMap<String, BindingContext>();
                    map.put("_binding_Context", PadDesktop.this.ctx);
                    JUMetaObjectManager.loadCpx((String)"DataBindings.cpx", map);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Databindings carregados com sucesso.");
                    }
                }
                catch (Exception ex) {
                    PadDesktop.this.ctx = null;
                    ex.printStackTrace();
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    JUMetaObjectManager.reportException(null, (Exception)ex);
                    System.exit(1);
                }
            }
        };
        thCarregaDatabindings.start();
        try {
            thCarregaDatabindings.join();
            if (this.ctx != null) {
                pad.setBindingContext(this.ctx);
                try {
                    Thread thCargaBanco = this.carregaBancoDados(this.ctx);
                    thCargaBanco.join();
                    splashScreen.dispose();
                    pad.show();
                }
                catch (InterruptedException e) {
                    log.debug((Object)"InterruptedException", (Throwable)e);
                }
            } else {
                log.error((Object)"PadWizardForm n\u00e3o pode ser inicializado devido ao BindingContext ser nulo.");
            }
        }
        catch (InterruptedException e) {
            log.debug((Object)"InterruptedException", (Throwable)e);
        }
    }

    private Thread carregaBancoDados(final BindingContext binding) {
        Thread thBanco = new Thread("Th-CargaDerby"){

            @Override
            public void run() {
                try {
                    DatacontrolHelper.getServicoPADAppModule(binding);
                    log.debug((Object)"Banco de Dados Aberto OK");
                }
                catch (Exception e) {
                    log.error((Object)"Erro ao abrir banco de dados", (Throwable)e);
                    Exception exBanco = new Exception("N\u00e3o foi possivel abrir o Banco de Dados (" + e.getMessage() + ").", e);
                    JUMetaObjectManager.reportException(null, (Exception)exBanco);
                }
            }
        };
        thBanco.start();
        Thread thTrataFechamentoBanco = new Thread("finalizaDerby"){

            @Override
            public void run() {
                log.info((Object)"Executando thread para finalizar Derby...");
                DatabaseHelper.fechaDerbyDatabase();
            }
        };
        Runtime.getRuntime().addShutdownHook(thTrataFechamentoBanco);
        return thBanco;
    }

    public static boolean isCargaBancoDados() {
        return _cargaBancoDados;
    }

    public static void exibeMensagemWarning(Component parentComponent, String mensagem) {
        JOptionPane.showMessageDialog(parentComponent, mensagem, "Aten\u00e7\u00e3o", 2);
    }
}

