/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util.test;

import br.gov.rs.tce.pad.modelo.seguranca.CriptografiaControle;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestaArquivosRemessa
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected static Log log = LogFactory.getLog(TestaArquivosRemessa.class);
    private BorderLayout borderLayout1 = new BorderLayout();
    private XYLayout xYLayout1 = new XYLayout();
    private JPanel PnlCenter = new JPanel();
    private JLabel labelInfo4 = new JLabel();
    private JButton buttonFind = new JButton();
    private JTextField textFieldPath = new JTextField();
    File _arquivoRemessa;
    File _arquivoDestino;
    private JLabel jLabel1 = new JLabel();
    private JLabel labelInfo5 = new JLabel();
    private JTextField textFieldPathDestino = new JTextField();
    private JButton buttonFindDestino = new JButton();
    private JButton btnProcessa = new JButton();

    public void jbInit() throws Exception {
        this.setSize(new Dimension(620, 224));
        this.getContentPane().setLayout(this.borderLayout1);
        this.setTitle(TestaArquivosRemessa.class.getSimpleName());
        this.PnlCenter.setBorder(BorderFactory.createEtchedBorder(1));
        this.PnlCenter.setLayout((LayoutManager)this.xYLayout1);
        this.PnlCenter.setSize(new Dimension(620, 270));
        this.PnlCenter.setMaximumSize(new Dimension(800, 600));
        this.labelInfo4.setText("Informe o Arquivo da Remessa");
        this.buttonFind.setText("Procurar");
        this.buttonFind.setOpaque(false);
        this.buttonFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestaArquivosRemessa.this.btnProcurar_actionPerformed(e);
            }
        });
        this.textFieldPath.setOpaque(false);
        this.jLabel1.setText("<html>Utilize este aplicativo para descompactar arquivos de remessa do sistema PAD - SIAPC. Esta aplica\u00e7\u00e3o deve ser utilizada apenas para an\u00e1lises simples dos dados.</html>");
        this.labelInfo5.setText("Informe Destino de Arquivos");
        this.textFieldPathDestino.setOpaque(false);
        this.buttonFindDestino.setText("Procurar");
        this.buttonFindDestino.setOpaque(false);
        this.buttonFindDestino.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestaArquivosRemessa.this.buttonFindDestino(e);
            }
        });
        this.btnProcessa.setText("Processar");
        this.btnProcessa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestaArquivosRemessa.this.btnProcessa_actionPerformed(e);
            }
        });
        this.PnlCenter.add((Component)this.btnProcessa, new XYConstraints(275, 150, 90, 25));
        this.PnlCenter.add((Component)this.buttonFindDestino, new XYConstraints(510, 100, 90, 25));
        this.PnlCenter.add((Component)this.textFieldPathDestino, new XYConstraints(185, 100, 300, 20));
        this.PnlCenter.add((Component)this.labelInfo5, new XYConstraints(15, 100, 165, 20));
        this.PnlCenter.add((Component)this.jLabel1, new XYConstraints(10, 5, 590, 40));
        this.PnlCenter.add((Component)this.textFieldPath, new XYConstraints(185, 50, 300, 20));
        this.PnlCenter.add((Component)this.buttonFind, new XYConstraints(510, 50, 90, 25));
        this.PnlCenter.add((Component)this.labelInfo4, new XYConstraints(15, 50, 165, 20));
        this.getContentPane().add((Component)this.PnlCenter, "Center");
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TestaArquivosRemessa panel = new TestaArquivosRemessa();
        try {
            panel.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        panel.pack();
        panel.setLocationRelativeTo(null);
        panel.setVisible(true);
    }

    private void selecionaArquivo() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean ok = false;
                if (file != null) {
                    String name = file.getName();
                    boolean bl = ok = name.endsWith(".p01") || name.endsWith(".dat") || name.endsWith(".00");
                }
                if (!ok) {
                    ok = file.isDirectory();
                }
                return ok;
            }

            @Override
            public String getDescription() {
                return "Arquivo de remesssa (*.dat, *.p01, *.00)";
            }
        };
        fc.setFileFilter(ff);
        if (fc.showOpenDialog(this) == 0) {
            this.textFieldPath.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void btnProcurar_actionPerformed(ActionEvent e) {
        this.selecionaArquivo();
    }

    private void processaDescompactacao() {
        File f = new File(this._arquivoDestino + File.separator + "consolida_remessa.dat");
        log.info((Object)(">> processaDescompactacao: Descompactacao iniciada: " + f.getAbsolutePath()));
        CompactacaoHelper compacta = new CompactacaoHelper();
        File fremessa = new File(this._arquivoRemessa.getParent() + File.separator);
        log.info((Object)("copiar de: " + this._arquivoRemessa + " ; para: " + fremessa));
        compacta.copiaArquivoCompactadoTeste(this._arquivoRemessa, fremessa, new NotificaEventos());
        compacta.descompacta(this._arquivoRemessa, this._arquivoDestino);
        File f2 = null;
        try {
            f2 = new File(this._arquivoDestino.getPath() + File.separator + "dados.crp");
            log.info((Object)("ARQUIVO_REMESSA_TXT_CRIPTO: " + f2.getPath() + " = " + f2.exists()));
            CriptografiaControle.descriptografa(f2, new File(this._arquivoDestino.getPath() + File.separator + "dados.dat"), "P@D.WEB?D&SKTOP;");
            compacta.descompacta(new File(this._arquivoDestino.getPath() + File.separator + "dados.dat"), this._arquivoDestino);
        }
        catch (FileNotFoundException e) {
            log.warn((Object)("arquivo n\u00e3o encontrado: " + e));
            log.debug((Object)("arquivo n\u00e3o encontrado: " + e), (Throwable)e);
        }
        try {
            f2 = new File(this._arquivoDestino.getPath() + File.separator + "remessa.crp");
            log.info((Object)("ARQUIVO_REMESSA_XML_CRIPTO: " + f2.getPath() + " = " + f2.exists()));
            CriptografiaControle.descriptografa(f2, new File(this._arquivoDestino.getPath() + File.separator + "remessa.zip"), "P@D.WEB?D&SKTOP;");
            compacta.descompacta(new File(this._arquivoDestino.getPath() + File.separator + "remessa.zip"), this._arquivoDestino);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            f2 = new File(this._arquivoDestino.getPath() + File.separator + "relat.crp");
            log.info((Object)("ARQUIVO_RELATORIO_CRIPTO: " + f2.getPath() + " = " + f2.exists()));
            CriptografiaControle.descriptografa(f2, new File(this._arquivoDestino.getPath() + File.separator + "relat.zip"), "P@D.WEB?D&SKTOP;");
            compacta.descompacta(new File(this._arquivoDestino.getPath() + File.separator + "relat.zip"), this._arquivoDestino);
        }
        catch (FileNotFoundException e) {
            log.info((Object)("Arquivo criptografado para relatorios PDF (relat.crp) n\u00e3o existente: " + e));
            log.debug((Object)("Arquivo criptografado para relatorios PDF (relat.crp) n\u00e3o existente: " + e), (Throwable)e);
        }
        log.info((Object)(">> processaDescompactacao: Descompactacao finalizada: " + f.getAbsolutePath()));
        JOptionPane.showMessageDialog(this, "Arquivo recuperado com Sucesso", "Informa\u00e7\u00e3o", 1);
    }

    private void buttonFindDestino(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this) == 0) {
            this.textFieldPathDestino.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    private void btnProcessa_actionPerformed(ActionEvent e) {
        boolean error = false;
        this._arquivoRemessa = new File(this.textFieldPath.getText());
        if (!this._arquivoRemessa.exists() || this._arquivoRemessa.isDirectory()) {
            log.warn((Object)("Erro _arquivoRemessa: " + this._arquivoRemessa));
            JOptionPane.showMessageDialog(this, "Arquivo de Remessa n\u00e3o encontrado (ou \u00e9 diret\u00f3rio)", "Informa\u00e7\u00e3o", 1);
            error = true;
        }
        this._arquivoDestino = new File(this.textFieldPathDestino.getText());
        if (!this._arquivoDestino.exists() || !this._arquivoDestino.isDirectory()) {
            log.warn((Object)("Erro _arquivoDestino: " + this._arquivoDestino));
            JOptionPane.showMessageDialog(this, "Arquivo Destino n\u00e3o encontrado (ou n\u00e3o \u00e9 diret\u00f3rio)", "Informa\u00e7\u00e3o", 1);
            error = true;
        }
        if (!error) {
            this.processaDescompactacao();
        }
    }

    class NotificaEventos
    implements ChangeListener {
        NotificaEventos() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
        }
    }
}

