/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.util;

public class ValidaPadraoNumerico {
    final String pattern;
    final int patternDigitCount;
    final int valorLengthMinimo;

    public ValidaPadraoNumerico(String pattern, int valorLengthMinimo) {
        this.pattern = pattern;
        this.valorLengthMinimo = valorLengthMinimo;
        this.patternDigitCount = ValidaPadraoNumerico.contaChar(pattern, '#');
    }

    public static int contaChar(String valor, char cPadrao) {
        int ret = 0;
        for (int i = 0; i < valor.length(); ++i) {
            char c = valor.charAt(i);
            if (c != cPadrao) continue;
            ++ret;
        }
        return ret;
    }

    public static int contaDigitos(String valor) {
        int ret = 0;
        for (int i = 0; i < valor.length(); ++i) {
            char c = valor.charAt(i);
            if (c < '0' || c > '9') continue;
            ++ret;
        }
        return ret;
    }

    public static String getNumeros(String valor, int minLength) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < valor.length(); ++i) {
            char c = valor.charAt(i);
            if (c == '.' || c == '/' || c == '-') continue;
            ret.append(c);
        }
        if (ret.length() < minLength) {
            while (ret.length() < minLength) {
                ret.insert(0, "0");
            }
        }
        return ret.toString();
    }

    public boolean validaPadrao(String valor) {
        int valorDigitosCount = ValidaPadraoNumerico.contaDigitos(valor);
        if (valorDigitosCount > this.patternDigitCount || valorDigitosCount < this.valorLengthMinimo) {
            System.err.println("ValidaPadraoNumerico: valorDigitosCount=");
            return false;
        }
        return true;
    }

    public String formataPadrao(String valor) {
        char[] chrs = this.pattern.toCharArray();
        StringBuilder valorFormatado = new StringBuilder();
        int offSet = 0;
        valor = ValidaPadraoNumerico.getNumeros(valor, this.patternDigitCount);
        for (int index = 0; index < chrs.length; ++index) {
            if (chrs[index] != '#') {
                valorFormatado.append(chrs[index]);
                continue;
            }
            valorFormatado.append(valor.substring(offSet, offSet + 1));
            ++offSet;
        }
        return valorFormatado.toString();
    }
}

